/****************************************************************************
**  SCALASCA    http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2013                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2009-2013                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#include <config.h>
#include <pearl/OmpFork_rep.h>

#include <iostream>

#include <pearl/Buffer.h>

using namespace std;
using namespace pearl;


//---------------------------------------------------------------------------
//
//  class OmpFork_rep
//
//---------------------------------------------------------------------------

//--- Constructors & destructor ---------------------------------------------

OmpFork_rep::OmpFork_rep(timestamp_t timestamp, uint32_t teamSize)
  : Event_rep(timestamp),
    mTeamSize(teamSize)
{
}


OmpFork_rep::OmpFork_rep(const GlobalDefs& defs, Buffer& buffer)
  : Event_rep(defs, buffer)
{
  mTeamSize = buffer.get_uint32();
}


//--- Event type information ------------------------------------------------

event_t OmpFork_rep::getType() const
{
  return OMP_FORK;
}


bool OmpFork_rep::isOfType(event_t type) const
{
  return ((OMP_FORK == type)
          || (GROUP_ALL == type));
}


//--- Access event data -----------------------------------------------------

uint32_t OmpFork_rep::getTeamSize() const
{
  return mTeamSize;
}


//--- Serialize event data (protected) --------------------------------------

void OmpFork_rep::pack(Buffer& buffer) const
{
  Event_rep::pack(buffer);

  buffer.put_uint32(mTeamSize);
}


//--- Generate human-readable output of event data (protected) --------------

ostream& OmpFork_rep::output(ostream& stream) const
{
  Event_rep::output(stream);

  return stream << "  team   = " << mTeamSize << endl;
}
