/****************************************************************************
**  SCALASCA    http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2013                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2009-2013                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#include <config.h>
#include <pearl/OmpAcquireLock_rep.h>

#include <iostream>

using namespace std;
using namespace pearl;


//---------------------------------------------------------------------------
//
//  class OmpAcquireLock_rep
//
//---------------------------------------------------------------------------

//--- Constructors & destructor ---------------------------------------------

OmpAcquireLock_rep::OmpAcquireLock_rep(timestamp_t timestamp,
                                       uint32_t    lockId,
                                       uint32_t    order)
  : Event_rep(timestamp),
    mLockId(lockId),
    mAcquisitionOrder(order)
{
}


OmpAcquireLock_rep::OmpAcquireLock_rep(const GlobalDefs& defs, Buffer& buffer)
  : Event_rep(defs, buffer),
    mLockId(PEARL_NO_ID),            // Lock ID is only local
    mAcquisitionOrder(PEARL_NO_ID)   // Acquisition order is only local
{
}


//--- Event type information ------------------------------------------------

event_t OmpAcquireLock_rep::getType() const
{
  return OMP_ACQUIRE_LOCK;
}


bool OmpAcquireLock_rep::isOfType(event_t type) const
{
  return ((OMP_ACQUIRE_LOCK == type)
          || (GROUP_ALL == type));
}


//--- Access event data -----------------------------------------------------

uint32_t OmpAcquireLock_rep::getLockId() const 
{
  return mLockId;
}


uint32_t OmpAcquireLock_rep::getAcquisitionOrder() const
{
  return mAcquisitionOrder;
}


//--- Generate human-readable output of event data (protected) --------------

ostream& OmpAcquireLock_rep::output(ostream& stream) const
{
  Event_rep::output(stream);

  return stream << "  lockid = " << mLockId << endl
                << "  order  = " << mAcquisitionOrder << endl;
}
