/****************************************************************************
**  SCALASCA    http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2013                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2009-2013                                                **
**  German Research School for Simulation Sciences GmbH,                   **
**  Laboratory for Parallel Programming                                    **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef PEARL_OMPRELEASELOCK_REP_H
#define PEARL_OMPRELEASELOCK_REP_H


#include <pearl/Event_rep.h>


/*-------------------------------------------------------------------------*/
/**
 *  @file    OmpReleaseLock_rep.h
 *  @ingroup PEARL_omp
 *  @brief   Declaration of the class OmpReleaseLock_rep.
 *
 *  This header file provides the declaration of the class OmpReleaseLock_rep.
 **/
/*-------------------------------------------------------------------------*/


namespace pearl
{

/*-------------------------------------------------------------------------*/
/**
 *  @class   OmpReleaseLock_rep
 *  @ingroup PEARL_omp
 *  @brief   %Event representation for OMP_RELEASE_LOCK events.
 **/
/*-------------------------------------------------------------------------*/

class PEARL_NOPAD_ATTR OmpReleaseLock_rep : public Event_rep
{
  public:
    /// @name Constructors & destructor
    /// @{

    OmpReleaseLock_rep(timestamp_t timestamp,
                       uint32_t    lockId,
                       uint32_t    order);
    OmpReleaseLock_rep(const GlobalDefs& defs, Buffer& buffer);

    /// @}
    /// @name Event type information
    /// @{

    virtual event_t getType() const;
    virtual bool    isOfType(event_t type) const;

    /// @}
    /// @name Access event data
    /// @{

    virtual uint32_t getLockId() const;

    uint32_t getAcquisitionOrder() const;

    /// @}


  protected:
    /// @name Generate human-readable output of event data
    /// @{

    virtual std::ostream& output(std::ostream& stream) const;

    /// @}


  private:
    /// Identifier of the lock being released
    uint32_t mLockId;

    /// Monotonically increasing ID to determine the order of lock acquisitions
    uint32_t mAcquisitionOrder;
};


}   // namespace pearl


#endif   // !PEARL_OMPRELEASELOCK_REP_H
