/****************************************************************************
**  SCALASCA    http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2013                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  Copyright (c) 2003-2008                                                **
**  University of Tennessee, Innovative Computing Laboratory               **
**                                                                         **
**  See the file COPYRIGHT in the package base directory for details       **
****************************************************************************/

#ifndef _PARAVER_MPITAB_H
#define _PARAVER_MPITAB_H

typedef struct {
  const char* name;
  int   id;
  int   type;
  int   state;
} pv_mpi_tab_t;

pv_mpi_tab_t pv_mpi_tab[] = {
  { "MPI_Abort",                 100, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Accumulate",             67, ET_MPI_RMA,   ST_MPIRMA   },
  { "MPI_Address",               111, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Allgather",              17, ET_MPI_COLL,  ST_MPICOLL  },
  { "MPI_Allgatherv",             18, ET_MPI_COLL,  ST_MPICOLL  },
  { "MPI_Allreduce",              10, ET_MPI_COLL,  ST_MPICOLL  },
  { "MPI_Alltoall",               11, ET_MPI_COLL,  ST_MPICOLL  },
  { "MPI_Alltoallv",              12, ET_MPI_COLL,  ST_MPICOLL  },
  { "MPI_Attr_delete",            81, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Attr_get",               82, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Attr_put",               83, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Barrier",                 8, ET_MPI_COLL,  ST_MPICOLL  },
  { "MPI_Bcast",                   7, ET_MPI_COLL,  ST_MPICOLL  },
  { "MPI_Bsend",                  33, ET_MPI_P2P,   ST_MPISEND  },
  { "MPI_Bsend_init",            112, ET_MPI_P2P,   ST_MPISEND  },
  { "MPI_Buffer_attach",         113, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Buffer_detach",         114, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Cancel",                 40, ET_MPI_P2P,   ST_MPIOTHER },
  { "MPI_Cart_coords",            45, ET_MPI_TOPO,  ST_MPIOTHER },
  { "MPI_Cart_create",            43, ET_MPI_TOPO,  ST_MPIOTHER },
  { "MPI_Cart_get",               46, ET_MPI_TOPO,  ST_MPIOTHER },
  { "MPI_Cart_map",               47, ET_MPI_TOPO,  ST_MPIOTHER },
  { "MPI_Cart_rank",              48, ET_MPI_TOPO,  ST_MPIOTHER },
  { "MPI_Cart_shift",             44, ET_MPI_TOPO,  ST_MPIOTHER },
  { "MPI_Cart_sub",               49, ET_MPI_TOPO,  ST_MPIOTHER },
  { "MPI_Cartdim_get",            50, ET_MPI_TOPO,  ST_MPIOTHER },
  { "MPI_Comm_compare",           29, ET_MPI_COMM,  ST_MPIOTHER },
  { "MPI_Comm_create",            21, ET_MPI_COMM,  ST_MPIOTHER },
  { "MPI_Comm_dup",               22, ET_MPI_COMM,  ST_MPIOTHER },
  { "MPI_Comm_free",              25, ET_MPI_COMM,  ST_MPIOTHER },
  { "MPI_Comm_group",             24, ET_MPI_COMM,  ST_MPIOTHER },
  { "MPI_Comm_rank",              19, ET_MPI_COMM,  ST_MPIOTHER },
  { "MPI_Comm_remote_group",      26, ET_MPI_COMM,  ST_MPIOTHER },
  { "MPI_Comm_remote_size",       27, ET_MPI_COMM,  ST_MPIOTHER },
  { "MPI_Comm_size",              20, ET_MPI_COMM,  ST_MPIOTHER },
  { "MPI_Comm_split",             23, ET_MPI_COMM,  ST_MPIOTHER },
  { "MPI_Comm_test_inter",        28, ET_MPI_COMM,  ST_MPIOTHER },
  { "MPI_Dims_create",            51, ET_MPI_TOPO,  ST_MPIOTHER },
  { "MPI_Errhandler_create",     102, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Errhandler_free",       103, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Errhandler_get",        104, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Errhandler_set",        106, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Error_class",           101, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Error_string",          105, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Finalize",               32, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Gather",                 13, ET_MPI_COLL,  ST_MPICOLL  },
  { "MPI_Gatherv",                14, ET_MPI_COLL,  ST_MPICOLL  },
  { "MPI_Get",                    66, ET_MPI_RMA,   ST_MPIRMA   },
  { "MPI_Get_count",             118, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Get_elements",          119, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Get_processor_name",    107, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Graph_create",           54, ET_MPI_TOPO,  ST_MPIOTHER },
  { "MPI_Graph_get",              52, ET_MPI_TOPO,  ST_MPIOTHER },
  { "MPI_Graph_map",              53, ET_MPI_TOPO,  ST_MPIOTHER },
  { "MPI_Graph_neighbors",        55, ET_MPI_TOPO,  ST_MPIOTHER },
  { "MPI_Graph_neighbors_count",  57, ET_MPI_TOPO,  ST_MPIOTHER },
  { "MPI_Graphdims_get",          56, ET_MPI_TOPO,  ST_MPIOTHER },
  { "MPI_Group_compare",          95, ET_MPI_GROUP, ST_MPIOTHER },
  { "MPI_Group_difference",       84, ET_MPI_GROUP, ST_MPIOTHER },
  { "MPI_Group_excl",             85, ET_MPI_GROUP, ST_MPIOTHER },
  { "MPI_Group_free",             86, ET_MPI_GROUP, ST_MPIOTHER },
  { "MPI_Group_incl",             87, ET_MPI_GROUP, ST_MPIOTHER },
  { "MPI_Group_intersection",     88, ET_MPI_GROUP, ST_MPIOTHER },
  { "MPI_Group_range_excl",       90, ET_MPI_GROUP, ST_MPIOTHER },
  { "MPI_Group_range_incl",       91, ET_MPI_GROUP, ST_MPIOTHER },
  { "MPI_Group_rank",             89, ET_MPI_GROUP, ST_MPIOTHER },
  { "MPI_Group_size",             92, ET_MPI_GROUP, ST_MPIOTHER },
  { "MPI_Group_translate_ranks",  93, ET_MPI_GROUP, ST_MPIOTHER },
  { "MPI_Group_union",            94, ET_MPI_GROUP, ST_MPIOTHER },
  { "MPI_Ibsend",                 36, ET_MPI_P2P,   ST_MPIISEND },
  { "MPI_Init",                   31, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Init_thread",           140, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Initialized",           108, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Intercomm_create",       96, ET_MPI_COMM,  ST_MPIOTHER },
  { "MPI_Intercomm_merge",        97, ET_MPI_COMM,  ST_MPIOTHER },
  { "MPI_Iprobe",                 62, ET_MPI_P2P,   ST_MPITEST  },
  { "MPI_Irecv",                   4, ET_MPI_P2P,   ST_MPIIRECV },
  { "MPI_Irsend",                 38, ET_MPI_P2P,   ST_MPIISEND },
  { "MPI_Isend",                   3, ET_MPI_P2P,   ST_MPIISEND },
  { "MPI_Issend",                 37, ET_MPI_P2P,   ST_MPIISEND },
  { "MPI_Keyval_create",          99, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Keyval_free",            98, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Op_create",              78, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Op_free",                79, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Pack",                   76, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Pack_size",             120, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Probe",                  61, ET_MPI_P2P,   ST_MPITEST  },
  { "MPI_Put",                    65, ET_MPI_RMA,   ST_MPIRMA   },
  { "MPI_Recv",                    2, ET_MPI_P2P,   ST_MPIRECV  },
  { "MPI_Recv_init",             116, ET_MPI_P2P,   ST_MPIRECV  },
  { "MPI_Reduce",                  9, ET_MPI_COLL,  ST_MPICOLL  },
  { "MPI_Reduce_scatter",         80, ET_MPI_COLL,  ST_MPICOLL  },
  { "MPI_Request_free",          115, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Rsend",                  35, ET_MPI_P2P,   ST_MPISEND  },
  { "MPI_Rsend_init",            121, ET_MPI_P2P,   ST_MPISEND  },
  { "MPI_Scan",                   30, ET_MPI_COLL,  ST_MPICOLL  },
  { "MPI_Scatter",                15, ET_MPI_COLL,  ST_MPICOLL  },
  { "MPI_Scatterv",               16, ET_MPI_COLL,  ST_MPICOLL  },
  { "MPI_Send",                    1, ET_MPI_P2P,   ST_MPISEND  },
  { "MPI_Send_init",             117, ET_MPI_P2P,   ST_MPISEND  },
  { "MPI_Sendrecv",               41, ET_MPI_P2P,   ST_MPISDRV  },
  { "MPI_Sendrecv_replace",       42, ET_MPI_P2P,   ST_MPISDRV  },
  { "MPI_Ssend",                  34, ET_MPI_P2P,   ST_MPISEND  },
  { "MPI_Ssend_init",            122, ET_MPI_P2P,   ST_MPISEND  },
  { "MPI_Start",                 123, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Startall",              124, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Test",                   39, ET_MPI_MISC,  ST_MPITEST  },
  { "MPI_Test_cancelled",        127, ET_MPI_MISC,  ST_MPITEST  },
  { "MPI_Testall",               125, ET_MPI_MISC,  ST_MPITEST  },
  { "MPI_Testany",               126, ET_MPI_MISC,  ST_MPITEST  },
  { "MPI_Testsome",              128, ET_MPI_MISC,  ST_MPITEST  },
  { "MPI_Topo_test",              58, ET_MPI_TOPO,  ST_MPIOTHER },
  { "MPI_Type_commit",           129, ET_MPI_TYPE,  ST_MPIOTHER },
  { "MPI_Type_contiguous",       130, ET_MPI_TYPE,  ST_MPIOTHER },
  { "MPI_Type_extent",           131, ET_MPI_TYPE,  ST_MPIOTHER },
  { "MPI_Type_free",             132, ET_MPI_TYPE,  ST_MPIOTHER },
  { "MPI_Type_hindexed",         133, ET_MPI_TYPE,  ST_MPIOTHER },
  { "MPI_Type_hvector",          134, ET_MPI_TYPE,  ST_MPIOTHER },
  { "MPI_Type_indexed",          135, ET_MPI_TYPE,  ST_MPIOTHER },
  { "MPI_Type_lb",               136, ET_MPI_TYPE,  ST_MPIOTHER },
  { "MPI_Type_size",             137, ET_MPI_TYPE,  ST_MPIOTHER },
  { "MPI_Type_struct",           138, ET_MPI_TYPE,  ST_MPIOTHER },
  { "MPI_Type_ub",               139, ET_MPI_TYPE,  ST_MPIOTHER },
  { "MPI_Type_vector",           141, ET_MPI_TYPE,  ST_MPIOTHER },
  { "MPI_Unpack",                 77, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Wait",                    5, ET_MPI_P2P,   ST_MPIWAIT  },
  { "MPI_Waitall",                 6, ET_MPI_P2P,   ST_MPIWAIT  },
  { "MPI_Waitany",                59, ET_MPI_P2P,   ST_MPIWAIT  },
  { "MPI_Waitsome",               60, ET_MPI_P2P,   ST_MPIWAIT  },
  { "MPI_Win_complete",           70, ET_MPI_RMA,   ST_MPIRMA   },
  { "MPI_Win_create",             63, ET_MPI_RMA,   ST_MPIRMA   },
  { "MPI_Win_fence",              68, ET_MPI_RMA,   ST_MPIRMA   },
  { "MPI_Win_free",               64, ET_MPI_RMA,   ST_MPIRMA   },
  { "MPI_Win_lock",               74, ET_MPI_RMA,   ST_MPIRMA   },
  { "MPI_Win_post",               71, ET_MPI_RMA,   ST_MPIRMA   },
  { "MPI_Win_start",              69, ET_MPI_RMA,   ST_MPIRMA   },
  { "MPI_Win_test",               73, ET_MPI_RMA,   ST_MPIRMA   },
  { "MPI_Win_unlock",             75, ET_MPI_RMA,   ST_MPIRMA   },
  { "MPI_Win_wait",               72, ET_MPI_RMA,   ST_MPIRMA   },
  { "MPI_Wtick",                 109, ET_MPI_MISC,  ST_MPIOTHER },
  { "MPI_Wtime",                 110, ET_MPI_MISC,  ST_MPIOTHER }
};

#endif
