/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JAttribute;
import ch.epfl.lamp.fjbg.JClass;
import ch.epfl.lamp.fjbg.JCode;
import ch.epfl.lamp.fjbg.JConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

public class JLocalVariableTableAttribute
extends JAttribute {
    private JConstantPool pool;
    protected final LinkedList entries = new LinkedList();
    protected int localVariableIndex = 0;

    public JLocalVariableTableAttribute(FJBGContext context, JClass clazz, JCode code) {
        super(context, clazz);
        this.pool = clazz.pool;
        assert (code.getOwner().getOwner() == clazz);
    }

    public JLocalVariableTableAttribute(FJBGContext context, JClass clazz, Object owner, String name, int size, DataInputStream stream) throws IOException {
        super(context, clazz, name);
        this.pool = clazz.pool;
        int count = stream.readShort();
        for (int i = 0; i < count; ++i) {
            short startPc = stream.readShort();
            short length = stream.readShort();
            short nameIndex = stream.readShort();
            short descIndex = stream.readShort();
            short index = stream.readShort();
            this.addEntry((int)startPc, (int)length, nameIndex, descIndex, (int)index);
        }
        assert (name.equals(this.getName()));
    }

    public void addEntry(int startPc, int length, int nameIndex, int descIndex, int index) {
        this.entries.add(new Entry(startPc, length, nameIndex, descIndex, index));
    }

    public void addEntry(int startPc, int length, String name, String desc, int index) {
        Entry e = new Entry(startPc, length, name, desc, index);
        Entry other = this.getEntry(index);
        if (other != null) {
            assert (other.nameIndex == e.nameIndex && other.descIndex == e.descIndex) : e + " already declared as " + other;
        } else {
            this.entries.add(e);
        }
    }

    public void addEntry(int startPc, int length, String name, String desc) {
        this.entries.add(new Entry(startPc, length, name, desc));
    }

    public String getName() {
        return "LocalVariableTable";
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("  LocalVariableTable: ");
        buf.append("\n   Start  Length  Slot  Name   Signature");
        Iterator it = this.entries.iterator();
        while (it.hasNext()) {
            buf.append("\n   ");
            Entry e = (Entry)it.next();
            JConstantPool.Utf8Entry name = (JConstantPool.Utf8Entry)this.pool.lookupEntry(e.nameIndex);
            JConstantPool.Utf8Entry sig = (JConstantPool.Utf8Entry)this.pool.lookupEntry(e.descIndex);
            buf.append(e.startPc);
            buf.append("      ");
            buf.append(e.length);
            buf.append("      ");
            buf.append(e.index);
            buf.append("    ");
            buf.append(name.getValue());
            buf.append("       ");
            buf.append(sig.getValue());
        }
        buf.append("\n");
        return buf.toString();
    }

    public int getMaxLocals() {
        return this.localVariableIndex;
    }

    public int getSize() {
        return 2 + this.entries.size() * 10;
    }

    protected void writeContentsTo(DataOutputStream stream) throws IOException {
        stream.writeShort(this.entries.size());
        for (Entry e : this.entries) {
            stream.writeShort(e.startPc);
            stream.writeShort(e.length);
            stream.writeShort(e.nameIndex);
            stream.writeShort(e.descIndex);
            stream.writeShort(e.index);
        }
    }

    private Entry getEntry(int index) {
        Entry e = null;
        try {
            e = (Entry)this.entries.get(index);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return e;
    }

    private class Entry {
        int startPc;
        int length;
        int nameIndex;
        int descIndex;
        int index;

        public Entry(int startPc, int length, int nameIndex, int descIndex, int index) {
            this.startPc = startPc;
            this.length = length;
            this.nameIndex = nameIndex;
            this.descIndex = descIndex;
            this.index = index;
            JLocalVariableTableAttribute.this.localVariableIndex += length;
        }

        public Entry(int startPc, int length, String name, String desc, int index) {
            this(startPc, length, jLocalVariableTableAttribute.pool.addUtf8(name), jLocalVariableTableAttribute.pool.addUtf8(desc), index);
        }

        public Entry(int startPc, int length, String name, String desc) {
            this(startPc, length, jLocalVariableTableAttribute.pool.addUtf8(name), jLocalVariableTableAttribute.pool.addUtf8(desc), jLocalVariableTableAttribute.localVariableIndex);
        }

        public boolean equals(Object other) {
            if (other instanceof Entry) {
                Entry otherEntry = (Entry)other;
                return otherEntry.index == this.index;
            }
            return false;
        }
    }
}

