/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kssl;

import com.sun.ksecurity.Certificate;
import com.sun.ksecurity.CryptoException;
import com.sun.ksecurity.KeyBuilder;
import com.sun.ksecurity.KeyStore;
import com.sun.ksecurity.MessageDigest;
import com.sun.ksecurity.RSAPublicKey;
import com.sun.ksecurity.RandomData;
import com.sun.kssl.Cipher;
import com.sun.kssl.HandshakeListener;
import com.sun.kssl.Record;
import com.sun.kssl.SSLStreamConnection;
import com.sun.kssl.Session;
import com.sun.kssl.Utils;
import com.sun.kssl.X509Certificate;
import java.io.IOException;

class Handshake {
    static final byte ARCFOUR_128_MD5 = 4;
    static final byte ARCFOUR_40_MD5 = 3;
    private static final byte[] SUITES_AND_COMP = new byte[]{0, 4, 0, 4, 0, 3, 1, 0};
    private static String[] suiteNames = new String[]{"", "", "", "ARC4_40_MD5", "ARC4_128_MD5"};
    private static final byte HSC_INIT = 1;
    private static final byte HSC_HELLO_SENT = 2;
    private static final byte HSC_FINISH_SENT = 3;
    private static final byte HSC_DONE = 4;
    private static final byte HDR_SIZE = 4;
    private static final byte HELLO_REQ = 0;
    private static final byte C_HELLO = 1;
    private static final byte S_HELLO = 2;
    private static final byte CERT = 11;
    private static final byte S_KEYEXCH = 12;
    private static final byte CERT_REQ = 13;
    private static final byte S_DONE = 14;
    private static final byte CERT_VRFY = 15;
    private static final byte C_KEYEXCH = 16;
    private static final byte FINISH = 20;
    private static final byte MD5_SIZE = 16;
    private static final byte SHA_SIZE = 20;
    private static final byte[] FINISH_PREFIX = new byte[]{20, 0, 0, 36};
    private Record rec;
    private HandshakeListener hl;
    private String peerHost;
    private int peerPort;
    private RandomData rnd = null;
    private byte[] cSession = null;
    private byte[] sSession = null;
    private byte[] crand = null;
    private byte[] srand = null;
    private byte state = 1;
    private byte ver;
    private byte role;
    private byte negSuite;
    private byte gotCertReq = 0;
    private byte[] preMaster = null;
    private byte[] master = null;
    private RSAPublicKey sKey = null;
    private RSAPublicKey eKey = null;
    private int sKeyUsage = 0;
    private byte certCnt = 0;
    private X509Certificate sCert = null;
    private MessageDigest ourMD5 = null;
    private MessageDigest ourSHA = null;
    private byte[] store = null;
    private int start = 0;
    private int cnt = 0;

    private static boolean isOk(HandshakeListener l, X509Certificate c, byte err) {
        if (l == null) {
            Utils.logln((byte)4, "Encountered error number " + err);
            return false;
        }
        return l.SSLCertificateOk(c, err);
    }

    private RSAPublicKey parseChain(String site, byte[] msg, int off, KeyStore tks) {
        try {
            RSAPublicKey sKey = null;
            X509Certificate c = null;
            X509Certificate pc = null;
            X509Certificate ts = null;
            byte by = 65535;
            byte code = 0;
            if (tks == null) {
                throw new IllegalArgumentException("no trusted keystore given");
            }
            this.certCnt = 0;
            while (off < msg.length - 3) {
                Certificate ic;
                int len;
                if (this.certCnt > by) {
                    Handshake.isOk(this.hl, c, (byte)7);
                    return null;
                }
                if ((c = X509Certificate.generateCertificate(msg, off, len = ((msg[off++] & 0xFF) << 16) + ((msg[off++] & 0xFF) << 8) + (msg[off++] & 0xFF))) == null) {
                    return null;
                }
                code = c.checkExtensions();
                if (code != 0) {
                    Handshake.isOk(this.hl, c, code);
                    return null;
                }
                code = c.checkValidity();
                if (code != 0 && !Handshake.isOk(this.hl, c, code)) {
                    return null;
                }
                int pLen = c.getBasicConstraints();
                if (this.certCnt > pLen + 1) {
                    Handshake.isOk(this.hl, c, (byte)7);
                    return null;
                }
                if (this.certCnt == 0) {
                    if (c.getSubjectAltNameType() == 2) {
                        if (!this.checkSiteName(site, (String)c.getSubjectAltName()) && !Handshake.isOk(this.hl, c, (byte)6)) {
                            return null;
                        }
                    } else {
                        String cname = c.getSubject();
                        if (cname == null && !Handshake.isOk(this.hl, c, (byte)6)) {
                            return null;
                        }
                        int tidx = cname.indexOf(59);
                        if (!this.checkSiteName(site, cname = tidx < 0 ? cname.toLowerCase() : cname.substring(3, tidx).toLowerCase()) && !Handshake.isOk(this.hl, c, (byte)6)) {
                            return null;
                        }
                    }
                    this.sCert = c;
                    sKey = (RSAPublicKey)c.getPublicKey();
                    this.sKeyUsage = c.getKeyUsage();
                }
                this.certCnt = (byte)(this.certCnt + 1);
                if (pc != null) {
                    if (pc.getIssuer().compareTo(c.getSubject()) != 0) {
                        Handshake.isOk(this.hl, pc, (byte)11);
                        Utils.logln((byte)4, "Bad certificate chain");
                        return null;
                    }
                    if (this.hl != null) {
                        this.hl.SSLHandshakeUpdate("Verifying certificate# " + (this.certCnt - 1));
                    }
                    if ((code = pc.verify(c.getPublicKey())) != 0) {
                        Handshake.isOk(this.hl, pc, code);
                        return null;
                    }
                }
                if ((ts = (ic = tks.getCertificate(c.getIssuer())) != null && ic.getType().equals("X.509") ? (X509Certificate)ic : null) != null) {
                    if (ts.checkValidity() == 0 || Handshake.isOk(this.hl, ts, (byte)12)) {
                        if (this.hl != null) {
                            this.hl.SSLHandshakeUpdate("Verifying certificate# " + this.certCnt);
                        }
                        code = c.verify(ts.getPublicKey());
                        ts.destroy();
                        ts = null;
                        if (code == 0) {
                            return sKey;
                        }
                    } else {
                        return null;
                    }
                }
                off += len;
                if (pc != null && pc != this.sCert) {
                    pc.destroy();
                }
                pc = c;
            }
            Handshake.isOk(this.hl, pc, (byte)5);
            return null;
        }
        catch (Exception e) {
            Utils.logln((byte)4, "parseChain caught " + e);
            return null;
        }
    }

    Handshake(String host, int port, Record r, HandshakeListener l) throws IOException {
        this.peerHost = new String(host);
        this.peerPort = port;
        this.rec = r;
        this.hl = l;
        this.eKey = null;
        this.sKey = null;
        this.state = 1;
        this.gotCertReq = 0;
        this.start = 0;
        this.cnt = 0;
        try {
            this.ourMD5 = MessageDigest.getInstance((byte)1, false);
            this.ourSHA = MessageDigest.getInstance((byte)2, false);
            this.rnd = RandomData.getInstance((byte)2);
        }
        catch (Exception e) {
            throw new IOException("No MD5 or SHA or Random, caught" + e);
        }
    }

    public void destroy() {
        this.rec = null;
        this.peerHost = null;
        this.rnd = null;
        this.sSession = null;
        this.cSession = null;
        this.srand = null;
        this.crand = null;
        this.master = null;
        this.preMaster = null;
        this.eKey = null;
        this.sKey = null;
        this.ourMD5 = null;
        this.ourSHA = null;
        this.store = null;
        this.hl = null;
    }

    private boolean checkSiteName(String siteName, String certName) {
        if (certName == null) {
            return false;
        }
        if (siteName.length() == certName.length() && siteName.regionMatches(true, 0, certName, 0, certName.length())) {
            return true;
        }
        if (!certName.startsWith("*.")) {
            return false;
        }
        int startOfDomain = siteName.indexOf(46);
        if (startOfDomain == -1) {
            return false;
        }
        int domainLength = siteName.length() - ++startOfDomain;
        if (certName.length() - 2 != domainLength) {
            return false;
        }
        return siteName.regionMatches(true, startOfDomain, certName, 2, domainLength);
    }

    private byte[] getNextMsg(byte type) throws IOException {
        if (this.cnt == 0) {
            byte[] tmp = this.rec.rdRec((byte)22);
            if (tmp == null || tmp.length < 9) {
                throw new IOException("getNextMsg refill failed");
            }
            this.cnt = tmp.length - 5;
            if (this.store == null || this.cnt > this.store.length) {
                this.store = null;
                this.store = this.cnt < 2048 ? new byte[2048] : new byte[this.cnt];
            }
            this.start = 0;
            System.arraycopy(tmp, 5, this.store, this.start, this.cnt);
        }
        if (this.store[this.start] == type) {
            int len = ((this.store[this.start + 1] & 0xFF) << 16) + ((this.store[this.start + 2] & 0xFF) << 8) + (this.store[this.start + 3] & 0xFF);
            if (this.cnt < 4 + len) {
                throw new IOException("Refill got short msg c=" + this.cnt + " l=" + len);
            }
            byte[] msg = new byte[4 + len];
            System.arraycopy(this.store, this.start, msg, 0, msg.length);
            this.start += msg.length;
            this.cnt -= msg.length;
            if (this.start > this.store.length) {
                throw new IOException("getNextMsg problem");
            }
            return msg;
        }
        return null;
    }

    private void sndHello3() throws IOException {
        this.cSession = Session.getSId(this.peerHost, this.peerPort);
        int len = this.cSession == null ? 0 : this.cSession.length;
        byte[] msg = new byte[39 + len + SUITES_AND_COMP.length];
        int idx = 0;
        msg[idx++] = 1;
        int mlen = msg.length - 4;
        msg[idx++] = (byte)(mlen >>> 16);
        msg[idx++] = (byte)(mlen >>> 8);
        msg[idx++] = (byte)(mlen & 0xFF);
        msg[idx++] = (byte)(this.ver >>> 4);
        msg[idx++] = (byte)(this.ver & 0xF);
        this.crand = new byte[32];
        this.rnd.generateData(this.crand, (short)0, (short)32);
        System.arraycopy(this.crand, 0, msg, idx, this.crand.length);
        idx += this.crand.length;
        msg[idx++] = (byte)(len & 0xFF);
        if (this.cSession != null) {
            System.arraycopy(this.cSession, 0, msg, idx, this.cSession.length);
            idx += this.cSession.length;
        }
        System.arraycopy(SUITES_AND_COMP, 0, msg, idx, SUITES_AND_COMP.length);
        this.ourMD5.update(msg, 0, msg.length);
        this.ourSHA.update(msg, 0, msg.length);
        this.rec.wrRec((byte)22, msg, 0, msg.length);
    }

    private int rcvSrvrHello() throws IOException {
        byte[] msg = this.getNextMsg((byte)2);
        if (msg == null || msg.length < 42) {
            return -1;
        }
        int idx = 4;
        if (msg[idx++] != this.ver >>> 4 || msg[idx++] != (this.ver & 0xF)) {
            return -1;
        }
        this.srand = new byte[32];
        System.arraycopy(msg, idx, this.srand, 0, 32);
        idx += 32;
        int slen = msg[idx++] & 0xFF;
        if (slen != 0) {
            if (msg.length < idx + slen) {
                return -1;
            }
            this.sSession = new byte[slen];
            System.arraycopy(msg, idx, this.sSession, 0, slen);
            idx += slen;
        }
        int n = ++idx;
        ++idx;
        this.negSuite = msg[n];
        if (this.negSuite != 4 && this.negSuite != 3 && msg[idx++] != 0) {
            return -1;
        }
        this.ourMD5.update(msg, 0, msg.length);
        this.ourSHA.update(msg, 0, msg.length);
        if (this.hl != null) {
            this.hl.SSLHandshakeUpdate("Negotiated " + (this.negSuite == 4 ? "strong" : "weak") + " encryption");
        } else {
            Utils.logln((byte)1, "Negotiated " + suiteNames[this.negSuite]);
        }
        return 0;
    }

    private int rcvCert() throws IOException {
        byte[] msg;
        if (this.hl != null) {
            this.hl.SSLHandshakeUpdate("Processing server certificate(s) ...");
        }
        if ((msg = this.getNextMsg((byte)11)) == null || msg.length < 7) {
            return -1;
        }
        int idx = 4;
        int len = 0;
        if (idx + (len = ((msg[idx++] & 0xFF) << 16) + ((msg[idx++] & 0xFF) << 8) + (msg[idx++] & 0xFF)) > msg.length) {
            return -1;
        }
        this.certCnt = 0;
        this.sKeyUsage = 0;
        this.sKey = this.parseChain(this.peerHost, msg, idx, SSLStreamConnection.getTrustedKeyStore());
        if (this.sKey == null) {
            return -1;
        }
        this.ourMD5.update(msg, 0, msg.length);
        this.ourSHA.update(msg, 0, msg.length);
        if (this.hl != null) {
            this.hl.SSLHandshakeUpdate("Processed " + this.certCnt + " certificate(s)");
        }
        this.certCnt = 0;
        return 0;
    }

    private int rcvSrvrKeyExch() throws IOException {
        int len;
        byte[] msg = this.getNextMsg((byte)12);
        int idx = 4;
        if (msg == null) {
            this.eKey = this.sKey;
            if (this.sKeyUsage != -1 && (this.sKeyUsage & 4) != 4 && (this.sKeyUsage & 0x20000) != 131072) {
                Utils.logln((byte)4, "Neither keyEncipherment nor serverAuth bit is set in server certificate");
                Handshake.isOk(this.hl, this.sCert, (byte)10);
                this.sCert.destroy();
                this.sCert = null;
                return -2;
            }
            return 0;
        }
        if (this.sKeyUsage != -1 && (this.sKeyUsage & 1) != 1 && (this.sKeyUsage & 0x20000) != 131072) {
            Utils.logln((byte)4, "Neither digitalSignature nor serverAuth bit is set in server certificate");
            if (!Handshake.isOk(this.hl, this.sCert, (byte)10)) {
                this.sCert.destroy();
                this.sCert = null;
                return -2;
            }
        }
        if (msg.length < idx + 4) {
            return -1;
        }
        if (msg.length < idx + (len = ((msg[idx++] & 0xFF) << 16) + (msg[idx++] & 0xFF)) + 2) {
            return -1;
        }
        try {
            if (len == 65 && msg[idx] == 0) {
                this.eKey = (RSAPublicKey)KeyBuilder.buildKey((byte)1, (short)512, false);
                this.eKey.setModulus(msg, (short)(idx + 1), (short)64);
            } else {
                this.eKey = (RSAPublicKey)KeyBuilder.buildKey((byte)1, (short)(len << 3), false);
                this.eKey.setModulus(msg, (short)idx, (short)len);
            }
            idx += len;
            len = ((msg[idx++] & 0xFF) << 16) + (msg[idx++] & 0xFF);
            if (msg.length < idx + len) {
                return -1;
            }
            this.eKey.setExponent(msg, (short)idx, (short)len);
        }
        catch (CryptoException ce) {
            return -1;
        }
        int end = idx += len;
        len = ((msg[idx++] & 0xFF) << 16) + (msg[idx++] & 0xFF);
        if (msg.length < idx + len) {
            return -1;
        }
        byte[] sig = new byte[len];
        System.arraycopy(msg, idx, sig, 0, sig.length);
        if ((idx += len) != msg.length) {
            return -1;
        }
        if (this.hl != null) {
            this.hl.SSLHandshakeUpdate("Verifying RSA parameters ...");
        }
        byte[] dat = new byte[36];
        try {
            MessageDigest di = MessageDigest.getInstance((byte)1, false);
            di.update(this.crand, 0, this.crand.length);
            di.update(this.srand, 0, this.srand.length);
            di.doFinal(msg, 4, end - 4, dat, 0);
            di = MessageDigest.getInstance((byte)2, false);
            di.update(this.crand, 0, this.crand.length);
            di.update(this.srand, 0, this.srand.length);
            di.doFinal(msg, 4, end - 4, dat, 16);
        }
        catch (Exception e) {
            throw new IOException("No MD5 or SHA");
        }
        try {
            Cipher rsa = Cipher.getInstance((byte)2, false);
            rsa.init(this.sKey, (byte)2);
            byte[] res = new byte[this.sKey.getSize() >>> 3];
            int val = rsa.doFinal(sig, 0, sig.length, res, 0);
            if (!Utils.byteMatch(res, 0, dat, 0, dat.length)) {
                Utils.logln((byte)4, "RSA params failed verification");
                return -1;
            }
        }
        catch (Exception e) {
            throw new IOException("RSA decryption caught " + e);
        }
        this.ourMD5.update(msg, 0, msg.length);
        this.ourSHA.update(msg, 0, msg.length);
        return 0;
    }

    private int rcvCertReq() throws IOException {
        byte[] msg = this.getNextMsg((byte)13);
        if (msg == null) {
            return 0;
        }
        this.gotCertReq = 1;
        this.ourMD5.update(msg, 0, msg.length);
        this.ourSHA.update(msg, 0, msg.length);
        return 0;
    }

    private int rcvSrvrHelloDone() throws IOException {
        byte[] msg = this.getNextMsg((byte)14);
        if (msg == null || msg.length != 4) {
            return -1;
        }
        this.ourMD5.update(msg, 0, msg.length);
        this.ourSHA.update(msg, 0, msg.length);
        return 0;
    }

    private void sndKeyExch() throws IOException {
        if (this.gotCertReq == 1) {
            this.rec.alert((byte)2, (byte)41);
            throw new IOException("No client cert");
        }
        this.preMaster = new byte[48];
        this.rnd.generateData(this.preMaster, (short)0, (short)48);
        this.preMaster[0] = (byte)(this.ver >>> 4);
        this.preMaster[1] = (byte)(this.ver & 0xF);
        int modLen = this.eKey.getSize() >>> 3;
        byte[] msg = new byte[4 + modLen];
        int idx = 0;
        msg[idx++] = 16;
        msg[idx++] = (byte)(modLen >>> 16);
        msg[idx++] = (byte)(modLen >>> 8);
        msg[idx++] = (byte)(modLen & 0xFF);
        if (this.hl != null) {
            this.hl.SSLHandshakeUpdate("Encrypting pre-master key ...");
        }
        try {
            Cipher rsa = Cipher.getInstance((byte)2, false);
            rsa.init(this.eKey, (byte)1);
            int val = rsa.doFinal(this.preMaster, 0, 48, msg, idx);
            if (val != modLen) {
                throw new IOException("RSA result too short");
            }
        }
        catch (Exception e) {
            throw new IOException("premaster encryption caught " + e);
        }
        this.ourMD5.update(msg, 0, msg.length);
        this.ourSHA.update(msg, 0, msg.length);
        this.rec.wrRec((byte)22, msg, 0, msg.length);
    }

    private void mkMaster() throws IOException {
        if (this.hl != null) {
            this.hl.SSLHandshakeUpdate("Computing masterkey ...");
        }
        byte[][] expansion = new byte[][]{{65}, {66, 66}, {67, 67, 67}};
        MessageDigest md = null;
        MessageDigest sd = null;
        byte[] tmp = new byte[this.preMaster.length + this.crand.length + this.srand.length];
        System.arraycopy(this.preMaster, 0, tmp, 0, this.preMaster.length);
        System.arraycopy(this.crand, 0, tmp, this.preMaster.length, this.crand.length);
        System.arraycopy(this.srand, 0, tmp, this.preMaster.length + this.crand.length, this.srand.length);
        try {
            md = MessageDigest.getInstance((byte)1, false);
            sd = MessageDigest.getInstance((byte)2, false);
        }
        catch (Exception e) {
            throw new IOException("No MD5 or SHA");
        }
        this.master = new byte[48];
        int i = 0;
        while (i < 3) {
            md.update(this.preMaster, 0, this.preMaster.length);
            sd.update(expansion[i], 0, expansion[i].length);
            byte[] res = new byte[20];
            sd.doFinal(tmp, 0, tmp.length, res, 0);
            md.doFinal(res, 0, res.length, this.master, i << 4);
            ++i;
        }
        if (this.hl != null) {
            this.hl.SSLHandshakeUpdate("Computed masterkey");
        }
    }

    private void sndChangeCipher() throws IOException {
        byte[] msg = new byte[]{1};
        this.rec.wrRec((byte)20, msg, 0, 1);
    }

    private byte[] computeFinished(byte who) throws IOException {
        byte[][] sender = new byte[][]{{83, 82, 86, 82}, {67, 76, 78, 84}};
        byte[] msg = new byte[36];
        byte[] tmp = null;
        try {
            MessageDigest d = (MessageDigest)this.ourMD5.clone();
            d.update(sender[who], 0, 4);
            d.update(this.master, 0, this.master.length);
            tmp = new byte[16];
            d.doFinal(Record.PAD1, 0, 48, tmp, 0);
            d.update(this.master, 0, this.master.length);
            d.update(Record.PAD2, 0, 48);
            d.doFinal(tmp, 0, 16, msg, 0);
            d = (MessageDigest)this.ourSHA.clone();
            d.update(sender[who], 0, 4);
            d.update(this.master, 0, this.master.length);
            tmp = new byte[20];
            d.doFinal(Record.PAD1, 0, 40, tmp, 0);
            d.update(this.master, 0, this.master.length);
            d.update(Record.PAD2, 0, 40);
            d.doFinal(tmp, 0, 20, msg, 16);
            return msg;
        }
        catch (Exception e) {
            throw new IOException("MessageDigest not cloneable");
        }
    }

    private void sndFinished() throws IOException {
        byte[] msg = new byte[40];
        System.arraycopy(FINISH_PREFIX, 0, msg, 0, 4);
        System.arraycopy(this.computeFinished(this.role), 0, msg, 4, 36);
        this.ourMD5.update(msg, 0, msg.length);
        this.ourSHA.update(msg, 0, msg.length);
        this.rec.wrRec((byte)22, msg, 0, msg.length);
    }

    private int rcvChangeCipher() throws IOException {
        if (this.cnt != 0) {
            Utils.logln((byte)4, "Unread handshake mesg in store");
            return -1;
        }
        byte[] msg = this.rec.rdRec((byte)20);
        if (msg == null || msg.length != 6 || msg[5] != 1) {
            return -1;
        }
        return 0;
    }

    private int rcvFinished() throws IOException {
        byte[] msg = this.getNextMsg((byte)20);
        if (msg == null || msg.length != 40) {
            return -1;
        }
        byte[] expected = this.computeFinished((byte)(1 - this.role));
        if (!Utils.byteMatch(msg, 4, expected, 0, expected.length)) {
            return -1;
        }
        this.ourMD5.update(msg, 0, msg.length);
        this.ourSHA.update(msg, 0, msg.length);
        return 0;
    }

    void doHandShake(byte aswho) throws IOException {
        if (this.hl != null) {
            this.hl.SSLHandshakeUpdate("Initiating SSL handshake ...");
        }
        long t1 = System.currentTimeMillis();
        this.ver = (byte)48;
        this.role = aswho;
        boolean val = false;
        while (this.state != 4) {
            switch (this.state) {
                case 1: {
                    this.sndHello3();
                    this.state = (byte)2;
                    break;
                }
                case 2: {
                    if (this.rcvSrvrHello() < 0) {
                        this.complain("Bad ServerHello");
                    }
                    if (this.sSession == null || this.cSession == null || this.sSession.length != this.cSession.length || !Utils.byteMatch(this.sSession, 0, this.cSession, 0, this.sSession.length)) {
                        if (this.rcvCert() < 0) {
                            this.complain("Bad Certificate");
                        }
                        int code = 0;
                        code = this.rcvSrvrKeyExch();
                        if (code < 0) {
                            if (code == -2) {
                                this.complain("Bad Certificate");
                            } else {
                                this.complain("Bad ServerKeyExchange");
                            }
                        }
                        this.rcvCertReq();
                        if (this.rcvSrvrHelloDone() < 0) {
                            this.complain("Bad ServerHelloDone");
                        }
                        this.sndKeyExch();
                        this.mkMaster();
                        try {
                            this.rec.init(this.crand, this.srand, this.negSuite, this.master);
                        }
                        catch (Exception e) {
                            this.complain("Record.init() caught " + e);
                        }
                        this.sndChangeCipher();
                        this.sndFinished();
                        this.state = (byte)3;
                        break;
                    }
                    this.master = Session.getMaster(this.peerHost, this.peerPort, this.sSession);
                    try {
                        this.rec.init(this.crand, this.srand, this.negSuite, this.master);
                    }
                    catch (Exception e) {
                        this.complain("Record.init() caught " + e);
                    }
                    if (this.rcvChangeCipher() < 0) {
                        this.complain("Bad ChangeCipherSpec");
                    }
                    if (this.rcvFinished() < 0) {
                        this.complain("Bad Finished");
                    }
                    this.sndChangeCipher();
                    this.sndFinished();
                    this.state = (byte)4;
                    break;
                }
                case 3: {
                    if (this.rcvChangeCipher() < 0) {
                        this.complain("Bad ChangeCipherSpec");
                    }
                    if (this.rcvFinished() < 0) {
                        this.complain("Bad Finished");
                    }
                    this.state = (byte)4;
                    break;
                }
                default: {
                    throw new IOException("Bad hndshk state " + this.state);
                }
            }
        }
        Session.add(this.peerHost, this.peerPort, this.sSession, this.master);
        if (this.preMaster != null) {
            int i = 0;
            while (i < this.preMaster.length) {
                this.preMaster[i] = 0;
                ++i;
            }
        }
        int i = 0;
        while (i < this.master.length) {
            this.master[i] = 0;
            ++i;
        }
        if (this.hl != null) {
            this.hl.SSLHandshakeUpdate("SSL handshake took " + (int)(System.currentTimeMillis() - t1) + "ms");
        }
    }

    private void complain(String msg) throws IOException {
        this.rec.alert((byte)2, (byte)40);
        if (this.sSession != null) {
            Session.del(this.peerHost, this.peerPort, this.sSession);
        }
        throw new IOException(msg);
    }
}

