/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Screen;

public class Ticker {
    private String message;
    private int messageLoc;
    private int messageWidth;
    private static final Image TICKER_IMG;
    static final long TICK_RATE = 250L;
    static final int TICK_SPEED = 5;
    static final int PREFERRED_HEIGHT;

    public Ticker(String str) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.setupText(str);
        }
    }

    public void setString(String str) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.setupText(str);
        }
    }

    public String getString() {
        return this.message;
    }

    void paintContent(Graphics g) {
        if (g.getClipHeight() > Screen.CONTENT_HEIGHT) {
            int imgLoc = 0;
            while (imgLoc < Display.WIDTH) {
                g.drawImage(TICKER_IMG, imgLoc, 0, 20);
                g.drawImage(TICKER_IMG, imgLoc, Screen.CONTENT_HEIGHT + 3, 20);
                imgLoc += 96;
            }
            g.setColor(Display.ERASE_COLOR);
            g.fillRect(0, 2, Display.WIDTH, Screen.CONTENT_HEIGHT + 1);
        }
        g.setColor(Display.ERASE_COLOR);
        g.fillRect(this.messageLoc, 1, this.messageWidth, Screen.CONTENT_HEIGHT);
        g.setColor(0);
        this.messageLoc -= 5;
        g.drawString(this.message, this.messageLoc, 2, 20);
        if (this.messageLoc <= -this.messageWidth) {
            this.messageLoc = Display.WIDTH;
        }
    }

    void reset() {
        this.messageLoc = Display.WIDTH;
    }

    private final void setupText(String message) {
        if (message == null) {
            throw new NullPointerException();
        }
        this.message = message;
        this.messageWidth = Screen.CONTENT_FONT.stringWidth(message);
    }

    static {
        byte[] imgData = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 94, 0, 0, 0, 1, 2, 3, 0, 0, 0, 42, 100, -15, -33, 0, 0, 0, 12, 80, 76, 84, 69, -1, -1, -1, -69, -69, -69, 106, 106, 106, 2, 2, 2, 106, -103, 14, -47, 0, 0, 0, 13, 73, 68, 65, 84, 120, -38, 99, -8, 21, -128, 29, 2, 0, -59, 113, 15, 121, -102, 106, 23, 47, 0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
        TICKER_IMG = Image.createImage(imgData, 0, imgData.length);
        PREFERRED_HEIGHT = Screen.CONTENT_HEIGHT + 4;
    }
}

