/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io;

import java.io.IOException;

public class HttpUrl {
    public String scheme;
    public String authority;
    public String path;
    public String query;
    public String fragment;
    public String host;
    public int port = -1;
    public String machine;
    public String domain;

    public HttpUrl(String url) throws IOException {
        int endOfScheme = url.indexOf(58);
        if (endOfScheme < url.indexOf(47)) {
            this.scheme = url.substring(0, endOfScheme);
            ++endOfScheme;
        } else {
            if (endOfScheme != -1 && endOfScheme == url.length() - 1) {
                this.scheme = url.substring(0, endOfScheme);
                return;
            }
            endOfScheme = 0;
        }
        this.parseAfterScheme(url, endOfScheme);
    }

    public HttpUrl(String theScheme, String partialUrl) throws IOException {
        this.scheme = theScheme;
        this.parseAfterScheme(partialUrl, 0);
    }

    private void parseAfterScheme(String url, int afterScheme) throws IOException {
        int endOfHost;
        int endOfUrl;
        int endOfAuthority = endOfUrl = url.length();
        int endOfPath = endOfUrl;
        int endOfQuery = endOfUrl;
        int startOfAuthority = url.startsWith("//", afterScheme) ? afterScheme + 2 : afterScheme;
        int start = url.indexOf(35, startOfAuthority);
        if (start != -1) {
            endOfAuthority = start;
            endOfPath = start;
            endOfQuery = start;
            if (start + 2 < endOfUrl) {
                this.fragment = url.substring(start + 1, endOfUrl);
            }
        }
        if ((start = url.indexOf(63, startOfAuthority)) != -1 && start < endOfQuery) {
            endOfAuthority = start;
            endOfPath = start;
            if (start + 2 < endOfQuery) {
                this.query = url.substring(start + 1, endOfQuery);
            }
        }
        if ((start = startOfAuthority == afterScheme ? afterScheme : url.indexOf(47, startOfAuthority)) != -1 && start < endOfPath) {
            endOfAuthority = start;
            if (start + 2 < endOfPath) {
                this.path = url.substring(start, endOfPath);
            }
        }
        if (startOfAuthority >= endOfAuthority) {
            return;
        }
        this.authority = url.substring(startOfAuthority, endOfAuthority);
        int endOfPort = this.authority.length();
        int startOfPort = this.authority.lastIndexOf(58);
        if (startOfPort != -1 && startOfPort > this.authority.indexOf(93)) {
            endOfHost = startOfPort;
            if (startOfPort + 2 < endOfPort) {
                try {
                    this.port = Integer.parseInt(this.authority.substring(startOfPort + 1, endOfPort));
                }
                catch (NumberFormatException nfe) {
                    throw new IOException("invalid port");
                }
            }
        } else {
            endOfHost = endOfPort;
        }
        this.host = this.authority.substring(0, endOfHost);
        if (Character.isDigit(this.host.charAt(0)) || this.host.charAt(0) == '[') {
            return;
        }
        int startOfDomain = this.host.indexOf(46);
        if (startOfDomain != -1) {
            this.domain = this.host.substring(startOfDomain + 1, this.host.length());
            this.machine = this.host.substring(0, startOfDomain);
        } else {
            this.machine = this.host;
        }
    }

    public void addBaseUrl(String baseUrl) throws IOException {
        this.addBaseUrl(new HttpUrl(baseUrl));
    }

    public void addBaseUrl(HttpUrl baseUrl) {
        if (this.authority != null) {
            return;
        }
        this.scheme = baseUrl.scheme;
        this.authority = baseUrl.authority;
        if (this.path == null) {
            this.path = baseUrl.path;
            return;
        }
        if (this.path.charAt(0) == '/' || baseUrl.path == null || baseUrl.path.charAt(0) != '/') {
            return;
        }
        String basePath = baseUrl.path.substring(0, baseUrl.path.lastIndexOf(47));
        this.path = basePath + '/' + this.path;
    }

    public String toString() {
        StringBuffer url = new StringBuffer();
        if (this.scheme != null) {
            url.append(this.scheme);
            url.append(':');
        }
        if (this.authority != null) {
            url.append('/');
            url.append('/');
            url.append(this.authority);
        }
        if (this.path != null) {
            url.append(this.path);
        }
        if (this.query != null) {
            url.append('?');
            url.append(this.path);
        }
        if (this.fragment != null) {
            url.append('#');
            url.append(this.fragment);
        }
        return url.toString();
    }
}

