/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import com.sun.midp.lcdui.Resource;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Layout;

class StringLayout
implements Layout {
    private String str;
    private short[] lineBreaks = new short[2];
    private int numLines;
    private int width = -1;
    private int height;
    private int maxHeight = -1;
    protected Font f;
    protected int lineHeight;
    protected int offsetWidth;
    private boolean isOffset;
    private int clippingIndicatorLineNumber;
    private static final String ELLIPSIS_CHAR = Resource.getString("...");
    private int widthOfEllipsisChar;
    private int ellipsisXOffset;

    StringLayout(String str, Font font) {
        this.str = str;
        this.f = font;
        this.lineHeight = font.getHeight();
        this.offsetWidth = 3 * this.f.charWidth(' ');
        this.clippingIndicatorLineNumber = -1;
        this.widthOfEllipsisChar = this.f.stringWidth(" ") + this.f.stringWidth(ELLIPSIS_CHAR);
    }

    public int getWidth() {
        return this.width;
    }

    public int setWidth(int w) {
        if (this.width != w && w >= 0) {
            this.width = w;
            this.updateLineBreaks();
        }
        return this.height;
    }

    public int getHeight() {
        return this.height;
    }

    public void setMaxHeight(int h) {
        if (h < 0) {
            h = 0;
        }
        this.maxHeight = h;
        this.updateLineBreaks();
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public void paint(Graphics g, boolean eraseBgrnd, boolean inverted) {
        if (this.numLines <= 0) {
            return;
        }
        int from = 0;
        int y = g.getClipY();
        if (y > this.height) {
            return;
        }
        int yEnd = y + g.getClipHeight();
        if (yEnd > this.height) {
            yEnd = this.height;
        }
        if (y < 0) {
            y = 0;
        } else if (y > 0) {
            from = y / this.lineHeight;
            if (from >= this.numLines) {
                return;
            }
            y = from * this.lineHeight;
            if (y > yEnd) {
                return;
            }
        }
        if (eraseBgrnd) {
            g.setColor(inverted ? 0 : Display.ERASE_COLOR);
            g.fillRect(0, y, this.width, this.height);
        }
        g.setFont(this.f);
        g.setColor(inverted ? Display.FG_H_COLOR : 0);
        short prevIndex = from == 0 ? (short)0 : this.lineBreaks[from - 1];
        int i = from;
        while (i < this.numLines && y < yEnd) {
            short index = this.lineBreaks[i];
            int n = index - prevIndex;
            if (this.str.charAt(index - 1) == '\n') {
                --n;
            }
            if (n > 0) {
                int x = i > 0 && this.isOffset ? this.offsetWidth : 0;
                g.drawSubstring(this.str, prevIndex, n, x, y, 20);
            }
            y += this.lineHeight;
            prevIndex = index;
            ++i;
        }
        if (i - 1 == this.clippingIndicatorLineNumber) {
            g.drawString(ELLIPSIS_CHAR, this.ellipsisXOffset, y - this.lineHeight, 20);
        }
    }

    String getString() {
        return this.str;
    }

    void setOffset(boolean isOffset) {
        this.isOffset = isOffset;
    }

    int setString(String str) {
        this.str = str;
        if (this.width > 0) {
            int oldHeight = this.height;
            this.updateLineBreaks();
            return this.height - oldHeight;
        }
        return 0;
    }

    private int addBreak(short spot) {
        if (this.numLines == this.lineBreaks.length) {
            short[] newBreaks = new short[this.lineBreaks.length + 2];
            System.arraycopy(this.lineBreaks, 0, newBreaks, 0, this.lineBreaks.length);
            this.lineBreaks = newBreaks;
        }
        this.lineBreaks[this.numLines] = spot;
        return this.isOffset ? this.width - this.offsetWidth : this.width;
    }

    private void updateLineBreaks() {
        this.clippingIndicatorLineNumber = -1;
        if (this.str == null || this.str.length() == 0 || this.width <= 0) {
            this.lineBreaks[0] = 0;
            this.numLines = 0;
            this.height = 0;
            return;
        }
        this.numLines = 0;
        int w = this.width;
        int curWidth = 0;
        int wordWidth = 0;
        int spaceIndex = 0;
        int numChars = this.str.length();
        int i = 0;
        while (i < numChars) {
            char ch = this.str.charAt(i);
            int charWidth = this.f.charWidth(ch);
            if (ch == '\n') {
                this.addBreak((short)(i + 1));
                ++this.numLines;
                wordWidth = 0;
                curWidth = 0;
            } else {
                if (ch == ' ') {
                    spaceIndex = i;
                    wordWidth = 0;
                } else {
                    wordWidth += charWidth;
                }
                if ((curWidth += charWidth) > w) {
                    if (spaceIndex == 0) {
                        w = this.addBreak((short)i);
                        curWidth = charWidth;
                    } else {
                        w = this.addBreak((short)(spaceIndex + 1));
                        curWidth = i == spaceIndex ? 0 : wordWidth;
                    }
                    ++this.numLines;
                    spaceIndex = 0;
                }
            }
            ++i;
        }
        this.addBreak((short)numChars);
        if (numChars > 0) {
            ++this.numLines;
        }
        this.height = this.numLines * this.lineHeight;
        if (this.maxHeight != -1 && this.height > this.maxHeight) {
            this.clippingIndicatorLineNumber = this.maxHeight / this.lineHeight - 1;
            short startOfLine = 0;
            if (this.clippingIndicatorLineNumber > 0) {
                startOfLine = this.lineBreaks[this.clippingIndicatorLineNumber - 1];
            }
            short newLineBreak = this.lineBreaks[this.clippingIndicatorLineNumber];
            int allowedWidth = this.width - this.widthOfEllipsisChar;
            int currWidth = this.f.substringWidth(this.str, startOfLine, newLineBreak - startOfLine);
            this.ellipsisXOffset = 0;
            while (currWidth < allowedWidth && newLineBreak <= numChars) {
                short s = newLineBreak;
                newLineBreak = (short)(newLineBreak + 1);
                currWidth += this.f.charWidth(this.str.charAt(s));
            }
            while (currWidth > allowedWidth) {
                newLineBreak = (short)(newLineBreak - 1);
                currWidth -= this.f.charWidth(this.str.charAt(newLineBreak));
            }
            this.ellipsisXOffset = currWidth;
            this.lineBreaks[this.clippingIndicatorLineNumber] = newLineBreak;
            this.height = this.maxHeight;
        }
    }
}

