/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import com.sun.midp.lcdui.Resource;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.StringLayout;

public class Alert
extends Screen {
    public static final int FOREVER = -2;
    static final Command OK = new Command(Resource.getString("Done"), 4, 0);
    CommandListener implicitListener = new CommandListener(){

        public void commandAction(Command c, Displayable s) {
            if (c == OK) {
                Object object = Display.LCDUILock;
                synchronized (object) {
                    Alert.this.currentDisplay.clearAlert();
                }
            }
        }
    };
    private static final int DEFAULT_TIMEOUT = 2000;
    private int time = 2000;
    private AlertType type;
    private StringLayout alertText;
    private Image alertImage;
    private int imgHeight;
    private int alertHeight;

    public Alert(String title) {
        this(title, null, null, null);
    }

    public Alert(String title, String alertText, Image alertImage, AlertType alertType) {
        super(title);
        this.setImageImpl(alertImage);
        this.setStringImpl(alertText);
        this.type = alertType;
        this.doLayout();
    }

    public int getDefaultTimeout() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            int n = this.alertHeight > this.viewPortHeight ? -2 : 2000;
            return n;
        }
    }

    public int getTimeout() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            int n = this.alertHeight > this.viewPortHeight ? -2 : this.time;
            return n;
        }
    }

    public void setTimeout(int time) {
        if (time <= 0 && time != -2) {
            throw new IllegalArgumentException();
        }
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.time = time;
        }
    }

    public AlertType getType() {
        return this.type;
    }

    public void setType(AlertType type) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.type = type;
        }
    }

    public String getString() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            String string = this.getStringImpl();
            return string;
        }
    }

    public void setString(String str) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.setStringImpl(str);
        }
    }

    public Image getImage() {
        return this.alertImage;
    }

    public void setImage(Image img) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.setImageImpl(img);
        }
    }

    public void addCommand(Command cmd) {
        throw new IllegalStateException();
    }

    public void setCommandListener(CommandListener l) {
        throw new IllegalStateException();
    }

    void showNotifyImpl(Display d) {
        super.showNotifyImpl(d);
        if (this.getTimeout() == -2) {
            super.addCommandImpl(OK);
            super.setCommandListener(this.implicitListener);
        }
    }

    void hideNotifyImpl(Display d) {
        super.hideNotifyImpl(d);
        super.removeCommandImpl(OK);
        super.setCommandListener(null);
    }

    void paintContent(Graphics g) {
        g.setColor(Display.ERASE_COLOR);
        g.fillRect(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
        int yOffset = (this.viewPortHeight - this.alertHeight) / 2;
        if (yOffset < 0) {
            yOffset = 0;
        }
        if (this.alertImage != null) {
            int xOffset = (this.viewPortWidth - this.alertImage.getWidth()) / 2;
            if (xOffset < 0) {
                xOffset = 0;
            }
            g.drawImage(this.alertImage, xOffset, yOffset, 20);
        }
        if (this.alertText != null) {
            g.translate(0, this.imgHeight + yOffset);
            this.alertText.paint(g, false, false);
        }
    }

    int layoutContent(int w, int h) {
        this.alertHeight = 0;
        if (this.alertText != null) {
            this.alertHeight += this.alertText.setWidth(w);
        }
        this.alertHeight += this.imgHeight;
        return this.alertHeight;
    }

    private void setImageImpl(Image img) {
        Image currentImg = this.getImage();
        if (currentImg == null && img == null || currentImg != null && img != null && currentImg == img) {
            return;
        }
        if (img != null && img.isMutable()) {
            throw new IllegalArgumentException();
        }
        int newImageHeight = img == null ? 0 : img.getHeight();
        this.alertImage = img;
        this.contentChanged(null, 0, 0, newImageHeight - this.imgHeight);
        this.alertHeight += newImageHeight - this.imgHeight;
        this.imgHeight = newImageHeight;
    }

    private void setStringImpl(String str) {
        String currentStr = this.getStringImpl();
        if (currentStr == null && str == null || currentStr != null && str != null && currentStr.equals(str)) {
            return;
        }
        int deltaHeight = 0;
        if (this.alertText == null) {
            this.alertText = new StringLayout(str, Screen.CONTENT_FONT);
            if (this.initLayoutDone()) {
                deltaHeight = this.alertText.setWidth(this.viewPortWidth);
            }
        } else {
            deltaHeight = this.alertText.setString(str);
        }
        this.alertHeight += deltaHeight;
        this.contentChanged(null, 0, 0, deltaHeight);
    }

    private String getStringImpl() {
        return this.alertText == null ? null : this.alertText.getString();
    }
}

