/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.rms;

import com.sun.midp.io.j2me.storage.File;
import com.sun.midp.io.j2me.storage.RandomAccessStream;
import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.security.SecurityDomain;
import java.io.IOException;
import java.util.Vector;

public class RecordStoreFile {
    private static SecurityDomain classSecurityDomain;
    private static final String dbExtension = ".db";
    private RandomAccessStream recordStream;

    public static void initSecurityDomain(SecurityDomain theDomain) {
        if (classSecurityDomain != null) {
            return;
        }
        classSecurityDomain = theDomain;
    }

    public RecordStoreFile(String filename) throws IOException {
        String path = RecordStoreFile.getStoragePath(filename);
        RandomAccessStream newStream = new RandomAccessStream(classSecurityDomain);
        newStream.connect(path, 3);
        this.recordStream = newStream;
    }

    public static boolean exists(String filename) {
        String path = RecordStoreFile.getStoragePath(filename);
        File file = new File(classSecurityDomain);
        return file.exists(path);
    }

    public static boolean deleteFile(String filename) {
        String path = RecordStoreFile.getStoragePath(filename);
        File file = new File(classSecurityDomain);
        try {
            file.delete(path);
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public void seek(int pos) throws IOException {
        this.recordStream.setPosition(pos);
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int offset, int numBytes) throws IOException {
        this.recordStream.writeBytes(buf, offset, numBytes);
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int offset, int numBytes) throws IOException {
        return this.recordStream.readBytes(buf, offset, numBytes);
    }

    public void close() throws IOException {
        if (this.recordStream != null) {
            this.recordStream.disconnect();
            this.recordStream = null;
        }
    }

    public void truncate(int size) throws IOException {
        if (this.recordStream != null) {
            this.recordStream.truncate(size);
        }
    }

    public static String[] listRecordStores() {
        File storage = new File(classSecurityDomain);
        String storageRoot = RecordStoreFile.getStoragePath(null);
        Vector files = storage.filenamesThatStartWith(storageRoot);
        Vector<String> names = new Vector<String>();
        int i = 0;
        while (i < files.size()) {
            String file = (String)files.elementAt(i);
            if (file.endsWith(dbExtension)) {
                String asciiName = file.substring(storageRoot.length(), file.length() - 3);
                names.addElement(File.asciiFilenameToUnicode(asciiName));
            }
            ++i;
        }
        if (names.size() == 0) {
            return null;
        }
        Object[] rv = new String[names.size()];
        names.copyInto(rv);
        return rv;
    }

    public static int spaceAvailable() {
        return new File(classSecurityDomain).getBytesAvailableForFiles();
    }

    private static String getStoragePath(String name) {
        MIDletSuite mSuite = Scheduler.getScheduler().getMIDletSuite();
        String str = mSuite.getStorageRoot();
        if (name != null) {
            StringBuffer path = new StringBuffer(str);
            path.append(File.unicodeToAsciiFilename(name));
            path.append(dbExtension);
            str = path.toString();
        }
        return str;
    }
}

