/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io;

import com.sun.cldc.io.ConnectionBaseInterface;
import com.sun.midp.io.BaseInputStream;
import com.sun.midp.io.BaseOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.StreamConnection;

public abstract class ConnectionBaseAdapter
implements ConnectionBaseInterface,
StreamConnection {
    protected boolean connectionOpen = false;
    int iStreams = 0;
    protected int maxIStreams = 1;
    int oStreams = 0;
    protected int maxOStreams = 1;

    public Connection openPrim(String name, int mode, boolean timeouts) throws IOException {
        switch (mode) {
            case 1: {
                this.maxOStreams = 0;
                break;
            }
            case 2: {
                this.maxIStreams = 0;
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal mode");
            }
        }
        this.connect(name, mode, timeouts);
        this.connectionOpen = true;
        return this;
    }

    public InputStream openInputStream() throws IOException {
        this.ensureOpen();
        if (this.maxIStreams == 0) {
            throw new IOException("write-only connection");
        }
        if (this.iStreams == this.maxIStreams) {
            throw new IOException("no more input streams available");
        }
        BaseInputStream i = new BaseInputStream(this);
        ++this.iStreams;
        return i;
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public OutputStream openOutputStream() throws IOException {
        this.ensureOpen();
        if (this.maxOStreams == 0) {
            throw new IOException("read-only connection");
        }
        if (this.oStreams == this.maxOStreams) {
            throw new IOException("no more output streams available");
        }
        BaseOutputStream o = new BaseOutputStream(this);
        ++this.oStreams;
        return o;
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    public void close() throws IOException {
        if (this.connectionOpen) {
            this.connectionOpen = false;
            this.closeCommon();
        }
    }

    void closeCommon() throws IOException {
        if (!this.connectionOpen && this.iStreams == 0 && this.oStreams == 0) {
            this.disconnect();
        }
    }

    protected void ensureOpen() throws IOException {
        if (!this.connectionOpen) {
            throw new IOException("Connection closed");
        }
    }

    protected abstract void connect(String var1, int var2, boolean var3) throws IOException;

    protected abstract void disconnect() throws IOException;

    protected abstract int readBytes(byte[] var1, int var2, int var3) throws IOException;

    protected int readBytesNonBlocking(byte[] b, int off, int len) throws IOException {
        return 0;
    }

    protected abstract int writeBytes(byte[] var1, int var2, int var3) throws IOException;

    protected void flush() throws IOException {
    }
}

