/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.io.j2me.socket;

import com.sun.cldc.io.GeneralBase;
import com.sun.cldc.io.j2me.socket.Protocol;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;

class PrivateOutputStream
extends OutputStream {
    protected Protocol parent;
    byte[] bytebuf;

    public PrivateOutputStream(Protocol parent) throws IOException {
        this.parent = parent;
    }

    void ensureOpen() throws IOException {
        if (this.parent == null) {
            throw new IOException("Stream closed");
        }
    }

    public synchronized void write(int b) throws IOException {
        if (this.bytebuf == null) {
            this.bytebuf = new byte[1];
        }
        this.bytebuf[0] = (byte)b;
        this.write(this.bytebuf, 0, 1);
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        int count;
        this.ensureOpen();
        if (b == null) {
            throw new NullPointerException();
        }
        if (len == 0) {
            return;
        }
        int n = 0;
        while ((n += (count = this.write1(b, off + n, len - n))) != len) {
            if (count != 0) continue;
            GeneralBase.iowait();
        }
    }

    protected int write1(byte[] b, int off, int len) throws IOException {
        if (this.parent == null) {
            throw new InterruptedIOException();
        }
        return this.parent.write0(b, off, len);
    }

    public void close() throws IOException {
        if (this.parent != null) {
            this.ensureOpen();
            this.flush();
            this.parent.realClose();
            this.parent.osopen = false;
            this.parent = null;
        }
    }
}

