/*
 * Decompiled with CFR 0.152.
 */
package com.sun.cldc.i18n.uclc;

public class DefaultCaseConverter {
    public static boolean isLowerCase(char ch) {
        return ch >= 'a' && ch <= 'z';
    }

    public static boolean isUpperCase(char ch) {
        return ch >= 'A' && ch <= 'Z';
    }

    public static char toLowerCase(char ch) {
        if (DefaultCaseConverter.isUpperCase(ch)) {
            return (char)(ch + 32);
        }
        return ch;
    }

    public static char toUpperCase(char ch) {
        if (DefaultCaseConverter.isLowerCase(ch)) {
            return (char)(ch - 32);
        }
        return ch;
    }

    public static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static int digit(char ch, int radix) {
        int value = -1;
        if (radix >= 2 && radix <= 36) {
            if (DefaultCaseConverter.isDigit(ch)) {
                value = ch - 48;
            } else if (DefaultCaseConverter.isUpperCase(ch) || DefaultCaseConverter.isLowerCase(ch)) {
                value = (ch & 0x1F) + 9;
            }
        }
        return value < radix ? value : -1;
    }
}

