.SS Build environment
.TP
.BR LD_LIBRARY_PATH
STRING type.
Library search path to use inside the chroot.
.IP
Default:
.PP
.RS
\f[CR]$ld_library_path = undef;\fP
.br
.RE
.TP
.BR PATH
STRING type.
PATH to set when running dpkg-buildpackage.
.IP
Default:
.PP
.RS
\f[CR]$path = '/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:/usr/games';\fP
.br
.RE
.SS Build options
.TP
.BR APPEND_TO_VERSION
STRING type.
Suffix to append to version number.  May be useful for derivative
distributions.
.IP
Default:
.PP
.RS
\f[CR]$append_to_version = undef;\fP
.br
.RE
.TP
.BR ARCH
STRING type.
Build architecture.
.IP
Default:
.PP
.RS
\f[CR]$arch = 'amd64';\fP
.br
.RE
.TP
.BR BUILD_ARCH_ALL
BOOL type.
Build architecture: all packages by default
.IP
Default:
.PP
.RS
\f[CR]$build_arch_all = 0;\fP
.br
.RE
.TP
.BR BUILD_ENV_CMND
STRING type.
This command is run with the dpkg-buildpackage command line passed to it
(in the chroot, if doing a chrooted build).  It is used by the sparc buildd
(which is sparc64) to call the wrapper script that sets the environment to
sparc (32-bit).  It could be used for other build environment setup
scripts.  Note that this is superceded by schroot's 'command-prefix' option
.IP
Default:
.PP
.RS
\f[CR]$build_env_cmnd = '';\fP
.br
.RE
.TP
.BR BUILD_SOURCE
BOOL type.
By default, do not build a source package (binary only build).	Set to 1 to
force creation of a source package, but note that this is inappropriate for
binary NMUs, where the option will always be disabled.
.IP
Default:
.PP
.RS
\f[CR]$build_source = 0;\fP
.br
.RE
.TP
.BR CHECK_SPACE
BOOL type.
Check free disk space prior to starting a build.  sbuild requires the free
space to be at least twice the size of the unpacked sources to allow a
build to proceed.  Can be disabled to allow building if space is very
limited, but the threshold to abort a build has been exceeded despite there
being sufficient space for the build to complete.
.IP
Default:
.PP
.RS
\f[CR]$check_space = 1;\fP
.br
.RE
.TP
.BR DISTRIBUTION
STRING type.
Default distribution.  By default, no distribution is defined, and the user
must specify it with the -d option.  However, a default may be configured
here if desired.  Users must take care not to upload to the wrong
distribution when this option is set, for example experimental packages
will be built for upload to unstable when this is not what is required.
.IP
Default:
.PP
.RS
\f[CR]$distribution = undef;\fP
.br
.RE
.TP
.BR FORCE_ORIG_SOURCE
BOOL type.
By default, the -s option only includes the .orig.tar.gz when needed (i.e.
when the Debian revision is 0 or 1).  By setting this option to 1, the
.orig.tar.gz will always be included when -s is used.  This is equivalent
to --force-orig-source.
.IP
Default:
.PP
.RS
\f[CR]$force_orig_source = 0;\fP
.br
.RE
.TP
.BR GCC_SNAPSHOT
BOOL type.
Build using current GCC snapshot?
.IP
Default:
.PP
.RS
\f[CR]$gcc_snapshot = 0;\fP
.br
.RE
.TP
.BR PGP_OPTIONS
ARRAY:STRING type.
Additional signing options for dpkg-buildpackage
.IP
Default:
.PP
.RS
\f[CR]$pgp_options = [\fP
.br
\f[CR]                 '-us',\fP
.br
\f[CR]                 '-uc'\fP
.br
\f[CR]               ];\fP
.br
.RE
.TP
.BR TOOLCHAIN_REGEX
ARRAY:STRING type.
Regular expressions identifying toolchain packages.  Note that for backward
compatible, this is also settable using the array @toolchain_regex
(deprecated), rather than an array reference.
.IP
Default:
.PP
.RS
\f[CR]$toolchain_regex = [\fP
.br
\f[CR]                     'binutils$',\fP
.br
\f[CR]                     'dpkg-dev$',\fP
.br
\f[CR]                     'gcc-[\\d.]+$',\fP
.br
\f[CR]                     'g\\+\\+-[\\d.]+$',\fP
.br
\f[CR]                     'libstdc\\+\\+',\fP
.br
\f[CR]                     'libc[\\d.]+-dev$',\fP
.br
\f[CR]                     'linux-kernel-headers$',\fP
.br
\f[CR]                     'linux-libc-dev$',\fP
.br
\f[CR]                     'gnumach-dev$',\fP
.br
\f[CR]                     'hurd-dev$',\fP
.br
\f[CR]                     'kfreebsd-kernel-headers$'\fP
.br
\f[CR]                   ];\fP
.br
.RE
.SS Build timeouts
.TP
.BR INDIVIDUAL_STALLED_PKG_TIMEOUT
HASH:NUMERIC type.
Some packages may exceed the general timeout (e.g. redirecting output to a
file) and need a different timeout.  This has is a mapping between source
package name and timeout.  Note that for backward compatibility, this is
also settable using the hash %individual_stalled_pkg_timeout (deprecated) ,
rather than a hash reference.
Example:
.PP
.RS
\f[CR]%individual_stalled_pkg_timeout = (smalleiffel => 300,\fP
.br
\f[CR]				   jade => 300,\fP
.br
\f[CR]				   atlas => 300,\fP
.br
\f[CR]				   glibc => 1000,\fP
.br
\f[CR]				   'gcc-3.3' => 300,\fP
.br
\f[CR]				   kwave => 600);\fP
.br
.RE
.IP
Default:
.PP
.RS
\f[CR]$individual_stalled_pkg_timeout = {};\fP
.br
.RE
.TP
.BR LOCK_INTERVAL
NUMERIC type.
Lock wait interval (seconds).  Maximum wait time is (max_lock_trys ×
lock_interval).
.IP
Default:
.PP
.RS
\f[CR]$lock_interval = 5;\fP
.br
.RE
.TP
.BR MAX_LOCK_TRYS
NUMERIC type.
Number of times to try waiting for a lock.
.IP
Default:
.PP
.RS
\f[CR]$max_lock_trys = 120;\fP
.br
.RE
.TP
.BR STALLED_PKG_TIMEOUT
NUMERIC type.
Time (in minutes) of inactivity after which a build is terminated. Activity
is measured by output to the log file.
.IP
Default:
.PP
.RS
\f[CR]$stalled_pkg_timeout = 150;\fP
.br
.RE
.SS Build validation
.TP
.BR LINTIAN
STRING type.
Path to lintian binary
.IP
Default:
.PP
.RS
\f[CR]$lintian = 'lintian';\fP
.br
.RE
.TP
.BR LINTIAN_OPTIONS
ARRAY:STRING type.
Options to pass to lintian.  Each option is a separate arrayref element. 
For example, ['-i', '-v'] to add -i and -v.
.IP
Default:
.PP
.RS
\f[CR]$lintian_opts = [];\fP
.br
.RE
.TP
.BR PIUPARTS
STRING type.
Path to piuparts binary
.IP
Default:
.PP
.RS
\f[CR]$piuparts = 'piuparts';\fP
.br
.RE
.TP
.BR PIUPARTS_OPTIONS
ARRAY:STRING type.
Options to pass to piuparts.  Each option is a separate arrayref element. 
For example, ['-b', '<chroot_tarball>'] to add -b and <chroot_tarball>.
.IP
Default:
.PP
.RS
\f[CR]$piuparts_opts = [];\fP
.br
.RE
.TP
.BR PIUPARTS_ROOT_ARGS
ARRAY:STRING type.
Preceding arguments to launch piuparts as root. If no arguments are
specified, piuparts will be launched via sudo.
.IP
Default:
.PP
.RS
\f[CR]$piuparts_root_args = [];\fP
.br
.RE
.TP
.BR RUN_LINTIAN
BOOL type.
Run lintian?
.IP
Default:
.PP
.RS
\f[CR]$run_lintian = 0;\fP
.br
.RE
.TP
.BR RUN_PIUPARTS
BOOL type.
Run piuparts
.IP
Default:
.PP
.RS
\f[CR]$run_piuparts = 0;\fP
.br
.RE
.SS Chroot options
.TP
.BR APT_ALLOW_UNAUTHENTICATED
BOOL type.
Force APT to accept unauthenticated packages.  By default, unauthenticated
packages are not allowed.  This is to keep the build environment secure,
using apt-secure(8).  By setting this to 1, APT::Get::AllowUnauthenticated
is set to "true" when running apt-get. This is disabled by default: only
enable it if you know what you are doing.
.IP
Default:
.PP
.RS
\f[CR]$apt_allow_unauthenticated = 0;\fP
.br
.RE
.TP
.BR APT_CLEAN
BOOL type.
APT clean.  1 to enable running "apt-get clean" at the start of each build,
or 0 to disable.
.IP
Default:
.PP
.RS
\f[CR]$apt_clean = 0;\fP
.br
.RE
.TP
.BR APT_DISTUPGRADE
BOOL type.
APT distupgrade.  1 to enable running "apt-get dist-upgrade" at the start
of each build, or 0 to disable.
.IP
Default:
.PP
.RS
\f[CR]$apt_distupgrade = 1;\fP
.br
.RE
.TP
.BR APT_UPDATE
BOOL type.
APT update.  1 to enable running "apt-get update" at the start of each
build, or 0 to disable.
.IP
Default:
.PP
.RS
\f[CR]$apt_update = 1;\fP
.br
.RE
.TP
.BR APT_UPDATE_ARCHIVE_ONLY
BOOL type.
Update local temporary APT archive directly (1, the default) or set to 0 to
disable and do a full apt update (not recommended in case the mirror
content has changed since the build started).
.IP
Default:
.PP
.RS
\f[CR]$apt_update_archive_only = 1;\fP
.br
.RE
.TP
.BR APT_UPGRADE
BOOL type.
APT upgrade.  1 to enable running "apt-get upgrade" at the start of each
build, or 0 to disable.
.IP
Default:
.PP
.RS
\f[CR]$apt_upgrade = 0;\fP
.br
.RE
.TP
.BR CHROOT
STRING type.
Default chroot (defaults to distribution[-arch][-sbuild])
.IP
Default:
.PP
.RS
\f[CR]$chroot = undef;\fP
.br
.RE
.TP
.BR CHROOT_MODE
STRING type.
Mechanism to use for chroot virtualisation.  Possible value are "schroot"
(default) and "sudo".
.IP
Default:
.PP
.RS
\f[CR]$chroot_mode = 'schroot';\fP
.br
.RE
.TP
.BR CHROOT_SETUP_SCRIPT
STRING type.
Script to run to perform custom setup tasks in the chroot.
.IP
Default:
.PP
.RS
\f[CR]$chroot_setup_script = undef;\fP
.br
.RE
.TP
.BR CHROOT_SPLIT
BOOL type.
Run in split mode?  In split mode, apt-get and dpkg are run on the host
system, rather than inside the chroot.
.IP
Default:
.PP
.RS
\f[CR]$chroot_split = 0;\fP
.br
.RE
.TP
.BR EXTERNAL_COMMANDS
HASH:ARRAY:ARRAY:STRING type.
External commands to run at various stages of a build. Commands are held in
a hash of arrays of arrays data structure.
Example:
.PP
.RS
\f[CR]$external_commands = {\fP
.br
\f[CR]    "pre-build-commands" => [\fP
.br
\f[CR]        ['foo', 'arg1', 'arg2'],\fP
.br
\f[CR]        ['bar', 'arg1', 'arg2', 'arg3'],\fP
.br
\f[CR]    ],\fP
.br
\f[CR]    "chroot-setup-commands" => [\fP
.br
\f[CR]        ['foo', 'arg1', 'arg2'],\fP
.br
\f[CR]        ['bar', 'arg1', 'arg2', 'arg3'],\fP
.br
\f[CR]    ],\fP
.br
\f[CR]    "chroot-cleanup-commands" => [\fP
.br
\f[CR]        ['foo', 'arg1', 'arg2'],\fP
.br
\f[CR]        ['bar', 'arg1', 'arg2', 'arg3'],\fP
.br
\f[CR]    ],\fP
.br
\f[CR]    "post-build-commands" => [\fP
.br
\f[CR]        ['foo', 'arg1', 'arg2'],\fP
.br
\f[CR]        ['bar', 'arg1', 'arg2', 'arg3'],\fP
.br
\f[CR]    ],\fP
.br
\f[CR]};\fP
.br
.RE
.IP
Default:
.PP
.RS
\f[CR]$external_commands = {\fP
.br
\f[CR]                       'post-build-commands' => [],\fP
.br
\f[CR]                       'chroot-setup-commands' => [],\fP
.br
\f[CR]                       'chroot-cleanup-commands' => [],\fP
.br
\f[CR]                       'pre-build-commands' => []\fP
.br
\f[CR]                     };\fP
.br
.RE
.TP
.BR LOG_EXTERNAL_COMMAND_ERROR
BOOL type.
Log standard error of commands run by sbuild?
.IP
Default:
.PP
.RS
\f[CR]$log_external_command_error = 1;\fP
.br
.RE
.TP
.BR LOG_EXTERNAL_COMMAND_OUTPUT
BOOL type.
Log standard output of commands run by sbuild?
.IP
Default:
.PP
.RS
\f[CR]$log_external_command_output = 1;\fP
.br
.RE
.TP
.BR PACKAGE_CHECKLIST
STRING type.
Where to store list currently installed packages inside chroot
.IP
Default:
.PP
.RS
\f[CR]$package_checklist = '/var/lib/sbuild/package-checklist';\fP
.br
.RE
.TP
.BR PURGE_BUILD_DEPS
STRING type.
When to purge the build dependencies after a build; possible values are
"never", "successful", and "always"
.IP
Default:
.PP
.RS
\f[CR]$purge_build_deps = 'always';\fP
.br
.RE
.TP
.BR PURGE_BUILD_DIRECTORY
STRING type.
When to purge the build directory after a build; possible values are
"never", "successful", and "always"
.IP
Default:
.PP
.RS
\f[CR]$purge_build_directory = 'always';\fP
.br
.RE
.TP
.BR PURGE_SESSION
STRING type.
Purge the schroot session following a build.  This is useful in conjunction
with the --purge and --purge-deps options when using snapshot chroots,
since by default the snapshot will be deleted. Possible values are "always"
(default), "never", and "successful"
.IP
Default:
.PP
.RS
\f[CR]$purge_session = 'always';\fP
.br
.RE
.SS Core options
.TP
.BR ARCHIVE
STRING type.
Archive being built.  Only set in build log.  This might be useful for
derivative distributions.
.IP
Default:
.PP
.RS
\f[CR]$archive = undef;\fP
.br
.RE
.TP
.BR BUILD_DIR
STRING type.
This option is deprecated.  Directory for chroot symlinks and sbuild logs. 
Defaults to the current directory if unspecified.  It is used as the
location of chroot symlinks (obsolete) and for current build log symlinks
and some build logs.  There is no default; if unset, it defaults to the
current working directory.  $HOME/build is another common configuration.
Example:
.PP
.RS
\f[CR]$build_dir = '/home/pete/build';\fP
.br
.RE
.TP
.BR CORE_DEPENDS
ARRAY:STRING type.
Packages which must be installed in the chroot for all builds.
.IP
Default:
.PP
.RS
\f[CR]$core_depends = [\fP
.br
\f[CR]                  'build-essential',\fP
.br
\f[CR]                  'fakeroot'\fP
.br
\f[CR]                ];\fP
.br
.RE
.TP
.BR ENVIRONMENT_FILTER
ARRAY:STRING type.
Only environment variables matching one of the regular expressions in this
arrayref will be passed to dpkg-buildpackage and other programs run by
sbuild.
.IP
Default:
.PP
.RS
\f[CR]$environment_filter = [\fP
.br
\f[CR]                        '^PATH$',\fP
.br
\f[CR]                        '^DEB(IAN|SIGN)?_[A-Z_]+$',\fP
.br
\f[CR]                        '^(C(PP|XX)?|LD|F)FLAGS(_APPEND)?$',\fP
.br
\f[CR]                        '^USER(NAME)?$',\fP
.br
\f[CR]                        '^LOGNAME$',\fP
.br
\f[CR]                        '^TERM$',\fP
.br
\f[CR]                        '^SHELL$'\fP
.br
\f[CR]                      ];\fP
.br
.RE
.TP
.BR JOB_FILE
STRING type.
Job status file (only used in batch mode)
.IP
Default:
.PP
.RS
\f[CR]$job_file = 'build-progress';\fP
.br
.RE
.TP
.BR SBUILD_MODE
STRING type.
sbuild behaviour; possible values are "user" (exit status reports build
failures) and "buildd" (exit status does not report build failures) for use
in a buildd setup.  "buildd" also currently implies enabling of "legacy
features" such as chroot symlinks in the build directory and the creation
of current symlinks in the build directory.
.IP
Default:
.PP
.RS
\f[CR]$sbuild_mode = 'user';\fP
.br
.RE
.SS Dependency resolution
.TP
.BR APT_POLICY
BOOL type.
APT policy.  1 to enable additional checking of package versions available
in the APT cache, or 0 to disable.  0 is the traditional sbuild behaviour;
1 is needed to build from additional repositories such as sarge-backports
or experimental, and has a small performance cost.  Note that this is only
used by the internal resolver.
.IP
Default:
.PP
.RS
\f[CR]$apt_policy = 1;\fP
.br
.RE
.TP
.BR BUILD_DEP_RESOLVER
STRING type.
Build dependency resolver.  The 'apt' resolver is currently the default,
and recommended for most users.  This resolver uses apt-get to resolve
dependencies.  Alternative resolvers are 'apt' and 'aptitude', which use a
built-in resolver module and aptitude to resolve build dependencies,
respectively.  The internal resolver is not capable of resolving complex
alternative and virtual package dependencies, but is otherwise equivalent
to apt.  The aptitude resolver is similar to apt, but is useful in more
complex situations, such as where multiple distributions are required, for
example when building from experimental, where packages are needed from
both unstable and experimental, but defaulting to unstable.
.IP
Default:
.PP
.RS
\f[CR]$build_dep_resolver = 'apt';\fP
.br
.RE
.TP
.BR CHECK_DEPENDS_ALGORITHM
STRING type.
Algorithm for build dependency checks: possible values are "first_only"
(used by Debian buildds) or "alternatives". Default: "first_only".  Note
that this is only used by the internal resolver.
.IP
Default:
.PP
.RS
\f[CR]$check_depends_algorithm = 'first-only';\fP
.br
.RE
.TP
.BR RESOLVE_ALTERNATIVES
BOOL type.
Should the dependency resolver use alternatives in Build-Depends and
Build-Depends-Indep?  By default, only the first alternative will be used;
all other alternatives will be removed.  Note that this does not include
architecture-specific alternatives, which are reduced to the build
architecture prior to alternatives removal.  This should be left disabled
when building for unstable; it may be useful when building backports.
.IP
Default:
.PP
.RS
\f[CR]$resolve_alternatives = undef;\fP
.br
.RE
.TP
.BR RESOLVE_VIRTUAL
BOOL type.
Attempt to resolve virtual dependencies?  This option is only used by the
internal resolver.
.IP
Default:
.PP
.RS
\f[CR]$resolve_virtual = 0;\fP
.br
.RE
.TP
.BR SBUILD_BUILD_DEPENDS_PUBLIC_KEY
STRING type.
GPG public key for temporary local apt archive.
.IP
Default:
.PP
.RS
\f[CR]$sbuild_build_depends_public_key = '/var/lib/sbuild/apt-keys/sbuild-key.pub';\fP
.br
.RE
.TP
.BR SBUILD_BUILD_DEPENDS_SECRET_KEY
STRING type.
GPG secret key for temporary local apt archive.
.IP
Default:
.PP
.RS
\f[CR]$sbuild_build_depends_secret_key = '/var/lib/sbuild/apt-keys/sbuild-key.sec';\fP
.br
.RE
.SS Logging options
.TP
.BR COMPRESS_BUILD_LOG_MAILS
BOOL type.
Should build log mails be compressed?
.IP
Default:
.PP
.RS
\f[CR]$compress_build_log_mails = 1;\fP
.br
.RE
.TP
.BR DEBUG
NUMERIC type.
Debug logging level
.IP
Default:
.PP
.RS
\f[CR]$debug = 0;\fP
.br
.RE
.TP
.BR LOG_COLOUR
BOOL type.
Add colour highlighting to interactive log messages (informational, warning
and error messages).  Log files will not be coloured.
.IP
Default:
.PP
.RS
\f[CR]$log_colour = 1;\fP
.br
.RE
.TP
.BR LOG_DIR
STRING type.
Directory for storing build logs
.IP
Default:
.PP
.RS
\f[CR]$log_dir = '/home/rleigh/logs';\fP
.br
.RE
.TP
.BR LOG_FILTER
BOOL type.
Filter variable strings from log messages such as the chroot name and build
directory
.IP
Default:
.PP
.RS
\f[CR]$log_filter = 1;\fP
.br
.RE
.TP
.BR MAILFROM
STRING type.
email address set in the From line of build logs
.IP
Default:
.PP
.RS
\f[CR]$mailfrom = 'Source Builder <sbuild>';\fP
.br
.RE
.TP
.BR MAILTO
STRING type.
email address to mail build logs to
.IP
Default:
.PP
.RS
\f[CR]$mailto = '';\fP
.br
.RE
.TP
.BR MAILTO_HASH
HASH:STRING type.
Like MAILTO, but per-distribution.  This is a hashref mapping distribution
name to MAILTO.  Note that for backward compatibility, this is also
settable using the hash %mailto (deprecated), rather than a hash reference.
.IP
Default:
.PP
.RS
\f[CR]$mailto_hash = {};\fP
.br
.RE
.TP
.BR MIME_BUILD_LOG_MAILS
BOOL type.
Should build log mails be MIME encoded?
.IP
Default:
.PP
.RS
\f[CR]$mime_build_log_mails = 1;\fP
.br
.RE
.TP
.BR VERBOSE
NUMERIC type.
Verbose logging level
.IP
Default:
.PP
.RS
\f[CR]$verbose = 0;\fP
.br
.RE
.SS Maintainer options
.TP
.BR KEY_ID
STRING type.
Key ID to use in .changes for the current upload.  It overrides both
$maintainer_name and $uploader_name.
.IP
Default:
.PP
.RS
\f[CR]$key_id = undef;\fP
.br
.RE
.TP
.BR MAINTAINER_NAME
STRING type.
Name to use as override in .changes files for the Maintainer field.  The
Maintainer field will not be overridden unless set here.
.IP
Default:
.PP
.RS
\f[CR]$maintainer_name = undef;\fP
.br
.RE
.TP
.BR UPLOADER_NAME
STRING type.
Name to use as override in .changes file for the Changed-By: field.
.IP
Default:
.PP
.RS
\f[CR]$uploader_name = undef;\fP
.br
.RE
.SS Programs
.TP
.BR APTITUDE
STRING type.
Path to aptitude binary
.IP
Default:
.PP
.RS
\f[CR]$aptitude = 'aptitude';\fP
.br
.RE
.TP
.BR APT_CACHE
STRING type.
Path to apt-cache binary
.IP
Default:
.PP
.RS
\f[CR]$apt_cache = 'apt-cache';\fP
.br
.RE
.TP
.BR APT_GET
STRING type.
Path to apt-get binary
.IP
Default:
.PP
.RS
\f[CR]$apt_get = 'apt-get';\fP
.br
.RE
.TP
.BR DCMD
STRING type.
Path to dcmd binary
.IP
Default:
.PP
.RS
\f[CR]$dcmd = 'dcmd';\fP
.br
.RE
.TP
.BR DPKG_SOURCE
STRING type.
Path to dpkg-source binary
.IP
Default:
.PP
.RS
\f[CR]$dpkg_source = 'dpkg-source';\fP
.br
.RE
.TP
.BR DPKG_SOURCE_OPTIONS
ARRAY:STRING type.
Additional command-line options for dpkg-source
.IP
Default:
.PP
.RS
\f[CR]$dpkg_source_opts = [];\fP
.br
.RE
.TP
.BR FAKEROOT
STRING type.
Path to fakeroot binary
.IP
Default:
.PP
.RS
\f[CR]$fakeroot = 'fakeroot';\fP
.br
.RE
.TP
.BR MAILPROG
STRING type.
Program to use to send mail
.IP
Default:
.PP
.RS
\f[CR]$mailprog = '/usr/sbin/sendmail';\fP
.br
.RE
.TP
.BR MD5SUM
STRING type.
Path to md5sum binary
.IP
Default:
.PP
.RS
\f[CR]$md5sum = 'md5sum';\fP
.br
.RE
.TP
.BR SCHROOT_OPTIONS
ARRAY:STRING type.
Additional command-line options for schroot
.IP
Default:
.PP
.RS
\f[CR]$schroot_options = [\fP
.br
\f[CR]                     '-q'\fP
.br
\f[CR]                   ];\fP
.br
.RE
.TP
.BR SU
STRING type.
Path to su binary
.IP
Default:
.PP
.RS
\f[CR]$su = 'su';\fP
.br
.RE
.TP
.BR SUDO
STRING type.
Path to sudo binary
.IP
Default:
.PP
.RS
\f[CR]$sudo = 'sudo';\fP
.br
.RE
.SS Statistics
.TP
.BR AVG_SPACE_DB
STRING type.
Name of a database for logging package space requirement (optional, no
database is written if empty)
.IP
Default:
.PP
.RS
\f[CR]$avg_space_db = '/var/lib/sbuild/avg-build-space';\fP
.br
.RE
.TP
.BR AVG_TIME_DB
STRING type.
Name of a database for logging package build times (optional, no database
is written if empty)
.IP
Default:
.PP
.RS
\f[CR]$avg_time_db = '/var/lib/sbuild/avg-build-times';\fP
.br
.RE
.TP
.BR STATS_DIR
STRING type.
Directory for writing build statistics to
.IP
Default:
.PP
.RS
\f[CR]$stats_dir = '/home/rleigh/stats';\fP
.br
.RE
.SS Watch options
.TP
.BR CHECK_WATCHES
BOOL type.
Check watched packages to discover missing build dependencies.	This can be
disabled to increase the speed of builds.
.IP
Default:
.PP
.RS
\f[CR]$check_watches = 1;\fP
.br
.RE
.TP
.BR IGNORE_WATCHES_NO_BUILD_DEPS
ARRAY:STRING type.
Ignore watches on the following packages if the package doesn't have its
own build dependencies in the .dsc.  Note that for backward compatibility,
this is also settable using the array @ignore_watches_no_build_deps
(deprecated), rather than an array reference.
.IP
Default:
.PP
.RS
\f[CR]$ignore_watches_no_build_deps = [];\fP
.br
.RE
.TP
.BR WATCHES
HASH:ARRAY:STRING type.
Binaries for which the access time is controlled if they are not listed as
source dependencies (note: /usr/bin is added if executable name does not
start with '/').  Most buildds run with clean chroots at the moment, so the
default list is now empty.  This hash is a mapping between a package name
and the binaries in the package stored as an array reference.  Note that
for backward compatibility, this is also settable using the hash %watches
(deprecated), rather than using a hash reference.
.IP
Default:
.PP
.RS
\f[CR]$watches = {};\fP
.br
.RE
