/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_MergesTwoDevelopmentHistories")
class Merge
extends TextBuiltin {
    @Option(name="--strategy", aliases={"-s"}, usage="usage_mergeStrategy")
    private String strategyName;
    @Option(name="--squash", usage="usage_squash")
    private boolean squash;
    @Option(name="--no-commit", usage="usage_noCommit")
    private boolean noCommit = false;
    private MergeStrategy mergeStrategy = MergeStrategy.RECURSIVE;
    @Argument(required=true, metaVar="metaVar_ref", usage="usage_mergeRef")
    private String ref;
    private MergeCommand.FastForwardMode ff = MergeCommand.FastForwardMode.FF;
    @Option(name="-m", usage="usage_message")
    private String message;

    Merge() {
    }

    @Option(name="--ff", usage="usage_mergeFf")
    void ff(boolean ignored) {
        this.ff = MergeCommand.FastForwardMode.FF;
    }

    @Option(name="--no-ff", usage="usage_mergeNoFf")
    void noff(boolean ignored) {
        this.ff = MergeCommand.FastForwardMode.NO_FF;
    }

    @Option(name="--ff-only", usage="usage_mergeFfOnly")
    void ffonly(boolean ignored) {
        this.ff = MergeCommand.FastForwardMode.FF_ONLY;
    }

    protected void run() throws Exception {
        MergeResult result;
        if (this.squash && this.ff == MergeCommand.FastForwardMode.NO_FF) {
            throw Merge.die(CLIText.get().cannotCombineSquashWithNoff);
        }
        if (this.strategyName != null) {
            this.mergeStrategy = MergeStrategy.get((String)this.strategyName);
            if (this.mergeStrategy == null) {
                throw Merge.die(MessageFormat.format(CLIText.get().unknownMergeStrategy, this.strategyName));
            }
        }
        Ref srcRef = this.db.getRef(this.ref);
        ObjectId src = this.db.resolve(this.ref + "^{commit}");
        if (src == null) {
            throw Merge.die(MessageFormat.format(CLIText.get().refDoesNotExistOrNoCommit, this.ref));
        }
        Ref oldHead = this.db.getRef("HEAD");
        Git git = new Git(this.db);
        MergeCommand mergeCmd = git.merge().setStrategy(this.mergeStrategy).setSquash(this.squash).setFastForward(this.ff).setCommit(!this.noCommit);
        if (srcRef != null) {
            mergeCmd.include(srcRef);
        } else {
            mergeCmd.include((AnyObjectId)src);
        }
        if (this.message != null) {
            mergeCmd.setMessage(this.message);
        }
        try {
            result = mergeCmd.call();
        }
        catch (CheckoutConflictException e) {
            result = new MergeResult(e.getConflictingPaths());
        }
        switch (result.getMergeStatus()) {
            case ALREADY_UP_TO_DATE: {
                if (this.squash) {
                    this.outw.print((Object)CLIText.get().nothingToSquash);
                }
                this.outw.println(CLIText.get().alreadyUpToDate);
                break;
            }
            case FAST_FORWARD: {
                ObjectId oldHeadId = oldHead.getObjectId();
                this.outw.println(MessageFormat.format(CLIText.get().updating, oldHeadId.abbreviate(7).name(), result.getNewHead().abbreviate(7).name()));
                this.outw.println(result.getMergeStatus().toString());
                break;
            }
            case CHECKOUT_CONFLICT: {
                this.outw.println(CLIText.get().mergeCheckoutConflict);
                for (String collidingPath : result.getCheckoutConflicts()) {
                    this.outw.println("\t" + collidingPath);
                }
                this.outw.println(CLIText.get().mergeCheckoutFailed);
                break;
            }
            case CONFLICTING: {
                for (String collidingPath : result.getConflicts().keySet()) {
                    this.outw.println(MessageFormat.format(CLIText.get().mergeConflict, collidingPath));
                }
                this.outw.println(CLIText.get().mergeFailed);
                break;
            }
            case FAILED: {
                for (Map.Entry entry : result.getFailingPaths().entrySet()) {
                    switch ((ResolveMerger.MergeFailureReason)entry.getValue()) {
                        case DIRTY_WORKTREE: 
                        case DIRTY_INDEX: {
                            this.outw.println(CLIText.get().dontOverwriteLocalChanges);
                            this.outw.println("        " + (String)entry.getKey());
                            break;
                        }
                        case COULD_NOT_DELETE: {
                            this.outw.println(CLIText.get().cannotDeleteFile);
                            this.outw.println("        " + (String)entry.getKey());
                        }
                    }
                }
                break;
            }
            case MERGED: {
                String name = !this.isMergedInto(oldHead, (AnyObjectId)src) ? this.mergeStrategy.getName() : "recursive";
                this.outw.println(MessageFormat.format(CLIText.get().mergeMadeBy, name));
                break;
            }
            case MERGED_NOT_COMMITTED: {
                this.outw.println(CLIText.get().mergeWentWellStoppedBeforeCommitting);
                break;
            }
            case MERGED_SQUASHED: 
            case FAST_FORWARD_SQUASHED: 
            case MERGED_SQUASHED_NOT_COMMITTED: {
                this.outw.println(CLIText.get().mergedSquashed);
                this.outw.println(CLIText.get().mergeWentWellStoppedBeforeCommitting);
                break;
            }
            case ABORTED: {
                throw Merge.die(CLIText.get().ffNotPossibleAborting);
            }
            case NOT_SUPPORTED: {
                this.outw.println(MessageFormat.format(CLIText.get().unsupportedOperation, result.toString()));
            }
        }
    }

    private boolean isMergedInto(Ref oldHead, AnyObjectId src) throws IOException {
        RevWalk revWalk = new RevWalk(this.db);
        ObjectId oldHeadObjectId = oldHead.getPeeledObjectId();
        if (oldHeadObjectId == null) {
            oldHeadObjectId = oldHead.getObjectId();
        }
        RevCommit oldHeadCommit = revWalk.lookupCommit((AnyObjectId)oldHeadObjectId);
        RevCommit srcCommit = revWalk.lookupCommit(src);
        return revWalk.isMergedInto(oldHeadCommit, srcCommit);
    }
}

