/*
 * Copyright (C) 2012 Jeremy Kerr <jeremy.kerr@canonical.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
 * USA.
 */
#ifndef IDC_H
#define IDC_H

#include "image.h"

#include <openssl/pkcs7.h>

struct idc;

int IDC_set(PKCS7 *p7, PKCS7_SIGNER_INFO *si, struct image *image);
struct idc *IDC_get(PKCS7 *p7, BIO *bio);
int IDC_check_hash(struct idc *idc, struct image *image);

#endif /* IDC_H */

