/* SBaz -- Scala Bazaar
 * Copyright 2005-2007 LAMP/EPFL
 * @author  Lex Spoon
 */

// $Id: Installed.scala 10489 2007-03-23 14:19:25Z michelou $

package sbaz.clui.commands

object Installed extends Command {
  val name = "installed"
  val oneLineHelp = "list the packages that are installed"
  val fullHelp: String = (
    "installed\n" +
    "\n" +
    "Display the list of packages that are already installed.\n")



  def run(args: List[String], settings: Settings) = {
    import settings._

    if (! args.isEmpty)
      usageExit

    val sortedSpecs = dir.installed.sortedPackageSpecs 

    for (val spec <- sortedSpecs) {
      Console.println(spec)
    }

    Console.println(sortedSpecs.length.toString() + " packages installed")
  }
}
