/*
 * AUTHOR: Pedro Lineu Orso                      orso@penguintech.com.br
 *                                                            1998, 2005
 * SARG Squid Analysis Report Generator      http://sarg.sourceforge.net
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"

int css(FILE *fp_css)
{
   FILE *fp_in, *fp_ou;
   char csstext[512];

   fp_ou = fp_css;
   if(strlen(ExternalCSSFile) > 0) {
      if((fp_in=fopen(ExternalCSSFile,"r"))==NULL) {
         fprintf(stderr, "SARG: (css) %s: %s\n",text[45],ExternalCSSFile);
         exit(1);
      }
      fputs("<style>\n",fp_ou);
      while(fgets(buf,MAXLEN,fp_in)!=NULL)
         fputs(buf,fp_ou);
      fputs("</style>\n",fp_ou);
      return;
   }

   fputs("<style>\n",fp_ou);
   sprintf(csstext,".logo {font-family:Verdana,Tahoma,Arial;font-size:11px;color:%s;}\n",LogoTextColor);
   fputs(csstext,fp_ou);
   sprintf(csstext,".body {font-family:%s;color:%s;background-color:%s;}\n",FontFace,TxColor,BgColor);
   fputs(csstext,fp_ou);
   sprintf(csstext,".info {font-family:%s;font-size:9px;}\n", FontFace);
   fputs(csstext,fp_ou);
   sprintf(csstext,".info a:link,a:visited {font-family:%s;color:#0000FF;font-size:9px;text-decoration:none;}\n", FontFace);
   fputs(csstext,fp_ou);
   sprintf(csstext,".title {font-family:%s;font-size:%s;color:%s;background-color:%s;}\n",FontFace,TitleFontSize,TiColor,BgColor);
   fputs(csstext,fp_ou);
   sprintf(csstext,".title2 {font-family:%s;font-size:%s;color:%s;background-color:%s;text-align:left;}\n",FontFace,TitleFontSize,TiColor,BgColor);
   fputs(csstext,fp_ou);
   sprintf(csstext,".title3 {font-family:%s;font-size:%s;color:%s;background-color:%s;text-align:right;}\n",FontFace,TitleFontSize,TiColor,BgColor);
   fputs(csstext,fp_ou);
   sprintf(csstext,".header {font-family:%s;font-size:%s;color:%s;background-color:%s;text-align:left;border-right:1px solid #666666;border-bottom:1px solid #666666;}\n",FontFace,HeaderFontSize,HeaderColor,HeaderBgColor);
   fputs(csstext,fp_ou);
   sprintf(csstext,".header2 {font-family:%s;font-size:%s;color:%s;background-color:%s;text-align:right;border-right:1px solid #666666;border-bottom:1px solid #666666;}\n",FontFace,HeaderFontSize,HeaderColor,HeaderBgColor);
   fputs(csstext,fp_ou);
   sprintf(csstext,".header3 {font-family:%s;font-size:%s;color:%s;background-color:%s;text-align:center;border-right:1px solid #666666;border-bottom:1px solid #666666;}\n",FontFace,HeaderFontSize,HeaderColor,HeaderBgColor);
   fputs(csstext,fp_ou);
   sprintf(csstext,".text {font-family:%s;color:%s;font-size:%s;}\n", FontFace, TxColor, FontSize);
   fputs(csstext,fp_ou);
   sprintf(csstext,".data {font-family:%s;color:%s;font-size:%s;background-color:%s;text-align:right;border-right:1px solid #6A5ACD;border-bottom:1px solid #6A5ACD;}\n", FontFace, TxColor, FontSize, TxBgColor);
   fputs(csstext,fp_ou);
   sprintf(csstext,".data a:link,a:visited {font-family:%s;color:#0000FF;font-size:%s;background-color:%s;text-align:right;text-decoration:none;}\n", FontFace, FontSize, TxBgColor);
   fputs(csstext,fp_ou);
   sprintf(csstext,".data2 {font-family:%s;color:%s;font-size:%s;background-color:%s;border-right:1px solid #6A5ACD;border-bottom:1px solid #6A5ACD;}\n", FontFace, TxColor, FontSize, TxBgColor);
   fputs(csstext,fp_ou);
   sprintf(csstext,".data2 a:link,a:visited {font-family:%s;color:#0000FF;font-size:%s;background-color:%s;text-decoration:none;}\n", FontFace, FontSize, TxBgColor);
   fputs(csstext,fp_ou);
   sprintf(csstext,".data3 {font-family:%s;color:%s;font-size:%s;text-align:center;background-color:%s;border-right:1px solid #6A5ACD;border-bottom:1px solid #6A5ACD;}\n", FontFace, TxColor, FontSize, TxBgColor);
   fputs(csstext,fp_ou);
   sprintf(csstext,".data3 a:link,a:visited {font-family:%s;color:#0000FF;font-size:%s;text-align:center;background-color:%s;text-decoration:none;}\n", FontFace, FontSize, TxBgColor);
   fputs(csstext,fp_ou);
   sprintf(csstext,".text {font-family:%s;color:%s;font-size:%s;text-align:right;}\n", FontFace, TxColor, FontSize, TxBgColor);
   fputs(csstext,fp_ou);
   sprintf(csstext,".link {font-family:%s;font-size:%s;color:#0000FF;}\n", FontFace, FontSize);
   fputs(csstext,fp_ou);
   sprintf(csstext,".link a:link,a:visited {font-family:%s;font-size:%s;color:#0000FF;text-decoration:none;}\n", FontFace, FontSize);
   fputs(csstext,fp_ou);
   fputs("</style>\n",fp_ou);

   return;
;}
