 /* sane - Scanner Access Now Easy.
   Copyright (C) 2003 Johannes Hub (JohannesHub@foni.net)

   This file is part of the SANE package.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   As a special exception, the authors of SANE give permission for
   additional uses of the libraries contained in this release of SANE.

   The exception is that, if you link a SANE library with other files
   to produce an exutable, this does not by itself cause the
   resulting executable to be covered by the GNU General Public
   License.  Your use of that executable is in no way restricted on
   account of linking the SANE library code into it.

   This exception does not, however, invalidate any other reasons why
   the executable file might be covered by the GNU General Public
   License.

   If you submit changes to SANE to the maintainers to be included in
   a subsequent release, you agree by submitting the changes that
   those changes may be distributed with this exception intact.

   If you write modifications of your own for SANE, it is your choice
   whether to permit this exception to apply to your modifications.
   If you do not wish that, delete this exception notice.
*/

/*
    Concept for a backend for scanners based on the RT8891 chipset,
    such as HP4400C, HP4470C.
    Parts of this source were inspired by other backends.

    History:


    Version 0.17g 18.04.04 10.alpha, little fixes
    Version 0.17  14.02.04 9. alpha
    Version 0.16  06.02.04 8. alpha, wait counting on LCD
    Version 0.15a 29.01.04 7. alpha, CCD switch moved to config file
    Version 0.15  11.01.04 6. alpha, a second CCD implemented
    Version 0.14  21/11/22 5. alpha
    Version 0.13a 21.11.04 4. alpha, an little fix included
    Version 0.13  13.11.04 4. alpha
    Version 0.12  22.10.03 third alpha, Backend name changed to HP_RTS88xx
    Version 0.11  30.08.03 second alpha
    Version 0.10  19.07.03 first alpha
*/

/*
  This file defines which transfer methods are compiled into the SANE backend
  (Linux scanner kernel module, BSD uscanner kernel module, libusb, ieee1284,
  dummy for scanner emulation, etc.)

  To disable a transfer method, comment out the corresponding #define
  !!!!! Please note, only one of this transfer methods allowed !!!!!

  #define SANEI_USB_SUPPORT
    USB support using the SANE builtin functions from sanei_usb.h
    sanei_usb.h version 1.0.7 supports Linux only (in fact it uses
    the scanner kernel module internally).

  #define LINUX_USB_SUPPORT
    USB support using the 'scanner' kernel module for Linux.
    You need at least Linux kernel version 2.4.12 to use this.

  #define USCANNER_SUPPORT
    USB support using the 'uscanner' kernel module for BSD.
    This is obviously mutually exclusive with LINUX_USB_SUPPORT

  #define LIBUSB_SUPPORT
    USB support using libusb (should be platform independent)
    You need at least version 0.1.5 of libusb (+ devel package) to use this.

  #define LIBIEEE1284_SUPPORT
    Parallel port support using libieee1284 (should be platform independent).
    You need at least version ... of libieee1284 (+ devel package) to use this.
    *** This transfer method has not been tested yet ***

  #define DUMMY_SCAN_SUPPORT
    Dummy transfer method used for testing.
    This method very simply emulates a specific type of scanner.

  Any changes in this file will have no effect until you recompile & install:
  (in the sane-backends package, backend directory)
    touch hp_rts88xx.c
    make
    make install
*/

/**/
/* not implemented yet *
#ifndef SANEI_USB_SUPPORT
#define SANEI_USB_SUPPORT
#endif
**/

/* scanner module */
/*
#ifndef LINUX_USB_SUPPORT
#define LINUX_USB_SUPPORT
#endif
*/
/**/

/**
* not implemented yet *
#define USCANNER_SUPPORT
**/

/**/
/* libusb */
#ifndef LIBUSB_SUPPORT
#define LIBUSB_SUPPORT
#endif
/**/

/* not implemented yet */
/* #define LIBIEEE1284_SUPPORT */

/* not implemented yet */
/* #define DUMMY_SCAN_SUPPORT */

