/* parser auto-generated by pidl */

#include "includes.h"
#include "autoconf/librpc/gen_ndr/ndr_secrets.h"

#include "librpc/gen_ndr/ndr_security.h"
_PUBLIC_ enum ndr_err_code ndr_push_TRUSTED_DOM_PASS(struct ndr_push *ndr, int ndr_flags, const struct TRUSTED_DOM_PASS *r)
{
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, strlen_m_term(r->uni_name)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->uni_name, 32, sizeof(uint16_t), CH_UTF16));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, strlen(r->pass)));
			{
				uint32_t _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->pass));
				ndr->flags = _flags_save_string;
			}
			NDR_CHECK(ndr_push_time_t(ndr, NDR_SCALARS, r->mod_time));
			NDR_CHECK(ndr_push_dom_sid(ndr, NDR_SCALARS, &r->domain_sid));
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_TRUSTED_DOM_PASS(struct ndr_pull *ndr, int ndr_flags, struct TRUSTED_DOM_PASS *r)
{
	uint32_t size_uni_name_0 = 0;
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->uni_name_len));
			size_uni_name_0 = 32;
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->uni_name, size_uni_name_0, sizeof(uint16_t), CH_UTF16));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->pass_len));
			{
				uint32_t _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->pass));
				ndr->flags = _flags_save_string;
			}
			NDR_CHECK(ndr_pull_time_t(ndr, NDR_SCALARS, &r->mod_time));
			NDR_CHECK(ndr_pull_dom_sid(ndr, NDR_SCALARS, &r->domain_sid));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_TRUSTED_DOM_PASS(struct ndr_print *ndr, const char *name, const struct TRUSTED_DOM_PASS *r)
{
	ndr_print_struct(ndr, name, "TRUSTED_DOM_PASS");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		uint32_t _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_uint32(ndr, "uni_name_len", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?strlen_m_term(r->uni_name):r->uni_name_len);
		ndr_print_string(ndr, "uni_name", r->uni_name);
		ndr_print_uint32(ndr, "pass_len", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?strlen(r->pass):r->pass_len);
		ndr_print_string(ndr, "pass", r->pass);
		ndr_print_time_t(ndr, "mod_time", r->mod_time);
		ndr_print_dom_sid(ndr, "domain_sid", &r->domain_sid);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_lsa_secret(struct ndr_push *ndr, int ndr_flags, const struct lsa_secret *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->secret_current));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->secret_current_lastchange));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->secret_old));
		NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->secret_old_lastchange));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->sd));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->secret_current) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->secret_current));
		}
		if (r->secret_old) {
			NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, *r->secret_old));
		}
		if (r->sd) {
			NDR_CHECK(ndr_push_security_descriptor(ndr, NDR_SCALARS|NDR_BUFFERS, r->sd));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_lsa_secret(struct ndr_pull *ndr, int ndr_flags, struct lsa_secret *r)
{
	uint32_t _ptr_secret_current;
	TALLOC_CTX *_mem_save_secret_current_0;
	uint32_t _ptr_secret_old;
	TALLOC_CTX *_mem_save_secret_old_0;
	uint32_t _ptr_sd;
	TALLOC_CTX *_mem_save_sd_0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_secret_current));
		if (_ptr_secret_current) {
			NDR_PULL_ALLOC(ndr, r->secret_current);
		} else {
			r->secret_current = NULL;
		}
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->secret_current_lastchange));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_secret_old));
		if (_ptr_secret_old) {
			NDR_PULL_ALLOC(ndr, r->secret_old);
		} else {
			r->secret_old = NULL;
		}
		NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->secret_old_lastchange));
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_sd));
		if (_ptr_sd) {
			NDR_PULL_ALLOC(ndr, r->sd);
		} else {
			r->sd = NULL;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (r->secret_current) {
			_mem_save_secret_current_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->secret_current, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->secret_current));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_secret_current_0, 0);
		}
		if (r->secret_old) {
			_mem_save_secret_old_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->secret_old, 0);
			NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, r->secret_old));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_secret_old_0, 0);
		}
		if (r->sd) {
			_mem_save_sd_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->sd, 0);
			NDR_CHECK(ndr_pull_security_descriptor(ndr, NDR_SCALARS|NDR_BUFFERS, r->sd));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_sd_0, 0);
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_lsa_secret(struct ndr_print *ndr, const char *name, const struct lsa_secret *r)
{
	ndr_print_struct(ndr, name, "lsa_secret");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ptr(ndr, "secret_current", r->secret_current);
	ndr->depth++;
	if (r->secret_current) {
		ndr_print_DATA_BLOB(ndr, "secret_current", *r->secret_current);
	}
	ndr->depth--;
	ndr_print_NTTIME(ndr, "secret_current_lastchange", r->secret_current_lastchange);
	ndr_print_ptr(ndr, "secret_old", r->secret_old);
	ndr->depth++;
	if (r->secret_old) {
		ndr_print_DATA_BLOB(ndr, "secret_old", *r->secret_old);
	}
	ndr->depth--;
	ndr_print_NTTIME(ndr, "secret_old_lastchange", r->secret_old_lastchange);
	ndr_print_ptr(ndr, "sd", r->sd);
	ndr->depth++;
	if (r->sd) {
		ndr_print_security_descriptor(ndr, "sd", r->sd);
	}
	ndr->depth--;
	ndr->depth--;
}

