/* parser auto-generated by pidl */

#include "includes.h"
#include "autoconf/librpc/gen_ndr/ndr_ntsvcs.h"

#include "librpc/gen_ndr/ndr_misc.h"
static enum ndr_err_code ndr_push_PNP_GetIdListFlags(struct ndr_push *ndr, int ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetIdListFlags(struct ndr_pull *ndr, int ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetIdListFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CM_GETIDLIST_FILTER_ENUMERATOR", CM_GETIDLIST_FILTER_ENUMERATOR, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CM_GETIDLIST_FILTER_SERVICE", CM_GETIDLIST_FILTER_SERVICE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CM_GETIDLIST_FILTER_EJECTRELATIONS", CM_GETIDLIST_FILTER_EJECTRELATIONS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CM_GETIDLIST_FILTER_REMOVALRELATIONS", CM_GETIDLIST_FILTER_REMOVALRELATIONS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CM_GETIDLIST_FILTER_POWERRELATIONS", CM_GETIDLIST_FILTER_POWERRELATIONS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CM_GETIDLIST_FILTER_BUSRELATIONS", CM_GETIDLIST_FILTER_BUSRELATIONS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CM_GETIDLIST_DONOTGENERATE", CM_GETIDLIST_DONOTGENERATE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CM_GETIDLIST_FILTER_TRANSPORTRELATIONS", CM_GETIDLIST_FILTER_TRANSPORTRELATIONS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CM_GETIDLIST_FILTER_PRESENT", CM_GETIDLIST_FILTER_PRESENT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "CM_GETIDLIST_FILTER_CLASS", CM_GETIDLIST_FILTER_CLASS, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_HwProfInfo(struct ndr_push *ndr, int ndr_flags, const struct PNP_HwProfInfo *r)
{
	uint32_t cntr_friendly_name_0;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->profile_handle));
		for (cntr_friendly_name_0 = 0; cntr_friendly_name_0 < 80; cntr_friendly_name_0++) {
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->friendly_name[cntr_friendly_name_0]));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->flags));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_HwProfInfo(struct ndr_pull *ndr, int ndr_flags, struct PNP_HwProfInfo *r)
{
	uint32_t size_friendly_name_0 = 0;
	uint32_t cntr_friendly_name_0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->profile_handle));
		size_friendly_name_0 = 80;
		for (cntr_friendly_name_0 = 0; cntr_friendly_name_0 < size_friendly_name_0; cntr_friendly_name_0++) {
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->friendly_name[cntr_friendly_name_0]));
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->flags));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_HwProfInfo(struct ndr_print *ndr, const char *name, const struct PNP_HwProfInfo *r)
{
	uint32_t cntr_friendly_name_0;
	ndr_print_struct(ndr, name, "PNP_HwProfInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "profile_handle", r->profile_handle);
	ndr->print(ndr, "%s: ARRAY(%d)", "friendly_name", (int)80);
	ndr->depth++;
	for (cntr_friendly_name_0=0;cntr_friendly_name_0<80;cntr_friendly_name_0++) {
		ndr_print_uint16(ndr, "friendly_name", r->friendly_name[cntr_friendly_name_0]);
	}
	ndr->depth--;
	ndr_print_uint32(ndr, "flags", r->flags);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_Disconnect(struct ndr_push *ndr, int flags, const struct PNP_Disconnect *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_Disconnect(struct ndr_pull *ndr, int flags, struct PNP_Disconnect *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_Disconnect(struct ndr_print *ndr, const char *name, int flags, const struct PNP_Disconnect *r)
{
	ndr_print_struct(ndr, name, "PNP_Disconnect");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_Disconnect");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_Disconnect");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_Connect(struct ndr_push *ndr, int flags, const struct PNP_Connect *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_Connect(struct ndr_pull *ndr, int flags, struct PNP_Connect *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_Connect(struct ndr_print *ndr, const char *name, int flags, const struct PNP_Connect *r)
{
	ndr_print_struct(ndr, name, "PNP_Connect");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_Connect");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_Connect");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetVersion(struct ndr_push *ndr, int flags, const struct PNP_GetVersion *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		if (r->out.version == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->out.version));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetVersion(struct ndr_pull *ndr, int flags, struct PNP_GetVersion *r)
{
	TALLOC_CTX *_mem_save_version_0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_PULL_ALLOC(ndr, r->out.version);
		ZERO_STRUCTP(r->out.version);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.version);
		}
		_mem_save_version_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.version, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->out.version));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_version_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetVersion(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetVersion *r)
{
	ndr_print_struct(ndr, name, "PNP_GetVersion");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetVersion");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetVersion");
		ndr->depth++;
		ndr_print_ptr(ndr, "version", r->out.version);
		ndr->depth++;
		ndr_print_uint16(ndr, "version", *r->out.version);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetGlobalState(struct ndr_push *ndr, int flags, const struct PNP_GetGlobalState *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetGlobalState(struct ndr_pull *ndr, int flags, struct PNP_GetGlobalState *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetGlobalState(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetGlobalState *r)
{
	ndr_print_struct(ndr, name, "PNP_GetGlobalState");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetGlobalState");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetGlobalState");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_InitDetection(struct ndr_push *ndr, int flags, const struct PNP_InitDetection *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_InitDetection(struct ndr_pull *ndr, int flags, struct PNP_InitDetection *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_InitDetection(struct ndr_print *ndr, const char *name, int flags, const struct PNP_InitDetection *r)
{
	ndr_print_struct(ndr, name, "PNP_InitDetection");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_InitDetection");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_InitDetection");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_ReportLogOn(struct ndr_push *ndr, int flags, const struct PNP_ReportLogOn *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_ReportLogOn(struct ndr_pull *ndr, int flags, struct PNP_ReportLogOn *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_ReportLogOn(struct ndr_print *ndr, const char *name, int flags, const struct PNP_ReportLogOn *r)
{
	ndr_print_struct(ndr, name, "PNP_ReportLogOn");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_ReportLogOn");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_ReportLogOn");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_ValidateDeviceInstance(struct ndr_push *ndr, int flags, const struct PNP_ValidateDeviceInstance *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.devicepath == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.devicepath, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.devicepath, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.devicepath, ndr_charset_length(r->in.devicepath, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_ValidateDeviceInstance(struct ndr_pull *ndr, int flags, struct PNP_ValidateDeviceInstance *r)
{
	uint32_t size_devicepath_1 = 0;
	uint32_t length_devicepath_1 = 0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.devicepath));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.devicepath));
		size_devicepath_1 = ndr_get_array_size(ndr, &r->in.devicepath);
		length_devicepath_1 = ndr_get_array_length(ndr, &r->in.devicepath);
		if (length_devicepath_1 > size_devicepath_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_devicepath_1, length_devicepath_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_devicepath_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.devicepath, length_devicepath_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_ValidateDeviceInstance(struct ndr_print *ndr, const char *name, int flags, const struct PNP_ValidateDeviceInstance *r)
{
	ndr_print_struct(ndr, name, "PNP_ValidateDeviceInstance");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_ValidateDeviceInstance");
		ndr->depth++;
		ndr_print_ptr(ndr, "devicepath", r->in.devicepath);
		ndr->depth++;
		ndr_print_string(ndr, "devicepath", r->in.devicepath);
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_ValidateDeviceInstance");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetRootDeviceInstance(struct ndr_push *ndr, int flags, const struct PNP_GetRootDeviceInstance *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetRootDeviceInstance(struct ndr_pull *ndr, int flags, struct PNP_GetRootDeviceInstance *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetRootDeviceInstance(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetRootDeviceInstance *r)
{
	ndr_print_struct(ndr, name, "PNP_GetRootDeviceInstance");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetRootDeviceInstance");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetRootDeviceInstance");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetRelatedDeviceInstance(struct ndr_push *ndr, int flags, const struct PNP_GetRelatedDeviceInstance *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetRelatedDeviceInstance(struct ndr_pull *ndr, int flags, struct PNP_GetRelatedDeviceInstance *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetRelatedDeviceInstance(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetRelatedDeviceInstance *r)
{
	ndr_print_struct(ndr, name, "PNP_GetRelatedDeviceInstance");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetRelatedDeviceInstance");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetRelatedDeviceInstance");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_EnumerateSubKeys(struct ndr_push *ndr, int flags, const struct PNP_EnumerateSubKeys *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_EnumerateSubKeys(struct ndr_pull *ndr, int flags, struct PNP_EnumerateSubKeys *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_EnumerateSubKeys(struct ndr_print *ndr, const char *name, int flags, const struct PNP_EnumerateSubKeys *r)
{
	ndr_print_struct(ndr, name, "PNP_EnumerateSubKeys");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_EnumerateSubKeys");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_EnumerateSubKeys");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetDeviceList(struct ndr_push *ndr, int flags, const struct PNP_GetDeviceList *r)
{
	uint32_t cntr_buffer_1;
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.filter));
		if (r->in.filter) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.filter, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.filter, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.filter, ndr_charset_length(r->in.filter, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		if (r->in.length == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.length));
		NDR_CHECK(ndr_push_PNP_GetIdListFlags(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.buffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.length));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.length));
		for (cntr_buffer_1 = 0; cntr_buffer_1 < *r->out.length; cntr_buffer_1++) {
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->out.buffer[cntr_buffer_1]));
		}
		if (r->out.length == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.length));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetDeviceList(struct ndr_pull *ndr, int flags, struct PNP_GetDeviceList *r)
{
	uint32_t _ptr_filter;
	uint32_t size_filter_1 = 0;
	uint32_t length_filter_1 = 0;
	uint32_t size_buffer_1 = 0;
	uint32_t length_buffer_1 = 0;
	uint32_t cntr_buffer_1;
	TALLOC_CTX *_mem_save_filter_0;
	TALLOC_CTX *_mem_save_buffer_1;
	TALLOC_CTX *_mem_save_length_0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_filter));
		if (_ptr_filter) {
			NDR_PULL_ALLOC(ndr, r->in.filter);
		} else {
			r->in.filter = NULL;
		}
		if (r->in.filter) {
			_mem_save_filter_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.filter, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.filter));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.filter));
			size_filter_1 = ndr_get_array_size(ndr, &r->in.filter);
			length_filter_1 = ndr_get_array_length(ndr, &r->in.filter);
			if (length_filter_1 > size_filter_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_filter_1, length_filter_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_filter_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.filter, length_filter_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_filter_0, 0);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.length);
		}
		_mem_save_length_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.length, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.length));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_length_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_PNP_GetIdListFlags(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC_N(ndr, r->out.buffer, *r->in.length);
		memset(r->out.buffer, 0, (*r->in.length) * sizeof(*r->out.buffer));
		NDR_PULL_ALLOC(ndr, r->out.length);
		*r->out.length = *r->in.length;
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.buffer));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.buffer));
		size_buffer_1 = ndr_get_array_size(ndr, &r->out.buffer);
		length_buffer_1 = ndr_get_array_length(ndr, &r->out.buffer);
		if (length_buffer_1 > size_buffer_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_buffer_1, length_buffer_1);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.buffer, size_buffer_1);
		}
		_mem_save_buffer_1 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.buffer, 0);
		for (cntr_buffer_1 = 0; cntr_buffer_1 < length_buffer_1; cntr_buffer_1++) {
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->out.buffer[cntr_buffer_1]));
		}
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_1, 0);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.length);
		}
		_mem_save_length_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.length, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.length));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_length_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.buffer) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.buffer, *r->out.length));
		}
		if (r->out.buffer) {
			NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->out.buffer, *r->out.length));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetDeviceList(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetDeviceList *r)
{
	uint32_t cntr_buffer_1;
	ndr_print_struct(ndr, name, "PNP_GetDeviceList");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetDeviceList");
		ndr->depth++;
		ndr_print_ptr(ndr, "filter", r->in.filter);
		ndr->depth++;
		if (r->in.filter) {
			ndr_print_string(ndr, "filter", r->in.filter);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "length", r->in.length);
		ndr->depth++;
		ndr_print_uint32(ndr, "length", *r->in.length);
		ndr->depth--;
		ndr_print_PNP_GetIdListFlags(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetDeviceList");
		ndr->depth++;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr->print(ndr, "%s: ARRAY(%d)", "buffer", (int)*r->out.length);
		ndr->depth++;
		for (cntr_buffer_1=0;cntr_buffer_1<*r->out.length;cntr_buffer_1++) {
			ndr_print_uint16(ndr, "buffer", r->out.buffer[cntr_buffer_1]);
		}
		ndr->depth--;
		ndr->depth--;
		ndr_print_ptr(ndr, "length", r->out.length);
		ndr->depth++;
		ndr_print_uint32(ndr, "length", *r->out.length);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetDeviceListSize(struct ndr_push *ndr, int flags, const struct PNP_GetDeviceListSize *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.devicename));
		if (r->in.devicename) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.devicename, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.devicename, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.devicename, ndr_charset_length(r->in.devicename, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_PNP_GetIdListFlags(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.size == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.size));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetDeviceListSize(struct ndr_pull *ndr, int flags, struct PNP_GetDeviceListSize *r)
{
	uint32_t _ptr_devicename;
	uint32_t size_devicename_1 = 0;
	uint32_t length_devicename_1 = 0;
	TALLOC_CTX *_mem_save_devicename_0;
	TALLOC_CTX *_mem_save_size_0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_devicename));
		if (_ptr_devicename) {
			NDR_PULL_ALLOC(ndr, r->in.devicename);
		} else {
			r->in.devicename = NULL;
		}
		if (r->in.devicename) {
			_mem_save_devicename_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.devicename, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.devicename));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.devicename));
			size_devicename_1 = ndr_get_array_size(ndr, &r->in.devicename);
			length_devicename_1 = ndr_get_array_length(ndr, &r->in.devicename);
			if (length_devicename_1 > size_devicename_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_devicename_1, length_devicename_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_devicename_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.devicename, length_devicename_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_devicename_0, 0);
		}
		NDR_CHECK(ndr_pull_PNP_GetIdListFlags(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.size);
		ZERO_STRUCTP(r->out.size);
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.size);
		}
		_mem_save_size_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.size, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.size));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_size_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetDeviceListSize(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetDeviceListSize *r)
{
	ndr_print_struct(ndr, name, "PNP_GetDeviceListSize");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetDeviceListSize");
		ndr->depth++;
		ndr_print_ptr(ndr, "devicename", r->in.devicename);
		ndr->depth++;
		if (r->in.devicename) {
			ndr_print_string(ndr, "devicename", r->in.devicename);
		}
		ndr->depth--;
		ndr_print_PNP_GetIdListFlags(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetDeviceListSize");
		ndr->depth++;
		ndr_print_ptr(ndr, "size", r->out.size);
		ndr->depth++;
		ndr_print_uint32(ndr, "size", *r->out.size);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetDepth(struct ndr_push *ndr, int flags, const struct PNP_GetDepth *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetDepth(struct ndr_pull *ndr, int flags, struct PNP_GetDepth *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetDepth(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetDepth *r)
{
	ndr_print_struct(ndr, name, "PNP_GetDepth");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetDepth");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetDepth");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetDeviceRegProp(struct ndr_push *ndr, int flags, const struct PNP_GetDeviceRegProp *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		if (r->in.devicepath == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.devicepath, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.devicepath, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.devicepath, ndr_charset_length(r->in.devicepath, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.property));
		if (r->in.reg_data_type == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winreg_Type(ndr, NDR_SCALARS, *r->in.reg_data_type));
		if (r->in.buffer_size == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.buffer_size));
		if (r->in.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.needed));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.reg_data_type == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_winreg_Type(ndr, NDR_SCALARS, *r->out.reg_data_type));
		if (r->out.buffer == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.buffer_size));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, *r->out.buffer_size));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->out.buffer, *r->out.buffer_size));
		if (r->out.buffer_size == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.buffer_size));
		if (r->out.needed == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.needed));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetDeviceRegProp(struct ndr_pull *ndr, int flags, struct PNP_GetDeviceRegProp *r)
{
	uint32_t size_devicepath_1 = 0;
	uint32_t length_devicepath_1 = 0;
	uint32_t size_buffer_1 = 0;
	uint32_t length_buffer_1 = 0;
	TALLOC_CTX *_mem_save_reg_data_type_0;
	TALLOC_CTX *_mem_save_buffer_size_0;
	TALLOC_CTX *_mem_save_needed_0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.devicepath));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.devicepath));
		size_devicepath_1 = ndr_get_array_size(ndr, &r->in.devicepath);
		length_devicepath_1 = ndr_get_array_length(ndr, &r->in.devicepath);
		if (length_devicepath_1 > size_devicepath_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_devicepath_1, length_devicepath_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_devicepath_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.devicepath, length_devicepath_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.property));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.reg_data_type);
		}
		_mem_save_reg_data_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.reg_data_type, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winreg_Type(ndr, NDR_SCALARS, r->in.reg_data_type));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_reg_data_type_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.buffer_size);
		}
		_mem_save_buffer_size_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.buffer_size, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.buffer_size));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_size_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.reg_data_type);
		*r->out.reg_data_type = *r->in.reg_data_type;
		NDR_PULL_ALLOC_N(ndr, r->out.buffer, *r->in.buffer_size);
		memset(r->out.buffer, 0, (*r->in.buffer_size) * sizeof(*r->out.buffer));
		NDR_PULL_ALLOC(ndr, r->out.buffer_size);
		*r->out.buffer_size = *r->in.buffer_size;
		NDR_PULL_ALLOC(ndr, r->out.needed);
		*r->out.needed = *r->in.needed;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.reg_data_type);
		}
		_mem_save_reg_data_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.reg_data_type, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_winreg_Type(ndr, NDR_SCALARS, r->out.reg_data_type));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_reg_data_type_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_array_size(ndr, &r->out.buffer));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->out.buffer));
		size_buffer_1 = ndr_get_array_size(ndr, &r->out.buffer);
		length_buffer_1 = ndr_get_array_length(ndr, &r->out.buffer);
		if (length_buffer_1 > size_buffer_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_buffer_1, length_buffer_1);
		}
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC_N(ndr, r->out.buffer, size_buffer_1);
		}
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->out.buffer, length_buffer_1));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.buffer_size);
		}
		_mem_save_buffer_size_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.buffer_size, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.buffer_size));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_buffer_size_0, LIBNDR_FLAG_REF_ALLOC);
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.needed);
		}
		_mem_save_needed_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.needed, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.needed));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_needed_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
		if (r->out.buffer) {
			NDR_CHECK(ndr_check_array_size(ndr, (void*)&r->out.buffer, *r->out.buffer_size));
		}
		if (r->out.buffer) {
			NDR_CHECK(ndr_check_array_length(ndr, (void*)&r->out.buffer, *r->out.buffer_size));
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetDeviceRegProp(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetDeviceRegProp *r)
{
	ndr_print_struct(ndr, name, "PNP_GetDeviceRegProp");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetDeviceRegProp");
		ndr->depth++;
		ndr_print_ptr(ndr, "devicepath", r->in.devicepath);
		ndr->depth++;
		ndr_print_string(ndr, "devicepath", r->in.devicepath);
		ndr->depth--;
		ndr_print_uint32(ndr, "property", r->in.property);
		ndr_print_ptr(ndr, "reg_data_type", r->in.reg_data_type);
		ndr->depth++;
		ndr_print_winreg_Type(ndr, "reg_data_type", *r->in.reg_data_type);
		ndr->depth--;
		ndr_print_ptr(ndr, "buffer_size", r->in.buffer_size);
		ndr->depth++;
		ndr_print_uint32(ndr, "buffer_size", *r->in.buffer_size);
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->in.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->in.needed);
		ndr->depth--;
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetDeviceRegProp");
		ndr->depth++;
		ndr_print_ptr(ndr, "reg_data_type", r->out.reg_data_type);
		ndr->depth++;
		ndr_print_winreg_Type(ndr, "reg_data_type", *r->out.reg_data_type);
		ndr->depth--;
		ndr_print_ptr(ndr, "buffer", r->out.buffer);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "buffer", r->out.buffer, *r->out.buffer_size);
		ndr->depth--;
		ndr_print_ptr(ndr, "buffer_size", r->out.buffer_size);
		ndr->depth++;
		ndr_print_uint32(ndr, "buffer_size", *r->out.buffer_size);
		ndr->depth--;
		ndr_print_ptr(ndr, "needed", r->out.needed);
		ndr->depth++;
		ndr_print_uint32(ndr, "needed", *r->out.needed);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_SetDeviceRegProp(struct ndr_push *ndr, int flags, const struct PNP_SetDeviceRegProp *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_SetDeviceRegProp(struct ndr_pull *ndr, int flags, struct PNP_SetDeviceRegProp *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_SetDeviceRegProp(struct ndr_print *ndr, const char *name, int flags, const struct PNP_SetDeviceRegProp *r)
{
	ndr_print_struct(ndr, name, "PNP_SetDeviceRegProp");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_SetDeviceRegProp");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_SetDeviceRegProp");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetClassInstance(struct ndr_push *ndr, int flags, const struct PNP_GetClassInstance *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetClassInstance(struct ndr_pull *ndr, int flags, struct PNP_GetClassInstance *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetClassInstance(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetClassInstance *r)
{
	ndr_print_struct(ndr, name, "PNP_GetClassInstance");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetClassInstance");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetClassInstance");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_CreateKey(struct ndr_push *ndr, int flags, const struct PNP_CreateKey *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_CreateKey(struct ndr_pull *ndr, int flags, struct PNP_CreateKey *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_CreateKey(struct ndr_print *ndr, const char *name, int flags, const struct PNP_CreateKey *r)
{
	ndr_print_struct(ndr, name, "PNP_CreateKey");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_CreateKey");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_CreateKey");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_DeleteRegistryKey(struct ndr_push *ndr, int flags, const struct PNP_DeleteRegistryKey *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_DeleteRegistryKey(struct ndr_pull *ndr, int flags, struct PNP_DeleteRegistryKey *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_DeleteRegistryKey(struct ndr_print *ndr, const char *name, int flags, const struct PNP_DeleteRegistryKey *r)
{
	ndr_print_struct(ndr, name, "PNP_DeleteRegistryKey");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_DeleteRegistryKey");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_DeleteRegistryKey");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetClassCount(struct ndr_push *ndr, int flags, const struct PNP_GetClassCount *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetClassCount(struct ndr_pull *ndr, int flags, struct PNP_GetClassCount *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetClassCount(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetClassCount *r)
{
	ndr_print_struct(ndr, name, "PNP_GetClassCount");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetClassCount");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetClassCount");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetClassName(struct ndr_push *ndr, int flags, const struct PNP_GetClassName *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetClassName(struct ndr_pull *ndr, int flags, struct PNP_GetClassName *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetClassName(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetClassName *r)
{
	ndr_print_struct(ndr, name, "PNP_GetClassName");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetClassName");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetClassName");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_DeleteClassKey(struct ndr_push *ndr, int flags, const struct PNP_DeleteClassKey *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_DeleteClassKey(struct ndr_pull *ndr, int flags, struct PNP_DeleteClassKey *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_DeleteClassKey(struct ndr_print *ndr, const char *name, int flags, const struct PNP_DeleteClassKey *r)
{
	ndr_print_struct(ndr, name, "PNP_DeleteClassKey");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_DeleteClassKey");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_DeleteClassKey");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetInterfaceDeviceAlias(struct ndr_push *ndr, int flags, const struct PNP_GetInterfaceDeviceAlias *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetInterfaceDeviceAlias(struct ndr_pull *ndr, int flags, struct PNP_GetInterfaceDeviceAlias *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetInterfaceDeviceAlias(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetInterfaceDeviceAlias *r)
{
	ndr_print_struct(ndr, name, "PNP_GetInterfaceDeviceAlias");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetInterfaceDeviceAlias");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetInterfaceDeviceAlias");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetInterfaceDeviceList(struct ndr_push *ndr, int flags, const struct PNP_GetInterfaceDeviceList *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetInterfaceDeviceList(struct ndr_pull *ndr, int flags, struct PNP_GetInterfaceDeviceList *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetInterfaceDeviceList(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetInterfaceDeviceList *r)
{
	ndr_print_struct(ndr, name, "PNP_GetInterfaceDeviceList");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetInterfaceDeviceList");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetInterfaceDeviceList");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetInterfaceDeviceListSize(struct ndr_push *ndr, int flags, const struct PNP_GetInterfaceDeviceListSize *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetInterfaceDeviceListSize(struct ndr_pull *ndr, int flags, struct PNP_GetInterfaceDeviceListSize *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetInterfaceDeviceListSize(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetInterfaceDeviceListSize *r)
{
	ndr_print_struct(ndr, name, "PNP_GetInterfaceDeviceListSize");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetInterfaceDeviceListSize");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetInterfaceDeviceListSize");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_RegisterDeviceClassAssociation(struct ndr_push *ndr, int flags, const struct PNP_RegisterDeviceClassAssociation *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_RegisterDeviceClassAssociation(struct ndr_pull *ndr, int flags, struct PNP_RegisterDeviceClassAssociation *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_RegisterDeviceClassAssociation(struct ndr_print *ndr, const char *name, int flags, const struct PNP_RegisterDeviceClassAssociation *r)
{
	ndr_print_struct(ndr, name, "PNP_RegisterDeviceClassAssociation");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_RegisterDeviceClassAssociation");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_RegisterDeviceClassAssociation");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_UnregisterDeviceClassAssociation(struct ndr_push *ndr, int flags, const struct PNP_UnregisterDeviceClassAssociation *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_UnregisterDeviceClassAssociation(struct ndr_pull *ndr, int flags, struct PNP_UnregisterDeviceClassAssociation *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_UnregisterDeviceClassAssociation(struct ndr_print *ndr, const char *name, int flags, const struct PNP_UnregisterDeviceClassAssociation *r)
{
	ndr_print_struct(ndr, name, "PNP_UnregisterDeviceClassAssociation");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_UnregisterDeviceClassAssociation");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_UnregisterDeviceClassAssociation");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetClassRegProp(struct ndr_push *ndr, int flags, const struct PNP_GetClassRegProp *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetClassRegProp(struct ndr_pull *ndr, int flags, struct PNP_GetClassRegProp *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetClassRegProp(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetClassRegProp *r)
{
	ndr_print_struct(ndr, name, "PNP_GetClassRegProp");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetClassRegProp");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetClassRegProp");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_SetClassRegProp(struct ndr_push *ndr, int flags, const struct PNP_SetClassRegProp *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_SetClassRegProp(struct ndr_pull *ndr, int flags, struct PNP_SetClassRegProp *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_SetClassRegProp(struct ndr_print *ndr, const char *name, int flags, const struct PNP_SetClassRegProp *r)
{
	ndr_print_struct(ndr, name, "PNP_SetClassRegProp");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_SetClassRegProp");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_SetClassRegProp");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_CreateDevInst(struct ndr_push *ndr, int flags, const struct PNP_CreateDevInst *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_CreateDevInst(struct ndr_pull *ndr, int flags, struct PNP_CreateDevInst *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_CreateDevInst(struct ndr_print *ndr, const char *name, int flags, const struct PNP_CreateDevInst *r)
{
	ndr_print_struct(ndr, name, "PNP_CreateDevInst");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_CreateDevInst");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_CreateDevInst");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_DeviceInstanceAction(struct ndr_push *ndr, int flags, const struct PNP_DeviceInstanceAction *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_DeviceInstanceAction(struct ndr_pull *ndr, int flags, struct PNP_DeviceInstanceAction *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_DeviceInstanceAction(struct ndr_print *ndr, const char *name, int flags, const struct PNP_DeviceInstanceAction *r)
{
	ndr_print_struct(ndr, name, "PNP_DeviceInstanceAction");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_DeviceInstanceAction");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_DeviceInstanceAction");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetDeviceStatus(struct ndr_push *ndr, int flags, const struct PNP_GetDeviceStatus *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetDeviceStatus(struct ndr_pull *ndr, int flags, struct PNP_GetDeviceStatus *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetDeviceStatus(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetDeviceStatus *r)
{
	ndr_print_struct(ndr, name, "PNP_GetDeviceStatus");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetDeviceStatus");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetDeviceStatus");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_SetDeviceProblem(struct ndr_push *ndr, int flags, const struct PNP_SetDeviceProblem *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_SetDeviceProblem(struct ndr_pull *ndr, int flags, struct PNP_SetDeviceProblem *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_SetDeviceProblem(struct ndr_print *ndr, const char *name, int flags, const struct PNP_SetDeviceProblem *r)
{
	ndr_print_struct(ndr, name, "PNP_SetDeviceProblem");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_SetDeviceProblem");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_SetDeviceProblem");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_DisableDevInst(struct ndr_push *ndr, int flags, const struct PNP_DisableDevInst *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_DisableDevInst(struct ndr_pull *ndr, int flags, struct PNP_DisableDevInst *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_DisableDevInst(struct ndr_print *ndr, const char *name, int flags, const struct PNP_DisableDevInst *r)
{
	ndr_print_struct(ndr, name, "PNP_DisableDevInst");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_DisableDevInst");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_DisableDevInst");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_UninstallDevInst(struct ndr_push *ndr, int flags, const struct PNP_UninstallDevInst *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_UninstallDevInst(struct ndr_pull *ndr, int flags, struct PNP_UninstallDevInst *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_UninstallDevInst(struct ndr_print *ndr, const char *name, int flags, const struct PNP_UninstallDevInst *r)
{
	ndr_print_struct(ndr, name, "PNP_UninstallDevInst");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_UninstallDevInst");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_UninstallDevInst");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_AddID(struct ndr_push *ndr, int flags, const struct PNP_AddID *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_AddID(struct ndr_pull *ndr, int flags, struct PNP_AddID *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_AddID(struct ndr_print *ndr, const char *name, int flags, const struct PNP_AddID *r)
{
	ndr_print_struct(ndr, name, "PNP_AddID");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_AddID");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_AddID");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_RegisterDriver(struct ndr_push *ndr, int flags, const struct PNP_RegisterDriver *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_RegisterDriver(struct ndr_pull *ndr, int flags, struct PNP_RegisterDriver *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_RegisterDriver(struct ndr_print *ndr, const char *name, int flags, const struct PNP_RegisterDriver *r)
{
	ndr_print_struct(ndr, name, "PNP_RegisterDriver");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_RegisterDriver");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_RegisterDriver");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_QueryRemove(struct ndr_push *ndr, int flags, const struct PNP_QueryRemove *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_QueryRemove(struct ndr_pull *ndr, int flags, struct PNP_QueryRemove *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_QueryRemove(struct ndr_print *ndr, const char *name, int flags, const struct PNP_QueryRemove *r)
{
	ndr_print_struct(ndr, name, "PNP_QueryRemove");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_QueryRemove");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_QueryRemove");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_RequestDeviceEject(struct ndr_push *ndr, int flags, const struct PNP_RequestDeviceEject *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_RequestDeviceEject(struct ndr_pull *ndr, int flags, struct PNP_RequestDeviceEject *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_RequestDeviceEject(struct ndr_print *ndr, const char *name, int flags, const struct PNP_RequestDeviceEject *r)
{
	ndr_print_struct(ndr, name, "PNP_RequestDeviceEject");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_RequestDeviceEject");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_RequestDeviceEject");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_IsDockStationPresent(struct ndr_push *ndr, int flags, const struct PNP_IsDockStationPresent *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_IsDockStationPresent(struct ndr_pull *ndr, int flags, struct PNP_IsDockStationPresent *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_IsDockStationPresent(struct ndr_print *ndr, const char *name, int flags, const struct PNP_IsDockStationPresent *r)
{
	ndr_print_struct(ndr, name, "PNP_IsDockStationPresent");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_IsDockStationPresent");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_IsDockStationPresent");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_RequestEjectPC(struct ndr_push *ndr, int flags, const struct PNP_RequestEjectPC *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_RequestEjectPC(struct ndr_pull *ndr, int flags, struct PNP_RequestEjectPC *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_RequestEjectPC(struct ndr_print *ndr, const char *name, int flags, const struct PNP_RequestEjectPC *r)
{
	ndr_print_struct(ndr, name, "PNP_RequestEjectPC");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_RequestEjectPC");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_RequestEjectPC");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_HwProfFlags(struct ndr_push *ndr, int flags, const struct PNP_HwProfFlags *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.action));
		if (r->in.devicepath == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.devicepath, CH_UTF16)));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
		NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.devicepath, CH_UTF16)));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.devicepath, ndr_charset_length(r->in.devicepath, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.config));
		if (r->in.profile_flags == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->in.profile_flags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.veto_type));
		if (r->in.veto_type) {
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->in.veto_type));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->in.unknown5));
		if (r->in.unknown5) {
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.unknown5, CH_UTF16)));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(r->in.unknown5, CH_UTF16)));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->in.unknown5, ndr_charset_length(r->in.unknown5, CH_UTF16), sizeof(uint16_t), CH_UTF16));
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.name_length));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.profile_flags == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, *r->out.profile_flags));
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.veto_type));
		if (r->out.veto_type) {
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, *r->out.veto_type));
		}
		NDR_CHECK(ndr_push_unique_ptr(ndr, r->out.unknown5a));
		if (r->out.unknown5a) {
			NDR_CHECK(ndr_push_unique_ptr(ndr, *r->out.unknown5a));
			if (*r->out.unknown5a) {
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.unknown5a, CH_UTF16)));
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, 0));
				NDR_CHECK(ndr_push_uint3264(ndr, NDR_SCALARS, ndr_charset_length(*r->out.unknown5a, CH_UTF16)));
				NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, *r->out.unknown5a, ndr_charset_length(*r->out.unknown5a, CH_UTF16), sizeof(uint16_t), CH_UTF16));
			}
		}
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_HwProfFlags(struct ndr_pull *ndr, int flags, struct PNP_HwProfFlags *r)
{
	uint32_t size_devicepath_1 = 0;
	uint32_t length_devicepath_1 = 0;
	uint32_t _ptr_veto_type;
	uint32_t _ptr_unknown5;
	uint32_t size_unknown5_1 = 0;
	uint32_t length_unknown5_1 = 0;
	uint32_t _ptr_unknown5a;
	uint32_t size_unknown5a_2 = 0;
	uint32_t length_unknown5a_2 = 0;
	TALLOC_CTX *_mem_save_profile_flags_0;
	TALLOC_CTX *_mem_save_veto_type_0;
	TALLOC_CTX *_mem_save_unknown5_0;
	TALLOC_CTX *_mem_save_unknown5a_0;
	TALLOC_CTX *_mem_save_unknown5a_1;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.action));
		NDR_CHECK(ndr_pull_array_size(ndr, &r->in.devicepath));
		NDR_CHECK(ndr_pull_array_length(ndr, &r->in.devicepath));
		size_devicepath_1 = ndr_get_array_size(ndr, &r->in.devicepath);
		length_devicepath_1 = ndr_get_array_length(ndr, &r->in.devicepath);
		if (length_devicepath_1 > size_devicepath_1) {
			return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_devicepath_1, length_devicepath_1);
		}
		NDR_CHECK(ndr_check_string_terminator(ndr, length_devicepath_1, sizeof(uint16_t)));
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.devicepath, length_devicepath_1, sizeof(uint16_t), CH_UTF16));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.config));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.profile_flags);
		}
		_mem_save_profile_flags_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.profile_flags, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->in.profile_flags));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_profile_flags_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_veto_type));
		if (_ptr_veto_type) {
			NDR_PULL_ALLOC(ndr, r->in.veto_type);
		} else {
			r->in.veto_type = NULL;
		}
		if (r->in.veto_type) {
			_mem_save_veto_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.veto_type, 0);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->in.veto_type));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_veto_type_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_unknown5));
		if (_ptr_unknown5) {
			NDR_PULL_ALLOC(ndr, r->in.unknown5);
		} else {
			r->in.unknown5 = NULL;
		}
		if (r->in.unknown5) {
			_mem_save_unknown5_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->in.unknown5, 0);
			NDR_CHECK(ndr_pull_array_size(ndr, &r->in.unknown5));
			NDR_CHECK(ndr_pull_array_length(ndr, &r->in.unknown5));
			size_unknown5_1 = ndr_get_array_size(ndr, &r->in.unknown5);
			length_unknown5_1 = ndr_get_array_length(ndr, &r->in.unknown5);
			if (length_unknown5_1 > size_unknown5_1) {
				return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_unknown5_1, length_unknown5_1);
			}
			NDR_CHECK(ndr_check_string_terminator(ndr, length_unknown5_1, sizeof(uint16_t)));
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->in.unknown5, length_unknown5_1, sizeof(uint16_t), CH_UTF16));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unknown5_0, 0);
		}
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.name_length));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.profile_flags);
		*r->out.profile_flags = *r->in.profile_flags;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.profile_flags);
		}
		_mem_save_profile_flags_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.profile_flags, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, r->out.profile_flags));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_profile_flags_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_veto_type));
		if (_ptr_veto_type) {
			NDR_PULL_ALLOC(ndr, r->out.veto_type);
		} else {
			r->out.veto_type = NULL;
		}
		if (r->out.veto_type) {
			_mem_save_veto_type_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.veto_type, 0);
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, r->out.veto_type));
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_veto_type_0, 0);
		}
		NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_unknown5a));
		if (_ptr_unknown5a) {
			NDR_PULL_ALLOC(ndr, r->out.unknown5a);
		} else {
			r->out.unknown5a = NULL;
		}
		if (r->out.unknown5a) {
			_mem_save_unknown5a_0 = NDR_PULL_GET_MEM_CTX(ndr);
			NDR_PULL_SET_MEM_CTX(ndr, r->out.unknown5a, 0);
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_unknown5a));
			if (_ptr_unknown5a) {
				NDR_PULL_ALLOC(ndr, *r->out.unknown5a);
			} else {
				*r->out.unknown5a = NULL;
			}
			if (*r->out.unknown5a) {
				_mem_save_unknown5a_1 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, *r->out.unknown5a, 0);
				NDR_CHECK(ndr_pull_array_size(ndr, r->out.unknown5a));
				NDR_CHECK(ndr_pull_array_length(ndr, r->out.unknown5a));
				size_unknown5a_2 = ndr_get_array_size(ndr, r->out.unknown5a);
				length_unknown5a_2 = ndr_get_array_length(ndr, r->out.unknown5a);
				if (length_unknown5a_2 > size_unknown5a_2) {
					return ndr_pull_error(ndr, NDR_ERR_ARRAY_SIZE, "Bad array size %u should exceed array length %u", size_unknown5a_2, length_unknown5a_2);
				}
				NDR_CHECK(ndr_check_string_terminator(ndr, length_unknown5a_2, sizeof(uint16_t)));
				NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, r->out.unknown5a, length_unknown5a_2, sizeof(uint16_t), CH_UTF16));
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unknown5a_1, 0);
			}
			NDR_PULL_SET_MEM_CTX(ndr, _mem_save_unknown5a_0, 0);
		}
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_HwProfFlags(struct ndr_print *ndr, const char *name, int flags, const struct PNP_HwProfFlags *r)
{
	ndr_print_struct(ndr, name, "PNP_HwProfFlags");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_HwProfFlags");
		ndr->depth++;
		ndr_print_uint32(ndr, "action", r->in.action);
		ndr_print_ptr(ndr, "devicepath", r->in.devicepath);
		ndr->depth++;
		ndr_print_string(ndr, "devicepath", r->in.devicepath);
		ndr->depth--;
		ndr_print_uint32(ndr, "config", r->in.config);
		ndr_print_ptr(ndr, "profile_flags", r->in.profile_flags);
		ndr->depth++;
		ndr_print_uint32(ndr, "profile_flags", *r->in.profile_flags);
		ndr->depth--;
		ndr_print_ptr(ndr, "veto_type", r->in.veto_type);
		ndr->depth++;
		if (r->in.veto_type) {
			ndr_print_uint16(ndr, "veto_type", *r->in.veto_type);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "unknown5", r->in.unknown5);
		ndr->depth++;
		if (r->in.unknown5) {
			ndr_print_string(ndr, "unknown5", r->in.unknown5);
		}
		ndr->depth--;
		ndr_print_uint32(ndr, "name_length", r->in.name_length);
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_HwProfFlags");
		ndr->depth++;
		ndr_print_ptr(ndr, "profile_flags", r->out.profile_flags);
		ndr->depth++;
		ndr_print_uint32(ndr, "profile_flags", *r->out.profile_flags);
		ndr->depth--;
		ndr_print_ptr(ndr, "veto_type", r->out.veto_type);
		ndr->depth++;
		if (r->out.veto_type) {
			ndr_print_uint16(ndr, "veto_type", *r->out.veto_type);
		}
		ndr->depth--;
		ndr_print_ptr(ndr, "unknown5a", r->out.unknown5a);
		ndr->depth++;
		if (r->out.unknown5a) {
			ndr_print_ptr(ndr, "unknown5a", *r->out.unknown5a);
			ndr->depth++;
			if (*r->out.unknown5a) {
				ndr_print_string(ndr, "unknown5a", *r->out.unknown5a);
			}
			ndr->depth--;
		}
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetHwProfInfo(struct ndr_push *ndr, int flags, const struct PNP_GetHwProfInfo *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.idx));
		if (r->in.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_PNP_HwProfInfo(ndr, NDR_SCALARS, r->in.info));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.size));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->in.flags));
	}
	if (flags & NDR_OUT) {
		if (r->out.info == NULL) {
			return ndr_push_error(ndr, NDR_ERR_INVALID_POINTER, "NULL [ref] pointer");
		}
		NDR_CHECK(ndr_push_PNP_HwProfInfo(ndr, NDR_SCALARS, r->out.info));
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetHwProfInfo(struct ndr_pull *ndr, int flags, struct PNP_GetHwProfInfo *r)
{
	TALLOC_CTX *_mem_save_info_0;
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
		ZERO_STRUCT(r->out);

		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.idx));
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->in.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->in.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_PNP_HwProfInfo(ndr, NDR_SCALARS, r->in.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->in.flags));
		NDR_PULL_ALLOC(ndr, r->out.info);
		*r->out.info = *r->in.info;
	}
	if (flags & NDR_OUT) {
		if (ndr->flags & LIBNDR_FLAG_REF_ALLOC) {
			NDR_PULL_ALLOC(ndr, r->out.info);
		}
		_mem_save_info_0 = NDR_PULL_GET_MEM_CTX(ndr);
		NDR_PULL_SET_MEM_CTX(ndr, r->out.info, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_PNP_HwProfInfo(ndr, NDR_SCALARS, r->out.info));
		NDR_PULL_SET_MEM_CTX(ndr, _mem_save_info_0, LIBNDR_FLAG_REF_ALLOC);
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetHwProfInfo(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetHwProfInfo *r)
{
	ndr_print_struct(ndr, name, "PNP_GetHwProfInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetHwProfInfo");
		ndr->depth++;
		ndr_print_uint32(ndr, "idx", r->in.idx);
		ndr_print_ptr(ndr, "info", r->in.info);
		ndr->depth++;
		ndr_print_PNP_HwProfInfo(ndr, "info", r->in.info);
		ndr->depth--;
		ndr_print_uint32(ndr, "size", r->in.size);
		ndr_print_uint32(ndr, "flags", r->in.flags);
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetHwProfInfo");
		ndr->depth++;
		ndr_print_ptr(ndr, "info", r->out.info);
		ndr->depth++;
		ndr_print_PNP_HwProfInfo(ndr, "info", r->out.info);
		ndr->depth--;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_AddEmptyLogConf(struct ndr_push *ndr, int flags, const struct PNP_AddEmptyLogConf *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_AddEmptyLogConf(struct ndr_pull *ndr, int flags, struct PNP_AddEmptyLogConf *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_AddEmptyLogConf(struct ndr_print *ndr, const char *name, int flags, const struct PNP_AddEmptyLogConf *r)
{
	ndr_print_struct(ndr, name, "PNP_AddEmptyLogConf");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_AddEmptyLogConf");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_AddEmptyLogConf");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_FreeLogConf(struct ndr_push *ndr, int flags, const struct PNP_FreeLogConf *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_FreeLogConf(struct ndr_pull *ndr, int flags, struct PNP_FreeLogConf *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_FreeLogConf(struct ndr_print *ndr, const char *name, int flags, const struct PNP_FreeLogConf *r)
{
	ndr_print_struct(ndr, name, "PNP_FreeLogConf");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_FreeLogConf");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_FreeLogConf");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetFirstLogConf(struct ndr_push *ndr, int flags, const struct PNP_GetFirstLogConf *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetFirstLogConf(struct ndr_pull *ndr, int flags, struct PNP_GetFirstLogConf *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetFirstLogConf(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetFirstLogConf *r)
{
	ndr_print_struct(ndr, name, "PNP_GetFirstLogConf");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetFirstLogConf");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetFirstLogConf");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetNextLogConf(struct ndr_push *ndr, int flags, const struct PNP_GetNextLogConf *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetNextLogConf(struct ndr_pull *ndr, int flags, struct PNP_GetNextLogConf *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetNextLogConf(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetNextLogConf *r)
{
	ndr_print_struct(ndr, name, "PNP_GetNextLogConf");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetNextLogConf");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetNextLogConf");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetLogConfPriority(struct ndr_push *ndr, int flags, const struct PNP_GetLogConfPriority *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetLogConfPriority(struct ndr_pull *ndr, int flags, struct PNP_GetLogConfPriority *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetLogConfPriority(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetLogConfPriority *r)
{
	ndr_print_struct(ndr, name, "PNP_GetLogConfPriority");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetLogConfPriority");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetLogConfPriority");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_AddResDes(struct ndr_push *ndr, int flags, const struct PNP_AddResDes *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_AddResDes(struct ndr_pull *ndr, int flags, struct PNP_AddResDes *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_AddResDes(struct ndr_print *ndr, const char *name, int flags, const struct PNP_AddResDes *r)
{
	ndr_print_struct(ndr, name, "PNP_AddResDes");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_AddResDes");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_AddResDes");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_FreeResDes(struct ndr_push *ndr, int flags, const struct PNP_FreeResDes *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_FreeResDes(struct ndr_pull *ndr, int flags, struct PNP_FreeResDes *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_FreeResDes(struct ndr_print *ndr, const char *name, int flags, const struct PNP_FreeResDes *r)
{
	ndr_print_struct(ndr, name, "PNP_FreeResDes");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_FreeResDes");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_FreeResDes");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetNextResDes(struct ndr_push *ndr, int flags, const struct PNP_GetNextResDes *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetNextResDes(struct ndr_pull *ndr, int flags, struct PNP_GetNextResDes *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetNextResDes(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetNextResDes *r)
{
	ndr_print_struct(ndr, name, "PNP_GetNextResDes");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetNextResDes");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetNextResDes");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetResDesData(struct ndr_push *ndr, int flags, const struct PNP_GetResDesData *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetResDesData(struct ndr_pull *ndr, int flags, struct PNP_GetResDesData *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetResDesData(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetResDesData *r)
{
	ndr_print_struct(ndr, name, "PNP_GetResDesData");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetResDesData");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetResDesData");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetResDesDataSize(struct ndr_push *ndr, int flags, const struct PNP_GetResDesDataSize *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetResDesDataSize(struct ndr_pull *ndr, int flags, struct PNP_GetResDesDataSize *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetResDesDataSize(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetResDesDataSize *r)
{
	ndr_print_struct(ndr, name, "PNP_GetResDesDataSize");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetResDesDataSize");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetResDesDataSize");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_ModifyResDes(struct ndr_push *ndr, int flags, const struct PNP_ModifyResDes *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_ModifyResDes(struct ndr_pull *ndr, int flags, struct PNP_ModifyResDes *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_ModifyResDes(struct ndr_print *ndr, const char *name, int flags, const struct PNP_ModifyResDes *r)
{
	ndr_print_struct(ndr, name, "PNP_ModifyResDes");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_ModifyResDes");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_ModifyResDes");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_DetectResourceLimit(struct ndr_push *ndr, int flags, const struct PNP_DetectResourceLimit *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_DetectResourceLimit(struct ndr_pull *ndr, int flags, struct PNP_DetectResourceLimit *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_DetectResourceLimit(struct ndr_print *ndr, const char *name, int flags, const struct PNP_DetectResourceLimit *r)
{
	ndr_print_struct(ndr, name, "PNP_DetectResourceLimit");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_DetectResourceLimit");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_DetectResourceLimit");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_QueryResConfList(struct ndr_push *ndr, int flags, const struct PNP_QueryResConfList *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_QueryResConfList(struct ndr_pull *ndr, int flags, struct PNP_QueryResConfList *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_QueryResConfList(struct ndr_print *ndr, const char *name, int flags, const struct PNP_QueryResConfList *r)
{
	ndr_print_struct(ndr, name, "PNP_QueryResConfList");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_QueryResConfList");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_QueryResConfList");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_SetHwProf(struct ndr_push *ndr, int flags, const struct PNP_SetHwProf *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_SetHwProf(struct ndr_pull *ndr, int flags, struct PNP_SetHwProf *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_SetHwProf(struct ndr_print *ndr, const char *name, int flags, const struct PNP_SetHwProf *r)
{
	ndr_print_struct(ndr, name, "PNP_SetHwProf");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_SetHwProf");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_SetHwProf");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_QueryArbitratorFreeData(struct ndr_push *ndr, int flags, const struct PNP_QueryArbitratorFreeData *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_QueryArbitratorFreeData(struct ndr_pull *ndr, int flags, struct PNP_QueryArbitratorFreeData *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_QueryArbitratorFreeData(struct ndr_print *ndr, const char *name, int flags, const struct PNP_QueryArbitratorFreeData *r)
{
	ndr_print_struct(ndr, name, "PNP_QueryArbitratorFreeData");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_QueryArbitratorFreeData");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_QueryArbitratorFreeData");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_QueryArbitratorFreeSize(struct ndr_push *ndr, int flags, const struct PNP_QueryArbitratorFreeSize *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_QueryArbitratorFreeSize(struct ndr_pull *ndr, int flags, struct PNP_QueryArbitratorFreeSize *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_QueryArbitratorFreeSize(struct ndr_print *ndr, const char *name, int flags, const struct PNP_QueryArbitratorFreeSize *r)
{
	ndr_print_struct(ndr, name, "PNP_QueryArbitratorFreeSize");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_QueryArbitratorFreeSize");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_QueryArbitratorFreeSize");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_RunDetection(struct ndr_push *ndr, int flags, const struct PNP_RunDetection *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_RunDetection(struct ndr_pull *ndr, int flags, struct PNP_RunDetection *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_RunDetection(struct ndr_print *ndr, const char *name, int flags, const struct PNP_RunDetection *r)
{
	ndr_print_struct(ndr, name, "PNP_RunDetection");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_RunDetection");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_RunDetection");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_RegisterNotification(struct ndr_push *ndr, int flags, const struct PNP_RegisterNotification *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_RegisterNotification(struct ndr_pull *ndr, int flags, struct PNP_RegisterNotification *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_RegisterNotification(struct ndr_print *ndr, const char *name, int flags, const struct PNP_RegisterNotification *r)
{
	ndr_print_struct(ndr, name, "PNP_RegisterNotification");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_RegisterNotification");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_RegisterNotification");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_UnregisterNotification(struct ndr_push *ndr, int flags, const struct PNP_UnregisterNotification *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_UnregisterNotification(struct ndr_pull *ndr, int flags, struct PNP_UnregisterNotification *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_UnregisterNotification(struct ndr_print *ndr, const char *name, int flags, const struct PNP_UnregisterNotification *r)
{
	ndr_print_struct(ndr, name, "PNP_UnregisterNotification");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_UnregisterNotification");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_UnregisterNotification");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetCustomDevProp(struct ndr_push *ndr, int flags, const struct PNP_GetCustomDevProp *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetCustomDevProp(struct ndr_pull *ndr, int flags, struct PNP_GetCustomDevProp *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetCustomDevProp(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetCustomDevProp *r)
{
	ndr_print_struct(ndr, name, "PNP_GetCustomDevProp");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetCustomDevProp");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetCustomDevProp");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetVersionInternal(struct ndr_push *ndr, int flags, const struct PNP_GetVersionInternal *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetVersionInternal(struct ndr_pull *ndr, int flags, struct PNP_GetVersionInternal *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetVersionInternal(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetVersionInternal *r)
{
	ndr_print_struct(ndr, name, "PNP_GetVersionInternal");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetVersionInternal");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetVersionInternal");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetBlockedDriverInfo(struct ndr_push *ndr, int flags, const struct PNP_GetBlockedDriverInfo *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetBlockedDriverInfo(struct ndr_pull *ndr, int flags, struct PNP_GetBlockedDriverInfo *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetBlockedDriverInfo(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetBlockedDriverInfo *r)
{
	ndr_print_struct(ndr, name, "PNP_GetBlockedDriverInfo");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetBlockedDriverInfo");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetBlockedDriverInfo");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static enum ndr_err_code ndr_push_PNP_GetServerSideDeviceInstallFlags(struct ndr_push *ndr, int flags, const struct PNP_GetServerSideDeviceInstallFlags *r)
{
	NDR_PUSH_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_push_WERROR(ndr, NDR_SCALARS, r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_PNP_GetServerSideDeviceInstallFlags(struct ndr_pull *ndr, int flags, struct PNP_GetServerSideDeviceInstallFlags *r)
{
	NDR_PULL_CHECK_FN_FLAGS(ndr, flags);
	if (flags & NDR_IN) {
	}
	if (flags & NDR_OUT) {
		NDR_CHECK(ndr_pull_WERROR(ndr, NDR_SCALARS, &r->out.result));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_PNP_GetServerSideDeviceInstallFlags(struct ndr_print *ndr, const char *name, int flags, const struct PNP_GetServerSideDeviceInstallFlags *r)
{
	ndr_print_struct(ndr, name, "PNP_GetServerSideDeviceInstallFlags");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	if (flags & NDR_SET_VALUES) {
		ndr->flags |= LIBNDR_PRINT_SET_VALUES;
	}
	if (flags & NDR_IN) {
		ndr_print_struct(ndr, "in", "PNP_GetServerSideDeviceInstallFlags");
		ndr->depth++;
		ndr->depth--;
	}
	if (flags & NDR_OUT) {
		ndr_print_struct(ndr, "out", "PNP_GetServerSideDeviceInstallFlags");
		ndr->depth++;
		ndr_print_WERROR(ndr, "result", r->out.result);
		ndr->depth--;
	}
	ndr->depth--;
}

static const struct ndr_interface_call ntsvcs_calls[] = {
	{
		"PNP_Disconnect",
		sizeof(struct PNP_Disconnect),
		(ndr_push_flags_fn_t) ndr_push_PNP_Disconnect,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_Disconnect,
		(ndr_print_function_t) ndr_print_PNP_Disconnect,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_Connect",
		sizeof(struct PNP_Connect),
		(ndr_push_flags_fn_t) ndr_push_PNP_Connect,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_Connect,
		(ndr_print_function_t) ndr_print_PNP_Connect,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_GetVersion",
		sizeof(struct PNP_GetVersion),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetVersion,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetVersion,
		(ndr_print_function_t) ndr_print_PNP_GetVersion,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_GetGlobalState",
		sizeof(struct PNP_GetGlobalState),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetGlobalState,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetGlobalState,
		(ndr_print_function_t) ndr_print_PNP_GetGlobalState,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_InitDetection",
		sizeof(struct PNP_InitDetection),
		(ndr_push_flags_fn_t) ndr_push_PNP_InitDetection,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_InitDetection,
		(ndr_print_function_t) ndr_print_PNP_InitDetection,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_ReportLogOn",
		sizeof(struct PNP_ReportLogOn),
		(ndr_push_flags_fn_t) ndr_push_PNP_ReportLogOn,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_ReportLogOn,
		(ndr_print_function_t) ndr_print_PNP_ReportLogOn,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_ValidateDeviceInstance",
		sizeof(struct PNP_ValidateDeviceInstance),
		(ndr_push_flags_fn_t) ndr_push_PNP_ValidateDeviceInstance,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_ValidateDeviceInstance,
		(ndr_print_function_t) ndr_print_PNP_ValidateDeviceInstance,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_GetRootDeviceInstance",
		sizeof(struct PNP_GetRootDeviceInstance),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetRootDeviceInstance,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetRootDeviceInstance,
		(ndr_print_function_t) ndr_print_PNP_GetRootDeviceInstance,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_GetRelatedDeviceInstance",
		sizeof(struct PNP_GetRelatedDeviceInstance),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetRelatedDeviceInstance,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetRelatedDeviceInstance,
		(ndr_print_function_t) ndr_print_PNP_GetRelatedDeviceInstance,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_EnumerateSubKeys",
		sizeof(struct PNP_EnumerateSubKeys),
		(ndr_push_flags_fn_t) ndr_push_PNP_EnumerateSubKeys,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_EnumerateSubKeys,
		(ndr_print_function_t) ndr_print_PNP_EnumerateSubKeys,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_GetDeviceList",
		sizeof(struct PNP_GetDeviceList),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetDeviceList,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetDeviceList,
		(ndr_print_function_t) ndr_print_PNP_GetDeviceList,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_GetDeviceListSize",
		sizeof(struct PNP_GetDeviceListSize),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetDeviceListSize,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetDeviceListSize,
		(ndr_print_function_t) ndr_print_PNP_GetDeviceListSize,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_GetDepth",
		sizeof(struct PNP_GetDepth),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetDepth,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetDepth,
		(ndr_print_function_t) ndr_print_PNP_GetDepth,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_GetDeviceRegProp",
		sizeof(struct PNP_GetDeviceRegProp),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetDeviceRegProp,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetDeviceRegProp,
		(ndr_print_function_t) ndr_print_PNP_GetDeviceRegProp,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_SetDeviceRegProp",
		sizeof(struct PNP_SetDeviceRegProp),
		(ndr_push_flags_fn_t) ndr_push_PNP_SetDeviceRegProp,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_SetDeviceRegProp,
		(ndr_print_function_t) ndr_print_PNP_SetDeviceRegProp,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_GetClassInstance",
		sizeof(struct PNP_GetClassInstance),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetClassInstance,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetClassInstance,
		(ndr_print_function_t) ndr_print_PNP_GetClassInstance,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_CreateKey",
		sizeof(struct PNP_CreateKey),
		(ndr_push_flags_fn_t) ndr_push_PNP_CreateKey,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_CreateKey,
		(ndr_print_function_t) ndr_print_PNP_CreateKey,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_DeleteRegistryKey",
		sizeof(struct PNP_DeleteRegistryKey),
		(ndr_push_flags_fn_t) ndr_push_PNP_DeleteRegistryKey,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_DeleteRegistryKey,
		(ndr_print_function_t) ndr_print_PNP_DeleteRegistryKey,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_GetClassCount",
		sizeof(struct PNP_GetClassCount),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetClassCount,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetClassCount,
		(ndr_print_function_t) ndr_print_PNP_GetClassCount,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_GetClassName",
		sizeof(struct PNP_GetClassName),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetClassName,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetClassName,
		(ndr_print_function_t) ndr_print_PNP_GetClassName,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_DeleteClassKey",
		sizeof(struct PNP_DeleteClassKey),
		(ndr_push_flags_fn_t) ndr_push_PNP_DeleteClassKey,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_DeleteClassKey,
		(ndr_print_function_t) ndr_print_PNP_DeleteClassKey,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_GetInterfaceDeviceAlias",
		sizeof(struct PNP_GetInterfaceDeviceAlias),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetInterfaceDeviceAlias,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetInterfaceDeviceAlias,
		(ndr_print_function_t) ndr_print_PNP_GetInterfaceDeviceAlias,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_GetInterfaceDeviceList",
		sizeof(struct PNP_GetInterfaceDeviceList),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetInterfaceDeviceList,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetInterfaceDeviceList,
		(ndr_print_function_t) ndr_print_PNP_GetInterfaceDeviceList,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_GetInterfaceDeviceListSize",
		sizeof(struct PNP_GetInterfaceDeviceListSize),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetInterfaceDeviceListSize,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetInterfaceDeviceListSize,
		(ndr_print_function_t) ndr_print_PNP_GetInterfaceDeviceListSize,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_RegisterDeviceClassAssociation",
		sizeof(struct PNP_RegisterDeviceClassAssociation),
		(ndr_push_flags_fn_t) ndr_push_PNP_RegisterDeviceClassAssociation,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_RegisterDeviceClassAssociation,
		(ndr_print_function_t) ndr_print_PNP_RegisterDeviceClassAssociation,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_UnregisterDeviceClassAssociation",
		sizeof(struct PNP_UnregisterDeviceClassAssociation),
		(ndr_push_flags_fn_t) ndr_push_PNP_UnregisterDeviceClassAssociation,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_UnregisterDeviceClassAssociation,
		(ndr_print_function_t) ndr_print_PNP_UnregisterDeviceClassAssociation,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_GetClassRegProp",
		sizeof(struct PNP_GetClassRegProp),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetClassRegProp,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetClassRegProp,
		(ndr_print_function_t) ndr_print_PNP_GetClassRegProp,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_SetClassRegProp",
		sizeof(struct PNP_SetClassRegProp),
		(ndr_push_flags_fn_t) ndr_push_PNP_SetClassRegProp,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_SetClassRegProp,
		(ndr_print_function_t) ndr_print_PNP_SetClassRegProp,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_CreateDevInst",
		sizeof(struct PNP_CreateDevInst),
		(ndr_push_flags_fn_t) ndr_push_PNP_CreateDevInst,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_CreateDevInst,
		(ndr_print_function_t) ndr_print_PNP_CreateDevInst,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_DeviceInstanceAction",
		sizeof(struct PNP_DeviceInstanceAction),
		(ndr_push_flags_fn_t) ndr_push_PNP_DeviceInstanceAction,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_DeviceInstanceAction,
		(ndr_print_function_t) ndr_print_PNP_DeviceInstanceAction,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_GetDeviceStatus",
		sizeof(struct PNP_GetDeviceStatus),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetDeviceStatus,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetDeviceStatus,
		(ndr_print_function_t) ndr_print_PNP_GetDeviceStatus,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_SetDeviceProblem",
		sizeof(struct PNP_SetDeviceProblem),
		(ndr_push_flags_fn_t) ndr_push_PNP_SetDeviceProblem,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_SetDeviceProblem,
		(ndr_print_function_t) ndr_print_PNP_SetDeviceProblem,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_DisableDevInst",
		sizeof(struct PNP_DisableDevInst),
		(ndr_push_flags_fn_t) ndr_push_PNP_DisableDevInst,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_DisableDevInst,
		(ndr_print_function_t) ndr_print_PNP_DisableDevInst,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_UninstallDevInst",
		sizeof(struct PNP_UninstallDevInst),
		(ndr_push_flags_fn_t) ndr_push_PNP_UninstallDevInst,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_UninstallDevInst,
		(ndr_print_function_t) ndr_print_PNP_UninstallDevInst,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_AddID",
		sizeof(struct PNP_AddID),
		(ndr_push_flags_fn_t) ndr_push_PNP_AddID,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_AddID,
		(ndr_print_function_t) ndr_print_PNP_AddID,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_RegisterDriver",
		sizeof(struct PNP_RegisterDriver),
		(ndr_push_flags_fn_t) ndr_push_PNP_RegisterDriver,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_RegisterDriver,
		(ndr_print_function_t) ndr_print_PNP_RegisterDriver,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_QueryRemove",
		sizeof(struct PNP_QueryRemove),
		(ndr_push_flags_fn_t) ndr_push_PNP_QueryRemove,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_QueryRemove,
		(ndr_print_function_t) ndr_print_PNP_QueryRemove,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_RequestDeviceEject",
		sizeof(struct PNP_RequestDeviceEject),
		(ndr_push_flags_fn_t) ndr_push_PNP_RequestDeviceEject,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_RequestDeviceEject,
		(ndr_print_function_t) ndr_print_PNP_RequestDeviceEject,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_IsDockStationPresent",
		sizeof(struct PNP_IsDockStationPresent),
		(ndr_push_flags_fn_t) ndr_push_PNP_IsDockStationPresent,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_IsDockStationPresent,
		(ndr_print_function_t) ndr_print_PNP_IsDockStationPresent,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_RequestEjectPC",
		sizeof(struct PNP_RequestEjectPC),
		(ndr_push_flags_fn_t) ndr_push_PNP_RequestEjectPC,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_RequestEjectPC,
		(ndr_print_function_t) ndr_print_PNP_RequestEjectPC,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_HwProfFlags",
		sizeof(struct PNP_HwProfFlags),
		(ndr_push_flags_fn_t) ndr_push_PNP_HwProfFlags,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_HwProfFlags,
		(ndr_print_function_t) ndr_print_PNP_HwProfFlags,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_GetHwProfInfo",
		sizeof(struct PNP_GetHwProfInfo),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetHwProfInfo,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetHwProfInfo,
		(ndr_print_function_t) ndr_print_PNP_GetHwProfInfo,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_AddEmptyLogConf",
		sizeof(struct PNP_AddEmptyLogConf),
		(ndr_push_flags_fn_t) ndr_push_PNP_AddEmptyLogConf,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_AddEmptyLogConf,
		(ndr_print_function_t) ndr_print_PNP_AddEmptyLogConf,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_FreeLogConf",
		sizeof(struct PNP_FreeLogConf),
		(ndr_push_flags_fn_t) ndr_push_PNP_FreeLogConf,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_FreeLogConf,
		(ndr_print_function_t) ndr_print_PNP_FreeLogConf,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_GetFirstLogConf",
		sizeof(struct PNP_GetFirstLogConf),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetFirstLogConf,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetFirstLogConf,
		(ndr_print_function_t) ndr_print_PNP_GetFirstLogConf,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_GetNextLogConf",
		sizeof(struct PNP_GetNextLogConf),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetNextLogConf,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetNextLogConf,
		(ndr_print_function_t) ndr_print_PNP_GetNextLogConf,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_GetLogConfPriority",
		sizeof(struct PNP_GetLogConfPriority),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetLogConfPriority,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetLogConfPriority,
		(ndr_print_function_t) ndr_print_PNP_GetLogConfPriority,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_AddResDes",
		sizeof(struct PNP_AddResDes),
		(ndr_push_flags_fn_t) ndr_push_PNP_AddResDes,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_AddResDes,
		(ndr_print_function_t) ndr_print_PNP_AddResDes,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_FreeResDes",
		sizeof(struct PNP_FreeResDes),
		(ndr_push_flags_fn_t) ndr_push_PNP_FreeResDes,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_FreeResDes,
		(ndr_print_function_t) ndr_print_PNP_FreeResDes,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_GetNextResDes",
		sizeof(struct PNP_GetNextResDes),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetNextResDes,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetNextResDes,
		(ndr_print_function_t) ndr_print_PNP_GetNextResDes,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_GetResDesData",
		sizeof(struct PNP_GetResDesData),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetResDesData,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetResDesData,
		(ndr_print_function_t) ndr_print_PNP_GetResDesData,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_GetResDesDataSize",
		sizeof(struct PNP_GetResDesDataSize),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetResDesDataSize,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetResDesDataSize,
		(ndr_print_function_t) ndr_print_PNP_GetResDesDataSize,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_ModifyResDes",
		sizeof(struct PNP_ModifyResDes),
		(ndr_push_flags_fn_t) ndr_push_PNP_ModifyResDes,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_ModifyResDes,
		(ndr_print_function_t) ndr_print_PNP_ModifyResDes,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_DetectResourceLimit",
		sizeof(struct PNP_DetectResourceLimit),
		(ndr_push_flags_fn_t) ndr_push_PNP_DetectResourceLimit,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_DetectResourceLimit,
		(ndr_print_function_t) ndr_print_PNP_DetectResourceLimit,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_QueryResConfList",
		sizeof(struct PNP_QueryResConfList),
		(ndr_push_flags_fn_t) ndr_push_PNP_QueryResConfList,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_QueryResConfList,
		(ndr_print_function_t) ndr_print_PNP_QueryResConfList,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_SetHwProf",
		sizeof(struct PNP_SetHwProf),
		(ndr_push_flags_fn_t) ndr_push_PNP_SetHwProf,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_SetHwProf,
		(ndr_print_function_t) ndr_print_PNP_SetHwProf,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_QueryArbitratorFreeData",
		sizeof(struct PNP_QueryArbitratorFreeData),
		(ndr_push_flags_fn_t) ndr_push_PNP_QueryArbitratorFreeData,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_QueryArbitratorFreeData,
		(ndr_print_function_t) ndr_print_PNP_QueryArbitratorFreeData,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_QueryArbitratorFreeSize",
		sizeof(struct PNP_QueryArbitratorFreeSize),
		(ndr_push_flags_fn_t) ndr_push_PNP_QueryArbitratorFreeSize,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_QueryArbitratorFreeSize,
		(ndr_print_function_t) ndr_print_PNP_QueryArbitratorFreeSize,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_RunDetection",
		sizeof(struct PNP_RunDetection),
		(ndr_push_flags_fn_t) ndr_push_PNP_RunDetection,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_RunDetection,
		(ndr_print_function_t) ndr_print_PNP_RunDetection,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_RegisterNotification",
		sizeof(struct PNP_RegisterNotification),
		(ndr_push_flags_fn_t) ndr_push_PNP_RegisterNotification,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_RegisterNotification,
		(ndr_print_function_t) ndr_print_PNP_RegisterNotification,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_UnregisterNotification",
		sizeof(struct PNP_UnregisterNotification),
		(ndr_push_flags_fn_t) ndr_push_PNP_UnregisterNotification,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_UnregisterNotification,
		(ndr_print_function_t) ndr_print_PNP_UnregisterNotification,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_GetCustomDevProp",
		sizeof(struct PNP_GetCustomDevProp),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetCustomDevProp,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetCustomDevProp,
		(ndr_print_function_t) ndr_print_PNP_GetCustomDevProp,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_GetVersionInternal",
		sizeof(struct PNP_GetVersionInternal),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetVersionInternal,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetVersionInternal,
		(ndr_print_function_t) ndr_print_PNP_GetVersionInternal,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_GetBlockedDriverInfo",
		sizeof(struct PNP_GetBlockedDriverInfo),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetBlockedDriverInfo,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetBlockedDriverInfo,
		(ndr_print_function_t) ndr_print_PNP_GetBlockedDriverInfo,
		{ 0, NULL },
		{ 0, NULL },
	},
	{
		"PNP_GetServerSideDeviceInstallFlags",
		sizeof(struct PNP_GetServerSideDeviceInstallFlags),
		(ndr_push_flags_fn_t) ndr_push_PNP_GetServerSideDeviceInstallFlags,
		(ndr_pull_flags_fn_t) ndr_pull_PNP_GetServerSideDeviceInstallFlags,
		(ndr_print_function_t) ndr_print_PNP_GetServerSideDeviceInstallFlags,
		{ 0, NULL },
		{ 0, NULL },
	},
	{ NULL, 0, NULL, NULL, NULL }
};

static const char * const ntsvcs_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\ntsvcs]", 
	"ncacn_np:[\\pipe\\plugplay]", 
};

static const struct ndr_interface_string_array ntsvcs_endpoints = {
	.count	= 2,
	.names	= ntsvcs_endpoint_strings
};

static const char * const ntsvcs_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array ntsvcs_authservices = {
	.count	= 1,
	.names	= ntsvcs_authservice_strings
};


const struct ndr_interface_table ndr_table_ntsvcs = {
	.name		= "ntsvcs",
	.syntax_id	= {
		{0x8d9f4e40,0xa03d,0x11ce,{0x8f,0x69},{0x08,0x00,0x3e,0x30,0x05,0x1b}},
		NDR_NTSVCS_VERSION
	},
	.helpstring	= NDR_NTSVCS_HELPSTRING,
	.num_calls	= 65,
	.calls		= ntsvcs_calls,
	.endpoints	= &ntsvcs_endpoints,
	.authservices	= &ntsvcs_authservices
};

