/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/cli_lsa.h"

NTSTATUS rpccli_lsa_Close(struct rpc_pipe_client *cli,
			  TALLOC_CTX *mem_ctx,
			  struct policy_handle *handle /* [in,out] [ref] */)
{
	struct lsa_Close r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_Close, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CLOSE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_Close, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_Delete(struct rpc_pipe_client *cli,
			   TALLOC_CTX *mem_ctx,
			   struct policy_handle *handle /* [in] [ref] */)
{
	struct lsa_Delete r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_Delete, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_DELETE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_Delete, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_EnumPrivs(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      struct policy_handle *handle /* [in] [ref] */,
			      uint32_t *resume_handle /* [in,out] [ref] */,
			      struct lsa_PrivArray *privs /* [out] [ref] */,
			      uint32_t max_count /* [in]  */)
{
	struct lsa_EnumPrivs r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.resume_handle = resume_handle;
	r.in.max_count = max_count;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumPrivs, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_ENUMPRIVS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumPrivs, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*resume_handle = *r.out.resume_handle;
	*privs = *r.out.privs;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_QuerySecurity(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *handle /* [in] [ref] */,
				  uint32_t sec_info /* [in]  */,
				  struct sec_desc_buf **sdbuf /* [out] [ref] */)
{
	struct lsa_QuerySecurity r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.sec_info = sec_info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QuerySecurity, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_QUERYSECURITY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QuerySecurity, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*sdbuf = *r.out.sdbuf;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_SetSecObj(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      struct policy_handle *handle /* [in] [ref] */,
			      uint32_t sec_info /* [in]  */,
			      struct sec_desc_buf *sdbuf /* [in] [ref] */)
{
	struct lsa_SetSecObj r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.sec_info = sec_info;
	r.in.sdbuf = sdbuf;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetSecObj, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_SETSECOBJ,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetSecObj, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_ChangePassword(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx)
{
	struct lsa_ChangePassword r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_ChangePassword, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CHANGEPASSWORD,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_ChangePassword, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_OpenPolicy(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       uint16_t *system_name /* [in] [unique] */,
			       struct lsa_ObjectAttribute *attr /* [in] [ref] */,
			       uint32_t access_mask /* [in]  */,
			       struct policy_handle *handle /* [out] [ref] */)
{
	struct lsa_OpenPolicy r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = system_name;
	r.in.attr = attr;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_OpenPolicy, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_OPENPOLICY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_OpenPolicy, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_QueryInfoPolicy(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *handle /* [in] [ref] */,
				    enum lsa_PolicyInfo level /* [in]  */,
				    union lsa_PolicyInformation **info /* [out] [ref,switch_is(level)] */)
{
	struct lsa_QueryInfoPolicy r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.level = level;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QueryInfoPolicy, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_QUERYINFOPOLICY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QueryInfoPolicy, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_SetInfoPolicy(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *handle /* [in] [ref] */,
				  enum lsa_PolicyInfo level /* [in]  */,
				  union lsa_PolicyInformation *info /* [in] [ref,switch_is(level)] */)
{
	struct lsa_SetInfoPolicy r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.level = level;
	r.in.info = info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetInfoPolicy, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_SETINFOPOLICY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetInfoPolicy, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_ClearAuditLog(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx)
{
	struct lsa_ClearAuditLog r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_ClearAuditLog, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CLEARAUDITLOG,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_ClearAuditLog, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_CreateAccount(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *handle /* [in] [ref] */,
				  struct dom_sid2 *sid /* [in] [ref] */,
				  uint32_t access_mask /* [in]  */,
				  struct policy_handle *acct_handle /* [out] [ref] */)
{
	struct lsa_CreateAccount r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.sid = sid;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CreateAccount, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREATEACCOUNT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CreateAccount, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*acct_handle = *r.out.acct_handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_EnumAccounts(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *handle /* [in] [ref] */,
				 uint32_t *resume_handle /* [in,out] [ref] */,
				 struct lsa_SidArray *sids /* [out] [ref] */,
				 uint32_t num_entries /* [in] [range(0,8192)] */)
{
	struct lsa_EnumAccounts r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.resume_handle = resume_handle;
	r.in.num_entries = num_entries;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumAccounts, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_ENUMACCOUNTS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumAccounts, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*resume_handle = *r.out.resume_handle;
	*sids = *r.out.sids;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_CreateTrustedDomain(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					struct policy_handle *policy_handle /* [in] [ref] */,
					struct lsa_DomainInfo *info /* [in] [ref] */,
					uint32_t access_mask /* [in]  */,
					struct policy_handle *trustdom_handle /* [out] [ref] */)
{
	struct lsa_CreateTrustedDomain r;
	NTSTATUS status;

	/* In parameters */
	r.in.policy_handle = policy_handle;
	r.in.info = info;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CreateTrustedDomain, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREATETRUSTEDDOMAIN,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CreateTrustedDomain, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*trustdom_handle = *r.out.trustdom_handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_EnumTrustDom(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *handle /* [in] [ref] */,
				 uint32_t *resume_handle /* [in,out] [ref] */,
				 struct lsa_DomainList *domains /* [out] [ref] */,
				 uint32_t max_size /* [in]  */)
{
	struct lsa_EnumTrustDom r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.resume_handle = resume_handle;
	r.in.max_size = max_size;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumTrustDom, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_ENUMTRUSTDOM,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumTrustDom, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*resume_handle = *r.out.resume_handle;
	*domains = *r.out.domains;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_LookupNames(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *handle /* [in] [ref] */,
				uint32_t num_names /* [in] [range(0,1000)] */,
				struct lsa_String *names /* [in] [size_is(num_names)] */,
				struct lsa_RefDomainList **domains /* [out] [ref] */,
				struct lsa_TransSidArray *sids /* [in,out] [ref] */,
				enum lsa_LookupNamesLevel level /* [in]  */,
				uint32_t *count /* [in,out] [ref] */)
{
	struct lsa_LookupNames r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.num_names = num_names;
	r.in.names = names;
	r.in.sids = sids;
	r.in.level = level;
	r.in.count = count;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupNames, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LOOKUPNAMES,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupNames, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*domains = *r.out.domains;
	*sids = *r.out.sids;
	*count = *r.out.count;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_LookupSids(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *handle /* [in] [ref] */,
			       struct lsa_SidArray *sids /* [in] [ref] */,
			       struct lsa_RefDomainList **domains /* [out] [ref] */,
			       struct lsa_TransNameArray *names /* [in,out] [ref] */,
			       uint16_t level /* [in]  */,
			       uint32_t *count /* [in,out] [ref] */)
{
	struct lsa_LookupSids r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.sids = sids;
	r.in.names = names;
	r.in.level = level;
	r.in.count = count;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupSids, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LOOKUPSIDS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupSids, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*domains = *r.out.domains;
	*names = *r.out.names;
	*count = *r.out.count;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_CreateSecret(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *handle /* [in] [ref] */,
				 struct lsa_String name /* [in]  */,
				 uint32_t access_mask /* [in]  */,
				 struct policy_handle *sec_handle /* [out] [ref] */)
{
	struct lsa_CreateSecret r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.name = name;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CreateSecret, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREATESECRET,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CreateSecret, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*sec_handle = *r.out.sec_handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_OpenAccount(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *handle /* [in] [ref] */,
				struct dom_sid2 *sid /* [in] [ref] */,
				uint32_t access_mask /* [in]  */,
				struct policy_handle *acct_handle /* [out] [ref] */)
{
	struct lsa_OpenAccount r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.sid = sid;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_OpenAccount, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_OPENACCOUNT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_OpenAccount, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*acct_handle = *r.out.acct_handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_EnumPrivsAccount(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *handle /* [in] [ref] */,
				     struct lsa_PrivilegeSet **privs /* [out] [ref] */)
{
	struct lsa_EnumPrivsAccount r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumPrivsAccount, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_ENUMPRIVSACCOUNT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumPrivsAccount, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*privs = *r.out.privs;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_AddPrivilegesToAccount(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *handle /* [in] [ref] */,
					   struct lsa_PrivilegeSet *privs /* [in] [ref] */)
{
	struct lsa_AddPrivilegesToAccount r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.privs = privs;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_AddPrivilegesToAccount, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_ADDPRIVILEGESTOACCOUNT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_AddPrivilegesToAccount, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_RemovePrivilegesFromAccount(struct rpc_pipe_client *cli,
						TALLOC_CTX *mem_ctx,
						struct policy_handle *handle /* [in] [ref] */,
						uint8_t remove_all /* [in]  */,
						struct lsa_PrivilegeSet *privs /* [in] [unique] */)
{
	struct lsa_RemovePrivilegesFromAccount r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.remove_all = remove_all;
	r.in.privs = privs;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_RemovePrivilegesFromAccount, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_REMOVEPRIVILEGESFROMACCOUNT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_RemovePrivilegesFromAccount, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_GetQuotasForAccount(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx)
{
	struct lsa_GetQuotasForAccount r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_GetQuotasForAccount, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_GETQUOTASFORACCOUNT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_GetQuotasForAccount, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_SetQuotasForAccount(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx)
{
	struct lsa_SetQuotasForAccount r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetQuotasForAccount, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_SETQUOTASFORACCOUNT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetQuotasForAccount, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_GetSystemAccessAccount(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *handle /* [in] [ref] */,
					   uint32_t *access_mask /* [out] [ref] */)
{
	struct lsa_GetSystemAccessAccount r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_GetSystemAccessAccount, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_GETSYSTEMACCESSACCOUNT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_GetSystemAccessAccount, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*access_mask = *r.out.access_mask;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_SetSystemAccessAccount(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *handle /* [in] [ref] */,
					   uint32_t access_mask /* [in]  */)
{
	struct lsa_SetSystemAccessAccount r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetSystemAccessAccount, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_SETSYSTEMACCESSACCOUNT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetSystemAccessAccount, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_OpenTrustedDomain(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *handle /* [in] [ref] */,
				      struct dom_sid2 *sid /* [in] [ref] */,
				      uint32_t access_mask /* [in]  */,
				      struct policy_handle *trustdom_handle /* [out] [ref] */)
{
	struct lsa_OpenTrustedDomain r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.sid = sid;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_OpenTrustedDomain, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_OPENTRUSTEDDOMAIN,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_OpenTrustedDomain, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*trustdom_handle = *r.out.trustdom_handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_QueryTrustedDomainInfo(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *trustdom_handle /* [in] [ref] */,
					   enum lsa_TrustDomInfoEnum level /* [in]  */,
					   union lsa_TrustedDomainInfo **info /* [out] [ref,switch_is(level)] */)
{
	struct lsa_QueryTrustedDomainInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.trustdom_handle = trustdom_handle;
	r.in.level = level;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QueryTrustedDomainInfo, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_QUERYTRUSTEDDOMAININFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QueryTrustedDomainInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_SetInformationTrustedDomain(struct rpc_pipe_client *cli,
						TALLOC_CTX *mem_ctx,
						struct policy_handle *trustdom_handle /* [in] [ref] */,
						enum lsa_TrustDomInfoEnum level /* [in]  */,
						union lsa_TrustedDomainInfo *info /* [in] [ref,switch_is(level)] */)
{
	struct lsa_SetInformationTrustedDomain r;
	NTSTATUS status;

	/* In parameters */
	r.in.trustdom_handle = trustdom_handle;
	r.in.level = level;
	r.in.info = info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetInformationTrustedDomain, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_SETINFORMATIONTRUSTEDDOMAIN,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetInformationTrustedDomain, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_OpenSecret(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *handle /* [in] [ref] */,
			       struct lsa_String name /* [in]  */,
			       uint32_t access_mask /* [in]  */,
			       struct policy_handle *sec_handle /* [out] [ref] */)
{
	struct lsa_OpenSecret r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.name = name;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_OpenSecret, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_OPENSECRET,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_OpenSecret, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*sec_handle = *r.out.sec_handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_SetSecret(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      struct policy_handle *sec_handle /* [in] [ref] */,
			      struct lsa_DATA_BUF *new_val /* [in] [unique] */,
			      struct lsa_DATA_BUF *old_val /* [in] [unique] */)
{
	struct lsa_SetSecret r;
	NTSTATUS status;

	/* In parameters */
	r.in.sec_handle = sec_handle;
	r.in.new_val = new_val;
	r.in.old_val = old_val;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetSecret, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_SETSECRET,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetSecret, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_QuerySecret(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *sec_handle /* [in] [ref] */,
				struct lsa_DATA_BUF_PTR *new_val /* [in,out] [unique] */,
				NTTIME *new_mtime /* [in,out] [unique] */,
				struct lsa_DATA_BUF_PTR *old_val /* [in,out] [unique] */,
				NTTIME *old_mtime /* [in,out] [unique] */)
{
	struct lsa_QuerySecret r;
	NTSTATUS status;

	/* In parameters */
	r.in.sec_handle = sec_handle;
	r.in.new_val = new_val;
	r.in.new_mtime = new_mtime;
	r.in.old_val = old_val;
	r.in.old_mtime = old_mtime;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QuerySecret, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_QUERYSECRET,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QuerySecret, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	if (new_val && r.out.new_val) {
		*new_val = *r.out.new_val;
	}
	if (new_mtime && r.out.new_mtime) {
		*new_mtime = *r.out.new_mtime;
	}
	if (old_val && r.out.old_val) {
		*old_val = *r.out.old_val;
	}
	if (old_mtime && r.out.old_mtime) {
		*old_mtime = *r.out.old_mtime;
	}

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_LookupPrivValue(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *handle /* [in] [ref] */,
				    struct lsa_String *name /* [in] [ref] */,
				    struct lsa_LUID *luid /* [out] [ref] */)
{
	struct lsa_LookupPrivValue r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.name = name;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupPrivValue, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LOOKUPPRIVVALUE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupPrivValue, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*luid = *r.out.luid;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_LookupPrivName(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *handle /* [in] [ref] */,
				   struct lsa_LUID *luid /* [in] [ref] */,
				   struct lsa_StringLarge **name /* [out] [ref] */)
{
	struct lsa_LookupPrivName r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.luid = luid;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupPrivName, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LOOKUPPRIVNAME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupPrivName, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*name = *r.out.name;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_LookupPrivDisplayName(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *handle /* [in] [ref] */,
					  struct lsa_String *name /* [in] [ref] */,
					  uint16_t language_id /* [in]  */,
					  uint16_t language_id_sys /* [in]  */,
					  struct lsa_StringLarge **disp_name /* [out] [ref] */,
					  uint16_t *returned_language_id /* [out] [ref] */)
{
	struct lsa_LookupPrivDisplayName r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.name = name;
	r.in.language_id = language_id;
	r.in.language_id_sys = language_id_sys;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupPrivDisplayName, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LOOKUPPRIVDISPLAYNAME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupPrivDisplayName, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*disp_name = *r.out.disp_name;
	*returned_language_id = *r.out.returned_language_id;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_DeleteObject(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *handle /* [in,out] [ref] */)
{
	struct lsa_DeleteObject r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_DeleteObject, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_DELETEOBJECT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_DeleteObject, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_EnumAccountsWithUserRight(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle *handle /* [in] [ref] */,
					      struct lsa_String *name /* [in] [unique] */,
					      struct lsa_SidArray *sids /* [out] [ref] */)
{
	struct lsa_EnumAccountsWithUserRight r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.name = name;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumAccountsWithUserRight, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_ENUMACCOUNTSWITHUSERRIGHT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumAccountsWithUserRight, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*sids = *r.out.sids;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_EnumAccountRights(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *handle /* [in] [ref] */,
				      struct dom_sid2 *sid /* [in] [ref] */,
				      struct lsa_RightSet *rights /* [out] [ref] */)
{
	struct lsa_EnumAccountRights r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.sid = sid;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumAccountRights, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_ENUMACCOUNTRIGHTS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumAccountRights, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*rights = *r.out.rights;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_AddAccountRights(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *handle /* [in] [ref] */,
				     struct dom_sid2 *sid /* [in] [ref] */,
				     struct lsa_RightSet *rights /* [in] [ref] */)
{
	struct lsa_AddAccountRights r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.sid = sid;
	r.in.rights = rights;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_AddAccountRights, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_ADDACCOUNTRIGHTS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_AddAccountRights, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_RemoveAccountRights(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					struct policy_handle *handle /* [in] [ref] */,
					struct dom_sid2 *sid /* [in] [ref] */,
					uint8_t remove_all /* [in]  */,
					struct lsa_RightSet *rights /* [in] [ref] */)
{
	struct lsa_RemoveAccountRights r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.sid = sid;
	r.in.remove_all = remove_all;
	r.in.rights = rights;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_RemoveAccountRights, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_REMOVEACCOUNTRIGHTS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_RemoveAccountRights, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_QueryTrustedDomainInfoBySid(struct rpc_pipe_client *cli,
						TALLOC_CTX *mem_ctx,
						struct policy_handle *handle /* [in] [ref] */,
						struct dom_sid2 *dom_sid /* [in] [ref] */,
						enum lsa_TrustDomInfoEnum level /* [in]  */,
						union lsa_TrustedDomainInfo **info /* [out] [ref,switch_is(level)] */)
{
	struct lsa_QueryTrustedDomainInfoBySid r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.dom_sid = dom_sid;
	r.in.level = level;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QueryTrustedDomainInfoBySid, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_QUERYTRUSTEDDOMAININFOBYSID,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QueryTrustedDomainInfoBySid, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_SetTrustedDomainInfo(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *handle /* [in] [ref] */,
					 struct dom_sid2 *dom_sid /* [in] [ref] */,
					 enum lsa_TrustDomInfoEnum level /* [in]  */,
					 union lsa_TrustedDomainInfo *info /* [in] [ref,switch_is(level)] */)
{
	struct lsa_SetTrustedDomainInfo r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.dom_sid = dom_sid;
	r.in.level = level;
	r.in.info = info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetTrustedDomainInfo, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_SETTRUSTEDDOMAININFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetTrustedDomainInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_DeleteTrustedDomain(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					struct policy_handle *handle /* [in] [ref] */,
					struct dom_sid2 *dom_sid /* [in] [ref] */)
{
	struct lsa_DeleteTrustedDomain r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.dom_sid = dom_sid;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_DeleteTrustedDomain, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_DELETETRUSTEDDOMAIN,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_DeleteTrustedDomain, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_StorePrivateData(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *handle /* [in] [ref] */,
				     struct lsa_String *name /* [in] [ref] */,
				     struct lsa_DATA_BUF *val /* [in] [unique] */)
{
	struct lsa_StorePrivateData r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.name = name;
	r.in.val = val;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_StorePrivateData, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_STOREPRIVATEDATA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_StorePrivateData, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_RetrievePrivateData(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					struct policy_handle *handle /* [in] [ref] */,
					struct lsa_String *name /* [in] [ref] */,
					struct lsa_DATA_BUF **val /* [in,out] [ref] */)
{
	struct lsa_RetrievePrivateData r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.name = name;
	r.in.val = val;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_RetrievePrivateData, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_RETRIEVEPRIVATEDATA,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_RetrievePrivateData, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*val = *r.out.val;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_OpenPolicy2(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				const char *system_name /* [in] [unique,charset(UTF16)] */,
				struct lsa_ObjectAttribute *attr /* [in] [ref] */,
				uint32_t access_mask /* [in]  */,
				struct policy_handle *handle /* [out] [ref] */)
{
	struct lsa_OpenPolicy2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = system_name;
	r.in.attr = attr;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_OpenPolicy2, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_OPENPOLICY2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_OpenPolicy2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_GetUserName(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				const char *system_name /* [in] [unique,charset(UTF16)] */,
				struct lsa_String **account_name /* [in,out] [ref] */,
				struct lsa_String **authority_name /* [in,out] [unique] */)
{
	struct lsa_GetUserName r;
	NTSTATUS status;

	/* In parameters */
	r.in.system_name = system_name;
	r.in.account_name = account_name;
	r.in.authority_name = authority_name;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_GetUserName, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_GETUSERNAME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_GetUserName, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*account_name = *r.out.account_name;
	if (authority_name && r.out.authority_name) {
		*authority_name = *r.out.authority_name;
	}

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_QueryInfoPolicy2(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *handle /* [in] [ref] */,
				     enum lsa_PolicyInfo level /* [in]  */,
				     union lsa_PolicyInformation **info /* [out] [ref,switch_is(level)] */)
{
	struct lsa_QueryInfoPolicy2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.level = level;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QueryInfoPolicy2, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_QUERYINFOPOLICY2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QueryInfoPolicy2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_SetInfoPolicy2(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *handle /* [in] [ref] */,
				   enum lsa_PolicyInfo level /* [in]  */,
				   union lsa_PolicyInformation *info /* [in] [ref,switch_is(level)] */)
{
	struct lsa_SetInfoPolicy2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.level = level;
	r.in.info = info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetInfoPolicy2, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_SETINFOPOLICY2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetInfoPolicy2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_QueryTrustedDomainInfoByName(struct rpc_pipe_client *cli,
						 TALLOC_CTX *mem_ctx,
						 struct policy_handle *handle /* [in] [ref] */,
						 struct lsa_String *trusted_domain /* [in] [ref] */,
						 enum lsa_TrustDomInfoEnum level /* [in]  */,
						 union lsa_TrustedDomainInfo **info /* [out] [ref,switch_is(level)] */)
{
	struct lsa_QueryTrustedDomainInfoByName r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.trusted_domain = trusted_domain;
	r.in.level = level;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QueryTrustedDomainInfoByName, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_QUERYTRUSTEDDOMAININFOBYNAME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QueryTrustedDomainInfoByName, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_SetTrustedDomainInfoByName(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle *handle /* [in] [ref] */,
					       struct lsa_String trusted_domain /* [in]  */,
					       enum lsa_TrustDomInfoEnum level /* [in]  */,
					       union lsa_TrustedDomainInfo *info /* [in] [unique,switch_is(level)] */)
{
	struct lsa_SetTrustedDomainInfoByName r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.trusted_domain = trusted_domain;
	r.in.level = level;
	r.in.info = info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetTrustedDomainInfoByName, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_SETTRUSTEDDOMAININFOBYNAME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetTrustedDomainInfoByName, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_EnumTrustedDomainsEx(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *handle /* [in] [ref] */,
					 uint32_t *resume_handle /* [in,out] [ref] */,
					 struct lsa_DomainListEx *domains /* [out] [ref] */,
					 uint32_t max_size /* [in]  */)
{
	struct lsa_EnumTrustedDomainsEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.resume_handle = resume_handle;
	r.in.max_size = max_size;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_EnumTrustedDomainsEx, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_ENUMTRUSTEDDOMAINSEX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_EnumTrustedDomainsEx, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*resume_handle = *r.out.resume_handle;
	*domains = *r.out.domains;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_CreateTrustedDomainEx(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *policy_handle /* [in] [ref] */,
					  struct lsa_TrustDomainInfoInfoEx *info /* [in] [ref] */,
					  struct lsa_TrustDomainInfoAuthInfoInternal *auth_info /* [in] [ref] */,
					  uint32_t access_mask /* [in]  */,
					  struct policy_handle *trustdom_handle /* [out] [ref] */)
{
	struct lsa_CreateTrustedDomainEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.policy_handle = policy_handle;
	r.in.info = info;
	r.in.auth_info = auth_info;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CreateTrustedDomainEx, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREATETRUSTEDDOMAINEX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CreateTrustedDomainEx, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*trustdom_handle = *r.out.trustdom_handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_CloseTrustedDomainEx(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *handle /* [in,out] [ref] */)
{
	struct lsa_CloseTrustedDomainEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CloseTrustedDomainEx, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CLOSETRUSTEDDOMAINEX,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CloseTrustedDomainEx, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*handle = *r.out.handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_QueryDomainInformationPolicy(struct rpc_pipe_client *cli,
						 TALLOC_CTX *mem_ctx,
						 struct policy_handle *handle /* [in] [ref] */,
						 uint16_t level /* [in]  */,
						 union lsa_DomainInformationPolicy **info /* [out] [ref,switch_is(level)] */)
{
	struct lsa_QueryDomainInformationPolicy r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.level = level;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_QueryDomainInformationPolicy, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_QUERYDOMAININFORMATIONPOLICY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_QueryDomainInformationPolicy, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*info = *r.out.info;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_SetDomainInformationPolicy(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle *handle /* [in] [ref] */,
					       uint16_t level /* [in]  */,
					       union lsa_DomainInformationPolicy *info /* [in] [unique,switch_is(level)] */)
{
	struct lsa_SetDomainInformationPolicy r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.level = level;
	r.in.info = info;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_SetDomainInformationPolicy, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_SETDOMAININFORMATIONPOLICY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_SetDomainInformationPolicy, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_OpenTrustedDomainByName(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *handle /* [in] [ref] */,
					    struct lsa_String name /* [in]  */,
					    uint32_t access_mask /* [in]  */,
					    struct policy_handle *trustdom_handle /* [out] [ref] */)
{
	struct lsa_OpenTrustedDomainByName r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.name = name;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_OpenTrustedDomainByName, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_OPENTRUSTEDDOMAINBYNAME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_OpenTrustedDomainByName, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*trustdom_handle = *r.out.trustdom_handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_TestCall(struct rpc_pipe_client *cli,
			     TALLOC_CTX *mem_ctx)
{
	struct lsa_TestCall r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_TestCall, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_TESTCALL,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_TestCall, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_LookupSids2(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *handle /* [in] [ref] */,
				struct lsa_SidArray *sids /* [in] [ref] */,
				struct lsa_RefDomainList **domains /* [out] [ref] */,
				struct lsa_TransNameArray2 *names /* [in,out] [ref] */,
				uint16_t level /* [in]  */,
				uint32_t *count /* [in,out] [ref] */,
				uint32_t unknown1 /* [in]  */,
				uint32_t unknown2 /* [in]  */)
{
	struct lsa_LookupSids2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.sids = sids;
	r.in.names = names;
	r.in.level = level;
	r.in.count = count;
	r.in.unknown1 = unknown1;
	r.in.unknown2 = unknown2;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupSids2, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LOOKUPSIDS2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupSids2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*domains = *r.out.domains;
	*names = *r.out.names;
	*count = *r.out.count;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_LookupNames2(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *handle /* [in] [ref] */,
				 uint32_t num_names /* [in] [range(0,1000)] */,
				 struct lsa_String *names /* [in] [size_is(num_names)] */,
				 struct lsa_RefDomainList **domains /* [out] [ref] */,
				 struct lsa_TransSidArray2 *sids /* [in,out] [ref] */,
				 enum lsa_LookupNamesLevel level /* [in]  */,
				 uint32_t *count /* [in,out] [ref] */,
				 uint32_t lookup_options /* [in]  */,
				 uint32_t client_revision /* [in]  */)
{
	struct lsa_LookupNames2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.num_names = num_names;
	r.in.names = names;
	r.in.sids = sids;
	r.in.level = level;
	r.in.count = count;
	r.in.lookup_options = lookup_options;
	r.in.client_revision = client_revision;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupNames2, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LOOKUPNAMES2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupNames2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*domains = *r.out.domains;
	*sids = *r.out.sids;
	*count = *r.out.count;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_CreateTrustedDomainEx2(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *policy_handle /* [in] [ref] */,
					   struct lsa_TrustDomainInfoInfoEx *info /* [in] [ref] */,
					   struct lsa_TrustDomainInfoAuthInfoInternal *auth_info /* [in] [ref] */,
					   uint32_t access_mask /* [in]  */,
					   struct policy_handle *trustdom_handle /* [out] [ref] */)
{
	struct lsa_CreateTrustedDomainEx2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.policy_handle = policy_handle;
	r.in.info = info;
	r.in.auth_info = auth_info;
	r.in.access_mask = access_mask;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CreateTrustedDomainEx2, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREATETRUSTEDDOMAINEX2,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CreateTrustedDomainEx2, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*trustdom_handle = *r.out.trustdom_handle;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_CREDRWRITE(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx)
{
	struct lsa_CREDRWRITE r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRWRITE, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREDRWRITE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRWRITE, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_CREDRREAD(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx)
{
	struct lsa_CREDRREAD r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRREAD, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREDRREAD,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRREAD, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_CREDRENUMERATE(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx)
{
	struct lsa_CREDRENUMERATE r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRENUMERATE, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREDRENUMERATE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRENUMERATE, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_CREDRWRITEDOMAINCREDENTIALS(struct rpc_pipe_client *cli,
						TALLOC_CTX *mem_ctx)
{
	struct lsa_CREDRWRITEDOMAINCREDENTIALS r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRWRITEDOMAINCREDENTIALS, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREDRWRITEDOMAINCREDENTIALS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRWRITEDOMAINCREDENTIALS, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_CREDRREADDOMAINCREDENTIALS(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx)
{
	struct lsa_CREDRREADDOMAINCREDENTIALS r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRREADDOMAINCREDENTIALS, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREDRREADDOMAINCREDENTIALS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRREADDOMAINCREDENTIALS, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_CREDRDELETE(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx)
{
	struct lsa_CREDRDELETE r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRDELETE, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREDRDELETE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRDELETE, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_CREDRGETTARGETINFO(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx)
{
	struct lsa_CREDRGETTARGETINFO r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRGETTARGETINFO, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREDRGETTARGETINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRGETTARGETINFO, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_CREDRPROFILELOADED(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx)
{
	struct lsa_CREDRPROFILELOADED r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRPROFILELOADED, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREDRPROFILELOADED,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRPROFILELOADED, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_LookupNames3(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *handle /* [in] [ref] */,
				 uint32_t num_names /* [in] [range(0,1000)] */,
				 struct lsa_String *names /* [in] [size_is(num_names)] */,
				 struct lsa_RefDomainList **domains /* [out] [ref] */,
				 struct lsa_TransSidArray3 *sids /* [in,out] [ref] */,
				 enum lsa_LookupNamesLevel level /* [in]  */,
				 uint32_t *count /* [in,out] [ref] */,
				 uint32_t lookup_options /* [in]  */,
				 uint32_t client_revision /* [in]  */)
{
	struct lsa_LookupNames3 r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.num_names = num_names;
	r.in.names = names;
	r.in.sids = sids;
	r.in.level = level;
	r.in.count = count;
	r.in.lookup_options = lookup_options;
	r.in.client_revision = client_revision;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupNames3, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LOOKUPNAMES3,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupNames3, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*domains = *r.out.domains;
	*sids = *r.out.sids;
	*count = *r.out.count;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_CREDRGETSESSIONTYPES(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx)
{
	struct lsa_CREDRGETSESSIONTYPES r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRGETSESSIONTYPES, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREDRGETSESSIONTYPES,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRGETSESSIONTYPES, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_LSARREGISTERAUDITEVENT(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx)
{
	struct lsa_LSARREGISTERAUDITEVENT r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARREGISTERAUDITEVENT, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LSARREGISTERAUDITEVENT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARREGISTERAUDITEVENT, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_LSARGENAUDITEVENT(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx)
{
	struct lsa_LSARGENAUDITEVENT r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARGENAUDITEVENT, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LSARGENAUDITEVENT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARGENAUDITEVENT, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_LSARUNREGISTERAUDITEVENT(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx)
{
	struct lsa_LSARUNREGISTERAUDITEVENT r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARUNREGISTERAUDITEVENT, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LSARUNREGISTERAUDITEVENT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARUNREGISTERAUDITEVENT, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_lsaRQueryForestTrustInformation(struct rpc_pipe_client *cli,
						    TALLOC_CTX *mem_ctx,
						    struct policy_handle *handle /* [in] [ref] */,
						    struct lsa_String *trusted_domain_name /* [in] [ref] */,
						    uint16_t unknown /* [in]  */,
						    struct lsa_ForestTrustInformation **forest_trust_info /* [out] [ref] */)
{
	struct lsa_lsaRQueryForestTrustInformation r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = handle;
	r.in.trusted_domain_name = trusted_domain_name;
	r.in.unknown = unknown;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_lsaRQueryForestTrustInformation, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LSARQUERYFORESTTRUSTINFORMATION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_lsaRQueryForestTrustInformation, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*forest_trust_info = *r.out.forest_trust_info;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_LSARSETFORESTTRUSTINFORMATION(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx)
{
	struct lsa_LSARSETFORESTTRUSTINFORMATION r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARSETFORESTTRUSTINFORMATION, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LSARSETFORESTTRUSTINFORMATION,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARSETFORESTTRUSTINFORMATION, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_CREDRRENAME(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx)
{
	struct lsa_CREDRRENAME r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_CREDRRENAME, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_CREDRRENAME,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_CREDRRENAME, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_LookupSids3(struct rpc_pipe_client *cli,
				TALLOC_CTX *mem_ctx,
				struct lsa_SidArray *sids /* [in] [ref] */,
				struct lsa_RefDomainList **domains /* [out] [ref] */,
				struct lsa_TransNameArray2 *names /* [in,out] [ref] */,
				uint16_t level /* [in]  */,
				uint32_t *count /* [in,out] [ref] */,
				uint32_t unknown1 /* [in]  */,
				uint32_t unknown2 /* [in]  */)
{
	struct lsa_LookupSids3 r;
	NTSTATUS status;

	/* In parameters */
	r.in.sids = sids;
	r.in.names = names;
	r.in.level = level;
	r.in.count = count;
	r.in.unknown1 = unknown1;
	r.in.unknown2 = unknown2;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupSids3, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LOOKUPSIDS3,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupSids3, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*domains = *r.out.domains;
	*names = *r.out.names;
	*count = *r.out.count;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_LookupNames4(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 uint32_t num_names /* [in] [range(0,1000)] */,
				 struct lsa_String *names /* [in] [size_is(num_names)] */,
				 struct lsa_RefDomainList **domains /* [out] [ref] */,
				 struct lsa_TransSidArray3 *sids /* [in,out] [ref] */,
				 enum lsa_LookupNamesLevel level /* [in]  */,
				 uint32_t *count /* [in,out] [ref] */,
				 uint32_t lookup_options /* [in]  */,
				 uint32_t client_revision /* [in]  */)
{
	struct lsa_LookupNames4 r;
	NTSTATUS status;

	/* In parameters */
	r.in.num_names = num_names;
	r.in.names = names;
	r.in.sids = sids;
	r.in.level = level;
	r.in.count = count;
	r.in.lookup_options = lookup_options;
	r.in.client_revision = client_revision;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LookupNames4, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LOOKUPNAMES4,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LookupNames4, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*domains = *r.out.domains;
	*sids = *r.out.sids;
	*count = *r.out.count;

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_LSAROPENPOLICYSCE(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx)
{
	struct lsa_LSAROPENPOLICYSCE r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSAROPENPOLICYSCE, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LSAROPENPOLICYSCE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSAROPENPOLICYSCE, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_LSARADTREGISTERSECURITYEVENTSOURCE(struct rpc_pipe_client *cli,
						       TALLOC_CTX *mem_ctx)
{
	struct lsa_LSARADTREGISTERSECURITYEVENTSOURCE r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARADTREGISTERSECURITYEVENTSOURCE, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LSARADTREGISTERSECURITYEVENTSOURCE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARADTREGISTERSECURITYEVENTSOURCE, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE(struct rpc_pipe_client *cli,
							 TALLOC_CTX *mem_ctx)
{
	struct lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LSARADTUNREGISTERSECURITYEVENTSOURCE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARADTUNREGISTERSECURITYEVENTSOURCE, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

NTSTATUS rpccli_lsa_LSARADTREPORTSECURITYEVENT(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx)
{
	struct lsa_LSARADTREPORTSECURITYEVENT r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(lsa_LSARADTREPORTSECURITYEVENT, &r);
	}

	status = cli->dispatch(cli,
				mem_ctx,
				&ndr_table_lsarpc,
				NDR_LSA_LSARADTREPORTSECURITYEVENT,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(lsa_LSARADTREPORTSECURITYEVENT, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	return r.out.result;
}

