/* server functions auto-generated by pidl */
#include "../librpc/gen_ndr/ndr_dsbackup.h"

/* ad_backup - dcerpc server boilerplate generated by pidl */


static NTSTATUS ad_backup__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_AD_BACKUP_BIND
	return DCESRV_INTERFACE_AD_BACKUP_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void ad_backup__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_AD_BACKUP_UNBIND
	DCESRV_INTERFACE_AD_BACKUP_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS ad_backup__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_ad_backup.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx,
			  ndr_table_ad_backup.calls[opnum].struct_size,
			  "struct %s",
			  ndr_table_ad_backup.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	ndr_err = ndr_table_ad_backup.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir, 
				  &ndr_table_ad_backup, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS ad_backup__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct HrRBackupPrepare *r2 = (struct HrRBackupPrepare *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(HrRBackupPrepare, NDR_IN, r2);
		}
		dcesrv_HrRBackupPrepare(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRBackupPrepare will reply async\n"));
		}
		break;
	}
	case 1: {
		struct HrRBackupEnd *r2 = (struct HrRBackupEnd *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(HrRBackupEnd, NDR_IN, r2);
		}
		dcesrv_HrRBackupEnd(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRBackupEnd will reply async\n"));
		}
		break;
	}
	case 2: {
		struct HrRBackupGetAttachmentInformation *r2 = (struct HrRBackupGetAttachmentInformation *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(HrRBackupGetAttachmentInformation, NDR_IN, r2);
		}
		dcesrv_HrRBackupGetAttachmentInformation(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRBackupGetAttachmentInformation will reply async\n"));
		}
		break;
	}
	case 3: {
		struct HrRBackupOpenFile *r2 = (struct HrRBackupOpenFile *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(HrRBackupOpenFile, NDR_IN, r2);
		}
		dcesrv_HrRBackupOpenFile(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRBackupOpenFile will reply async\n"));
		}
		break;
	}
	case 4: {
		struct HrRBackupRead *r2 = (struct HrRBackupRead *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(HrRBackupRead, NDR_IN, r2);
		}
		dcesrv_HrRBackupRead(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRBackupRead will reply async\n"));
		}
		break;
	}
	case 5: {
		struct HrRBackupClose *r2 = (struct HrRBackupClose *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(HrRBackupClose, NDR_IN, r2);
		}
		dcesrv_HrRBackupClose(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRBackupClose will reply async\n"));
		}
		break;
	}
	case 6: {
		struct HrRBackupGetBackupLogs *r2 = (struct HrRBackupGetBackupLogs *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(HrRBackupGetBackupLogs, NDR_IN, r2);
		}
		dcesrv_HrRBackupGetBackupLogs(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRBackupGetBackupLogs will reply async\n"));
		}
		break;
	}
	case 7: {
		struct HrRBackupTruncateLogs *r2 = (struct HrRBackupTruncateLogs *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(HrRBackupTruncateLogs, NDR_IN, r2);
		}
		dcesrv_HrRBackupTruncateLogs(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRBackupTruncateLogs will reply async\n"));
		}
		break;
	}
	case 8: {
		struct HrRBackupPing *r2 = (struct HrRBackupPing *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(HrRBackupPing, NDR_IN, r2);
		}
		dcesrv_HrRBackupPing(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRBackupPing will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir, 
		          &ndr_table_ad_backup, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS ad_backup__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct HrRBackupPrepare *r2 = (struct HrRBackupPrepare *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRBackupPrepare replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(HrRBackupPrepare, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in HrRBackupPrepare\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct HrRBackupEnd *r2 = (struct HrRBackupEnd *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRBackupEnd replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(HrRBackupEnd, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in HrRBackupEnd\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct HrRBackupGetAttachmentInformation *r2 = (struct HrRBackupGetAttachmentInformation *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRBackupGetAttachmentInformation replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(HrRBackupGetAttachmentInformation, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in HrRBackupGetAttachmentInformation\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct HrRBackupOpenFile *r2 = (struct HrRBackupOpenFile *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRBackupOpenFile replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(HrRBackupOpenFile, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in HrRBackupOpenFile\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct HrRBackupRead *r2 = (struct HrRBackupRead *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRBackupRead replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(HrRBackupRead, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in HrRBackupRead\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 5: {
		struct HrRBackupClose *r2 = (struct HrRBackupClose *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRBackupClose replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(HrRBackupClose, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in HrRBackupClose\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 6: {
		struct HrRBackupGetBackupLogs *r2 = (struct HrRBackupGetBackupLogs *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRBackupGetBackupLogs replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(HrRBackupGetBackupLogs, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in HrRBackupGetBackupLogs\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 7: {
		struct HrRBackupTruncateLogs *r2 = (struct HrRBackupTruncateLogs *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRBackupTruncateLogs replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(HrRBackupTruncateLogs, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in HrRBackupTruncateLogs\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 8: {
		struct HrRBackupPing *r2 = (struct HrRBackupPing *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRBackupPing replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(HrRBackupPing, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in HrRBackupPing\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir,
		          &ndr_table_ad_backup, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS ad_backup__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_ad_backup.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

const struct dcesrv_interface dcesrv_ad_backup_interface = {
	.name		= "ad_backup",
	.syntax_id  = {{0xecec0d70,0xa603,0x11d0,{0x96,0xb1},{0x00,0xa0,0xc9,0x1e,0xce,0x30}},1.0},
	.bind		= ad_backup__op_bind,
	.unbind		= ad_backup__op_unbind,
	.ndr_pull	= ad_backup__op_ndr_pull,
	.dispatch	= ad_backup__op_dispatch,
	.reply		= ad_backup__op_reply,
	.ndr_push	= ad_backup__op_ndr_push
};


static NTSTATUS ad_backup__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<ndr_table_ad_backup.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = ndr_table_ad_backup.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &dcesrv_ad_backup_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("ad_backup_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static bool ad_backup__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_ad_backup_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_ad_backup_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_ad_backup_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool ad_backup__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_ad_backup_interface.name, name)==0) {
		memcpy(iface, &dcesrv_ad_backup_interface, sizeof(*iface));
		return true;
	}

	return false;	
}
	
NTSTATUS dcerpc_server_ad_backup_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "ad_backup";

	/* fill in all the operations */
	ep_server.init_server = ad_backup__op_init_server;

	ep_server.interface_by_uuid = ad_backup__op_interface_by_uuid;
	ep_server.interface_by_name = ad_backup__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'ad_backup' endpoint server!\n"));
		return ret;
	}

	return ret;
}

/* ad_restore - dcerpc server boilerplate generated by pidl */


static NTSTATUS ad_restore__op_bind(struct dcesrv_call_state *dce_call, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_AD_RESTORE_BIND
	return DCESRV_INTERFACE_AD_RESTORE_BIND(dce_call,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void ad_restore__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_AD_RESTORE_UNBIND
	DCESRV_INTERFACE_AD_RESTORE_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS ad_restore__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_ad_restore.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx,
			  ndr_table_ad_restore.calls[opnum].struct_size,
			  "struct %s",
			  ndr_table_ad_restore.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	ndr_err = ndr_table_ad_restore.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir, 
				  &ndr_table_ad_restore, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS ad_restore__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct HrRIsNTDSOnline *r2 = (struct HrRIsNTDSOnline *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(HrRIsNTDSOnline, NDR_IN, r2);
		}
		dcesrv_HrRIsNTDSOnline(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRIsNTDSOnline will reply async\n"));
		}
		break;
	}
	case 1: {
		struct HrRRestorePrepare *r2 = (struct HrRRestorePrepare *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(HrRRestorePrepare, NDR_IN, r2);
		}
		dcesrv_HrRRestorePrepare(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRRestorePrepare will reply async\n"));
		}
		break;
	}
	case 2: {
		struct HrRRestoreRegister *r2 = (struct HrRRestoreRegister *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(HrRRestoreRegister, NDR_IN, r2);
		}
		dcesrv_HrRRestoreRegister(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRRestoreRegister will reply async\n"));
		}
		break;
	}
	case 3: {
		struct HrRRestoreRegisterComplete *r2 = (struct HrRRestoreRegisterComplete *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(HrRRestoreRegisterComplete, NDR_IN, r2);
		}
		dcesrv_HrRRestoreRegisterComplete(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRRestoreRegisterComplete will reply async\n"));
		}
		break;
	}
	case 4: {
		struct HrRRestoreGetDatabaseLocations *r2 = (struct HrRRestoreGetDatabaseLocations *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(HrRRestoreGetDatabaseLocations, NDR_IN, r2);
		}
		dcesrv_HrRRestoreGetDatabaseLocations(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRRestoreGetDatabaseLocations will reply async\n"));
		}
		break;
	}
	case 5: {
		struct HrRRestoreEnd *r2 = (struct HrRRestoreEnd *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(HrRRestoreEnd, NDR_IN, r2);
		}
		dcesrv_HrRRestoreEnd(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRRestoreEnd will reply async\n"));
		}
		break;
	}
	case 6: {
		struct HrRRestoreSetCurrentLogNumber *r2 = (struct HrRRestoreSetCurrentLogNumber *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(HrRRestoreSetCurrentLogNumber, NDR_IN, r2);
		}
		dcesrv_HrRRestoreSetCurrentLogNumber(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRRestoreSetCurrentLogNumber will reply async\n"));
		}
		break;
	}
	case 7: {
		struct HrRRestoreCheckLogsForBackup *r2 = (struct HrRRestoreCheckLogsForBackup *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(HrRRestoreCheckLogsForBackup, NDR_IN, r2);
		}
		dcesrv_HrRRestoreCheckLogsForBackup(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRRestoreCheckLogsForBackup will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir, 
		          &ndr_table_ad_restore, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS ad_restore__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct HrRIsNTDSOnline *r2 = (struct HrRIsNTDSOnline *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRIsNTDSOnline replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(HrRIsNTDSOnline, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in HrRIsNTDSOnline\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct HrRRestorePrepare *r2 = (struct HrRRestorePrepare *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRRestorePrepare replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(HrRRestorePrepare, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in HrRRestorePrepare\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct HrRRestoreRegister *r2 = (struct HrRRestoreRegister *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRRestoreRegister replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(HrRRestoreRegister, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in HrRRestoreRegister\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct HrRRestoreRegisterComplete *r2 = (struct HrRRestoreRegisterComplete *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRRestoreRegisterComplete replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(HrRRestoreRegisterComplete, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in HrRRestoreRegisterComplete\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct HrRRestoreGetDatabaseLocations *r2 = (struct HrRRestoreGetDatabaseLocations *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRRestoreGetDatabaseLocations replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(HrRRestoreGetDatabaseLocations, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in HrRRestoreGetDatabaseLocations\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 5: {
		struct HrRRestoreEnd *r2 = (struct HrRRestoreEnd *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRRestoreEnd replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(HrRRestoreEnd, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in HrRRestoreEnd\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 6: {
		struct HrRRestoreSetCurrentLogNumber *r2 = (struct HrRRestoreSetCurrentLogNumber *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRRestoreSetCurrentLogNumber replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(HrRRestoreSetCurrentLogNumber, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in HrRRestoreSetCurrentLogNumber\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 7: {
		struct HrRRestoreCheckLogsForBackup *r2 = (struct HrRRestoreCheckLogsForBackup *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function HrRRestoreCheckLogsForBackup replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(HrRRestoreCheckLogsForBackup, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in HrRRestoreCheckLogsForBackup\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		dcerpc_log_packet(dce_call->conn->packet_log_dir,
		          &ndr_table_ad_restore, opnum, NDR_IN,
				  &dce_call->pkt.u.request.stub_and_verifier);
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS ad_restore__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_ad_restore.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

const struct dcesrv_interface dcesrv_ad_restore_interface = {
	.name		= "ad_restore",
	.syntax_id  = {{0x16e0cf3a,0xa604,0x11d0,{0x96,0xb1},{0x00,0xa0,0xc9,0x1e,0xce,0x30}},1.0},
	.bind		= ad_restore__op_bind,
	.unbind		= ad_restore__op_unbind,
	.ndr_pull	= ad_restore__op_ndr_pull,
	.dispatch	= ad_restore__op_dispatch,
	.reply		= ad_restore__op_reply,
	.ndr_push	= ad_restore__op_ndr_push
};


static NTSTATUS ad_restore__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;

	for (i=0;i<ndr_table_ad_restore.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = ndr_table_ad_restore.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, &dcesrv_ad_restore_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("ad_restore_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static bool ad_restore__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_ad_restore_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_ad_restore_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_ad_restore_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool ad_restore__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_ad_restore_interface.name, name)==0) {
		memcpy(iface, &dcesrv_ad_restore_interface, sizeof(*iface));
		return true;
	}

	return false;	
}
	
NTSTATUS dcerpc_server_ad_restore_init(void)
{
	NTSTATUS ret;
	struct dcesrv_endpoint_server ep_server;

	/* fill in our name */
	ep_server.name = "ad_restore";

	/* fill in all the operations */
	ep_server.init_server = ad_restore__op_init_server;

	ep_server.interface_by_uuid = ad_restore__op_interface_by_uuid;
	ep_server.interface_by_name = ad_restore__op_interface_by_name;

	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'ad_restore' endpoint server!\n"));
		return ret;
	}

	return ret;
}

