/* header auto-generated by pidl */

#include <stdint.h>

#include "librpc/gen_ndr/lsa.h"
#include "librpc/gen_ndr/security.h"
#ifndef _HEADER_eventlog
#define _HEADER_eventlog

/* bitmap eventlogReadFlags */
#define EVENTLOG_SEQUENTIAL_READ ( 0x0001 )
#define EVENTLOG_SEEK_READ ( 0x0002 )
#define EVENTLOG_FORWARDS_READ ( 0x0004 )
#define EVENTLOG_BACKWARDS_READ ( 0x0008 )

enum eventlogEventTypes
#ifndef USE_UINT_ENUMS
 {
	EVENTLOG_SUCCESS=0x0000,
	EVENTLOG_ERROR_TYPE=0x0001,
	EVENTLOG_WARNING_TYPE=0x0002,
	EVENTLOG_INFORMATION_TYPE=0x0004,
	EVENTLOG_AUDIT_SUCCESS=0x0008,
	EVENTLOG_AUDIT_FAILURE=0x0010
}
#else
 { __donnot_use_enum_eventlogEventTypes=0x7FFFFFFF}
#define EVENTLOG_SUCCESS ( 0x0000 )
#define EVENTLOG_ERROR_TYPE ( 0x0001 )
#define EVENTLOG_WARNING_TYPE ( 0x0002 )
#define EVENTLOG_INFORMATION_TYPE ( 0x0004 )
#define EVENTLOG_AUDIT_SUCCESS ( 0x0008 )
#define EVENTLOG_AUDIT_FAILURE ( 0x0010 )
#endif
;

struct eventlog_OpenUnknown0 {
	uint16_t unknown0;
	uint16_t unknown1;
};

struct eventlog_Record {
	uint32_t size;
	const char *reserved;/* [value("eLfL"),charset(DOS)] */
	uint32_t record_number;
	time_t time_generated;
	time_t time_written;
	uint32_t event_id;
	enum eventlogEventTypes event_type;
	uint16_t num_of_strings;/* [range(0,256)] */
	uint16_t event_category;
	uint16_t reserved_flags;
	uint32_t closing_record_number;
	uint32_t stringoffset;
	uint32_t sid_size;/* [value(ndr_size_dom_sid0(&sid,ndr->flags))] */
	uint32_t sid_offset;
	uint32_t data_length;
	uint32_t data_offset;
	const char * source_name;/* [flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * computer_name;/* [flag(LIBNDR_FLAG_STR_NULLTERM)] */
	struct dom_sid0 sid;/* [subcontext_size(sid_size),subcontext(0)] */
	const char * *strings;/* [flag(LIBNDR_FLAG_STR_NULLTERM)] */
	const char * raw_data;/* [flag(LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM)] */
	DATA_BLOB _padding;/* [flag(LIBNDR_FLAG_ALIGN4)] */
	uint32_t size2;/* [value(size)] */
}/* [public,flag(LIBNDR_FLAG_NOALIGN)] */;


struct eventlog_ClearEventLogW {
	struct {
		struct policy_handle *handle;/* [ref] */
		struct lsa_String *backupfile;/* [unique] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};


struct eventlog_BackupEventLogW {
	struct {
		NTSTATUS result;
	} out;

};


struct eventlog_CloseEventLog {
	struct {
		struct policy_handle *handle;/* [ref] */
	} in;

	struct {
		struct policy_handle *handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct eventlog_DeregisterEventSource {
	struct {
		NTSTATUS result;
	} out;

};


struct eventlog_GetNumRecords {
	struct {
		struct policy_handle *handle;/* [ref] */
	} in;

	struct {
		uint32_t *number;/* [ref] */
		NTSTATUS result;
	} out;

};


struct eventlog_GetOldestRecord {
	struct {
		struct policy_handle *handle;/* [ref] */
	} in;

	struct {
		uint32_t *oldest_entry;/* [ref] */
		NTSTATUS result;
	} out;

};


struct eventlog_ChangeNotify {
	struct {
		NTSTATUS result;
	} out;

};


struct eventlog_OpenEventLogW {
	struct {
		struct eventlog_OpenUnknown0 *unknown0;/* [unique] */
		struct lsa_String *logname;/* [ref] */
		struct lsa_String *servername;/* [ref] */
		uint32_t major_version;
		uint32_t minor_version;
	} in;

	struct {
		struct policy_handle *handle;/* [ref] */
		NTSTATUS result;
	} out;

};


struct eventlog_RegisterEventSourceW {
	struct {
		NTSTATUS result;
	} out;

};


struct eventlog_OpenBackupEventLogW {
	struct {
		NTSTATUS result;
	} out;

};


struct eventlog_ReadEventLogW {
	struct {
		struct policy_handle *handle;/* [ref] */
		uint32_t flags;
		uint32_t offset;
		uint32_t number_of_bytes;/* [range(0,0x7FFFF)] */
	} in;

	struct {
		uint8_t *data;/* [ref,size_is(number_of_bytes)] */
		uint32_t *sent_size;/* [ref] */
		uint32_t *real_size;/* [ref] */
		NTSTATUS result;
	} out;

};


struct eventlog_ReportEventW {
	struct {
		NTSTATUS result;
	} out;

};


struct eventlog_ClearEventLogA {
	struct {
		NTSTATUS result;
	} out;

};


struct eventlog_BackupEventLogA {
	struct {
		NTSTATUS result;
	} out;

};


struct eventlog_OpenEventLogA {
	struct {
		NTSTATUS result;
	} out;

};


struct eventlog_RegisterEventSourceA {
	struct {
		NTSTATUS result;
	} out;

};


struct eventlog_OpenBackupEventLogA {
	struct {
		NTSTATUS result;
	} out;

};


struct eventlog_ReadEventLogA {
	struct {
		NTSTATUS result;
	} out;

};


struct eventlog_ReportEventA {
	struct {
		NTSTATUS result;
	} out;

};


struct eventlog_RegisterClusterSvc {
	struct {
		NTSTATUS result;
	} out;

};


struct eventlog_DeregisterClusterSvc {
	struct {
		NTSTATUS result;
	} out;

};


struct eventlog_WriteClusterEvents {
	struct {
		NTSTATUS result;
	} out;

};


struct eventlog_GetLogIntormation {
	struct {
		NTSTATUS result;
	} out;

};


struct eventlog_FlushEventLog {
	struct {
		struct policy_handle *handle;/* [ref] */
	} in;

	struct {
		NTSTATUS result;
	} out;

};

#endif /* _HEADER_eventlog */
