#include "../librpc/gen_ndr/ndr_frsapi.h"
#ifndef __CLI_FRSAPI__
#define __CLI_FRSAPI__
NTSTATUS rpccli_FRSAPI_VERIFY_PROMOTION(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx);
NTSTATUS rpccli_FRSAPI_PROMOTION_STATUS(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx);
NTSTATUS rpccli_FRSAPI_START_DEMOTION(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx);
NTSTATUS rpccli_FRSAPI_COMMIT_DEMOTION(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx);
NTSTATUS rpccli_frsapi_SetDsPollingIntervalW(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     uint32_t CurrentInterval /* [in]  */,
					     uint32_t DsPollingLongInterval /* [in]  */,
					     uint32_t DsPollingShortInterval /* [in]  */,
					     WERROR *werror);
NTSTATUS rpccli_frsapi_GetDsPollingIntervalW(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     uint32_t *CurrentInterval /* [out] [ref] */,
					     uint32_t *DsPollingLongInterval /* [out] [ref] */,
					     uint32_t *DsPollingShortInterval /* [out] [ref] */,
					     WERROR *werror);
NTSTATUS rpccli_FRSAPI_VERIFY_PROMOTION_W(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx);
NTSTATUS rpccli_frsapi_InfoW(struct rpc_pipe_client *cli,
			     TALLOC_CTX *mem_ctx,
			     uint32_t length /* [in] [range(0,0x10000)] */,
			     struct frsapi_Info *info /* [in,out] [unique] */,
			     WERROR *werror);
NTSTATUS rpccli_frsapi_IsPathReplicated(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *path /* [in] [unique,charset(UTF16)] */,
					enum frsapi_ReplicaSetType replica_set_type /* [in]  */,
					uint32_t *unknown1 /* [out] [ref] */,
					uint32_t *unknown2 /* [out] [ref] */,
					uint32_t *unknown3 /* [out] [ref] */,
					struct GUID *replica_set_guid /* [out] [ref] */,
					WERROR *werror);
NTSTATUS rpccli_FRSAPI_WRITER_COMMAND(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx);
NTSTATUS rpccli_frsapi_ForceReplication(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					struct GUID *guid1 /* [in] [unique] */,
					struct GUID *guid2 /* [in] [unique] */,
					const char *replica_set /* [in] [unique,charset(UTF16)] */,
					const char *partner_name /* [in] [unique,charset(UTF16)] */,
					WERROR *werror);
#endif /* __CLI_FRSAPI__ */
