/*
 * Unix SMB/CIFS implementation.
 * client auto-generated by pidl. DO NOT MODIFY!
 */

#include "includes.h"
#include "../librpc/gen_ndr/cli_efs.h"

NTSTATUS rpccli_EfsRpcOpenFileRaw(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *pvContext /* [out] [ref] */,
				  const char *FileName /* [in] [charset(UTF16)] */,
				  uint32_t Flags /* [in]  */,
				  WERROR *werror)
{
	struct EfsRpcOpenFileRaw r;
	NTSTATUS status;

	/* In parameters */
	r.in.FileName = FileName;
	r.in.Flags = Flags;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcOpenFileRaw, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCOPENFILERAW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcOpenFileRaw, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*pvContext = *r.out.pvContext;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_EfsRpcReadFileRaw(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *pvContext /* [in] [ref] */,
				  WERROR *werror)
{
	struct EfsRpcReadFileRaw r;
	NTSTATUS status;

	/* In parameters */
	r.in.pvContext = pvContext;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcReadFileRaw, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCREADFILERAW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcReadFileRaw, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_EfsRpcWriteFileRaw(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *pvContext /* [in] [ref] */,
				   WERROR *werror)
{
	struct EfsRpcWriteFileRaw r;
	NTSTATUS status;

	/* In parameters */
	r.in.pvContext = pvContext;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcWriteFileRaw, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCWRITEFILERAW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcWriteFileRaw, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_EfsRpcCloseRaw(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *pvContext /* [in,out] [ref] */)
{
	struct EfsRpcCloseRaw r;
	NTSTATUS status;

	/* In parameters */
	r.in.pvContext = pvContext;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcCloseRaw, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCCLOSERAW,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcCloseRaw, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*pvContext = *r.out.pvContext;

	/* Return result */
	return NT_STATUS_OK;
}

NTSTATUS rpccli_EfsRpcEncryptFileSrv(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *Filename /* [in] [charset(UTF16)] */,
				     WERROR *werror)
{
	struct EfsRpcEncryptFileSrv r;
	NTSTATUS status;

	/* In parameters */
	r.in.Filename = Filename;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcEncryptFileSrv, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCENCRYPTFILESRV,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcEncryptFileSrv, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_EfsRpcDecryptFileSrv(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *FileName /* [in] [charset(UTF16)] */,
				     uint32_t Reserved /* [in]  */,
				     WERROR *werror)
{
	struct EfsRpcDecryptFileSrv r;
	NTSTATUS status;

	/* In parameters */
	r.in.FileName = FileName;
	r.in.Reserved = Reserved;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcDecryptFileSrv, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCDECRYPTFILESRV,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcDecryptFileSrv, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_EfsRpcQueryUsersOnFile(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *FileName /* [in] [charset(UTF16)] */,
				       struct ENCRYPTION_CERTIFICATE_HASH_LIST **pUsers /* [out] [unique,ref] */,
				       WERROR *werror)
{
	struct EfsRpcQueryUsersOnFile r;
	NTSTATUS status;

	/* In parameters */
	r.in.FileName = FileName;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcQueryUsersOnFile, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCQUERYUSERSONFILE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcQueryUsersOnFile, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*pUsers = *r.out.pUsers;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_EfsRpcQueryRecoveryAgents(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  const char *FileName /* [in] [charset(UTF16)] */,
					  struct ENCRYPTION_CERTIFICATE_HASH_LIST **pRecoveryAgents /* [out] [unique,ref] */,
					  WERROR *werror)
{
	struct EfsRpcQueryRecoveryAgents r;
	NTSTATUS status;

	/* In parameters */
	r.in.FileName = FileName;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcQueryRecoveryAgents, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCQUERYRECOVERYAGENTS,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcQueryRecoveryAgents, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */
	*pRecoveryAgents = *r.out.pRecoveryAgents;

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_EfsRpcRemoveUsersFromFile(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  const char *FileName /* [in] [charset(UTF16)] */,
					  WERROR *werror)
{
	struct EfsRpcRemoveUsersFromFile r;
	NTSTATUS status;

	/* In parameters */
	r.in.FileName = FileName;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcRemoveUsersFromFile, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCREMOVEUSERSFROMFILE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcRemoveUsersFromFile, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_EfsRpcAddUsersToFile(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *FileName /* [in] [charset(UTF16)] */,
				     WERROR *werror)
{
	struct EfsRpcAddUsersToFile r;
	NTSTATUS status;

	/* In parameters */
	r.in.FileName = FileName;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcAddUsersToFile, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCADDUSERSTOFILE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcAddUsersToFile, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_EfsRpcSetFileEncryptionKey(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   struct ENCRYPTION_CERTIFICATE *pEncryptionCertificate /* [in] [unique] */,
					   WERROR *werror)
{
	struct EfsRpcSetFileEncryptionKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.pEncryptionCertificate = pEncryptionCertificate;

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcSetFileEncryptionKey, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCSETFILEENCRYPTIONKEY,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcSetFileEncryptionKey, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_EfsRpcNotSupported(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   WERROR *werror)
{
	struct EfsRpcNotSupported r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcNotSupported, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCNOTSUPPORTED,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcNotSupported, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_EfsRpcFileKeyInfo(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  WERROR *werror)
{
	struct EfsRpcFileKeyInfo r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcFileKeyInfo, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCFILEKEYINFO,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcFileKeyInfo, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

NTSTATUS rpccli_EfsRpcDuplicateEncryptionInfoFile(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx,
						  WERROR *werror)
{
	struct EfsRpcDuplicateEncryptionInfoFile r;
	NTSTATUS status;

	/* In parameters */

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_IN_DEBUG(EfsRpcDuplicateEncryptionInfoFile, &r);
	}

	status = cli_do_rpc_ndr(cli,
				mem_ctx,
				&ndr_table_efs,
				NDR_EFSRPCDUPLICATEENCRYPTIONINFOFILE,
				&r);

	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	if (DEBUGLEVEL >= 10) {
		NDR_PRINT_OUT_DEBUG(EfsRpcDuplicateEncryptionInfoFile, &r);
	}

	if (NT_STATUS_IS_ERR(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	if (werror) {
		*werror = r.out.result;
	}

	return werror_to_ntstatus(r.out.result);
}

