#include "../librpc/gen_ndr/ndr_atsvc.h"
#ifndef __CLI_ATSVC__
#define __CLI_ATSVC__
NTSTATUS rpccli_atsvc_JobAdd(struct rpc_pipe_client *cli,
			     TALLOC_CTX *mem_ctx,
			     const char *servername /* [in] [unique,charset(UTF16)] */,
			     struct atsvc_JobInfo *job_info /* [in] [ref] */,
			     uint32_t *job_id /* [out] [ref] */);
NTSTATUS rpccli_atsvc_JobDel(struct rpc_pipe_client *cli,
			     TALLOC_CTX *mem_ctx,
			     const char *servername /* [in] [unique,charset(UTF16)] */,
			     uint32_t min_job_id /* [in]  */,
			     uint32_t max_job_id /* [in]  */);
NTSTATUS rpccli_atsvc_JobEnum(struct rpc_pipe_client *cli,
			      TALLOC_CTX *mem_ctx,
			      const char *servername /* [in] [unique,charset(UTF16)] */,
			      struct atsvc_enum_ctr *ctr /* [in,out] [ref] */,
			      uint32_t preferred_max_len /* [in]  */,
			      uint32_t *total_entries /* [out] [ref] */,
			      uint32_t *resume_handle /* [in,out] [unique] */);
NTSTATUS rpccli_atsvc_JobGetInfo(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 const char *servername /* [in] [unique,charset(UTF16)] */,
				 uint32_t job_id /* [in]  */,
				 struct atsvc_JobInfo **job_info /* [out] [ref] */);
#endif /* __CLI_ATSVC__ */
