/* 
   Unix SMB/CIFS implementation.
   Python bindings for COM library.
   Copyright (C) Jelmer Vernooij <jelmer@samba.org> 2008
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <Python.h>
#include "includes.h"
#include "lib/com/com.h"
#include "librpc/ndr/libndr.h"
#include "libcli/util/pyerrors.h"

static struct com_context *py_com_ctx = NULL; /* FIXME: evil global */

static PyObject *py_get_class_object(PyObject *self, PyObject *args)
{
	char *s_clsid, *s_iid;
	struct GUID clsid, iid;
	struct IUnknown *object;
	NTSTATUS status;
	WERROR error;

	if (!PyArg_ParseTuple(args, "ss", &s_clsid, &s_iid))
		return NULL;

	status = GUID_from_string(s_clsid, &clsid);
	if (!NT_STATUS_IS_OK(status)) {
		PyErr_FromNTSTATUS(status);
		return NULL;
	}

	status = GUID_from_string(s_iid, &iid);
	if (!NT_STATUS_IS_OK(status)) {
		PyErr_FromNTSTATUS(status);
		return NULL;
	}

	error = com_get_class_object(py_com_ctx, &clsid, &iid, &object);
	if (!W_ERROR_IS_OK(error)) {
		PyErr_FromWERROR(error);
		return NULL;
	}
	
	/* FIXME: Magic, integrate with stubs generated by pidl. */

	Py_RETURN_NONE;
}

static struct PyMethodDef com_methods[] = {
	{ "get_class_object", (PyCFunction)py_get_class_object, METH_VARARGS, "S.get_class_object(clsid, iid) -> instance" },
	{ NULL },
};

void initcom(void)
{
	PyObject *m;
	WERROR error;

	error = com_init_ctx(&py_com_ctx, NULL);
	if (!W_ERROR_IS_OK(error)) {
		PyErr_FromWERROR(error);
		return;
	}

	m = Py_InitModule3("com", com_methods, "Simple COM implementation");
	if (m == NULL)
		return;
}
