#!/bin/bash

cat mklist.txt |
while read line; do
    ws=""
    list=""
    for f in $line; do
	echo "Processing $f"
	f="../../$f"
	test -f $f || {
	    echo "$f doesn't exist"
	    exit 1
	}
	ws="$(dirname $f)/wscript_build"
	if [ -f $ws ]; then
	    if test -s $ws && ! grep "AUTOGENERATED.by.mktowscript" $ws > /dev/null; then
		echo "Skipping manually edited file $ws"
		continue
	    fi
	fi
	list="$list $f"
    done
    if [ "$list" = "" ]; then
	continue
    fi
    ./mktowscript.pl $list > wscript_build.$$ || {
	echo "Failed on $f"
	rm -f wscript_build.$$
	exit 1
    }
    if cmp wscript_build.$$ $ws > /dev/null 2>&1; then
	rm -f wscript_build.$$
    else
	mv wscript_build.$$ $ws || exit 1
    fi
    #exit 1
done
