/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "autoconf/librpc/gen_ndr/ndr_spoolss.h"
#include "autoconf/librpc/gen_ndr/ndr_spoolss_c.h"

/* spoolss - client functions generated by pidl */

struct dcerpc_spoolss_EnumPrinters_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_EnumPrinters_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_EnumPrinters_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_EnumPrinters *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_EnumPrinters_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_EnumPrinters_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ENUMPRINTERS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_EnumPrinters_r_done, req);

	return req;
}

static void dcerpc_spoolss_EnumPrinters_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_EnumPrinters_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_EnumPrinters_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_EnumPrinters_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_EnumPrinters_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_EnumPrinters *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ENUMPRINTERS, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_EnumPrinters_state {
	struct spoolss_EnumPrinters orig;
	struct spoolss_EnumPrinters tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_EnumPrinters_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_EnumPrinters_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    uint32_t _flags /* [in]  */,
						    const char *_server /* [in] [unique,charset(UTF16)] */,
						    uint32_t _level /* [in]  */,
						    DATA_BLOB *_buffer /* [in] [unique] */,
						    uint32_t _offered /* [in]  */,
						    uint32_t *_count /* [out] [ref] */,
						    union spoolss_PrinterInfo **_info /* [out] [ref,switch_is(level),size_is(,*count)] */,
						    uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_EnumPrinters_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_EnumPrinters_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.flags = _flags;
	state->orig.in.server = _server;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.count = _count;
	state->orig.out.info = _info;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_EnumPrinters_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_EnumPrinters_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_EnumPrinters_done, req);
	return req;
}

static void dcerpc_spoolss_EnumPrinters_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_EnumPrinters_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_EnumPrinters_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_EnumPrinters_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.count = *state->tmp.out.count;
	*state->orig.out.info = *state->tmp.out.info;
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_EnumPrinters_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_spoolss_EnumPrinters_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_EnumPrinters_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_EnumPrinters(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     uint32_t _flags /* [in]  */,
				     const char *_server /* [in] [unique,charset(UTF16)] */,
				     uint32_t _level /* [in]  */,
				     DATA_BLOB *_buffer /* [in] [unique] */,
				     uint32_t _offered /* [in]  */,
				     uint32_t *_count /* [out] [ref] */,
				     union spoolss_PrinterInfo **_info /* [out] [ref,switch_is(level),size_is(,*count)] */,
				     uint32_t *_needed /* [out] [ref] */,
				     WERROR *result)
{
	struct spoolss_EnumPrinters r;
	NTSTATUS status;

	/* In parameters */
	r.in.flags = _flags;
	r.in.server = _server;
	r.in.level = _level;
	r.in.buffer = _buffer;
	r.in.offered = _offered;

	status = dcerpc_spoolss_EnumPrinters_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_count = *r.out.count;
	*_info = *r.out.info;
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_OpenPrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_OpenPrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_OpenPrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_OpenPrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_OpenPrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_OpenPrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_OPENPRINTER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_OpenPrinter_r_done, req);

	return req;
}

static void dcerpc_spoolss_OpenPrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_OpenPrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_OpenPrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_OpenPrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_OpenPrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_OpenPrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_OPENPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_OpenPrinter_state {
	struct spoolss_OpenPrinter orig;
	struct spoolss_OpenPrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_OpenPrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_OpenPrinter_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   const char *_printername /* [in] [unique,charset(UTF16)] */,
						   const char *_datatype /* [in] [unique,charset(UTF16)] */,
						   struct spoolss_DevmodeContainer _devmode_ctr /* [in]  */,
						   uint32_t _access_mask /* [in]  */,
						   struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_OpenPrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_OpenPrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.printername = _printername;
	state->orig.in.datatype = _datatype;
	state->orig.in.devmode_ctr = _devmode_ctr;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_OpenPrinter_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_OpenPrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_OpenPrinter_done, req);
	return req;
}

static void dcerpc_spoolss_OpenPrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_OpenPrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_OpenPrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_OpenPrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_OpenPrinter_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct dcerpc_spoolss_OpenPrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_OpenPrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_OpenPrinter(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    const char *_printername /* [in] [unique,charset(UTF16)] */,
				    const char *_datatype /* [in] [unique,charset(UTF16)] */,
				    struct spoolss_DevmodeContainer _devmode_ctr /* [in]  */,
				    uint32_t _access_mask /* [in]  */,
				    struct policy_handle *_handle /* [out] [ref] */,
				    WERROR *result)
{
	struct spoolss_OpenPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.printername = _printername;
	r.in.datatype = _datatype;
	r.in.devmode_ctr = _devmode_ctr;
	r.in.access_mask = _access_mask;

	status = dcerpc_spoolss_OpenPrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_SetJob_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_SetJob_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_SetJob_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_SetJob *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_SetJob_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_SetJob_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_SETJOB, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_SetJob_r_done, req);

	return req;
}

static void dcerpc_spoolss_SetJob_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_SetJob_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_SetJob_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_SetJob_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_SetJob_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_SetJob *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_SETJOB, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_SetJob_state {
	struct spoolss_SetJob orig;
	struct spoolss_SetJob tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_SetJob_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_SetJob_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      struct policy_handle *_handle /* [in] [ref] */,
					      uint32_t _job_id /* [in]  */,
					      struct spoolss_JobInfoContainer *_ctr /* [in] [unique] */,
					      enum spoolss_JobControl _command /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_SetJob_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_SetJob_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.job_id = _job_id;
	state->orig.in.ctr = _ctr;
	state->orig.in.command = _command;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_SetJob_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_SetJob_done, req);
	return req;
}

static void dcerpc_spoolss_SetJob_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_SetJob_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_SetJob_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_SetJob_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_SetJob_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result)
{
	struct dcerpc_spoolss_SetJob_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_SetJob_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_SetJob(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *_handle /* [in] [ref] */,
			       uint32_t _job_id /* [in]  */,
			       struct spoolss_JobInfoContainer *_ctr /* [in] [unique] */,
			       enum spoolss_JobControl _command /* [in]  */,
			       WERROR *result)
{
	struct spoolss_SetJob r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.job_id = _job_id;
	r.in.ctr = _ctr;
	r.in.command = _command;

	status = dcerpc_spoolss_SetJob_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_GetJob_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_GetJob_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_GetJob_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_GetJob *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_GetJob_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_GetJob_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_GETJOB, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_GetJob_r_done, req);

	return req;
}

static void dcerpc_spoolss_GetJob_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_GetJob_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_GetJob_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_GetJob_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_GetJob_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_GetJob *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_GETJOB, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_GetJob_state {
	struct spoolss_GetJob orig;
	struct spoolss_GetJob tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_GetJob_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_GetJob_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      struct policy_handle *_handle /* [in] [ref] */,
					      uint32_t _job_id /* [in]  */,
					      uint32_t _level /* [in]  */,
					      DATA_BLOB *_buffer /* [in] [unique] */,
					      uint32_t _offered /* [in]  */,
					      union spoolss_JobInfo *_info /* [out] [unique,subcontext_size(offered),subcontext(4),switch_is(level)] */,
					      uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_GetJob_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_GetJob_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.job_id = _job_id;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.info = _info;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_GetJob_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_GetJob_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_GetJob_done, req);
	return req;
}

static void dcerpc_spoolss_GetJob_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_GetJob_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_GetJob_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_GetJob_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.info && state->tmp.out.info) {
		*state->orig.out.info = *state->tmp.out.info;
	}
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_GetJob_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result)
{
	struct dcerpc_spoolss_GetJob_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_GetJob_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_GetJob(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *_handle /* [in] [ref] */,
			       uint32_t _job_id /* [in]  */,
			       uint32_t _level /* [in]  */,
			       DATA_BLOB *_buffer /* [in] [unique] */,
			       uint32_t _offered /* [in]  */,
			       union spoolss_JobInfo *_info /* [out] [unique,subcontext_size(offered),subcontext(4),switch_is(level)] */,
			       uint32_t *_needed /* [out] [ref] */,
			       WERROR *result)
{
	struct spoolss_GetJob r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.job_id = _job_id;
	r.in.level = _level;
	r.in.buffer = _buffer;
	r.in.offered = _offered;

	status = dcerpc_spoolss_GetJob_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_info && r.out.info) {
		*_info = *r.out.info;
	}
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_EnumJobs_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_EnumJobs_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_EnumJobs_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_EnumJobs *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_EnumJobs_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_EnumJobs_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ENUMJOBS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_EnumJobs_r_done, req);

	return req;
}

static void dcerpc_spoolss_EnumJobs_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_EnumJobs_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_EnumJobs_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_EnumJobs_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_EnumJobs_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_EnumJobs *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ENUMJOBS, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_EnumJobs_state {
	struct spoolss_EnumJobs orig;
	struct spoolss_EnumJobs tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_EnumJobs_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_EnumJobs_send(TALLOC_CTX *mem_ctx,
						struct tevent_context *ev,
						struct dcerpc_binding_handle *h,
						struct policy_handle *_handle /* [in] [ref] */,
						uint32_t _firstjob /* [in]  */,
						uint32_t _numjobs /* [in]  */,
						uint32_t _level /* [in]  */,
						DATA_BLOB *_buffer /* [in] [unique] */,
						uint32_t _offered /* [in]  */,
						uint32_t *_count /* [out] [ref] */,
						union spoolss_JobInfo **_info /* [out] [ref,switch_is(level),size_is(,*count)] */,
						uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_EnumJobs_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_EnumJobs_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.firstjob = _firstjob;
	state->orig.in.numjobs = _numjobs;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.count = _count;
	state->orig.out.info = _info;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_EnumJobs_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_EnumJobs_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_EnumJobs_done, req);
	return req;
}

static void dcerpc_spoolss_EnumJobs_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_EnumJobs_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_EnumJobs_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_EnumJobs_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.count = *state->tmp.out.count;
	*state->orig.out.info = *state->tmp.out.info;
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_EnumJobs_recv(struct tevent_req *req,
				      TALLOC_CTX *mem_ctx,
				      WERROR *result)
{
	struct dcerpc_spoolss_EnumJobs_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_EnumJobs_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_EnumJobs(struct dcerpc_binding_handle *h,
				 TALLOC_CTX *mem_ctx,
				 struct policy_handle *_handle /* [in] [ref] */,
				 uint32_t _firstjob /* [in]  */,
				 uint32_t _numjobs /* [in]  */,
				 uint32_t _level /* [in]  */,
				 DATA_BLOB *_buffer /* [in] [unique] */,
				 uint32_t _offered /* [in]  */,
				 uint32_t *_count /* [out] [ref] */,
				 union spoolss_JobInfo **_info /* [out] [ref,switch_is(level),size_is(,*count)] */,
				 uint32_t *_needed /* [out] [ref] */,
				 WERROR *result)
{
	struct spoolss_EnumJobs r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.firstjob = _firstjob;
	r.in.numjobs = _numjobs;
	r.in.level = _level;
	r.in.buffer = _buffer;
	r.in.offered = _offered;

	status = dcerpc_spoolss_EnumJobs_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_count = *r.out.count;
	*_info = *r.out.info;
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_AddPrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_AddPrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_AddPrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_AddPrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_AddPrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_AddPrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ADDPRINTER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_AddPrinter_r_done, req);

	return req;
}

static void dcerpc_spoolss_AddPrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_AddPrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_AddPrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_AddPrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_AddPrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_AddPrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ADDPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_AddPrinter_state {
	struct spoolss_AddPrinter orig;
	struct spoolss_AddPrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_AddPrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_AddPrinter_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  const char *_server /* [in] [unique,charset(UTF16)] */,
						  struct spoolss_SetPrinterInfoCtr *_info_ctr /* [in] [ref] */,
						  struct spoolss_DevmodeContainer *_devmode_ctr /* [in] [ref] */,
						  struct sec_desc_buf *_secdesc_ctr /* [in] [ref] */,
						  struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_AddPrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_AddPrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server = _server;
	state->orig.in.info_ctr = _info_ctr;
	state->orig.in.devmode_ctr = _devmode_ctr;
	state->orig.in.secdesc_ctr = _secdesc_ctr;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_AddPrinter_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_AddPrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_AddPrinter_done, req);
	return req;
}

static void dcerpc_spoolss_AddPrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_AddPrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_AddPrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_AddPrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_AddPrinter_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_spoolss_AddPrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_AddPrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_AddPrinter(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   const char *_server /* [in] [unique,charset(UTF16)] */,
				   struct spoolss_SetPrinterInfoCtr *_info_ctr /* [in] [ref] */,
				   struct spoolss_DevmodeContainer *_devmode_ctr /* [in] [ref] */,
				   struct sec_desc_buf *_secdesc_ctr /* [in] [ref] */,
				   struct policy_handle *_handle /* [out] [ref] */,
				   WERROR *result)
{
	struct spoolss_AddPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.server = _server;
	r.in.info_ctr = _info_ctr;
	r.in.devmode_ctr = _devmode_ctr;
	r.in.secdesc_ctr = _secdesc_ctr;

	status = dcerpc_spoolss_AddPrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_DeletePrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_DeletePrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_DeletePrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_DeletePrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_DeletePrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_DeletePrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_DELETEPRINTER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_DeletePrinter_r_done, req);

	return req;
}

static void dcerpc_spoolss_DeletePrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_DeletePrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_DeletePrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_DeletePrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_DeletePrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_DeletePrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_DELETEPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_DeletePrinter_state {
	struct spoolss_DeletePrinter orig;
	struct spoolss_DeletePrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_DeletePrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_DeletePrinter_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle *_handle /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_DeletePrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_DeletePrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_DeletePrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_DeletePrinter_done, req);
	return req;
}

static void dcerpc_spoolss_DeletePrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_DeletePrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_DeletePrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_DeletePrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_DeletePrinter_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_spoolss_DeletePrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_DeletePrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_DeletePrinter(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *_handle /* [in] [ref] */,
				      WERROR *result)
{
	struct spoolss_DeletePrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	status = dcerpc_spoolss_DeletePrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_SetPrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_SetPrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_SetPrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_SetPrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_SetPrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_SetPrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_SETPRINTER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_SetPrinter_r_done, req);

	return req;
}

static void dcerpc_spoolss_SetPrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_SetPrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_SetPrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_SetPrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_SetPrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_SetPrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_SETPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_SetPrinter_state {
	struct spoolss_SetPrinter orig;
	struct spoolss_SetPrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_SetPrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_SetPrinter_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  struct policy_handle *_handle /* [in] [ref] */,
						  struct spoolss_SetPrinterInfoCtr *_info_ctr /* [in] [ref] */,
						  struct spoolss_DevmodeContainer *_devmode_ctr /* [in] [ref] */,
						  struct sec_desc_buf *_secdesc_ctr /* [in] [ref] */,
						  enum spoolss_PrinterControl _command /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_SetPrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_SetPrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.info_ctr = _info_ctr;
	state->orig.in.devmode_ctr = _devmode_ctr;
	state->orig.in.secdesc_ctr = _secdesc_ctr;
	state->orig.in.command = _command;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_SetPrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_SetPrinter_done, req);
	return req;
}

static void dcerpc_spoolss_SetPrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_SetPrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_SetPrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_SetPrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_SetPrinter_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_spoolss_SetPrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_SetPrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_SetPrinter(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *_handle /* [in] [ref] */,
				   struct spoolss_SetPrinterInfoCtr *_info_ctr /* [in] [ref] */,
				   struct spoolss_DevmodeContainer *_devmode_ctr /* [in] [ref] */,
				   struct sec_desc_buf *_secdesc_ctr /* [in] [ref] */,
				   enum spoolss_PrinterControl _command /* [in]  */,
				   WERROR *result)
{
	struct spoolss_SetPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.info_ctr = _info_ctr;
	r.in.devmode_ctr = _devmode_ctr;
	r.in.secdesc_ctr = _secdesc_ctr;
	r.in.command = _command;

	status = dcerpc_spoolss_SetPrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_GetPrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_GetPrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_GetPrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_GetPrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_GetPrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_GetPrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_GETPRINTER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_GetPrinter_r_done, req);

	return req;
}

static void dcerpc_spoolss_GetPrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_GetPrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_GetPrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_GetPrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_GetPrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_GetPrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_GETPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_GetPrinter_state {
	struct spoolss_GetPrinter orig;
	struct spoolss_GetPrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_GetPrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_GetPrinter_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  struct policy_handle *_handle /* [in] [ref] */,
						  uint32_t _level /* [in]  */,
						  DATA_BLOB *_buffer /* [in] [unique] */,
						  uint32_t _offered /* [in]  */,
						  union spoolss_PrinterInfo *_info /* [out] [unique,subcontext_size(offered),subcontext(4),switch_is(level)] */,
						  uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_GetPrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_GetPrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.info = _info;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_GetPrinter_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_GetPrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_GetPrinter_done, req);
	return req;
}

static void dcerpc_spoolss_GetPrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_GetPrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_GetPrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_GetPrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.info && state->tmp.out.info) {
		*state->orig.out.info = *state->tmp.out.info;
	}
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_GetPrinter_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_spoolss_GetPrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_GetPrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_GetPrinter(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *_handle /* [in] [ref] */,
				   uint32_t _level /* [in]  */,
				   DATA_BLOB *_buffer /* [in] [unique] */,
				   uint32_t _offered /* [in]  */,
				   union spoolss_PrinterInfo *_info /* [out] [unique,subcontext_size(offered),subcontext(4),switch_is(level)] */,
				   uint32_t *_needed /* [out] [ref] */,
				   WERROR *result)
{
	struct spoolss_GetPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.level = _level;
	r.in.buffer = _buffer;
	r.in.offered = _offered;

	status = dcerpc_spoolss_GetPrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_info && r.out.info) {
		*_info = *r.out.info;
	}
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_AddPrinterDriver_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_AddPrinterDriver_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_AddPrinterDriver_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_AddPrinterDriver *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_AddPrinterDriver_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_AddPrinterDriver_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ADDPRINTERDRIVER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_AddPrinterDriver_r_done, req);

	return req;
}

static void dcerpc_spoolss_AddPrinterDriver_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_AddPrinterDriver_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_AddPrinterDriver_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_AddPrinterDriver_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_AddPrinterDriver_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_AddPrinterDriver *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ADDPRINTERDRIVER, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_AddPrinterDriver_state {
	struct spoolss_AddPrinterDriver orig;
	struct spoolss_AddPrinterDriver tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_AddPrinterDriver_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_AddPrinterDriver_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							const char *_servername /* [in] [unique,charset(UTF16)] */,
							struct spoolss_AddDriverInfoCtr *_info_ctr /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_AddPrinterDriver_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_AddPrinterDriver_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.info_ctr = _info_ctr;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_AddPrinterDriver_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_AddPrinterDriver_done, req);
	return req;
}

static void dcerpc_spoolss_AddPrinterDriver_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_AddPrinterDriver_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_AddPrinterDriver_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_AddPrinterDriver_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_AddPrinterDriver_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_spoolss_AddPrinterDriver_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_AddPrinterDriver_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_AddPrinterDriver(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 const char *_servername /* [in] [unique,charset(UTF16)] */,
					 struct spoolss_AddDriverInfoCtr *_info_ctr /* [in] [ref] */,
					 WERROR *result)
{
	struct spoolss_AddPrinterDriver r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = _servername;
	r.in.info_ctr = _info_ctr;

	status = dcerpc_spoolss_AddPrinterDriver_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_EnumPrinterDrivers_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_EnumPrinterDrivers_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_EnumPrinterDrivers_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_EnumPrinterDrivers *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_EnumPrinterDrivers_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_EnumPrinterDrivers_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ENUMPRINTERDRIVERS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_EnumPrinterDrivers_r_done, req);

	return req;
}

static void dcerpc_spoolss_EnumPrinterDrivers_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_EnumPrinterDrivers_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_EnumPrinterDrivers_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_EnumPrinterDrivers_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_EnumPrinterDrivers_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_EnumPrinterDrivers *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ENUMPRINTERDRIVERS, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_EnumPrinterDrivers_state {
	struct spoolss_EnumPrinterDrivers orig;
	struct spoolss_EnumPrinterDrivers tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_EnumPrinterDrivers_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_EnumPrinterDrivers_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  const char *_server /* [in] [unique,charset(UTF16)] */,
							  const char *_environment /* [in] [unique,charset(UTF16)] */,
							  uint32_t _level /* [in]  */,
							  DATA_BLOB *_buffer /* [in] [unique] */,
							  uint32_t _offered /* [in]  */,
							  uint32_t *_count /* [out] [ref] */,
							  union spoolss_DriverInfo **_info /* [out] [ref,switch_is(level),size_is(,*count)] */,
							  uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_EnumPrinterDrivers_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_EnumPrinterDrivers_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server = _server;
	state->orig.in.environment = _environment;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.count = _count;
	state->orig.out.info = _info;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_EnumPrinterDrivers_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_EnumPrinterDrivers_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_EnumPrinterDrivers_done, req);
	return req;
}

static void dcerpc_spoolss_EnumPrinterDrivers_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_EnumPrinterDrivers_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_EnumPrinterDrivers_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_EnumPrinterDrivers_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.count = *state->tmp.out.count;
	*state->orig.out.info = *state->tmp.out.info;
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_EnumPrinterDrivers_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_spoolss_EnumPrinterDrivers_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_EnumPrinterDrivers_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_EnumPrinterDrivers(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   const char *_server /* [in] [unique,charset(UTF16)] */,
					   const char *_environment /* [in] [unique,charset(UTF16)] */,
					   uint32_t _level /* [in]  */,
					   DATA_BLOB *_buffer /* [in] [unique] */,
					   uint32_t _offered /* [in]  */,
					   uint32_t *_count /* [out] [ref] */,
					   union spoolss_DriverInfo **_info /* [out] [ref,switch_is(level),size_is(,*count)] */,
					   uint32_t *_needed /* [out] [ref] */,
					   WERROR *result)
{
	struct spoolss_EnumPrinterDrivers r;
	NTSTATUS status;

	/* In parameters */
	r.in.server = _server;
	r.in.environment = _environment;
	r.in.level = _level;
	r.in.buffer = _buffer;
	r.in.offered = _offered;

	status = dcerpc_spoolss_EnumPrinterDrivers_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_count = *r.out.count;
	*_info = *r.out.info;
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_GetPrinterDriver_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_GetPrinterDriver_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_GetPrinterDriver_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_GetPrinterDriver *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_GetPrinterDriver_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_GetPrinterDriver_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_GETPRINTERDRIVER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_GetPrinterDriver_r_done, req);

	return req;
}

static void dcerpc_spoolss_GetPrinterDriver_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_GetPrinterDriver_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_GetPrinterDriver_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_GetPrinterDriver_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_GetPrinterDriver_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_GetPrinterDriver *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_GETPRINTERDRIVER, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_GetPrinterDriver_state {
	struct spoolss_GetPrinterDriver orig;
	struct spoolss_GetPrinterDriver tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_GetPrinterDriver_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_GetPrinterDriver_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle *_handle /* [in] [ref] */,
							const char *_architecture /* [in] [unique,charset(UTF16)] */,
							uint32_t _level /* [in]  */,
							DATA_BLOB *_buffer /* [in] [unique] */,
							uint32_t _offered /* [in]  */,
							union spoolss_DriverInfo *_info /* [out] [unique,subcontext_size(offered),subcontext(4),switch_is(level)] */,
							uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_GetPrinterDriver_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_GetPrinterDriver_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.architecture = _architecture;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.info = _info;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_GetPrinterDriver_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_GetPrinterDriver_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_GetPrinterDriver_done, req);
	return req;
}

static void dcerpc_spoolss_GetPrinterDriver_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_GetPrinterDriver_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_GetPrinterDriver_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_GetPrinterDriver_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.info && state->tmp.out.info) {
		*state->orig.out.info = *state->tmp.out.info;
	}
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_GetPrinterDriver_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_spoolss_GetPrinterDriver_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_GetPrinterDriver_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_GetPrinterDriver(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *_handle /* [in] [ref] */,
					 const char *_architecture /* [in] [unique,charset(UTF16)] */,
					 uint32_t _level /* [in]  */,
					 DATA_BLOB *_buffer /* [in] [unique] */,
					 uint32_t _offered /* [in]  */,
					 union spoolss_DriverInfo *_info /* [out] [unique,subcontext_size(offered),subcontext(4),switch_is(level)] */,
					 uint32_t *_needed /* [out] [ref] */,
					 WERROR *result)
{
	struct spoolss_GetPrinterDriver r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.architecture = _architecture;
	r.in.level = _level;
	r.in.buffer = _buffer;
	r.in.offered = _offered;

	status = dcerpc_spoolss_GetPrinterDriver_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_info && r.out.info) {
		*_info = *r.out.info;
	}
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_GetPrinterDriverDirectory_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_GetPrinterDriverDirectory_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_GetPrinterDriverDirectory_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_GetPrinterDriverDirectory *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_GetPrinterDriverDirectory_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_GetPrinterDriverDirectory_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_GETPRINTERDRIVERDIRECTORY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_GetPrinterDriverDirectory_r_done, req);

	return req;
}

static void dcerpc_spoolss_GetPrinterDriverDirectory_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_GetPrinterDriverDirectory_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_GetPrinterDriverDirectory_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_GetPrinterDriverDirectory_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_GetPrinterDriverDirectory_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_GetPrinterDriverDirectory *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_GETPRINTERDRIVERDIRECTORY, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_GetPrinterDriverDirectory_state {
	struct spoolss_GetPrinterDriverDirectory orig;
	struct spoolss_GetPrinterDriverDirectory tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_GetPrinterDriverDirectory_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_GetPrinterDriverDirectory_send(TALLOC_CTX *mem_ctx,
								 struct tevent_context *ev,
								 struct dcerpc_binding_handle *h,
								 const char *_server /* [in] [unique,charset(UTF16)] */,
								 const char *_environment /* [in] [unique,charset(UTF16)] */,
								 uint32_t _level /* [in]  */,
								 DATA_BLOB *_buffer /* [in] [unique] */,
								 uint32_t _offered /* [in]  */,
								 union spoolss_DriverDirectoryInfo *_info /* [out] [unique,subcontext_size(offered),subcontext(4),switch_is(level)] */,
								 uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_GetPrinterDriverDirectory_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_GetPrinterDriverDirectory_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server = _server;
	state->orig.in.environment = _environment;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.info = _info;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_GetPrinterDriverDirectory_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_GetPrinterDriverDirectory_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_GetPrinterDriverDirectory_done, req);
	return req;
}

static void dcerpc_spoolss_GetPrinterDriverDirectory_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_GetPrinterDriverDirectory_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_GetPrinterDriverDirectory_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_GetPrinterDriverDirectory_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.info && state->tmp.out.info) {
		*state->orig.out.info = *state->tmp.out.info;
	}
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_GetPrinterDriverDirectory_recv(struct tevent_req *req,
						       TALLOC_CTX *mem_ctx,
						       WERROR *result)
{
	struct dcerpc_spoolss_GetPrinterDriverDirectory_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_GetPrinterDriverDirectory_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_GetPrinterDriverDirectory(struct dcerpc_binding_handle *h,
						  TALLOC_CTX *mem_ctx,
						  const char *_server /* [in] [unique,charset(UTF16)] */,
						  const char *_environment /* [in] [unique,charset(UTF16)] */,
						  uint32_t _level /* [in]  */,
						  DATA_BLOB *_buffer /* [in] [unique] */,
						  uint32_t _offered /* [in]  */,
						  union spoolss_DriverDirectoryInfo *_info /* [out] [unique,subcontext_size(offered),subcontext(4),switch_is(level)] */,
						  uint32_t *_needed /* [out] [ref] */,
						  WERROR *result)
{
	struct spoolss_GetPrinterDriverDirectory r;
	NTSTATUS status;

	/* In parameters */
	r.in.server = _server;
	r.in.environment = _environment;
	r.in.level = _level;
	r.in.buffer = _buffer;
	r.in.offered = _offered;

	status = dcerpc_spoolss_GetPrinterDriverDirectory_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_info && r.out.info) {
		*_info = *r.out.info;
	}
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_DeletePrinterDriver_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_DeletePrinterDriver_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_DeletePrinterDriver_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_DeletePrinterDriver *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_DeletePrinterDriver_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_DeletePrinterDriver_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_DELETEPRINTERDRIVER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_DeletePrinterDriver_r_done, req);

	return req;
}

static void dcerpc_spoolss_DeletePrinterDriver_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_DeletePrinterDriver_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_DeletePrinterDriver_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_DeletePrinterDriver_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_DeletePrinterDriver_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_DeletePrinterDriver *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_DELETEPRINTERDRIVER, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_DeletePrinterDriver_state {
	struct spoolss_DeletePrinterDriver orig;
	struct spoolss_DeletePrinterDriver tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_DeletePrinterDriver_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_DeletePrinterDriver_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   const char *_server /* [in] [unique,charset(UTF16)] */,
							   const char *_architecture /* [in] [charset(UTF16)] */,
							   const char *_driver /* [in] [charset(UTF16)] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_DeletePrinterDriver_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_DeletePrinterDriver_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server = _server;
	state->orig.in.architecture = _architecture;
	state->orig.in.driver = _driver;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_DeletePrinterDriver_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_DeletePrinterDriver_done, req);
	return req;
}

static void dcerpc_spoolss_DeletePrinterDriver_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_DeletePrinterDriver_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_DeletePrinterDriver_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_DeletePrinterDriver_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_DeletePrinterDriver_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_spoolss_DeletePrinterDriver_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_DeletePrinterDriver_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_DeletePrinterDriver(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    const char *_server /* [in] [unique,charset(UTF16)] */,
					    const char *_architecture /* [in] [charset(UTF16)] */,
					    const char *_driver /* [in] [charset(UTF16)] */,
					    WERROR *result)
{
	struct spoolss_DeletePrinterDriver r;
	NTSTATUS status;

	/* In parameters */
	r.in.server = _server;
	r.in.architecture = _architecture;
	r.in.driver = _driver;

	status = dcerpc_spoolss_DeletePrinterDriver_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_AddPrintProcessor_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_AddPrintProcessor_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_AddPrintProcessor_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_AddPrintProcessor *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_AddPrintProcessor_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_AddPrintProcessor_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ADDPRINTPROCESSOR, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_AddPrintProcessor_r_done, req);

	return req;
}

static void dcerpc_spoolss_AddPrintProcessor_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_AddPrintProcessor_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_AddPrintProcessor_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_AddPrintProcessor_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_AddPrintProcessor_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_AddPrintProcessor *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ADDPRINTPROCESSOR, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_AddPrintProcessor_state {
	struct spoolss_AddPrintProcessor orig;
	struct spoolss_AddPrintProcessor tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_AddPrintProcessor_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_AddPrintProcessor_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 const char *_server /* [in] [unique,charset(UTF16)] */,
							 const char *_architecture /* [in] [charset(UTF16)] */,
							 const char *_path_name /* [in] [charset(UTF16)] */,
							 const char *_print_processor_name /* [in] [charset(UTF16)] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_AddPrintProcessor_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_AddPrintProcessor_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server = _server;
	state->orig.in.architecture = _architecture;
	state->orig.in.path_name = _path_name;
	state->orig.in.print_processor_name = _print_processor_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_AddPrintProcessor_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_AddPrintProcessor_done, req);
	return req;
}

static void dcerpc_spoolss_AddPrintProcessor_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_AddPrintProcessor_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_AddPrintProcessor_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_AddPrintProcessor_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_AddPrintProcessor_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_spoolss_AddPrintProcessor_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_AddPrintProcessor_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_AddPrintProcessor(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  const char *_server /* [in] [unique,charset(UTF16)] */,
					  const char *_architecture /* [in] [charset(UTF16)] */,
					  const char *_path_name /* [in] [charset(UTF16)] */,
					  const char *_print_processor_name /* [in] [charset(UTF16)] */,
					  WERROR *result)
{
	struct spoolss_AddPrintProcessor r;
	NTSTATUS status;

	/* In parameters */
	r.in.server = _server;
	r.in.architecture = _architecture;
	r.in.path_name = _path_name;
	r.in.print_processor_name = _print_processor_name;

	status = dcerpc_spoolss_AddPrintProcessor_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_EnumPrintProcessors_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_EnumPrintProcessors_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_EnumPrintProcessors_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_EnumPrintProcessors *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_EnumPrintProcessors_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_EnumPrintProcessors_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ENUMPRINTPROCESSORS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_EnumPrintProcessors_r_done, req);

	return req;
}

static void dcerpc_spoolss_EnumPrintProcessors_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_EnumPrintProcessors_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_EnumPrintProcessors_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_EnumPrintProcessors_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_EnumPrintProcessors_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_EnumPrintProcessors *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ENUMPRINTPROCESSORS, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_EnumPrintProcessors_state {
	struct spoolss_EnumPrintProcessors orig;
	struct spoolss_EnumPrintProcessors tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_EnumPrintProcessors_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_EnumPrintProcessors_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   const char *_servername /* [in] [unique,charset(UTF16)] */,
							   const char *_environment /* [in] [unique,charset(UTF16)] */,
							   uint32_t _level /* [in]  */,
							   DATA_BLOB *_buffer /* [in] [unique] */,
							   uint32_t _offered /* [in]  */,
							   uint32_t *_count /* [out] [ref] */,
							   union spoolss_PrintProcessorInfo **_info /* [out] [ref,switch_is(level),size_is(,*count)] */,
							   uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_EnumPrintProcessors_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_EnumPrintProcessors_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.environment = _environment;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.count = _count;
	state->orig.out.info = _info;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_EnumPrintProcessors_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_EnumPrintProcessors_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_EnumPrintProcessors_done, req);
	return req;
}

static void dcerpc_spoolss_EnumPrintProcessors_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_EnumPrintProcessors_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_EnumPrintProcessors_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_EnumPrintProcessors_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.count = *state->tmp.out.count;
	*state->orig.out.info = *state->tmp.out.info;
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_EnumPrintProcessors_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_spoolss_EnumPrintProcessors_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_EnumPrintProcessors_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_EnumPrintProcessors(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    const char *_servername /* [in] [unique,charset(UTF16)] */,
					    const char *_environment /* [in] [unique,charset(UTF16)] */,
					    uint32_t _level /* [in]  */,
					    DATA_BLOB *_buffer /* [in] [unique] */,
					    uint32_t _offered /* [in]  */,
					    uint32_t *_count /* [out] [ref] */,
					    union spoolss_PrintProcessorInfo **_info /* [out] [ref,switch_is(level),size_is(,*count)] */,
					    uint32_t *_needed /* [out] [ref] */,
					    WERROR *result)
{
	struct spoolss_EnumPrintProcessors r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = _servername;
	r.in.environment = _environment;
	r.in.level = _level;
	r.in.buffer = _buffer;
	r.in.offered = _offered;

	status = dcerpc_spoolss_EnumPrintProcessors_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_count = *r.out.count;
	*_info = *r.out.info;
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_GetPrintProcessorDirectory_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_GetPrintProcessorDirectory_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_GetPrintProcessorDirectory_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_GetPrintProcessorDirectory *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_GetPrintProcessorDirectory_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_GetPrintProcessorDirectory_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_GETPRINTPROCESSORDIRECTORY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_GetPrintProcessorDirectory_r_done, req);

	return req;
}

static void dcerpc_spoolss_GetPrintProcessorDirectory_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_GetPrintProcessorDirectory_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_GetPrintProcessorDirectory_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_GetPrintProcessorDirectory_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_GetPrintProcessorDirectory_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_GetPrintProcessorDirectory *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_GETPRINTPROCESSORDIRECTORY, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_GetPrintProcessorDirectory_state {
	struct spoolss_GetPrintProcessorDirectory orig;
	struct spoolss_GetPrintProcessorDirectory tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_GetPrintProcessorDirectory_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_GetPrintProcessorDirectory_send(TALLOC_CTX *mem_ctx,
								  struct tevent_context *ev,
								  struct dcerpc_binding_handle *h,
								  const char *_server /* [in] [unique,charset(UTF16)] */,
								  const char *_environment /* [in] [unique,charset(UTF16)] */,
								  uint32_t _level /* [in]  */,
								  DATA_BLOB *_buffer /* [in] [unique] */,
								  uint32_t _offered /* [in]  */,
								  union spoolss_PrintProcessorDirectoryInfo *_info /* [out] [unique,subcontext_size(offered),subcontext(4),switch_is(level)] */,
								  uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_GetPrintProcessorDirectory_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_GetPrintProcessorDirectory_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server = _server;
	state->orig.in.environment = _environment;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.info = _info;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_GetPrintProcessorDirectory_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_GetPrintProcessorDirectory_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_GetPrintProcessorDirectory_done, req);
	return req;
}

static void dcerpc_spoolss_GetPrintProcessorDirectory_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_GetPrintProcessorDirectory_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_GetPrintProcessorDirectory_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_GetPrintProcessorDirectory_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.info && state->tmp.out.info) {
		*state->orig.out.info = *state->tmp.out.info;
	}
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_GetPrintProcessorDirectory_recv(struct tevent_req *req,
							TALLOC_CTX *mem_ctx,
							WERROR *result)
{
	struct dcerpc_spoolss_GetPrintProcessorDirectory_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_GetPrintProcessorDirectory_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_GetPrintProcessorDirectory(struct dcerpc_binding_handle *h,
						   TALLOC_CTX *mem_ctx,
						   const char *_server /* [in] [unique,charset(UTF16)] */,
						   const char *_environment /* [in] [unique,charset(UTF16)] */,
						   uint32_t _level /* [in]  */,
						   DATA_BLOB *_buffer /* [in] [unique] */,
						   uint32_t _offered /* [in]  */,
						   union spoolss_PrintProcessorDirectoryInfo *_info /* [out] [unique,subcontext_size(offered),subcontext(4),switch_is(level)] */,
						   uint32_t *_needed /* [out] [ref] */,
						   WERROR *result)
{
	struct spoolss_GetPrintProcessorDirectory r;
	NTSTATUS status;

	/* In parameters */
	r.in.server = _server;
	r.in.environment = _environment;
	r.in.level = _level;
	r.in.buffer = _buffer;
	r.in.offered = _offered;

	status = dcerpc_spoolss_GetPrintProcessorDirectory_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_info && r.out.info) {
		*_info = *r.out.info;
	}
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_StartDocPrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_StartDocPrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_StartDocPrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_StartDocPrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_StartDocPrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_StartDocPrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_STARTDOCPRINTER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_StartDocPrinter_r_done, req);

	return req;
}

static void dcerpc_spoolss_StartDocPrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_StartDocPrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_StartDocPrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_StartDocPrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_StartDocPrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_StartDocPrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_STARTDOCPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_StartDocPrinter_state {
	struct spoolss_StartDocPrinter orig;
	struct spoolss_StartDocPrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_StartDocPrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_StartDocPrinter_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct policy_handle *_handle /* [in] [ref] */,
						       uint32_t _level /* [in]  */,
						       union spoolss_DocumentInfo _info /* [in] [switch_is(level)] */,
						       uint32_t *_job_id /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_StartDocPrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_StartDocPrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.level = _level;
	state->orig.in.info = _info;

	/* Out parameters */
	state->orig.out.job_id = _job_id;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_StartDocPrinter_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_StartDocPrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_StartDocPrinter_done, req);
	return req;
}

static void dcerpc_spoolss_StartDocPrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_StartDocPrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_StartDocPrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_StartDocPrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.job_id = *state->tmp.out.job_id;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_StartDocPrinter_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_spoolss_StartDocPrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_StartDocPrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_StartDocPrinter(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct policy_handle *_handle /* [in] [ref] */,
					uint32_t _level /* [in]  */,
					union spoolss_DocumentInfo _info /* [in] [switch_is(level)] */,
					uint32_t *_job_id /* [out] [ref] */,
					WERROR *result)
{
	struct spoolss_StartDocPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.level = _level;
	r.in.info = _info;

	status = dcerpc_spoolss_StartDocPrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_job_id = *r.out.job_id;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_StartPagePrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_StartPagePrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_StartPagePrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_StartPagePrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_StartPagePrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_StartPagePrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_STARTPAGEPRINTER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_StartPagePrinter_r_done, req);

	return req;
}

static void dcerpc_spoolss_StartPagePrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_StartPagePrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_StartPagePrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_StartPagePrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_StartPagePrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_StartPagePrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_STARTPAGEPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_StartPagePrinter_state {
	struct spoolss_StartPagePrinter orig;
	struct spoolss_StartPagePrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_StartPagePrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_StartPagePrinter_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle *_handle /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_StartPagePrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_StartPagePrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_StartPagePrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_StartPagePrinter_done, req);
	return req;
}

static void dcerpc_spoolss_StartPagePrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_StartPagePrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_StartPagePrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_StartPagePrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_StartPagePrinter_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_spoolss_StartPagePrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_StartPagePrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_StartPagePrinter(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *_handle /* [in] [ref] */,
					 WERROR *result)
{
	struct spoolss_StartPagePrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	status = dcerpc_spoolss_StartPagePrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_WritePrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_WritePrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_WritePrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_WritePrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_WritePrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_WritePrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_WRITEPRINTER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_WritePrinter_r_done, req);

	return req;
}

static void dcerpc_spoolss_WritePrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_WritePrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_WritePrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_WritePrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_WritePrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_WritePrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_WRITEPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_WritePrinter_state {
	struct spoolss_WritePrinter orig;
	struct spoolss_WritePrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_WritePrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_WritePrinter_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle *_handle /* [in] [ref] */,
						    DATA_BLOB _data /* [in]  */,
						    uint32_t __data_size /* [in] [value(r->in.data.length)] */,
						    uint32_t *_num_written /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_WritePrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_WritePrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.data = _data;
	state->orig.in._data_size = __data_size;

	/* Out parameters */
	state->orig.out.num_written = _num_written;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_WritePrinter_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_WritePrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_WritePrinter_done, req);
	return req;
}

static void dcerpc_spoolss_WritePrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_WritePrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_WritePrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_WritePrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.num_written = *state->tmp.out.num_written;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_WritePrinter_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_spoolss_WritePrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_WritePrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_WritePrinter(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *_handle /* [in] [ref] */,
				     DATA_BLOB _data /* [in]  */,
				     uint32_t __data_size /* [in] [value(r->in.data.length)] */,
				     uint32_t *_num_written /* [out] [ref] */,
				     WERROR *result)
{
	struct spoolss_WritePrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.data = _data;
	r.in._data_size = __data_size;

	status = dcerpc_spoolss_WritePrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_num_written = *r.out.num_written;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_EndPagePrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_EndPagePrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_EndPagePrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_EndPagePrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_EndPagePrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_EndPagePrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ENDPAGEPRINTER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_EndPagePrinter_r_done, req);

	return req;
}

static void dcerpc_spoolss_EndPagePrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_EndPagePrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_EndPagePrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_EndPagePrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_EndPagePrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_EndPagePrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ENDPAGEPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_EndPagePrinter_state {
	struct spoolss_EndPagePrinter orig;
	struct spoolss_EndPagePrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_EndPagePrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_EndPagePrinter_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle *_handle /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_EndPagePrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_EndPagePrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_EndPagePrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_EndPagePrinter_done, req);
	return req;
}

static void dcerpc_spoolss_EndPagePrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_EndPagePrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_EndPagePrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_EndPagePrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_EndPagePrinter_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_spoolss_EndPagePrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_EndPagePrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_EndPagePrinter(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *_handle /* [in] [ref] */,
				       WERROR *result)
{
	struct spoolss_EndPagePrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	status = dcerpc_spoolss_EndPagePrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_AbortPrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_AbortPrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_AbortPrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_AbortPrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_AbortPrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_AbortPrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ABORTPRINTER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_AbortPrinter_r_done, req);

	return req;
}

static void dcerpc_spoolss_AbortPrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_AbortPrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_AbortPrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_AbortPrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_AbortPrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_AbortPrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ABORTPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_AbortPrinter_state {
	struct spoolss_AbortPrinter orig;
	struct spoolss_AbortPrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_AbortPrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_AbortPrinter_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle *_handle /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_AbortPrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_AbortPrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_AbortPrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_AbortPrinter_done, req);
	return req;
}

static void dcerpc_spoolss_AbortPrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_AbortPrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_AbortPrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_AbortPrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_AbortPrinter_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_spoolss_AbortPrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_AbortPrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_AbortPrinter(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *_handle /* [in] [ref] */,
				     WERROR *result)
{
	struct spoolss_AbortPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	status = dcerpc_spoolss_AbortPrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_ReadPrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_ReadPrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_ReadPrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_ReadPrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_ReadPrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_ReadPrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_READPRINTER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_ReadPrinter_r_done, req);

	return req;
}

static void dcerpc_spoolss_ReadPrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_ReadPrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_ReadPrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_ReadPrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_ReadPrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_ReadPrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_READPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_ReadPrinter_state {
	struct spoolss_ReadPrinter orig;
	struct spoolss_ReadPrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_ReadPrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_ReadPrinter_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct policy_handle *_handle /* [in] [ref] */,
						   uint8_t *_data /* [out] [ref,size_is(data_size)] */,
						   uint32_t _data_size /* [in]  */,
						   uint32_t *__data_size /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_ReadPrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_ReadPrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.data_size = _data_size;

	/* Out parameters */
	state->orig.out.data = _data;
	state->orig.out._data_size = __data_size;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_ReadPrinter_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_ReadPrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_ReadPrinter_done, req);
	return req;
}

static void dcerpc_spoolss_ReadPrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_ReadPrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_ReadPrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_ReadPrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_data;
		_copy_len_data = state->tmp.in.data_size;
		memcpy(state->orig.out.data, state->tmp.out.data, _copy_len_data * sizeof(*state->orig.out.data));
	}
	*state->orig.out._data_size = *state->tmp.out._data_size;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_ReadPrinter_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct dcerpc_spoolss_ReadPrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_ReadPrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_ReadPrinter(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *_handle /* [in] [ref] */,
				    uint8_t *_data /* [out] [ref,size_is(data_size)] */,
				    uint32_t _data_size /* [in]  */,
				    uint32_t *__data_size /* [out] [ref] */,
				    WERROR *result)
{
	struct spoolss_ReadPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.data_size = _data_size;

	status = dcerpc_spoolss_ReadPrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_data;
		_copy_len_data = r.in.data_size;
		memcpy(_data, r.out.data, _copy_len_data * sizeof(*_data));
	}
	*__data_size = *r.out._data_size;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_EndDocPrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_EndDocPrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_EndDocPrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_EndDocPrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_EndDocPrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_EndDocPrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ENDDOCPRINTER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_EndDocPrinter_r_done, req);

	return req;
}

static void dcerpc_spoolss_EndDocPrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_EndDocPrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_EndDocPrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_EndDocPrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_EndDocPrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_EndDocPrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ENDDOCPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_EndDocPrinter_state {
	struct spoolss_EndDocPrinter orig;
	struct spoolss_EndDocPrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_EndDocPrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_EndDocPrinter_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle *_handle /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_EndDocPrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_EndDocPrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_EndDocPrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_EndDocPrinter_done, req);
	return req;
}

static void dcerpc_spoolss_EndDocPrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_EndDocPrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_EndDocPrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_EndDocPrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_EndDocPrinter_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_spoolss_EndDocPrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_EndDocPrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_EndDocPrinter(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *_handle /* [in] [ref] */,
				      WERROR *result)
{
	struct spoolss_EndDocPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	status = dcerpc_spoolss_EndDocPrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_AddJob_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_AddJob_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_AddJob_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_AddJob *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_AddJob_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_AddJob_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ADDJOB, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_AddJob_r_done, req);

	return req;
}

static void dcerpc_spoolss_AddJob_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_AddJob_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_AddJob_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_AddJob_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_AddJob_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_AddJob *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ADDJOB, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_AddJob_state {
	struct spoolss_AddJob orig;
	struct spoolss_AddJob tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_AddJob_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_AddJob_send(TALLOC_CTX *mem_ctx,
					      struct tevent_context *ev,
					      struct dcerpc_binding_handle *h,
					      struct policy_handle *_handle /* [in] [ref] */,
					      uint32_t _level /* [in]  */,
					      uint8_t *_buffer /* [in,out] [unique,size_is(offered)] */,
					      uint32_t _offered /* [in]  */,
					      uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_AddJob_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_AddJob_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.buffer = _buffer;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_AddJob_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_AddJob_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_AddJob_done, req);
	return req;
}

static void dcerpc_spoolss_AddJob_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_AddJob_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_AddJob_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_AddJob_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.buffer && state->tmp.out.buffer) {
		{
			size_t _copy_len_buffer;
			_copy_len_buffer = state->tmp.in.offered;
			memcpy(state->orig.out.buffer, state->tmp.out.buffer, _copy_len_buffer * sizeof(*state->orig.out.buffer));
		}
	}
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_AddJob_recv(struct tevent_req *req,
				    TALLOC_CTX *mem_ctx,
				    WERROR *result)
{
	struct dcerpc_spoolss_AddJob_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_AddJob_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_AddJob(struct dcerpc_binding_handle *h,
			       TALLOC_CTX *mem_ctx,
			       struct policy_handle *_handle /* [in] [ref] */,
			       uint32_t _level /* [in]  */,
			       uint8_t *_buffer /* [in,out] [unique,size_is(offered)] */,
			       uint32_t _offered /* [in]  */,
			       uint32_t *_needed /* [out] [ref] */,
			       WERROR *result)
{
	struct spoolss_AddJob r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.level = _level;
	r.in.buffer = _buffer;
	r.in.offered = _offered;

	status = dcerpc_spoolss_AddJob_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_buffer && r.out.buffer) {
		{
			size_t _copy_len_buffer;
			_copy_len_buffer = r.in.offered;
			memcpy(_buffer, r.out.buffer, _copy_len_buffer * sizeof(*_buffer));
		}
	}
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_ScheduleJob_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_ScheduleJob_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_ScheduleJob_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_ScheduleJob *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_ScheduleJob_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_ScheduleJob_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_SCHEDULEJOB, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_ScheduleJob_r_done, req);

	return req;
}

static void dcerpc_spoolss_ScheduleJob_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_ScheduleJob_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_ScheduleJob_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_ScheduleJob_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_ScheduleJob_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_ScheduleJob *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_SCHEDULEJOB, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_ScheduleJob_state {
	struct spoolss_ScheduleJob orig;
	struct spoolss_ScheduleJob tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_ScheduleJob_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_ScheduleJob_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct policy_handle *_handle /* [in] [ref] */,
						   uint32_t _jobid /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_ScheduleJob_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_ScheduleJob_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.jobid = _jobid;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_ScheduleJob_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_ScheduleJob_done, req);
	return req;
}

static void dcerpc_spoolss_ScheduleJob_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_ScheduleJob_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_ScheduleJob_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_ScheduleJob_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_ScheduleJob_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct dcerpc_spoolss_ScheduleJob_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_ScheduleJob_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_ScheduleJob(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *_handle /* [in] [ref] */,
				    uint32_t _jobid /* [in]  */,
				    WERROR *result)
{
	struct spoolss_ScheduleJob r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.jobid = _jobid;

	status = dcerpc_spoolss_ScheduleJob_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_GetPrinterData_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_GetPrinterData_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_GetPrinterData_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_GetPrinterData *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_GetPrinterData_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_GetPrinterData_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_GETPRINTERDATA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_GetPrinterData_r_done, req);

	return req;
}

static void dcerpc_spoolss_GetPrinterData_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_GetPrinterData_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_GetPrinterData_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_GetPrinterData_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_GetPrinterData_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_GetPrinterData *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_GETPRINTERDATA, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_GetPrinterData_state {
	struct spoolss_GetPrinterData orig;
	struct spoolss_GetPrinterData tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_GetPrinterData_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_GetPrinterData_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle *_handle /* [in] [ref] */,
						      const char *_value_name /* [in] [charset(UTF16)] */,
						      enum winreg_Type *_type /* [out] [ref] */,
						      uint8_t *_data /* [out] [ref,size_is(offered)] */,
						      uint32_t _offered /* [in]  */,
						      uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_GetPrinterData_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_GetPrinterData_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.value_name = _value_name;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.type = _type;
	state->orig.out.data = _data;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_GetPrinterData_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_GetPrinterData_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_GetPrinterData_done, req);
	return req;
}

static void dcerpc_spoolss_GetPrinterData_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_GetPrinterData_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_GetPrinterData_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_GetPrinterData_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.type = *state->tmp.out.type;
	{
		size_t _copy_len_data;
		_copy_len_data = state->tmp.in.offered;
		memcpy(state->orig.out.data, state->tmp.out.data, _copy_len_data * sizeof(*state->orig.out.data));
	}
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_GetPrinterData_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_spoolss_GetPrinterData_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_GetPrinterData_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_GetPrinterData(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *_handle /* [in] [ref] */,
				       const char *_value_name /* [in] [charset(UTF16)] */,
				       enum winreg_Type *_type /* [out] [ref] */,
				       uint8_t *_data /* [out] [ref,size_is(offered)] */,
				       uint32_t _offered /* [in]  */,
				       uint32_t *_needed /* [out] [ref] */,
				       WERROR *result)
{
	struct spoolss_GetPrinterData r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.value_name = _value_name;
	r.in.offered = _offered;

	status = dcerpc_spoolss_GetPrinterData_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_type = *r.out.type;
	{
		size_t _copy_len_data;
		_copy_len_data = r.in.offered;
		memcpy(_data, r.out.data, _copy_len_data * sizeof(*_data));
	}
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_SetPrinterData_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_SetPrinterData_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_SetPrinterData_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_SetPrinterData *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_SetPrinterData_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_SetPrinterData_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_SETPRINTERDATA, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_SetPrinterData_r_done, req);

	return req;
}

static void dcerpc_spoolss_SetPrinterData_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_SetPrinterData_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_SetPrinterData_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_SetPrinterData_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_SetPrinterData_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_SetPrinterData *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_SETPRINTERDATA, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_SetPrinterData_state {
	struct spoolss_SetPrinterData orig;
	struct spoolss_SetPrinterData tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_SetPrinterData_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_SetPrinterData_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle *_handle /* [in] [ref] */,
						      const char *_value_name /* [in] [charset(UTF16)] */,
						      enum winreg_Type _type /* [in]  */,
						      uint8_t *_data /* [in] [ref,size_is(offered)] */,
						      uint32_t _offered /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_SetPrinterData_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_SetPrinterData_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.value_name = _value_name;
	state->orig.in.type = _type;
	state->orig.in.data = _data;
	state->orig.in.offered = _offered;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_SetPrinterData_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_SetPrinterData_done, req);
	return req;
}

static void dcerpc_spoolss_SetPrinterData_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_SetPrinterData_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_SetPrinterData_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_SetPrinterData_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_SetPrinterData_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_spoolss_SetPrinterData_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_SetPrinterData_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_SetPrinterData(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *_handle /* [in] [ref] */,
				       const char *_value_name /* [in] [charset(UTF16)] */,
				       enum winreg_Type _type /* [in]  */,
				       uint8_t *_data /* [in] [ref,size_is(offered)] */,
				       uint32_t _offered /* [in]  */,
				       WERROR *result)
{
	struct spoolss_SetPrinterData r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.value_name = _value_name;
	r.in.type = _type;
	r.in.data = _data;
	r.in.offered = _offered;

	status = dcerpc_spoolss_SetPrinterData_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_ClosePrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_ClosePrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_ClosePrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_ClosePrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_ClosePrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_ClosePrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_CLOSEPRINTER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_ClosePrinter_r_done, req);

	return req;
}

static void dcerpc_spoolss_ClosePrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_ClosePrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_ClosePrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_ClosePrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_ClosePrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_ClosePrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_CLOSEPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_ClosePrinter_state {
	struct spoolss_ClosePrinter orig;
	struct spoolss_ClosePrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_ClosePrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_ClosePrinter_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle *_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_ClosePrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_ClosePrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_ClosePrinter_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_ClosePrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_ClosePrinter_done, req);
	return req;
}

static void dcerpc_spoolss_ClosePrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_ClosePrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_ClosePrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_ClosePrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_ClosePrinter_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_spoolss_ClosePrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_ClosePrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_ClosePrinter(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *_handle /* [in,out] [ref] */,
				     WERROR *result)
{
	struct spoolss_ClosePrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	status = dcerpc_spoolss_ClosePrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_AddForm_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_AddForm_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_AddForm_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_AddForm *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_AddForm_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_AddForm_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ADDFORM, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_AddForm_r_done, req);

	return req;
}

static void dcerpc_spoolss_AddForm_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_AddForm_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_AddForm_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_AddForm_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_AddForm_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_AddForm *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ADDFORM, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_AddForm_state {
	struct spoolss_AddForm orig;
	struct spoolss_AddForm tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_AddForm_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_AddForm_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct policy_handle *_handle /* [in] [ref] */,
					       uint32_t _level /* [in]  */,
					       union spoolss_AddFormInfo _info /* [in] [switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_AddForm_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_AddForm_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.level = _level;
	state->orig.in.info = _info;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_AddForm_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_AddForm_done, req);
	return req;
}

static void dcerpc_spoolss_AddForm_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_AddForm_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_AddForm_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_AddForm_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_AddForm_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct dcerpc_spoolss_AddForm_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_AddForm_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_AddForm(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *_handle /* [in] [ref] */,
				uint32_t _level /* [in]  */,
				union spoolss_AddFormInfo _info /* [in] [switch_is(level)] */,
				WERROR *result)
{
	struct spoolss_AddForm r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.level = _level;
	r.in.info = _info;

	status = dcerpc_spoolss_AddForm_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_DeleteForm_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_DeleteForm_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_DeleteForm_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_DeleteForm *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_DeleteForm_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_DeleteForm_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_DELETEFORM, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_DeleteForm_r_done, req);

	return req;
}

static void dcerpc_spoolss_DeleteForm_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_DeleteForm_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_DeleteForm_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_DeleteForm_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_DeleteForm_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_DeleteForm *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_DELETEFORM, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_DeleteForm_state {
	struct spoolss_DeleteForm orig;
	struct spoolss_DeleteForm tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_DeleteForm_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_DeleteForm_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  struct policy_handle *_handle /* [in] [ref] */,
						  const char *_form_name /* [in] [charset(UTF16)] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_DeleteForm_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_DeleteForm_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.form_name = _form_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_DeleteForm_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_DeleteForm_done, req);
	return req;
}

static void dcerpc_spoolss_DeleteForm_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_DeleteForm_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_DeleteForm_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_DeleteForm_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_DeleteForm_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_spoolss_DeleteForm_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_DeleteForm_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_DeleteForm(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   struct policy_handle *_handle /* [in] [ref] */,
				   const char *_form_name /* [in] [charset(UTF16)] */,
				   WERROR *result)
{
	struct spoolss_DeleteForm r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.form_name = _form_name;

	status = dcerpc_spoolss_DeleteForm_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_GetForm_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_GetForm_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_GetForm_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_GetForm *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_GetForm_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_GetForm_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_GETFORM, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_GetForm_r_done, req);

	return req;
}

static void dcerpc_spoolss_GetForm_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_GetForm_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_GetForm_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_GetForm_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_GetForm_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_GetForm *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_GETFORM, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_GetForm_state {
	struct spoolss_GetForm orig;
	struct spoolss_GetForm tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_GetForm_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_GetForm_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct policy_handle *_handle /* [in] [ref] */,
					       const char *_form_name /* [in] [charset(UTF16)] */,
					       uint32_t _level /* [in]  */,
					       DATA_BLOB *_buffer /* [in] [unique] */,
					       uint32_t _offered /* [in]  */,
					       union spoolss_FormInfo *_info /* [out] [unique,subcontext_size(offered),subcontext(4),switch_is(level)] */,
					       uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_GetForm_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_GetForm_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.form_name = _form_name;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.info = _info;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_GetForm_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_GetForm_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_GetForm_done, req);
	return req;
}

static void dcerpc_spoolss_GetForm_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_GetForm_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_GetForm_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_GetForm_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.info && state->tmp.out.info) {
		*state->orig.out.info = *state->tmp.out.info;
	}
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_GetForm_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct dcerpc_spoolss_GetForm_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_GetForm_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_GetForm(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *_handle /* [in] [ref] */,
				const char *_form_name /* [in] [charset(UTF16)] */,
				uint32_t _level /* [in]  */,
				DATA_BLOB *_buffer /* [in] [unique] */,
				uint32_t _offered /* [in]  */,
				union spoolss_FormInfo *_info /* [out] [unique,subcontext_size(offered),subcontext(4),switch_is(level)] */,
				uint32_t *_needed /* [out] [ref] */,
				WERROR *result)
{
	struct spoolss_GetForm r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.form_name = _form_name;
	r.in.level = _level;
	r.in.buffer = _buffer;
	r.in.offered = _offered;

	status = dcerpc_spoolss_GetForm_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_info && r.out.info) {
		*_info = *r.out.info;
	}
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_SetForm_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_SetForm_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_SetForm_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_SetForm *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_SetForm_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_SetForm_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_SETFORM, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_SetForm_r_done, req);

	return req;
}

static void dcerpc_spoolss_SetForm_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_SetForm_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_SetForm_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_SetForm_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_SetForm_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_SetForm *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_SETFORM, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_SetForm_state {
	struct spoolss_SetForm orig;
	struct spoolss_SetForm tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_SetForm_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_SetForm_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct policy_handle *_handle /* [in] [ref] */,
					       const char *_form_name /* [in] [charset(UTF16)] */,
					       uint32_t _level /* [in]  */,
					       union spoolss_AddFormInfo _info /* [in] [switch_is(level)] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_SetForm_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_SetForm_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.form_name = _form_name;
	state->orig.in.level = _level;
	state->orig.in.info = _info;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_SetForm_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_SetForm_done, req);
	return req;
}

static void dcerpc_spoolss_SetForm_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_SetForm_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_SetForm_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_SetForm_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_SetForm_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct dcerpc_spoolss_SetForm_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_SetForm_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_SetForm(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *_handle /* [in] [ref] */,
				const char *_form_name /* [in] [charset(UTF16)] */,
				uint32_t _level /* [in]  */,
				union spoolss_AddFormInfo _info /* [in] [switch_is(level)] */,
				WERROR *result)
{
	struct spoolss_SetForm r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.form_name = _form_name;
	r.in.level = _level;
	r.in.info = _info;

	status = dcerpc_spoolss_SetForm_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_EnumForms_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_EnumForms_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_EnumForms_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_EnumForms *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_EnumForms_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_EnumForms_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ENUMFORMS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_EnumForms_r_done, req);

	return req;
}

static void dcerpc_spoolss_EnumForms_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_EnumForms_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_EnumForms_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_EnumForms_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_EnumForms_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_EnumForms *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ENUMFORMS, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_EnumForms_state {
	struct spoolss_EnumForms orig;
	struct spoolss_EnumForms tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_EnumForms_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_EnumForms_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 struct policy_handle *_handle /* [in] [ref] */,
						 uint32_t _level /* [in]  */,
						 DATA_BLOB *_buffer /* [in] [unique] */,
						 uint32_t _offered /* [in]  */,
						 uint32_t *_count /* [out] [ref] */,
						 union spoolss_FormInfo **_info /* [out] [ref,switch_is(level),size_is(,*count)] */,
						 uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_EnumForms_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_EnumForms_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.count = _count;
	state->orig.out.info = _info;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_EnumForms_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_EnumForms_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_EnumForms_done, req);
	return req;
}

static void dcerpc_spoolss_EnumForms_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_EnumForms_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_EnumForms_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_EnumForms_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.count = *state->tmp.out.count;
	*state->orig.out.info = *state->tmp.out.info;
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_EnumForms_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_spoolss_EnumForms_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_EnumForms_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_EnumForms(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  struct policy_handle *_handle /* [in] [ref] */,
				  uint32_t _level /* [in]  */,
				  DATA_BLOB *_buffer /* [in] [unique] */,
				  uint32_t _offered /* [in]  */,
				  uint32_t *_count /* [out] [ref] */,
				  union spoolss_FormInfo **_info /* [out] [ref,switch_is(level),size_is(,*count)] */,
				  uint32_t *_needed /* [out] [ref] */,
				  WERROR *result)
{
	struct spoolss_EnumForms r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.level = _level;
	r.in.buffer = _buffer;
	r.in.offered = _offered;

	status = dcerpc_spoolss_EnumForms_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_count = *r.out.count;
	*_info = *r.out.info;
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_EnumPorts_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_EnumPorts_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_EnumPorts_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_EnumPorts *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_EnumPorts_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_EnumPorts_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ENUMPORTS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_EnumPorts_r_done, req);

	return req;
}

static void dcerpc_spoolss_EnumPorts_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_EnumPorts_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_EnumPorts_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_EnumPorts_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_EnumPorts_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_EnumPorts *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ENUMPORTS, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_EnumPorts_state {
	struct spoolss_EnumPorts orig;
	struct spoolss_EnumPorts tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_EnumPorts_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_EnumPorts_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 const char *_servername /* [in] [unique,charset(UTF16)] */,
						 uint32_t _level /* [in]  */,
						 DATA_BLOB *_buffer /* [in] [unique] */,
						 uint32_t _offered /* [in]  */,
						 uint32_t *_count /* [out] [ref] */,
						 union spoolss_PortInfo **_info /* [out] [ref,switch_is(level),size_is(,*count)] */,
						 uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_EnumPorts_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_EnumPorts_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.count = _count;
	state->orig.out.info = _info;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_EnumPorts_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_EnumPorts_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_EnumPorts_done, req);
	return req;
}

static void dcerpc_spoolss_EnumPorts_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_EnumPorts_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_EnumPorts_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_EnumPorts_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.count = *state->tmp.out.count;
	*state->orig.out.info = *state->tmp.out.info;
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_EnumPorts_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_spoolss_EnumPorts_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_EnumPorts_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_EnumPorts(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  const char *_servername /* [in] [unique,charset(UTF16)] */,
				  uint32_t _level /* [in]  */,
				  DATA_BLOB *_buffer /* [in] [unique] */,
				  uint32_t _offered /* [in]  */,
				  uint32_t *_count /* [out] [ref] */,
				  union spoolss_PortInfo **_info /* [out] [ref,switch_is(level),size_is(,*count)] */,
				  uint32_t *_needed /* [out] [ref] */,
				  WERROR *result)
{
	struct spoolss_EnumPorts r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = _servername;
	r.in.level = _level;
	r.in.buffer = _buffer;
	r.in.offered = _offered;

	status = dcerpc_spoolss_EnumPorts_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_count = *r.out.count;
	*_info = *r.out.info;
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_EnumMonitors_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_EnumMonitors_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_EnumMonitors_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_EnumMonitors *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_EnumMonitors_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_EnumMonitors_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ENUMMONITORS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_EnumMonitors_r_done, req);

	return req;
}

static void dcerpc_spoolss_EnumMonitors_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_EnumMonitors_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_EnumMonitors_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_EnumMonitors_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_EnumMonitors_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_EnumMonitors *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ENUMMONITORS, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_EnumMonitors_state {
	struct spoolss_EnumMonitors orig;
	struct spoolss_EnumMonitors tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_EnumMonitors_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_EnumMonitors_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    const char *_servername /* [in] [unique,charset(UTF16)] */,
						    uint32_t _level /* [in]  */,
						    DATA_BLOB *_buffer /* [in] [unique] */,
						    uint32_t _offered /* [in]  */,
						    uint32_t *_count /* [out] [ref] */,
						    union spoolss_MonitorInfo **_info /* [out] [ref,switch_is(level),size_is(,*count)] */,
						    uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_EnumMonitors_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_EnumMonitors_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.count = _count;
	state->orig.out.info = _info;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_EnumMonitors_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_EnumMonitors_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_EnumMonitors_done, req);
	return req;
}

static void dcerpc_spoolss_EnumMonitors_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_EnumMonitors_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_EnumMonitors_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_EnumMonitors_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.count = *state->tmp.out.count;
	*state->orig.out.info = *state->tmp.out.info;
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_EnumMonitors_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_spoolss_EnumMonitors_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_EnumMonitors_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_EnumMonitors(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     const char *_servername /* [in] [unique,charset(UTF16)] */,
				     uint32_t _level /* [in]  */,
				     DATA_BLOB *_buffer /* [in] [unique] */,
				     uint32_t _offered /* [in]  */,
				     uint32_t *_count /* [out] [ref] */,
				     union spoolss_MonitorInfo **_info /* [out] [ref,switch_is(level),size_is(,*count)] */,
				     uint32_t *_needed /* [out] [ref] */,
				     WERROR *result)
{
	struct spoolss_EnumMonitors r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = _servername;
	r.in.level = _level;
	r.in.buffer = _buffer;
	r.in.offered = _offered;

	status = dcerpc_spoolss_EnumMonitors_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_count = *r.out.count;
	*_info = *r.out.info;
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_AddPort_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_AddPort_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_AddPort_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_AddPort *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_AddPort_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_AddPort_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ADDPORT, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_AddPort_r_done, req);

	return req;
}

static void dcerpc_spoolss_AddPort_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_AddPort_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_AddPort_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_AddPort_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_AddPort_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_AddPort *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ADDPORT, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_AddPort_state {
	struct spoolss_AddPort orig;
	struct spoolss_AddPort tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_AddPort_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_AddPort_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       const char *_server_name /* [in] [unique,charset(UTF16)] */,
					       uint32_t _unknown /* [in]  */,
					       const char *_monitor_name /* [in] [charset(UTF16)] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_AddPort_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_AddPort_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.unknown = _unknown;
	state->orig.in.monitor_name = _monitor_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_AddPort_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_AddPort_done, req);
	return req;
}

static void dcerpc_spoolss_AddPort_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_AddPort_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_AddPort_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_AddPort_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_AddPort_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct dcerpc_spoolss_AddPort_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_AddPort_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_AddPort(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				const char *_server_name /* [in] [unique,charset(UTF16)] */,
				uint32_t _unknown /* [in]  */,
				const char *_monitor_name /* [in] [charset(UTF16)] */,
				WERROR *result)
{
	struct spoolss_AddPort r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.unknown = _unknown;
	r.in.monitor_name = _monitor_name;

	status = dcerpc_spoolss_AddPort_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_DeletePort_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_DeletePort_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_DeletePort_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_DeletePort *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_DeletePort_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_DeletePort_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_DELETEPORT, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_DeletePort_r_done, req);

	return req;
}

static void dcerpc_spoolss_DeletePort_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_DeletePort_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_DeletePort_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_DeletePort_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_DeletePort_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_DeletePort *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_DELETEPORT, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_DeletePort_state {
	struct spoolss_DeletePort orig;
	struct spoolss_DeletePort tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_DeletePort_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_DeletePort_send(TALLOC_CTX *mem_ctx,
						  struct tevent_context *ev,
						  struct dcerpc_binding_handle *h,
						  const char *_server_name /* [in] [unique,charset(UTF16)] */,
						  uint32_t _ptr /* [in]  */,
						  const char *_port_name /* [in] [ref,charset(UTF16)] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_DeletePort_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_DeletePort_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.ptr = _ptr;
	state->orig.in.port_name = _port_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_DeletePort_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_DeletePort_done, req);
	return req;
}

static void dcerpc_spoolss_DeletePort_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_DeletePort_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_DeletePort_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_DeletePort_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_DeletePort_recv(struct tevent_req *req,
					TALLOC_CTX *mem_ctx,
					WERROR *result)
{
	struct dcerpc_spoolss_DeletePort_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_DeletePort_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_DeletePort(struct dcerpc_binding_handle *h,
				   TALLOC_CTX *mem_ctx,
				   const char *_server_name /* [in] [unique,charset(UTF16)] */,
				   uint32_t _ptr /* [in]  */,
				   const char *_port_name /* [in] [ref,charset(UTF16)] */,
				   WERROR *result)
{
	struct spoolss_DeletePort r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.ptr = _ptr;
	r.in.port_name = _port_name;

	status = dcerpc_spoolss_DeletePort_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_CreatePrinterIC_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_CreatePrinterIC_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_CreatePrinterIC_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_CreatePrinterIC *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_CreatePrinterIC_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_CreatePrinterIC_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_CREATEPRINTERIC, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_CreatePrinterIC_r_done, req);

	return req;
}

static void dcerpc_spoolss_CreatePrinterIC_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_CreatePrinterIC_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_CreatePrinterIC_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_CreatePrinterIC_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_CreatePrinterIC_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_CreatePrinterIC *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_CREATEPRINTERIC, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_CreatePrinterIC_state {
	struct spoolss_CreatePrinterIC orig;
	struct spoolss_CreatePrinterIC tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_CreatePrinterIC_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_CreatePrinterIC_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct policy_handle *_handle /* [in] [ref] */,
						       struct policy_handle *_gdi_handle /* [out] [ref] */,
						       struct spoolss_DevmodeContainer *_devmode_ctr /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_CreatePrinterIC_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_CreatePrinterIC_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.devmode_ctr = _devmode_ctr;

	/* Out parameters */
	state->orig.out.gdi_handle = _gdi_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_CreatePrinterIC_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_CreatePrinterIC_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_CreatePrinterIC_done, req);
	return req;
}

static void dcerpc_spoolss_CreatePrinterIC_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_CreatePrinterIC_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_CreatePrinterIC_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_CreatePrinterIC_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.gdi_handle = *state->tmp.out.gdi_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_CreatePrinterIC_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_spoolss_CreatePrinterIC_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_CreatePrinterIC_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_CreatePrinterIC(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct policy_handle *_handle /* [in] [ref] */,
					struct policy_handle *_gdi_handle /* [out] [ref] */,
					struct spoolss_DevmodeContainer *_devmode_ctr /* [in] [ref] */,
					WERROR *result)
{
	struct spoolss_CreatePrinterIC r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.devmode_ctr = _devmode_ctr;

	status = dcerpc_spoolss_CreatePrinterIC_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_gdi_handle = *r.out.gdi_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_DeletePrinterIC_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_DeletePrinterIC_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_DeletePrinterIC_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_DeletePrinterIC *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_DeletePrinterIC_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_DeletePrinterIC_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_DELETEPRINTERIC, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_DeletePrinterIC_r_done, req);

	return req;
}

static void dcerpc_spoolss_DeletePrinterIC_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_DeletePrinterIC_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_DeletePrinterIC_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_DeletePrinterIC_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_DeletePrinterIC_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_DeletePrinterIC *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_DELETEPRINTERIC, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_DeletePrinterIC_state {
	struct spoolss_DeletePrinterIC orig;
	struct spoolss_DeletePrinterIC tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_DeletePrinterIC_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_DeletePrinterIC_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct policy_handle *_gdi_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_DeletePrinterIC_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_DeletePrinterIC_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.gdi_handle = _gdi_handle;

	/* Out parameters */
	state->orig.out.gdi_handle = _gdi_handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_DeletePrinterIC_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_DeletePrinterIC_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_DeletePrinterIC_done, req);
	return req;
}

static void dcerpc_spoolss_DeletePrinterIC_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_DeletePrinterIC_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_DeletePrinterIC_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_DeletePrinterIC_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.gdi_handle = *state->tmp.out.gdi_handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_DeletePrinterIC_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_spoolss_DeletePrinterIC_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_DeletePrinterIC_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_DeletePrinterIC(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct policy_handle *_gdi_handle /* [in,out] [ref] */,
					WERROR *result)
{
	struct spoolss_DeletePrinterIC r;
	NTSTATUS status;

	/* In parameters */
	r.in.gdi_handle = _gdi_handle;

	status = dcerpc_spoolss_DeletePrinterIC_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_gdi_handle = *r.out.gdi_handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_EnumPrintProcDataTypes_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_EnumPrintProcDataTypes_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_EnumPrintProcDataTypes_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_EnumPrintProcDataTypes *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_EnumPrintProcDataTypes_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_EnumPrintProcDataTypes_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ENUMPRINTPROCDATATYPES, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_EnumPrintProcDataTypes_r_done, req);

	return req;
}

static void dcerpc_spoolss_EnumPrintProcDataTypes_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_EnumPrintProcDataTypes_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_EnumPrintProcDataTypes_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_EnumPrintProcDataTypes_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_EnumPrintProcDataTypes_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_EnumPrintProcDataTypes *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ENUMPRINTPROCDATATYPES, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_EnumPrintProcDataTypes_state {
	struct spoolss_EnumPrintProcDataTypes orig;
	struct spoolss_EnumPrintProcDataTypes tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_EnumPrintProcDataTypes_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_EnumPrintProcDataTypes_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct dcerpc_binding_handle *h,
							      const char *_servername /* [in] [unique,charset(UTF16)] */,
							      const char *_print_processor_name /* [in] [unique,charset(UTF16)] */,
							      uint32_t _level /* [in]  */,
							      DATA_BLOB *_buffer /* [in] [unique] */,
							      uint32_t _offered /* [in]  */,
							      uint32_t *_count /* [out] [ref] */,
							      union spoolss_PrintProcDataTypesInfo **_info /* [out] [ref,switch_is(level),size_is(,*count)] */,
							      uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_EnumPrintProcDataTypes_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_EnumPrintProcDataTypes_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.print_processor_name = _print_processor_name;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.count = _count;
	state->orig.out.info = _info;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_EnumPrintProcDataTypes_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_EnumPrintProcDataTypes_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_EnumPrintProcDataTypes_done, req);
	return req;
}

static void dcerpc_spoolss_EnumPrintProcDataTypes_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_EnumPrintProcDataTypes_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_EnumPrintProcDataTypes_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_EnumPrintProcDataTypes_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.count = *state->tmp.out.count;
	*state->orig.out.info = *state->tmp.out.info;
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_EnumPrintProcDataTypes_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    WERROR *result)
{
	struct dcerpc_spoolss_EnumPrintProcDataTypes_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_EnumPrintProcDataTypes_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_EnumPrintProcDataTypes(struct dcerpc_binding_handle *h,
					       TALLOC_CTX *mem_ctx,
					       const char *_servername /* [in] [unique,charset(UTF16)] */,
					       const char *_print_processor_name /* [in] [unique,charset(UTF16)] */,
					       uint32_t _level /* [in]  */,
					       DATA_BLOB *_buffer /* [in] [unique] */,
					       uint32_t _offered /* [in]  */,
					       uint32_t *_count /* [out] [ref] */,
					       union spoolss_PrintProcDataTypesInfo **_info /* [out] [ref,switch_is(level),size_is(,*count)] */,
					       uint32_t *_needed /* [out] [ref] */,
					       WERROR *result)
{
	struct spoolss_EnumPrintProcDataTypes r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = _servername;
	r.in.print_processor_name = _print_processor_name;
	r.in.level = _level;
	r.in.buffer = _buffer;
	r.in.offered = _offered;

	status = dcerpc_spoolss_EnumPrintProcDataTypes_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_count = *r.out.count;
	*_info = *r.out.info;
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_ResetPrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_ResetPrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_ResetPrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_ResetPrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_ResetPrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_ResetPrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_RESETPRINTER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_ResetPrinter_r_done, req);

	return req;
}

static void dcerpc_spoolss_ResetPrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_ResetPrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_ResetPrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_ResetPrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_ResetPrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_ResetPrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_RESETPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_ResetPrinter_state {
	struct spoolss_ResetPrinter orig;
	struct spoolss_ResetPrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_ResetPrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_ResetPrinter_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle *_handle /* [in] [ref] */,
						    const char *_data_type /* [in] [unique,charset(UTF16)] */,
						    struct spoolss_DevmodeContainer *_devmode_ctr /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_ResetPrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_ResetPrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.data_type = _data_type;
	state->orig.in.devmode_ctr = _devmode_ctr;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_ResetPrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_ResetPrinter_done, req);
	return req;
}

static void dcerpc_spoolss_ResetPrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_ResetPrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_ResetPrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_ResetPrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_ResetPrinter_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_spoolss_ResetPrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_ResetPrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_ResetPrinter(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *_handle /* [in] [ref] */,
				     const char *_data_type /* [in] [unique,charset(UTF16)] */,
				     struct spoolss_DevmodeContainer *_devmode_ctr /* [in] [ref] */,
				     WERROR *result)
{
	struct spoolss_ResetPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.data_type = _data_type;
	r.in.devmode_ctr = _devmode_ctr;

	status = dcerpc_spoolss_ResetPrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_GetPrinterDriver2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_GetPrinterDriver2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_GetPrinterDriver2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_GetPrinterDriver2 *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_GetPrinterDriver2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_GetPrinterDriver2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_GETPRINTERDRIVER2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_GetPrinterDriver2_r_done, req);

	return req;
}

static void dcerpc_spoolss_GetPrinterDriver2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_GetPrinterDriver2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_GetPrinterDriver2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_GetPrinterDriver2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_GetPrinterDriver2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_GetPrinterDriver2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_GETPRINTERDRIVER2, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_GetPrinterDriver2_state {
	struct spoolss_GetPrinterDriver2 orig;
	struct spoolss_GetPrinterDriver2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_GetPrinterDriver2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_GetPrinterDriver2_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle *_handle /* [in] [ref] */,
							 const char *_architecture /* [in] [unique,charset(UTF16)] */,
							 uint32_t _level /* [in]  */,
							 DATA_BLOB *_buffer /* [in] [unique] */,
							 uint32_t _offered /* [in]  */,
							 uint32_t _client_major_version /* [in]  */,
							 uint32_t _client_minor_version /* [in]  */,
							 union spoolss_DriverInfo *_info /* [out] [unique,subcontext_size(offered),subcontext(4),switch_is(level)] */,
							 uint32_t *_needed /* [out] [ref] */,
							 uint32_t *_server_major_version /* [out] [ref] */,
							 uint32_t *_server_minor_version /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_GetPrinterDriver2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_GetPrinterDriver2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.architecture = _architecture;
	state->orig.in.level = _level;
	state->orig.in.buffer = _buffer;
	state->orig.in.offered = _offered;
	state->orig.in.client_major_version = _client_major_version;
	state->orig.in.client_minor_version = _client_minor_version;

	/* Out parameters */
	state->orig.out.info = _info;
	state->orig.out.needed = _needed;
	state->orig.out.server_major_version = _server_major_version;
	state->orig.out.server_minor_version = _server_minor_version;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_GetPrinterDriver2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_GetPrinterDriver2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_GetPrinterDriver2_done, req);
	return req;
}

static void dcerpc_spoolss_GetPrinterDriver2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_GetPrinterDriver2_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_GetPrinterDriver2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_GetPrinterDriver2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.info && state->tmp.out.info) {
		*state->orig.out.info = *state->tmp.out.info;
	}
	*state->orig.out.needed = *state->tmp.out.needed;
	*state->orig.out.server_major_version = *state->tmp.out.server_major_version;
	*state->orig.out.server_minor_version = *state->tmp.out.server_minor_version;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_GetPrinterDriver2_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_spoolss_GetPrinterDriver2_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_GetPrinterDriver2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_GetPrinterDriver2(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *_handle /* [in] [ref] */,
					  const char *_architecture /* [in] [unique,charset(UTF16)] */,
					  uint32_t _level /* [in]  */,
					  DATA_BLOB *_buffer /* [in] [unique] */,
					  uint32_t _offered /* [in]  */,
					  uint32_t _client_major_version /* [in]  */,
					  uint32_t _client_minor_version /* [in]  */,
					  union spoolss_DriverInfo *_info /* [out] [unique,subcontext_size(offered),subcontext(4),switch_is(level)] */,
					  uint32_t *_needed /* [out] [ref] */,
					  uint32_t *_server_major_version /* [out] [ref] */,
					  uint32_t *_server_minor_version /* [out] [ref] */,
					  WERROR *result)
{
	struct spoolss_GetPrinterDriver2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.architecture = _architecture;
	r.in.level = _level;
	r.in.buffer = _buffer;
	r.in.offered = _offered;
	r.in.client_major_version = _client_major_version;
	r.in.client_minor_version = _client_minor_version;

	status = dcerpc_spoolss_GetPrinterDriver2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_info && r.out.info) {
		*_info = *r.out.info;
	}
	*_needed = *r.out.needed;
	*_server_major_version = *r.out.server_major_version;
	*_server_minor_version = *r.out.server_minor_version;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_FindClosePrinterNotify_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_FindClosePrinterNotify_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_FindClosePrinterNotify_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_FindClosePrinterNotify *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_FindClosePrinterNotify_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_FindClosePrinterNotify_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_FINDCLOSEPRINTERNOTIFY, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_FindClosePrinterNotify_r_done, req);

	return req;
}

static void dcerpc_spoolss_FindClosePrinterNotify_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_FindClosePrinterNotify_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_FindClosePrinterNotify_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_FindClosePrinterNotify_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_FindClosePrinterNotify_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_FindClosePrinterNotify *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_FINDCLOSEPRINTERNOTIFY, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_FindClosePrinterNotify_state {
	struct spoolss_FindClosePrinterNotify orig;
	struct spoolss_FindClosePrinterNotify tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_FindClosePrinterNotify_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_FindClosePrinterNotify_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct dcerpc_binding_handle *h,
							      struct policy_handle *_handle /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_FindClosePrinterNotify_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_FindClosePrinterNotify_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_FindClosePrinterNotify_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_FindClosePrinterNotify_done, req);
	return req;
}

static void dcerpc_spoolss_FindClosePrinterNotify_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_FindClosePrinterNotify_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_FindClosePrinterNotify_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_FindClosePrinterNotify_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_FindClosePrinterNotify_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    WERROR *result)
{
	struct dcerpc_spoolss_FindClosePrinterNotify_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_FindClosePrinterNotify_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_FindClosePrinterNotify(struct dcerpc_binding_handle *h,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle *_handle /* [in] [ref] */,
					       WERROR *result)
{
	struct spoolss_FindClosePrinterNotify r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	status = dcerpc_spoolss_FindClosePrinterNotify_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_ReplyOpenPrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_ReplyOpenPrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_ReplyOpenPrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_ReplyOpenPrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_ReplyOpenPrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_ReplyOpenPrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_REPLYOPENPRINTER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_ReplyOpenPrinter_r_done, req);

	return req;
}

static void dcerpc_spoolss_ReplyOpenPrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_ReplyOpenPrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_ReplyOpenPrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_ReplyOpenPrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_ReplyOpenPrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_ReplyOpenPrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_REPLYOPENPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_ReplyOpenPrinter_state {
	struct spoolss_ReplyOpenPrinter orig;
	struct spoolss_ReplyOpenPrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_ReplyOpenPrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_ReplyOpenPrinter_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							const char *_server_name /* [in] [charset(UTF16)] */,
							uint32_t _printer_local /* [in]  */,
							enum winreg_Type _type /* [in]  */,
							uint32_t _bufsize /* [in] [range(0,512)] */,
							uint8_t *_buffer /* [in] [unique,size_is(bufsize)] */,
							struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_ReplyOpenPrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_ReplyOpenPrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server_name = _server_name;
	state->orig.in.printer_local = _printer_local;
	state->orig.in.type = _type;
	state->orig.in.bufsize = _bufsize;
	state->orig.in.buffer = _buffer;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_ReplyOpenPrinter_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_ReplyOpenPrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_ReplyOpenPrinter_done, req);
	return req;
}

static void dcerpc_spoolss_ReplyOpenPrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_ReplyOpenPrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_ReplyOpenPrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_ReplyOpenPrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_ReplyOpenPrinter_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_spoolss_ReplyOpenPrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_ReplyOpenPrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_ReplyOpenPrinter(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 const char *_server_name /* [in] [charset(UTF16)] */,
					 uint32_t _printer_local /* [in]  */,
					 enum winreg_Type _type /* [in]  */,
					 uint32_t _bufsize /* [in] [range(0,512)] */,
					 uint8_t *_buffer /* [in] [unique,size_is(bufsize)] */,
					 struct policy_handle *_handle /* [out] [ref] */,
					 WERROR *result)
{
	struct spoolss_ReplyOpenPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.server_name = _server_name;
	r.in.printer_local = _printer_local;
	r.in.type = _type;
	r.in.bufsize = _bufsize;
	r.in.buffer = _buffer;

	status = dcerpc_spoolss_ReplyOpenPrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_RouterReplyPrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_RouterReplyPrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_RouterReplyPrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_RouterReplyPrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_RouterReplyPrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_RouterReplyPrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ROUTERREPLYPRINTER, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_RouterReplyPrinter_r_done, req);

	return req;
}

static void dcerpc_spoolss_RouterReplyPrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_RouterReplyPrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_RouterReplyPrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_RouterReplyPrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_RouterReplyPrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_RouterReplyPrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ROUTERREPLYPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_RouterReplyPrinter_state {
	struct spoolss_RouterReplyPrinter orig;
	struct spoolss_RouterReplyPrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_RouterReplyPrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_RouterReplyPrinter_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle *_handle /* [in] [ref] */,
							  uint32_t _flags /* [in]  */,
							  uint32_t _bufsize /* [in] [range(0,512)] */,
							  uint8_t *_buffer /* [in] [unique,size_is(bufsize)] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_RouterReplyPrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_RouterReplyPrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.flags = _flags;
	state->orig.in.bufsize = _bufsize;
	state->orig.in.buffer = _buffer;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_RouterReplyPrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_RouterReplyPrinter_done, req);
	return req;
}

static void dcerpc_spoolss_RouterReplyPrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_RouterReplyPrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_RouterReplyPrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_RouterReplyPrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_RouterReplyPrinter_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_spoolss_RouterReplyPrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_RouterReplyPrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_RouterReplyPrinter(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *_handle /* [in] [ref] */,
					   uint32_t _flags /* [in]  */,
					   uint32_t _bufsize /* [in] [range(0,512)] */,
					   uint8_t *_buffer /* [in] [unique,size_is(bufsize)] */,
					   WERROR *result)
{
	struct spoolss_RouterReplyPrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.flags = _flags;
	r.in.bufsize = _bufsize;
	r.in.buffer = _buffer;

	status = dcerpc_spoolss_RouterReplyPrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_ReplyClosePrinter_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_ReplyClosePrinter_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_ReplyClosePrinter_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_ReplyClosePrinter *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_ReplyClosePrinter_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_ReplyClosePrinter_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_REPLYCLOSEPRINTER, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_ReplyClosePrinter_r_done, req);

	return req;
}

static void dcerpc_spoolss_ReplyClosePrinter_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_ReplyClosePrinter_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_ReplyClosePrinter_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_ReplyClosePrinter_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_ReplyClosePrinter_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_ReplyClosePrinter *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_REPLYCLOSEPRINTER, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_ReplyClosePrinter_state {
	struct spoolss_ReplyClosePrinter orig;
	struct spoolss_ReplyClosePrinter tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_ReplyClosePrinter_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_ReplyClosePrinter_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle *_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_ReplyClosePrinter_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_ReplyClosePrinter_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_ReplyClosePrinter_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_ReplyClosePrinter_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_ReplyClosePrinter_done, req);
	return req;
}

static void dcerpc_spoolss_ReplyClosePrinter_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_ReplyClosePrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_ReplyClosePrinter_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_ReplyClosePrinter_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_ReplyClosePrinter_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_spoolss_ReplyClosePrinter_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_ReplyClosePrinter_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_ReplyClosePrinter(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *_handle /* [in,out] [ref] */,
					  WERROR *result)
{
	struct spoolss_ReplyClosePrinter r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	status = dcerpc_spoolss_ReplyClosePrinter_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_AddPortEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_AddPortEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_AddPortEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_AddPortEx *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_AddPortEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_AddPortEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ADDPORTEX, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_AddPortEx_r_done, req);

	return req;
}

static void dcerpc_spoolss_AddPortEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_AddPortEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_AddPortEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_AddPortEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_AddPortEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_AddPortEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ADDPORTEX, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_AddPortEx_state {
	struct spoolss_AddPortEx orig;
	struct spoolss_AddPortEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_AddPortEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_AddPortEx_send(TALLOC_CTX *mem_ctx,
						 struct tevent_context *ev,
						 struct dcerpc_binding_handle *h,
						 const char *_servername /* [in] [unique,charset(UTF16)] */,
						 struct spoolss_SetPortInfoContainer *_port_ctr /* [in] [ref] */,
						 struct spoolss_PortVarContainer *_port_var_ctr /* [in] [ref] */,
						 const char *_monitor_name /* [in] [unique,charset(UTF16)] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_AddPortEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_AddPortEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.port_ctr = _port_ctr;
	state->orig.in.port_var_ctr = _port_var_ctr;
	state->orig.in.monitor_name = _monitor_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_AddPortEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_AddPortEx_done, req);
	return req;
}

static void dcerpc_spoolss_AddPortEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_AddPortEx_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_AddPortEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_AddPortEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_AddPortEx_recv(struct tevent_req *req,
				       TALLOC_CTX *mem_ctx,
				       WERROR *result)
{
	struct dcerpc_spoolss_AddPortEx_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_AddPortEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_AddPortEx(struct dcerpc_binding_handle *h,
				  TALLOC_CTX *mem_ctx,
				  const char *_servername /* [in] [unique,charset(UTF16)] */,
				  struct spoolss_SetPortInfoContainer *_port_ctr /* [in] [ref] */,
				  struct spoolss_PortVarContainer *_port_var_ctr /* [in] [ref] */,
				  const char *_monitor_name /* [in] [unique,charset(UTF16)] */,
				  WERROR *result)
{
	struct spoolss_AddPortEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = _servername;
	r.in.port_ctr = _port_ctr;
	r.in.port_var_ctr = _port_var_ctr;
	r.in.monitor_name = _monitor_name;

	status = dcerpc_spoolss_AddPortEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_RemoteFindFirstPrinterChangeNotifyEx *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_REMOTEFINDFIRSTPRINTERCHANGENOTIFYEX, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx_r_done, req);

	return req;
}

static void dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_RemoteFindFirstPrinterChangeNotifyEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_REMOTEFINDFIRSTPRINTERCHANGENOTIFYEX, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx_state {
	struct spoolss_RemoteFindFirstPrinterChangeNotifyEx orig;
	struct spoolss_RemoteFindFirstPrinterChangeNotifyEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx_send(TALLOC_CTX *mem_ctx,
									    struct tevent_context *ev,
									    struct dcerpc_binding_handle *h,
									    struct policy_handle *_handle /* [in] [ref] */,
									    uint32_t _flags /* [in]  */,
									    uint32_t _options /* [in]  */,
									    const char *_local_machine /* [in] [unique,charset(UTF16)] */,
									    uint32_t _printer_local /* [in]  */,
									    struct spoolss_NotifyOption *_notify_options /* [in] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.flags = _flags;
	state->orig.in.options = _options;
	state->orig.in.local_machine = _local_machine;
	state->orig.in.printer_local = _printer_local;
	state->orig.in.notify_options = _notify_options;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx_done, req);
	return req;
}

static void dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx_recv(struct tevent_req *req,
								  TALLOC_CTX *mem_ctx,
								  WERROR *result)
{
	struct dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx(struct dcerpc_binding_handle *h,
							     TALLOC_CTX *mem_ctx,
							     struct policy_handle *_handle /* [in] [ref] */,
							     uint32_t _flags /* [in]  */,
							     uint32_t _options /* [in]  */,
							     const char *_local_machine /* [in] [unique,charset(UTF16)] */,
							     uint32_t _printer_local /* [in]  */,
							     struct spoolss_NotifyOption *_notify_options /* [in] [unique] */,
							     WERROR *result)
{
	struct spoolss_RemoteFindFirstPrinterChangeNotifyEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.flags = _flags;
	r.in.options = _options;
	r.in.local_machine = _local_machine;
	r.in.printer_local = _printer_local;
	r.in.notify_options = _notify_options;

	status = dcerpc_spoolss_RemoteFindFirstPrinterChangeNotifyEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_RouterReplyPrinterEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_RouterReplyPrinterEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_RouterReplyPrinterEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_RouterReplyPrinterEx *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_RouterReplyPrinterEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_RouterReplyPrinterEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ROUTERREPLYPRINTEREX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_RouterReplyPrinterEx_r_done, req);

	return req;
}

static void dcerpc_spoolss_RouterReplyPrinterEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_RouterReplyPrinterEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_RouterReplyPrinterEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_RouterReplyPrinterEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_RouterReplyPrinterEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_RouterReplyPrinterEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ROUTERREPLYPRINTEREX, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_RouterReplyPrinterEx_state {
	struct spoolss_RouterReplyPrinterEx orig;
	struct spoolss_RouterReplyPrinterEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_RouterReplyPrinterEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_RouterReplyPrinterEx_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct dcerpc_binding_handle *h,
							    struct policy_handle *_handle /* [in] [ref] */,
							    uint32_t _color /* [in]  */,
							    uint32_t _flags /* [in]  */,
							    uint32_t *_reply_result /* [out] [ref] */,
							    uint32_t _reply_type /* [in]  */,
							    union spoolss_ReplyPrinterInfo _info /* [in] [switch_is(reply_type)] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_RouterReplyPrinterEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_RouterReplyPrinterEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.color = _color;
	state->orig.in.flags = _flags;
	state->orig.in.reply_type = _reply_type;
	state->orig.in.info = _info;

	/* Out parameters */
	state->orig.out.reply_result = _reply_result;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_RouterReplyPrinterEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_RouterReplyPrinterEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_RouterReplyPrinterEx_done, req);
	return req;
}

static void dcerpc_spoolss_RouterReplyPrinterEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_RouterReplyPrinterEx_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_RouterReplyPrinterEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_RouterReplyPrinterEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.reply_result = *state->tmp.out.reply_result;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_RouterReplyPrinterEx_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result)
{
	struct dcerpc_spoolss_RouterReplyPrinterEx_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_RouterReplyPrinterEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_RouterReplyPrinterEx(struct dcerpc_binding_handle *h,
					     TALLOC_CTX *mem_ctx,
					     struct policy_handle *_handle /* [in] [ref] */,
					     uint32_t _color /* [in]  */,
					     uint32_t _flags /* [in]  */,
					     uint32_t *_reply_result /* [out] [ref] */,
					     uint32_t _reply_type /* [in]  */,
					     union spoolss_ReplyPrinterInfo _info /* [in] [switch_is(reply_type)] */,
					     WERROR *result)
{
	struct spoolss_RouterReplyPrinterEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.color = _color;
	r.in.flags = _flags;
	r.in.reply_type = _reply_type;
	r.in.info = _info;

	status = dcerpc_spoolss_RouterReplyPrinterEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_reply_result = *r.out.reply_result;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_RouterRefreshPrinterChangeNotify_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_RouterRefreshPrinterChangeNotify_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_RouterRefreshPrinterChangeNotify_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_RouterRefreshPrinterChangeNotify *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_RouterRefreshPrinterChangeNotify_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_RouterRefreshPrinterChangeNotify_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ROUTERREFRESHPRINTERCHANGENOTIFY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_RouterRefreshPrinterChangeNotify_r_done, req);

	return req;
}

static void dcerpc_spoolss_RouterRefreshPrinterChangeNotify_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_RouterRefreshPrinterChangeNotify_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_RouterRefreshPrinterChangeNotify_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_RouterRefreshPrinterChangeNotify_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_RouterRefreshPrinterChangeNotify_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_RouterRefreshPrinterChangeNotify *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ROUTERREFRESHPRINTERCHANGENOTIFY, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_RouterRefreshPrinterChangeNotify_state {
	struct spoolss_RouterRefreshPrinterChangeNotify orig;
	struct spoolss_RouterRefreshPrinterChangeNotify tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_RouterRefreshPrinterChangeNotify_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_RouterRefreshPrinterChangeNotify_send(TALLOC_CTX *mem_ctx,
									struct tevent_context *ev,
									struct dcerpc_binding_handle *h,
									struct policy_handle *_handle /* [in] [ref] */,
									uint32_t _change_low /* [in]  */,
									struct spoolss_NotifyOption *_options /* [in] [unique] */,
									struct spoolss_NotifyInfo **_info /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_RouterRefreshPrinterChangeNotify_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_RouterRefreshPrinterChangeNotify_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.change_low = _change_low;
	state->orig.in.options = _options;

	/* Out parameters */
	state->orig.out.info = _info;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_RouterRefreshPrinterChangeNotify_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_RouterRefreshPrinterChangeNotify_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_RouterRefreshPrinterChangeNotify_done, req);
	return req;
}

static void dcerpc_spoolss_RouterRefreshPrinterChangeNotify_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_RouterRefreshPrinterChangeNotify_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_RouterRefreshPrinterChangeNotify_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_RouterRefreshPrinterChangeNotify_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_RouterRefreshPrinterChangeNotify_recv(struct tevent_req *req,
							      TALLOC_CTX *mem_ctx,
							      WERROR *result)
{
	struct dcerpc_spoolss_RouterRefreshPrinterChangeNotify_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_RouterRefreshPrinterChangeNotify_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_RouterRefreshPrinterChangeNotify(struct dcerpc_binding_handle *h,
							 TALLOC_CTX *mem_ctx,
							 struct policy_handle *_handle /* [in] [ref] */,
							 uint32_t _change_low /* [in]  */,
							 struct spoolss_NotifyOption *_options /* [in] [unique] */,
							 struct spoolss_NotifyInfo **_info /* [out] [ref] */,
							 WERROR *result)
{
	struct spoolss_RouterRefreshPrinterChangeNotify r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.change_low = _change_low;
	r.in.options = _options;

	status = dcerpc_spoolss_RouterRefreshPrinterChangeNotify_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_OpenPrinterEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_OpenPrinterEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_OpenPrinterEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_OpenPrinterEx *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_OpenPrinterEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_OpenPrinterEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_OPENPRINTEREX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_OpenPrinterEx_r_done, req);

	return req;
}

static void dcerpc_spoolss_OpenPrinterEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_OpenPrinterEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_OpenPrinterEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_OpenPrinterEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_OpenPrinterEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_OpenPrinterEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_OPENPRINTEREX, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_OpenPrinterEx_state {
	struct spoolss_OpenPrinterEx orig;
	struct spoolss_OpenPrinterEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_OpenPrinterEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_OpenPrinterEx_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     const char *_printername /* [in] [unique,charset(UTF16)] */,
						     const char *_datatype /* [in] [unique,charset(UTF16)] */,
						     struct spoolss_DevmodeContainer _devmode_ctr /* [in]  */,
						     uint32_t _access_mask /* [in]  */,
						     uint32_t _level /* [in]  */,
						     union spoolss_UserLevel _userlevel /* [in] [switch_is(level)] */,
						     struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_OpenPrinterEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_OpenPrinterEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.printername = _printername;
	state->orig.in.datatype = _datatype;
	state->orig.in.devmode_ctr = _devmode_ctr;
	state->orig.in.access_mask = _access_mask;
	state->orig.in.level = _level;
	state->orig.in.userlevel = _userlevel;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_OpenPrinterEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_OpenPrinterEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_OpenPrinterEx_done, req);
	return req;
}

static void dcerpc_spoolss_OpenPrinterEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_OpenPrinterEx_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_OpenPrinterEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_OpenPrinterEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_OpenPrinterEx_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_spoolss_OpenPrinterEx_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_OpenPrinterEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_OpenPrinterEx(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      const char *_printername /* [in] [unique,charset(UTF16)] */,
				      const char *_datatype /* [in] [unique,charset(UTF16)] */,
				      struct spoolss_DevmodeContainer _devmode_ctr /* [in]  */,
				      uint32_t _access_mask /* [in]  */,
				      uint32_t _level /* [in]  */,
				      union spoolss_UserLevel _userlevel /* [in] [switch_is(level)] */,
				      struct policy_handle *_handle /* [out] [ref] */,
				      WERROR *result)
{
	struct spoolss_OpenPrinterEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.printername = _printername;
	r.in.datatype = _datatype;
	r.in.devmode_ctr = _devmode_ctr;
	r.in.access_mask = _access_mask;
	r.in.level = _level;
	r.in.userlevel = _userlevel;

	status = dcerpc_spoolss_OpenPrinterEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_AddPrinterEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_AddPrinterEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_AddPrinterEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_AddPrinterEx *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_AddPrinterEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_AddPrinterEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ADDPRINTEREX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_AddPrinterEx_r_done, req);

	return req;
}

static void dcerpc_spoolss_AddPrinterEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_AddPrinterEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_AddPrinterEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_AddPrinterEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_AddPrinterEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_AddPrinterEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ADDPRINTEREX, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_AddPrinterEx_state {
	struct spoolss_AddPrinterEx orig;
	struct spoolss_AddPrinterEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_AddPrinterEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_AddPrinterEx_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    const char *_server /* [in] [unique,charset(UTF16)] */,
						    struct spoolss_SetPrinterInfoCtr *_info_ctr /* [in] [ref] */,
						    struct spoolss_DevmodeContainer *_devmode_ctr /* [in] [ref] */,
						    struct sec_desc_buf *_secdesc_ctr /* [in] [ref] */,
						    struct spoolss_UserLevelCtr *_userlevel_ctr /* [in] [ref] */,
						    struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_AddPrinterEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_AddPrinterEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server = _server;
	state->orig.in.info_ctr = _info_ctr;
	state->orig.in.devmode_ctr = _devmode_ctr;
	state->orig.in.secdesc_ctr = _secdesc_ctr;
	state->orig.in.userlevel_ctr = _userlevel_ctr;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_AddPrinterEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_AddPrinterEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_AddPrinterEx_done, req);
	return req;
}

static void dcerpc_spoolss_AddPrinterEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_AddPrinterEx_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_AddPrinterEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_AddPrinterEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_AddPrinterEx_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_spoolss_AddPrinterEx_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_AddPrinterEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_AddPrinterEx(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     const char *_server /* [in] [unique,charset(UTF16)] */,
				     struct spoolss_SetPrinterInfoCtr *_info_ctr /* [in] [ref] */,
				     struct spoolss_DevmodeContainer *_devmode_ctr /* [in] [ref] */,
				     struct sec_desc_buf *_secdesc_ctr /* [in] [ref] */,
				     struct spoolss_UserLevelCtr *_userlevel_ctr /* [in] [ref] */,
				     struct policy_handle *_handle /* [out] [ref] */,
				     WERROR *result)
{
	struct spoolss_AddPrinterEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.server = _server;
	r.in.info_ctr = _info_ctr;
	r.in.devmode_ctr = _devmode_ctr;
	r.in.secdesc_ctr = _secdesc_ctr;
	r.in.userlevel_ctr = _userlevel_ctr;

	status = dcerpc_spoolss_AddPrinterEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_SetPort_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_SetPort_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_SetPort_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_SetPort *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_SetPort_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_SetPort_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_SETPORT, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_SetPort_r_done, req);

	return req;
}

static void dcerpc_spoolss_SetPort_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_SetPort_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_SetPort_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_SetPort_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_SetPort_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_SetPort *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_SETPORT, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_SetPort_state {
	struct spoolss_SetPort orig;
	struct spoolss_SetPort tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_SetPort_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_SetPort_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       const char *_servername /* [in] [unique,charset(UTF16)] */,
					       const char *_port_name /* [in] [unique,charset(UTF16)] */,
					       struct spoolss_SetPortInfoContainer *_port_ctr /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_SetPort_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_SetPort_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.port_name = _port_name;
	state->orig.in.port_ctr = _port_ctr;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_SetPort_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_SetPort_done, req);
	return req;
}

static void dcerpc_spoolss_SetPort_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_SetPort_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_SetPort_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_SetPort_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_SetPort_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct dcerpc_spoolss_SetPort_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_SetPort_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_SetPort(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				const char *_servername /* [in] [unique,charset(UTF16)] */,
				const char *_port_name /* [in] [unique,charset(UTF16)] */,
				struct spoolss_SetPortInfoContainer *_port_ctr /* [in] [ref] */,
				WERROR *result)
{
	struct spoolss_SetPort r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = _servername;
	r.in.port_name = _port_name;
	r.in.port_ctr = _port_ctr;

	status = dcerpc_spoolss_SetPort_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_EnumPrinterData_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_EnumPrinterData_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_EnumPrinterData_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_EnumPrinterData *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_EnumPrinterData_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_EnumPrinterData_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ENUMPRINTERDATA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_EnumPrinterData_r_done, req);

	return req;
}

static void dcerpc_spoolss_EnumPrinterData_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_EnumPrinterData_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_EnumPrinterData_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_EnumPrinterData_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_EnumPrinterData_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_EnumPrinterData *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ENUMPRINTERDATA, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_EnumPrinterData_state {
	struct spoolss_EnumPrinterData orig;
	struct spoolss_EnumPrinterData tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_EnumPrinterData_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_EnumPrinterData_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct policy_handle *_handle /* [in] [ref] */,
						       uint32_t _enum_index /* [in]  */,
						       const char *_value_name /* [out] [charset(UTF16),size_is(value_offered/2)] */,
						       uint32_t _value_offered /* [in]  */,
						       uint32_t *_value_needed /* [out] [ref] */,
						       enum winreg_Type *_type /* [out] [ref] */,
						       uint8_t *_data /* [out] [ref,flag(LIBNDR_PRINT_ARRAY_HEX),size_is(data_offered)] */,
						       uint32_t _data_offered /* [in]  */,
						       uint32_t *_data_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_EnumPrinterData_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_EnumPrinterData_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.enum_index = _enum_index;
	state->orig.in.value_offered = _value_offered;
	state->orig.in.data_offered = _data_offered;

	/* Out parameters */
	state->orig.out.value_name = _value_name;
	state->orig.out.value_needed = _value_needed;
	state->orig.out.type = _type;
	state->orig.out.data = _data;
	state->orig.out.data_needed = _data_needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_EnumPrinterData_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_EnumPrinterData_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_EnumPrinterData_done, req);
	return req;
}

static void dcerpc_spoolss_EnumPrinterData_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_EnumPrinterData_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_EnumPrinterData_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_EnumPrinterData_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_value_name;
		_copy_len_value_name = ndr_charset_length(state->tmp.out.value_name, CH_UNIX);
		if (_copy_len_value_name > state->tmp.in.value_offered / 2) {
			tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
			return;
		}
		memcpy(discard_const_p(uint8_t *, state->orig.out.value_name), state->tmp.out.value_name, _copy_len_value_name * sizeof(*state->orig.out.value_name));
	}
	*state->orig.out.value_needed = *state->tmp.out.value_needed;
	*state->orig.out.type = *state->tmp.out.type;
	{
		size_t _copy_len_data;
		_copy_len_data = state->tmp.in.data_offered;
		memcpy(state->orig.out.data, state->tmp.out.data, _copy_len_data * sizeof(*state->orig.out.data));
	}
	*state->orig.out.data_needed = *state->tmp.out.data_needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_EnumPrinterData_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_spoolss_EnumPrinterData_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_EnumPrinterData_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_EnumPrinterData(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct policy_handle *_handle /* [in] [ref] */,
					uint32_t _enum_index /* [in]  */,
					const char *_value_name /* [out] [charset(UTF16),size_is(value_offered/2)] */,
					uint32_t _value_offered /* [in]  */,
					uint32_t *_value_needed /* [out] [ref] */,
					enum winreg_Type *_type /* [out] [ref] */,
					uint8_t *_data /* [out] [ref,flag(LIBNDR_PRINT_ARRAY_HEX),size_is(data_offered)] */,
					uint32_t _data_offered /* [in]  */,
					uint32_t *_data_needed /* [out] [ref] */,
					WERROR *result)
{
	struct spoolss_EnumPrinterData r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.enum_index = _enum_index;
	r.in.value_offered = _value_offered;
	r.in.data_offered = _data_offered;

	status = dcerpc_spoolss_EnumPrinterData_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_value_name;
		_copy_len_value_name = ndr_charset_length(r.out.value_name, CH_UNIX);
		if (_copy_len_value_name > r.in.value_offered / 2) {
			return NT_STATUS_INVALID_NETWORK_RESPONSE;
		}
		memcpy(discard_const_p(uint8_t *, _value_name), r.out.value_name, _copy_len_value_name * sizeof(*_value_name));
	}
	*_value_needed = *r.out.value_needed;
	*_type = *r.out.type;
	{
		size_t _copy_len_data;
		_copy_len_data = r.in.data_offered;
		memcpy(_data, r.out.data, _copy_len_data * sizeof(*_data));
	}
	*_data_needed = *r.out.data_needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_DeletePrinterData_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_DeletePrinterData_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_DeletePrinterData_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_DeletePrinterData *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_DeletePrinterData_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_DeletePrinterData_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_DELETEPRINTERDATA, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_DeletePrinterData_r_done, req);

	return req;
}

static void dcerpc_spoolss_DeletePrinterData_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_DeletePrinterData_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_DeletePrinterData_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_DeletePrinterData_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_DeletePrinterData_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_DeletePrinterData *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_DELETEPRINTERDATA, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_DeletePrinterData_state {
	struct spoolss_DeletePrinterData orig;
	struct spoolss_DeletePrinterData tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_DeletePrinterData_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_DeletePrinterData_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle *_handle /* [in] [ref] */,
							 const char *_value_name /* [in] [charset(UTF16)] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_DeletePrinterData_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_DeletePrinterData_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.value_name = _value_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_DeletePrinterData_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_DeletePrinterData_done, req);
	return req;
}

static void dcerpc_spoolss_DeletePrinterData_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_DeletePrinterData_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_DeletePrinterData_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_DeletePrinterData_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_DeletePrinterData_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_spoolss_DeletePrinterData_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_DeletePrinterData_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_DeletePrinterData(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *_handle /* [in] [ref] */,
					  const char *_value_name /* [in] [charset(UTF16)] */,
					  WERROR *result)
{
	struct spoolss_DeletePrinterData r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.value_name = _value_name;

	status = dcerpc_spoolss_DeletePrinterData_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_SetPrinterDataEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_SetPrinterDataEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_SetPrinterDataEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_SetPrinterDataEx *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_SetPrinterDataEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_SetPrinterDataEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_SETPRINTERDATAEX, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_SetPrinterDataEx_r_done, req);

	return req;
}

static void dcerpc_spoolss_SetPrinterDataEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_SetPrinterDataEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_SetPrinterDataEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_SetPrinterDataEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_SetPrinterDataEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_SetPrinterDataEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_SETPRINTERDATAEX, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_SetPrinterDataEx_state {
	struct spoolss_SetPrinterDataEx orig;
	struct spoolss_SetPrinterDataEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_SetPrinterDataEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_SetPrinterDataEx_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle *_handle /* [in] [ref] */,
							const char *_key_name /* [in] [charset(UTF16)] */,
							const char *_value_name /* [in] [charset(UTF16)] */,
							enum winreg_Type _type /* [in]  */,
							uint8_t *_data /* [in] [ref,size_is(offered)] */,
							uint32_t _offered /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_SetPrinterDataEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_SetPrinterDataEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.key_name = _key_name;
	state->orig.in.value_name = _value_name;
	state->orig.in.type = _type;
	state->orig.in.data = _data;
	state->orig.in.offered = _offered;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_SetPrinterDataEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_SetPrinterDataEx_done, req);
	return req;
}

static void dcerpc_spoolss_SetPrinterDataEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_SetPrinterDataEx_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_SetPrinterDataEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_SetPrinterDataEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_SetPrinterDataEx_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_spoolss_SetPrinterDataEx_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_SetPrinterDataEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_SetPrinterDataEx(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *_handle /* [in] [ref] */,
					 const char *_key_name /* [in] [charset(UTF16)] */,
					 const char *_value_name /* [in] [charset(UTF16)] */,
					 enum winreg_Type _type /* [in]  */,
					 uint8_t *_data /* [in] [ref,size_is(offered)] */,
					 uint32_t _offered /* [in]  */,
					 WERROR *result)
{
	struct spoolss_SetPrinterDataEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.key_name = _key_name;
	r.in.value_name = _value_name;
	r.in.type = _type;
	r.in.data = _data;
	r.in.offered = _offered;

	status = dcerpc_spoolss_SetPrinterDataEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_GetPrinterDataEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_GetPrinterDataEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_GetPrinterDataEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_GetPrinterDataEx *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_GetPrinterDataEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_GetPrinterDataEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_GETPRINTERDATAEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_GetPrinterDataEx_r_done, req);

	return req;
}

static void dcerpc_spoolss_GetPrinterDataEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_GetPrinterDataEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_GetPrinterDataEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_GetPrinterDataEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_GetPrinterDataEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_GetPrinterDataEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_GETPRINTERDATAEX, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_GetPrinterDataEx_state {
	struct spoolss_GetPrinterDataEx orig;
	struct spoolss_GetPrinterDataEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_GetPrinterDataEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_GetPrinterDataEx_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle *_handle /* [in] [ref] */,
							const char *_key_name /* [in] [charset(UTF16)] */,
							const char *_value_name /* [in] [charset(UTF16)] */,
							enum winreg_Type *_type /* [out] [ref] */,
							uint8_t *_data /* [out] [ref,size_is(offered)] */,
							uint32_t _offered /* [in]  */,
							uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_GetPrinterDataEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_GetPrinterDataEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.key_name = _key_name;
	state->orig.in.value_name = _value_name;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.type = _type;
	state->orig.out.data = _data;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_GetPrinterDataEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_GetPrinterDataEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_GetPrinterDataEx_done, req);
	return req;
}

static void dcerpc_spoolss_GetPrinterDataEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_GetPrinterDataEx_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_GetPrinterDataEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_GetPrinterDataEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.type = *state->tmp.out.type;
	{
		size_t _copy_len_data;
		_copy_len_data = state->tmp.in.offered;
		memcpy(state->orig.out.data, state->tmp.out.data, _copy_len_data * sizeof(*state->orig.out.data));
	}
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_GetPrinterDataEx_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_spoolss_GetPrinterDataEx_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_GetPrinterDataEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_GetPrinterDataEx(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *_handle /* [in] [ref] */,
					 const char *_key_name /* [in] [charset(UTF16)] */,
					 const char *_value_name /* [in] [charset(UTF16)] */,
					 enum winreg_Type *_type /* [out] [ref] */,
					 uint8_t *_data /* [out] [ref,size_is(offered)] */,
					 uint32_t _offered /* [in]  */,
					 uint32_t *_needed /* [out] [ref] */,
					 WERROR *result)
{
	struct spoolss_GetPrinterDataEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.key_name = _key_name;
	r.in.value_name = _value_name;
	r.in.offered = _offered;

	status = dcerpc_spoolss_GetPrinterDataEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_type = *r.out.type;
	{
		size_t _copy_len_data;
		_copy_len_data = r.in.offered;
		memcpy(_data, r.out.data, _copy_len_data * sizeof(*_data));
	}
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_EnumPrinterDataEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_EnumPrinterDataEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_EnumPrinterDataEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_EnumPrinterDataEx *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_EnumPrinterDataEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_EnumPrinterDataEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ENUMPRINTERDATAEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_EnumPrinterDataEx_r_done, req);

	return req;
}

static void dcerpc_spoolss_EnumPrinterDataEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_EnumPrinterDataEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_EnumPrinterDataEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_EnumPrinterDataEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_EnumPrinterDataEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_EnumPrinterDataEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ENUMPRINTERDATAEX, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_EnumPrinterDataEx_state {
	struct spoolss_EnumPrinterDataEx orig;
	struct spoolss_EnumPrinterDataEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_EnumPrinterDataEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_EnumPrinterDataEx_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle *_handle /* [in] [ref] */,
							 const char *_key_name /* [in] [charset(UTF16)] */,
							 uint32_t _offered /* [in]  */,
							 uint32_t *_count /* [out] [ref] */,
							 struct spoolss_PrinterEnumValues **_info /* [out] [ref,size_is(,*count)] */,
							 uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_EnumPrinterDataEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_EnumPrinterDataEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.key_name = _key_name;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.count = _count;
	state->orig.out.info = _info;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_EnumPrinterDataEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_EnumPrinterDataEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_EnumPrinterDataEx_done, req);
	return req;
}

static void dcerpc_spoolss_EnumPrinterDataEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_EnumPrinterDataEx_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_EnumPrinterDataEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_EnumPrinterDataEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.count = *state->tmp.out.count;
	*state->orig.out.info = *state->tmp.out.info;
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_EnumPrinterDataEx_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_spoolss_EnumPrinterDataEx_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_EnumPrinterDataEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_EnumPrinterDataEx(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *_handle /* [in] [ref] */,
					  const char *_key_name /* [in] [charset(UTF16)] */,
					  uint32_t _offered /* [in]  */,
					  uint32_t *_count /* [out] [ref] */,
					  struct spoolss_PrinterEnumValues **_info /* [out] [ref,size_is(,*count)] */,
					  uint32_t *_needed /* [out] [ref] */,
					  WERROR *result)
{
	struct spoolss_EnumPrinterDataEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.key_name = _key_name;
	r.in.offered = _offered;

	status = dcerpc_spoolss_EnumPrinterDataEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_count = *r.out.count;
	*_info = *r.out.info;
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_EnumPrinterKey_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_EnumPrinterKey_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_EnumPrinterKey_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_EnumPrinterKey *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_EnumPrinterKey_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_EnumPrinterKey_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ENUMPRINTERKEY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_EnumPrinterKey_r_done, req);

	return req;
}

static void dcerpc_spoolss_EnumPrinterKey_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_EnumPrinterKey_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_EnumPrinterKey_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_EnumPrinterKey_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_EnumPrinterKey_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_EnumPrinterKey *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ENUMPRINTERKEY, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_EnumPrinterKey_state {
	struct spoolss_EnumPrinterKey orig;
	struct spoolss_EnumPrinterKey tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_EnumPrinterKey_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_EnumPrinterKey_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct dcerpc_binding_handle *h,
						      struct policy_handle *_handle /* [in] [ref] */,
						      const char *_key_name /* [in] [charset(UTF16)] */,
						      uint32_t *__ndr_size /* [out] [ref] */,
						      union spoolss_KeyNames *_key_buffer /* [out] [subcontext_size(*_ndr_size*2),ref,subcontext(0),switch_is(*_ndr_size)] */,
						      uint32_t _offered /* [in]  */,
						      uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_EnumPrinterKey_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_EnumPrinterKey_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.key_name = _key_name;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out._ndr_size = __ndr_size;
	state->orig.out.key_buffer = _key_buffer;
	state->orig.out.needed = _needed;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_EnumPrinterKey_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_EnumPrinterKey_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_EnumPrinterKey_done, req);
	return req;
}

static void dcerpc_spoolss_EnumPrinterKey_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_EnumPrinterKey_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_EnumPrinterKey_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_EnumPrinterKey_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out._ndr_size = *state->tmp.out._ndr_size;
	*state->orig.out.key_buffer = *state->tmp.out.key_buffer;
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_EnumPrinterKey_recv(struct tevent_req *req,
					    TALLOC_CTX *mem_ctx,
					    WERROR *result)
{
	struct dcerpc_spoolss_EnumPrinterKey_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_EnumPrinterKey_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_EnumPrinterKey(struct dcerpc_binding_handle *h,
				       TALLOC_CTX *mem_ctx,
				       struct policy_handle *_handle /* [in] [ref] */,
				       const char *_key_name /* [in] [charset(UTF16)] */,
				       uint32_t *__ndr_size /* [out] [ref] */,
				       union spoolss_KeyNames *_key_buffer /* [out] [subcontext_size(*_ndr_size*2),ref,subcontext(0),switch_is(*_ndr_size)] */,
				       uint32_t _offered /* [in]  */,
				       uint32_t *_needed /* [out] [ref] */,
				       WERROR *result)
{
	struct spoolss_EnumPrinterKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.key_name = _key_name;
	r.in.offered = _offered;

	status = dcerpc_spoolss_EnumPrinterKey_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*__ndr_size = *r.out._ndr_size;
	*_key_buffer = *r.out.key_buffer;
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_DeletePrinterDataEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_DeletePrinterDataEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_DeletePrinterDataEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_DeletePrinterDataEx *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_DeletePrinterDataEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_DeletePrinterDataEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_DELETEPRINTERDATAEX, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_DeletePrinterDataEx_r_done, req);

	return req;
}

static void dcerpc_spoolss_DeletePrinterDataEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_DeletePrinterDataEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_DeletePrinterDataEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_DeletePrinterDataEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_DeletePrinterDataEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_DeletePrinterDataEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_DELETEPRINTERDATAEX, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_DeletePrinterDataEx_state {
	struct spoolss_DeletePrinterDataEx orig;
	struct spoolss_DeletePrinterDataEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_DeletePrinterDataEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_DeletePrinterDataEx_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   struct policy_handle *_handle /* [in] [ref] */,
							   const char *_key_name /* [in] [charset(UTF16)] */,
							   const char *_value_name /* [in] [charset(UTF16)] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_DeletePrinterDataEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_DeletePrinterDataEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.key_name = _key_name;
	state->orig.in.value_name = _value_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_DeletePrinterDataEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_DeletePrinterDataEx_done, req);
	return req;
}

static void dcerpc_spoolss_DeletePrinterDataEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_DeletePrinterDataEx_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_DeletePrinterDataEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_DeletePrinterDataEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_DeletePrinterDataEx_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_spoolss_DeletePrinterDataEx_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_DeletePrinterDataEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_DeletePrinterDataEx(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *_handle /* [in] [ref] */,
					    const char *_key_name /* [in] [charset(UTF16)] */,
					    const char *_value_name /* [in] [charset(UTF16)] */,
					    WERROR *result)
{
	struct spoolss_DeletePrinterDataEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.key_name = _key_name;
	r.in.value_name = _value_name;

	status = dcerpc_spoolss_DeletePrinterDataEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_DeletePrinterKey_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_DeletePrinterKey_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_DeletePrinterKey_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_DeletePrinterKey *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_DeletePrinterKey_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_DeletePrinterKey_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_DELETEPRINTERKEY, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_DeletePrinterKey_r_done, req);

	return req;
}

static void dcerpc_spoolss_DeletePrinterKey_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_DeletePrinterKey_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_DeletePrinterKey_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_DeletePrinterKey_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_DeletePrinterKey_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_DeletePrinterKey *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_DELETEPRINTERKEY, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_DeletePrinterKey_state {
	struct spoolss_DeletePrinterKey orig;
	struct spoolss_DeletePrinterKey tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_DeletePrinterKey_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_DeletePrinterKey_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle *_handle /* [in] [ref] */,
							const char *_key_name /* [in] [charset(UTF16)] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_DeletePrinterKey_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_DeletePrinterKey_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.key_name = _key_name;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_DeletePrinterKey_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_DeletePrinterKey_done, req);
	return req;
}

static void dcerpc_spoolss_DeletePrinterKey_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_DeletePrinterKey_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_DeletePrinterKey_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_DeletePrinterKey_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_DeletePrinterKey_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_spoolss_DeletePrinterKey_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_DeletePrinterKey_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_DeletePrinterKey(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *_handle /* [in] [ref] */,
					 const char *_key_name /* [in] [charset(UTF16)] */,
					 WERROR *result)
{
	struct spoolss_DeletePrinterKey r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.key_name = _key_name;

	status = dcerpc_spoolss_DeletePrinterKey_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_DeletePrinterDriverEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_DeletePrinterDriverEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_DeletePrinterDriverEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_DeletePrinterDriverEx *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_DeletePrinterDriverEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_DeletePrinterDriverEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_DELETEPRINTERDRIVEREX, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_DeletePrinterDriverEx_r_done, req);

	return req;
}

static void dcerpc_spoolss_DeletePrinterDriverEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_DeletePrinterDriverEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_DeletePrinterDriverEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_DeletePrinterDriverEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_DeletePrinterDriverEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_DeletePrinterDriverEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_DELETEPRINTERDRIVEREX, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_DeletePrinterDriverEx_state {
	struct spoolss_DeletePrinterDriverEx orig;
	struct spoolss_DeletePrinterDriverEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_DeletePrinterDriverEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_DeletePrinterDriverEx_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     const char *_server /* [in] [unique,charset(UTF16)] */,
							     const char *_architecture /* [in] [charset(UTF16)] */,
							     const char *_driver /* [in] [charset(UTF16)] */,
							     uint32_t _delete_flags /* [in]  */,
							     uint32_t _version /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_DeletePrinterDriverEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_DeletePrinterDriverEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server = _server;
	state->orig.in.architecture = _architecture;
	state->orig.in.driver = _driver;
	state->orig.in.delete_flags = _delete_flags;
	state->orig.in.version = _version;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_DeletePrinterDriverEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_DeletePrinterDriverEx_done, req);
	return req;
}

static void dcerpc_spoolss_DeletePrinterDriverEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_DeletePrinterDriverEx_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_DeletePrinterDriverEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_DeletePrinterDriverEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_DeletePrinterDriverEx_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_spoolss_DeletePrinterDriverEx_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_DeletePrinterDriverEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_DeletePrinterDriverEx(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      const char *_server /* [in] [unique,charset(UTF16)] */,
					      const char *_architecture /* [in] [charset(UTF16)] */,
					      const char *_driver /* [in] [charset(UTF16)] */,
					      uint32_t _delete_flags /* [in]  */,
					      uint32_t _version /* [in]  */,
					      WERROR *result)
{
	struct spoolss_DeletePrinterDriverEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.server = _server;
	r.in.architecture = _architecture;
	r.in.driver = _driver;
	r.in.delete_flags = _delete_flags;
	r.in.version = _version;

	status = dcerpc_spoolss_DeletePrinterDriverEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_AddPerMachineConnection_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_AddPerMachineConnection_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_AddPerMachineConnection_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_AddPerMachineConnection *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_AddPerMachineConnection_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_AddPerMachineConnection_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ADDPERMACHINECONNECTION, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_AddPerMachineConnection_r_done, req);

	return req;
}

static void dcerpc_spoolss_AddPerMachineConnection_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_AddPerMachineConnection_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_AddPerMachineConnection_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_AddPerMachineConnection_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_AddPerMachineConnection_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_AddPerMachineConnection *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ADDPERMACHINECONNECTION, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_AddPerMachineConnection_state {
	struct spoolss_AddPerMachineConnection orig;
	struct spoolss_AddPerMachineConnection tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_AddPerMachineConnection_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_AddPerMachineConnection_send(TALLOC_CTX *mem_ctx,
							       struct tevent_context *ev,
							       struct dcerpc_binding_handle *h,
							       const char *_server /* [in] [unique,charset(UTF16)] */,
							       const char *_printername /* [in] [ref,charset(UTF16)] */,
							       const char *_printserver /* [in] [ref,charset(UTF16)] */,
							       const char *_provider /* [in] [ref,charset(UTF16)] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_AddPerMachineConnection_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_AddPerMachineConnection_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server = _server;
	state->orig.in.printername = _printername;
	state->orig.in.printserver = _printserver;
	state->orig.in.provider = _provider;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_AddPerMachineConnection_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_AddPerMachineConnection_done, req);
	return req;
}

static void dcerpc_spoolss_AddPerMachineConnection_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_AddPerMachineConnection_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_AddPerMachineConnection_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_AddPerMachineConnection_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_AddPerMachineConnection_recv(struct tevent_req *req,
						     TALLOC_CTX *mem_ctx,
						     WERROR *result)
{
	struct dcerpc_spoolss_AddPerMachineConnection_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_AddPerMachineConnection_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_AddPerMachineConnection(struct dcerpc_binding_handle *h,
						TALLOC_CTX *mem_ctx,
						const char *_server /* [in] [unique,charset(UTF16)] */,
						const char *_printername /* [in] [ref,charset(UTF16)] */,
						const char *_printserver /* [in] [ref,charset(UTF16)] */,
						const char *_provider /* [in] [ref,charset(UTF16)] */,
						WERROR *result)
{
	struct spoolss_AddPerMachineConnection r;
	NTSTATUS status;

	/* In parameters */
	r.in.server = _server;
	r.in.printername = _printername;
	r.in.printserver = _printserver;
	r.in.provider = _provider;

	status = dcerpc_spoolss_AddPerMachineConnection_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_DeletePerMachineConnection_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_DeletePerMachineConnection_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_DeletePerMachineConnection_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_DeletePerMachineConnection *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_DeletePerMachineConnection_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_DeletePerMachineConnection_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_DELETEPERMACHINECONNECTION, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_DeletePerMachineConnection_r_done, req);

	return req;
}

static void dcerpc_spoolss_DeletePerMachineConnection_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_DeletePerMachineConnection_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_DeletePerMachineConnection_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_DeletePerMachineConnection_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_DeletePerMachineConnection_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_DeletePerMachineConnection *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_DELETEPERMACHINECONNECTION, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_DeletePerMachineConnection_state {
	struct spoolss_DeletePerMachineConnection orig;
	struct spoolss_DeletePerMachineConnection tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_DeletePerMachineConnection_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_DeletePerMachineConnection_send(TALLOC_CTX *mem_ctx,
								  struct tevent_context *ev,
								  struct dcerpc_binding_handle *h,
								  const char *_server /* [in] [unique,charset(UTF16)] */,
								  const char *_printername /* [in] [ref,charset(UTF16)] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_DeletePerMachineConnection_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_DeletePerMachineConnection_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.server = _server;
	state->orig.in.printername = _printername;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_DeletePerMachineConnection_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_DeletePerMachineConnection_done, req);
	return req;
}

static void dcerpc_spoolss_DeletePerMachineConnection_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_DeletePerMachineConnection_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_DeletePerMachineConnection_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_DeletePerMachineConnection_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_DeletePerMachineConnection_recv(struct tevent_req *req,
							TALLOC_CTX *mem_ctx,
							WERROR *result)
{
	struct dcerpc_spoolss_DeletePerMachineConnection_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_DeletePerMachineConnection_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_DeletePerMachineConnection(struct dcerpc_binding_handle *h,
						   TALLOC_CTX *mem_ctx,
						   const char *_server /* [in] [unique,charset(UTF16)] */,
						   const char *_printername /* [in] [ref,charset(UTF16)] */,
						   WERROR *result)
{
	struct spoolss_DeletePerMachineConnection r;
	NTSTATUS status;

	/* In parameters */
	r.in.server = _server;
	r.in.printername = _printername;

	status = dcerpc_spoolss_DeletePerMachineConnection_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_XcvData_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_XcvData_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_XcvData_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_XcvData *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_XcvData_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_XcvData_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_XCVDATA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_XcvData_r_done, req);

	return req;
}

static void dcerpc_spoolss_XcvData_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_XcvData_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_XcvData_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_XcvData_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_XcvData_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_XcvData *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_XCVDATA, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_XcvData_state {
	struct spoolss_XcvData orig;
	struct spoolss_XcvData tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_XcvData_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_XcvData_send(TALLOC_CTX *mem_ctx,
					       struct tevent_context *ev,
					       struct dcerpc_binding_handle *h,
					       struct policy_handle *_handle /* [in] [ref] */,
					       const char *_function_name /* [in] [charset(UTF16)] */,
					       DATA_BLOB _in_data /* [in]  */,
					       uint32_t __in_data_length /* [in] [value(r->in.in_data.length)] */,
					       uint8_t *_out_data /* [out] [ref,size_is(out_data_size)] */,
					       uint32_t _out_data_size /* [in]  */,
					       uint32_t *_needed /* [out] [ref] */,
					       uint32_t *_status_code /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_XcvData_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_XcvData_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.function_name = _function_name;
	state->orig.in.in_data = _in_data;
	state->orig.in._in_data_length = __in_data_length;
	state->orig.in.out_data_size = _out_data_size;
	state->orig.in.status_code = _status_code;

	/* Out parameters */
	state->orig.out.out_data = _out_data;
	state->orig.out.needed = _needed;
	state->orig.out.status_code = _status_code;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_XcvData_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_XcvData_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_XcvData_done, req);
	return req;
}

static void dcerpc_spoolss_XcvData_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_XcvData_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_XcvData_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_XcvData_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_out_data;
		_copy_len_out_data = state->tmp.in.out_data_size;
		memcpy(state->orig.out.out_data, state->tmp.out.out_data, _copy_len_out_data * sizeof(*state->orig.out.out_data));
	}
	*state->orig.out.needed = *state->tmp.out.needed;
	*state->orig.out.status_code = *state->tmp.out.status_code;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_XcvData_recv(struct tevent_req *req,
				     TALLOC_CTX *mem_ctx,
				     WERROR *result)
{
	struct dcerpc_spoolss_XcvData_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_XcvData_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_XcvData(struct dcerpc_binding_handle *h,
				TALLOC_CTX *mem_ctx,
				struct policy_handle *_handle /* [in] [ref] */,
				const char *_function_name /* [in] [charset(UTF16)] */,
				DATA_BLOB _in_data /* [in]  */,
				uint32_t __in_data_length /* [in] [value(r->in.in_data.length)] */,
				uint8_t *_out_data /* [out] [ref,size_is(out_data_size)] */,
				uint32_t _out_data_size /* [in]  */,
				uint32_t *_needed /* [out] [ref] */,
				uint32_t *_status_code /* [in,out] [ref] */,
				WERROR *result)
{
	struct spoolss_XcvData r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.function_name = _function_name;
	r.in.in_data = _in_data;
	r.in._in_data_length = __in_data_length;
	r.in.out_data_size = _out_data_size;
	r.in.status_code = _status_code;

	status = dcerpc_spoolss_XcvData_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_out_data;
		_copy_len_out_data = r.in.out_data_size;
		memcpy(_out_data, r.out.out_data, _copy_len_out_data * sizeof(*_out_data));
	}
	*_needed = *r.out.needed;
	*_status_code = *r.out.status_code;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_AddPrinterDriverEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_AddPrinterDriverEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_AddPrinterDriverEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_AddPrinterDriverEx *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_AddPrinterDriverEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_AddPrinterDriverEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ADDPRINTERDRIVEREX, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_AddPrinterDriverEx_r_done, req);

	return req;
}

static void dcerpc_spoolss_AddPrinterDriverEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_AddPrinterDriverEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_AddPrinterDriverEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_AddPrinterDriverEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_AddPrinterDriverEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_AddPrinterDriverEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_ADDPRINTERDRIVEREX, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_AddPrinterDriverEx_state {
	struct spoolss_AddPrinterDriverEx orig;
	struct spoolss_AddPrinterDriverEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_AddPrinterDriverEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_AddPrinterDriverEx_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  const char *_servername /* [in] [unique,charset(UTF16)] */,
							  struct spoolss_AddDriverInfoCtr *_info_ctr /* [in] [ref] */,
							  uint32_t _flags /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_AddPrinterDriverEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_AddPrinterDriverEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.info_ctr = _info_ctr;
	state->orig.in.flags = _flags;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_AddPrinterDriverEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_AddPrinterDriverEx_done, req);
	return req;
}

static void dcerpc_spoolss_AddPrinterDriverEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_AddPrinterDriverEx_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_AddPrinterDriverEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_AddPrinterDriverEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_AddPrinterDriverEx_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_spoolss_AddPrinterDriverEx_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_AddPrinterDriverEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_AddPrinterDriverEx(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   const char *_servername /* [in] [unique,charset(UTF16)] */,
					   struct spoolss_AddDriverInfoCtr *_info_ctr /* [in] [ref] */,
					   uint32_t _flags /* [in]  */,
					   WERROR *result)
{
	struct spoolss_AddPrinterDriverEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = _servername;
	r.in.info_ctr = _info_ctr;
	r.in.flags = _flags;

	status = dcerpc_spoolss_AddPrinterDriverEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_GetCorePrinterDrivers_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_GetCorePrinterDrivers_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_GetCorePrinterDrivers_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_GetCorePrinterDrivers *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_GetCorePrinterDrivers_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_GetCorePrinterDrivers_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_GETCOREPRINTERDRIVERS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_GetCorePrinterDrivers_r_done, req);

	return req;
}

static void dcerpc_spoolss_GetCorePrinterDrivers_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_GetCorePrinterDrivers_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_GetCorePrinterDrivers_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_GetCorePrinterDrivers_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_GetCorePrinterDrivers_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_GetCorePrinterDrivers *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_GETCOREPRINTERDRIVERS, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_GetCorePrinterDrivers_state {
	struct spoolss_GetCorePrinterDrivers orig;
	struct spoolss_GetCorePrinterDrivers tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_GetCorePrinterDrivers_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_GetCorePrinterDrivers_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     const char *_servername /* [in] [unique,charset(UTF16)] */,
							     const char *_architecture /* [in] [ref,charset(UTF16)] */,
							     uint32_t _core_driver_size /* [in]  */,
							     const char *_core_driver_dependencies /* [in] [ref,charset(UTF16),size_is(core_driver_size)] */,
							     uint32_t _core_printer_driver_count /* [in]  */,
							     struct spoolss_CorePrinterDriver *_core_printer_drivers /* [out] [ref,size_is(core_printer_driver_count)] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_GetCorePrinterDrivers_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_GetCorePrinterDrivers_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.architecture = _architecture;
	state->orig.in.core_driver_size = _core_driver_size;
	state->orig.in.core_driver_dependencies = _core_driver_dependencies;
	state->orig.in.core_printer_driver_count = _core_printer_driver_count;

	/* Out parameters */
	state->orig.out.core_printer_drivers = _core_printer_drivers;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_GetCorePrinterDrivers_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_GetCorePrinterDrivers_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_GetCorePrinterDrivers_done, req);
	return req;
}

static void dcerpc_spoolss_GetCorePrinterDrivers_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_GetCorePrinterDrivers_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_GetCorePrinterDrivers_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_GetCorePrinterDrivers_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_core_printer_drivers;
		_copy_len_core_printer_drivers = state->tmp.in.core_printer_driver_count;
		memcpy(state->orig.out.core_printer_drivers, state->tmp.out.core_printer_drivers, _copy_len_core_printer_drivers * sizeof(*state->orig.out.core_printer_drivers));
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_GetCorePrinterDrivers_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_spoolss_GetCorePrinterDrivers_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_GetCorePrinterDrivers_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_GetCorePrinterDrivers(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      const char *_servername /* [in] [unique,charset(UTF16)] */,
					      const char *_architecture /* [in] [ref,charset(UTF16)] */,
					      uint32_t _core_driver_size /* [in]  */,
					      const char *_core_driver_dependencies /* [in] [ref,charset(UTF16),size_is(core_driver_size)] */,
					      uint32_t _core_printer_driver_count /* [in]  */,
					      struct spoolss_CorePrinterDriver *_core_printer_drivers /* [out] [ref,size_is(core_printer_driver_count)] */,
					      WERROR *result)
{
	struct spoolss_GetCorePrinterDrivers r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = _servername;
	r.in.architecture = _architecture;
	r.in.core_driver_size = _core_driver_size;
	r.in.core_driver_dependencies = _core_driver_dependencies;
	r.in.core_printer_driver_count = _core_printer_driver_count;

	status = dcerpc_spoolss_GetCorePrinterDrivers_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_core_printer_drivers;
		_copy_len_core_printer_drivers = r.in.core_printer_driver_count;
		memcpy(_core_printer_drivers, r.out.core_printer_drivers, _copy_len_core_printer_drivers * sizeof(*_core_printer_drivers));
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_spoolss_GetPrinterDriverPackagePath_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_GetPrinterDriverPackagePath_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_GetPrinterDriverPackagePath_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct spoolss_GetPrinterDriverPackagePath *r)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_GetPrinterDriverPackagePath_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_GetPrinterDriverPackagePath_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_GETPRINTERDRIVERPACKAGEPATH, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_GetPrinterDriverPackagePath_r_done, req);

	return req;
}

static void dcerpc_spoolss_GetPrinterDriverPackagePath_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_GetPrinterDriverPackagePath_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_spoolss_GetPrinterDriverPackagePath_r_state *state =
		tevent_req_data(req,
		struct dcerpc_spoolss_GetPrinterDriverPackagePath_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_GetPrinterDriverPackagePath_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct spoolss_GetPrinterDriverPackagePath *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_spoolss,
			NDR_SPOOLSS_GETPRINTERDRIVERPACKAGEPATH, mem_ctx, r);

	return status;
}

struct dcerpc_spoolss_GetPrinterDriverPackagePath_state {
	struct spoolss_GetPrinterDriverPackagePath orig;
	struct spoolss_GetPrinterDriverPackagePath tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_spoolss_GetPrinterDriverPackagePath_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_spoolss_GetPrinterDriverPackagePath_send(TALLOC_CTX *mem_ctx,
								   struct tevent_context *ev,
								   struct dcerpc_binding_handle *h,
								   const char *_servername /* [in] [unique,charset(UTF16)] */,
								   const char *_architecture /* [in] [ref,charset(UTF16)] */,
								   const char *_language /* [in] [unique,charset(UTF16)] */,
								   const char *_package_id /* [in] [ref,charset(UTF16)] */,
								   const char *_driver_package_cab /* [in,out] [unique,charset(UTF16),size_is(driver_package_cab_size)] */,
								   uint32_t _driver_package_cab_size /* [in]  */,
								   uint32_t *_required /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_spoolss_GetPrinterDriverPackagePath_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_spoolss_GetPrinterDriverPackagePath_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.servername = _servername;
	state->orig.in.architecture = _architecture;
	state->orig.in.language = _language;
	state->orig.in.package_id = _package_id;
	state->orig.in.driver_package_cab = _driver_package_cab;
	state->orig.in.driver_package_cab_size = _driver_package_cab_size;

	/* Out parameters */
	state->orig.out.driver_package_cab = _driver_package_cab;
	state->orig.out.required = _required;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_spoolss_GetPrinterDriverPackagePath_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_spoolss_GetPrinterDriverPackagePath_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_spoolss_GetPrinterDriverPackagePath_done, req);
	return req;
}

static void dcerpc_spoolss_GetPrinterDriverPackagePath_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_spoolss_GetPrinterDriverPackagePath_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_GetPrinterDriverPackagePath_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_spoolss_GetPrinterDriverPackagePath_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.driver_package_cab && state->tmp.out.driver_package_cab) {
		{
			size_t _copy_len_driver_package_cab;
			_copy_len_driver_package_cab = ndr_charset_length(state->tmp.out.driver_package_cab, CH_UNIX);
			if (_copy_len_driver_package_cab > ndr_charset_length(state->tmp.in.driver_package_cab, CH_UNIX)) {
				tevent_req_nterror(req, NT_STATUS_INVALID_NETWORK_RESPONSE);
				return;
			}
			memcpy(discard_const_p(uint8_t *, state->orig.out.driver_package_cab), state->tmp.out.driver_package_cab, _copy_len_driver_package_cab * sizeof(*state->orig.out.driver_package_cab));
		}
	}
	*state->orig.out.required = *state->tmp.out.required;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_spoolss_GetPrinterDriverPackagePath_recv(struct tevent_req *req,
							 TALLOC_CTX *mem_ctx,
							 WERROR *result)
{
	struct dcerpc_spoolss_GetPrinterDriverPackagePath_state *state = tevent_req_data(
		req, struct dcerpc_spoolss_GetPrinterDriverPackagePath_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_spoolss_GetPrinterDriverPackagePath(struct dcerpc_binding_handle *h,
						    TALLOC_CTX *mem_ctx,
						    const char *_servername /* [in] [unique,charset(UTF16)] */,
						    const char *_architecture /* [in] [ref,charset(UTF16)] */,
						    const char *_language /* [in] [unique,charset(UTF16)] */,
						    const char *_package_id /* [in] [ref,charset(UTF16)] */,
						    const char *_driver_package_cab /* [in,out] [unique,charset(UTF16),size_is(driver_package_cab_size)] */,
						    uint32_t _driver_package_cab_size /* [in]  */,
						    uint32_t *_required /* [out] [ref] */,
						    WERROR *result)
{
	struct spoolss_GetPrinterDriverPackagePath r;
	NTSTATUS status;

	/* In parameters */
	r.in.servername = _servername;
	r.in.architecture = _architecture;
	r.in.language = _language;
	r.in.package_id = _package_id;
	r.in.driver_package_cab = _driver_package_cab;
	r.in.driver_package_cab_size = _driver_package_cab_size;

	status = dcerpc_spoolss_GetPrinterDriverPackagePath_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_driver_package_cab && r.out.driver_package_cab) {
		{
			size_t _copy_len_driver_package_cab;
			_copy_len_driver_package_cab = ndr_charset_length(r.out.driver_package_cab, CH_UNIX);
			if (_copy_len_driver_package_cab > ndr_charset_length(r.in.driver_package_cab, CH_UNIX)) {
				return NT_STATUS_INVALID_NETWORK_RESPONSE;
			}
			memcpy(discard_const_p(uint8_t *, _driver_package_cab), r.out.driver_package_cab, _copy_len_driver_package_cab * sizeof(*_driver_package_cab));
		}
	}
	*_required = *r.out.required;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

