/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : Draw.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/01/16
 *    Last                 : 2007/11/08
 * ====================================================================
 */
#ifndef __DRAW_H__
#define __DRAW_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */
#define DMPAPER_A4				1
#define DMORIENT_LANDSCAPE		2
#define DMORIENT_PORTRAIT		3
#define DMPAPER_A3				4
#define DMPAPER_B4				5
#define DMPAPER_B5				6




/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _DRAW_
#define   GLOBAL
// 初期値設定
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// 初期値設定の代入部分を無くす
#define   GLOBAL_VAL(v)  /* */
#endif




#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _DRAW_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */

gint view_port_set(gdouble vx1, gdouble vy1, gdouble vx2, gdouble vy2);
gint world_window_set_center(gdouble mag, gdouble mag_x, gdouble mag_y, gdouble view_x);

void Draw(GtkWidget *widget);
int ToDeviceX(double x);
int ToDeviceY(double y);
double ToViewX(int x);
double ToViewY(int y);

GdkGC *create_gc(GtkWidget *w);
void delete_gc(GdkGC *gc);
int PenSet(GdkGC *gc, int style, long color);
int PenSet_with_back(GdkGC *gc, int style, long color, long backcolor);
int PenDelete(GdkGC *gc);

int CircleDraw(GtkWidget *widget, double CX, double CY, double R, int Style, long color);
int ArcDraw(GtkWidget *widget, double CX, double CY, double R, double SX, double SY, double EX, double EY, int Style, long color);
int LineDraw(GtkWidget *widget, double SX,double SY,double EX,double EY, int Style, long color);
int PointDraw(GtkWidget *widget, double x, double y, int Style, long color);

int open_spline_Basic(GtkWidget *widget, int n, VERTEX *vertex, int split, int style, long color);
int close_spline_Basic(GtkWidget *widget, int n, VERTEX *vertex, int split, int style, long color);
int b_spline_Basic(GtkWidget *widget, int n, VERTEX *vertex, double pitch, int style, long color);
int PolyLineDraw(GtkWidget *widget, POLYLINE *a, int frag);
int EllipseDraw(GtkWidget *widget, ELLIPSE *ellipse, int frag);

int PointCheckDraw(double *SX, double *SY);
int CircleCheckDraw(double *CX, double *CY, double *R);
int LineCheckDraw(double *SX, double *SY, double *EX, double *EY);
void MoveUp(void);
void MoveDown(void);
void MoveRight(void);
void MoveLeft(void);
void Redraw(void);
void UpDate(void);
void UpDate_widget(GtkWidget *widget);

void ZoomDown(void);
void ZoomUp(void);
void window_set(void);
void SetMag(double MagData);
int CircleK(GtkWidget *widget, double CX, double CY, double R, double SA, double EA, int Style, long color);
int LineK(GtkWidget *widget, double SX, double SY, double EX, double EY, int style, long color);
/* 楕円の表示 */
int EllipseK(GtkWidget *widget, ELLIPSE ellipse, int style, long color);
//int EllipseK(GtkWidget *widget, 
//			 double cx, double cy, double a, double b, 
//			 double sa, double ea, double angle , 
//			 int style, long color);
int WakuWakuDraw(GtkWidget *widget);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __DRAW_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : Draw.h
 * ====================================================================
 */
