/* Plagiat gallery creation tool for Jakub Steiner's O.R.I.G.I.N.A.L 
 * photo gallery.
 * Copyright (C) 2005 Robert Staudinger <robert.staudinger@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <string.h>
#include <glade/glade.h>
#include "pgt-prefs.h"
#include "pgt-utils.h"

struct _PgtPrefs {
	GObject parent;
	gboolean is_disposed;
	GladeXML *xml;
	GtkWidget *prefswin;
	GtkWidget *closebtn;
};

struct _PgtPrefsClass {
	GObjectClass parent;
};

static GObjectClass *pgt_prefs_parent_class = NULL;

static void
close_cb (GtkButton *button, 
	  PgtPrefs *self)
{
	g_assert (GTK_IS_WINDOW (self->prefswin));
	gtk_widget_destroy (self->prefswin);
}

static void
instance_init (PgtPrefs *self)
{

	self->is_disposed = FALSE;

	if (pgt_runs_from_srcdir ()) {
		self->xml = glade_xml_new ("../data/mainwin.glade", NULL, NULL); 
	}
	else {
		self->xml = glade_xml_new (PLAGIAT_DATADIR "/mainwin.glade", NULL, NULL);
	}
	self->prefswin = glade_xml_get_widget (self->xml, "prefswin");
	gtk_window_set_modal (GTK_WINDOW (self->prefswin), TRUE);	

	self->closebtn = glade_xml_get_widget (self->xml, "closebtn");
	g_signal_connect (self->closebtn, "clicked", G_CALLBACK (close_cb), self);
}

static void
instance_dispose (GObject *instance)
{
	PgtPrefs *self = PGT_PREFS (instance);

	if (self->is_disposed)
		return;

	self->is_disposed = TRUE;

	pgt_prefs_parent_class->dispose (G_OBJECT (self));
}

static void
class_init (PgtPrefsClass *klass)
{
	GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

	/* hook gobject vfuncs */
	gobject_class->dispose = instance_dispose;

	pgt_prefs_parent_class = (GObjectClass*) g_type_class_peek_parent (klass);
}

GType
pgt_prefs_get_gtype (void)
{
        static GType type = 0;
        if (!type) {
                static const GTypeInfo info = {
                        sizeof (PgtPrefsClass),
                        NULL,           /* base_init */
                        NULL,           /* base_finalize */
                        (GClassInitFunc) class_init,
                        NULL,           /* class_finalize */
                        NULL,           /* class_data */
                        sizeof (PgtPrefs),
                        0,              /* n_preallocs */
                        (GInstanceInitFunc) instance_init,
                };
                type = g_type_register_static (G_TYPE_OBJECT, "PgtPrefs", &info, (GTypeFlags)0);
        }
        return type;
}

PgtPrefs*   
pgt_prefs_new (void)
{
	return PGT_PREFS (g_object_new (PGT_TYPE_PREFS, NULL));
}

GtkWidget* 
pgt_prefs_get_window (PgtPrefs *self)
{
	return self->prefswin;
}

void 
pgt_prefs_connect_close (PgtPrefs *self, 
			     GCallback handler, 
			     gpointer data)
{
	g_signal_connect (self->prefswin, "delete-event", handler, data);
}
