/* Plagiat gallery creation tool for Jakub Steiner's O.R.I.G.I.N.A.L 
 * photo gallery.
 * Copyright (C) 2005 Robert Staudinger <robert.staudinger@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "pgt-calendar.h"
#include "pgt-utils.h"

struct _PgtCalendar {
	GtkDialog parent;
	gboolean is_disposed;
	GtkWidget *calendar;
};

struct _PgtCalendarClass {
	GtkDialogClass parent;
};

static GObjectClass *pgt_calendar_parent_class = NULL;

static void
instance_init (PgtCalendar *self)
{
	GtkWidget *closebtn = NULL;

	self->is_disposed = FALSE;

	g_object_set (self, "has-separator", FALSE, NULL);

	self->calendar = gtk_calendar_new ();
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (self)->vbox), self->calendar,
			    TRUE, TRUE, 0);
	gtk_widget_show (self->calendar);

	closebtn = gtk_button_new_from_stock (GTK_STOCK_CLOSE);
	gtk_dialog_add_action_widget (GTK_DIALOG (self), closebtn, GTK_RESPONSE_CLOSE);
	gtk_widget_show (closebtn);
}

static void
instance_dispose (GObject *instance)
{
	PgtCalendar *self = PGT_CALENDAR (instance);

	if (self->is_disposed)
		return;

	self->is_disposed = TRUE;

	pgt_calendar_parent_class->dispose (G_OBJECT (self));
}

static void
class_init (PgtCalendarClass *klass)
{
	GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

	/* hook gobject vfuncs */
	gobject_class->dispose = instance_dispose;

	pgt_calendar_parent_class = (GObjectClass*) g_type_class_peek_parent (klass);
}

GType
pgt_calendar_get_gtype (void)
{
        static GType type = 0;
        if (!type) {
                static const GTypeInfo info = {
                        sizeof (PgtCalendarClass),
                        NULL,           /* base_init */
                        NULL,           /* base_finalize */
                        (GClassInitFunc) class_init,
                        NULL,           /* class_finalize */
                        NULL,           /* class_data */
                        sizeof (PgtCalendar),
                        0,              /* n_preallocs */
                        (GInstanceInitFunc) instance_init,
                };
                type = g_type_register_static (GTK_TYPE_DIALOG, "PgtCalendar", &info, (GTypeFlags)0);
        }
        return type;
}

PgtCalendar*   
pgt_calendar_new (void)
{
	PgtCalendar *calendar = PGT_CALENDAR (g_object_new (PGT_TYPE_CALENDAR, NULL));
	return calendar;
}

void 
pgt_calendar_get_date (PgtCalendar *self, 
		       guint *year, 
		       guint *month, 
		       guint *day)
{
	gtk_calendar_get_date (GTK_CALENDAR (self->calendar), year, month, day);
}
