# Copyright 2015 Canonical Ltd
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

import contextlib

import mock

from nova import test
from nova.virt import fake

from nova_lxd.nova.virt.lxd import container_client
from nova_lxd.nova.virt.lxd import container_migrate
from nova_lxd.nova.virt.lxd import container_utils
from nova_lxd.tests import stubs


@mock.patch.object(container_migrate, 'CONF', stubs.MockConf())
class LXDTestContainerMigrate(test.NoDBTestCase):

    @mock.patch.object(container_migrate, 'CONF', stubs.MockConf())
    def setUp(self):
        super(LXDTestContainerMigrate, self).setUp()

        self.migrate = container_migrate.LXDContainerMigrate(
            fake.FakeVirtAPI())

    def test_finish_migration(self):
        context = mock.Mock()
        migration = {'source_compute': 'fake-source',
                     'dest_compute': 'fake-dest'}
        instance = stubs._fake_instance()
        bdevice_info = mock.Mock()
        disk_info = mock.Mock()
        network_info = mock.Mock()
        with contextlib.nested(
            mock.patch.object(container_client.LXDContainerClient,
                              'client'),
            mock.patch.object(container_utils.LXDContainerUtils,
                              'container_stop'),
            mock.patch.object(container_utils.LXDContainerUtils,
                              'container_init'),
            mock.patch.object(container_utils.LXDContainerUtils,
                              'container_destroy'),
        ) as (
            container_defined,
            container_stop,
            container_init,
            container_destroy
        ):
            self.assertEqual(None,
                             (self.migrate.finish_migration(context,
                                                            migration,
                                                            instance,
                                                            disk_info,
                                                            network_info,
                                                            bdevice_info)))
