This package provides common data structures used by all Lezer-related
parsing—those related to syntax trees and the generic interface of
parsers. Their main use is the [LR](#lr) parsers generated by the
[parser generator](#generator), but for example the [Markdown
parser](https://github.com/lezer-parser/markdown) implements a
different parsing algorithm using the same interfaces.

### Trees

Lezer syntax trees are _not_ abstract, they just tell you which nodes
were parsed where, without providing additional information about
their role or relation (beyond parent-child relations). This makes
them rather unsuited for some purposes, but quick to construct and
cheap to store.

@Tree

@SyntaxNodeRef

@SyntaxNode

@TreeCursor

@IterMode

@NodeWeakMap

#### Node types

@NodeType

@NodeSet

@NodeProp

@NodePropSource

#### Buffers

Buffers are an optimization in the way Lezer trees are stored.

@TreeBuffer

@DefaultBufferLength

@BufferCursor

### Parsing

@Parser

@Input

@PartialParse

@ParseWrapper

### Incremental Parsing

Efficient reparsing happens by reusing parts of the original parsed
structure.

@TreeFragment

@ChangedRange

### Mixed Parsing

@parseMixed

@NestedParse

@MountedTree
