# -*- coding: utf-8 -*-
# -*- coding: utf8 -*-
"""Autogenerated file - DO NOT EDIT
If you spot a bug, please report it on the mailing list and/or change the generator."""

from nipype.interfaces.base import CommandLine, CommandLineInputSpec, SEMLikeCommandLine, TraitedSpec, File, Directory, traits, isdefined, InputMultiPath, OutputMultiPath
import os


class ResampleDTIVolumeInputSpec(CommandLineInputSpec):
    inputVolume = File(position=-2, desc="Input volume to be resampled", exists=True, argstr="%s")
    outputVolume = traits.Either(traits.Bool, File(), position=-1, hash_files=False, desc="Resampled Volume", argstr="%s")
    Reference = File(desc="Reference Volume (spacing,size,orientation,origin)", exists=True, argstr="--Reference %s")
    transformationFile = File(exists=True, argstr="--transformationFile %s")
    defField = File(desc="File containing the deformation field (3D vector image containing vectors with 3 components)", exists=True, argstr="--defField %s")
    hfieldtype = traits.Enum("displacement", "h-Field", desc="Set if the deformation field is an -Field", argstr="--hfieldtype %s")
    interpolation = traits.Enum("linear", "nn", "ws", "bs", desc="Sampling algorithm (linear , nn (nearest neighborhoor), ws (WindowedSinc), bs (BSpline) )", argstr="--interpolation %s")
    correction = traits.Enum("zero", "none", "abs", "nearest", desc="Correct the tensors if computed tensor is not semi-definite positive", argstr="--correction %s")
    transform_tensor_method = traits.Enum("PPD", "FS", desc="Chooses between 2 methods to transform the tensors: Finite Strain (FS), faster but less accurate, or Preservation of the Principal Direction (PPD)", argstr="--transform_tensor_method %s")
    transform_order = traits.Enum("input-to-output", "output-to-input", desc="Select in what order the transforms are read", argstr="--transform_order %s")
    notbulk = traits.Bool(desc="The transform following the BSpline transform is not set as a bulk transform for the BSpline transform", argstr="--notbulk ")
    spaceChange = traits.Bool(desc="Space Orientation between transform and image is different (RAS/LPS) (warning: if the transform is a Transform Node in Slicer3, do not select)", argstr="--spaceChange ")
    rotation_point = traits.List(desc="Center of rotation (only for rigid and affine transforms)", argstr="--rotation_point %s")
    centered_transform = traits.Bool(desc="Set the center of the transformation to the center of the input image (only for rigid and affine transforms)", argstr="--centered_transform ")
    image_center = traits.Enum("input", "output", desc="Image to use to center the transform (used only if \'Centered Transform\' is selected)", argstr="--image_center %s")
    Inverse_ITK_Transformation = traits.Bool(desc="Inverse the transformation before applying it from output image to input image (only for rigid and affine transforms)", argstr="--Inverse_ITK_Transformation ")
    spacing = InputMultiPath(traits.Float, desc="Spacing along each dimension (0 means use input spacing)", sep=",", argstr="--spacing %s")
    size = InputMultiPath(traits.Float, desc="Size along each dimension (0 means use input size)", sep=",", argstr="--size %s")
    origin = traits.List(desc="Origin of the output Image", argstr="--origin %s")
    direction_matrix = InputMultiPath(traits.Float, desc="9 parameters of the direction matrix by rows (ijk to LPS if LPS transform, ijk to RAS if RAS transform)", sep=",", argstr="--direction_matrix %s")
    number_of_thread = traits.Int(desc="Number of thread used to compute the output image", argstr="--number_of_thread %d")
    default_pixel_value = traits.Float(desc="Default pixel value for samples falling outside of the input region", argstr="--default_pixel_value %f")
    window_function = traits.Enum("h", "c", "w", "l", "b", desc="Window Function , h = Hamming , c = Cosine , w = Welch , l = Lanczos , b = Blackman", argstr="--window_function %s")
    spline_order = traits.Int(desc="Spline Order (Spline order may be from 0 to 5)", argstr="--spline_order %d")
    transform_matrix = InputMultiPath(traits.Float, desc="12 parameters of the transform matrix by rows ( --last 3 being translation-- )", sep=",", argstr="--transform_matrix %s")
    transform = traits.Enum("rt", "a", desc="Transform algorithm, rt = Rigid Transform, a = Affine Transform", argstr="--transform %s")


class ResampleDTIVolumeOutputSpec(TraitedSpec):
    outputVolume = File(position=-1, desc="Resampled Volume", exists=True)


class ResampleDTIVolume(SEMLikeCommandLine):
    """title: Resample DTI Volume

category: Diffusion.Diffusion Tensor Images

description: Resampling an image is a very important task in image analysis. It is especially important in the frame of image registration. This module implements DT image resampling through the use of itk Transforms. The resampling is controlled by the Output Spacing. "Resampling" is performed in space coordinates, not pixel/grid coordinates. It is quite important to ensure that image spacing is properly set on the images involved. The interpolator is required since the mapping from one space to the other will often require evaluation of the intensity of the image at non-grid positions.

version: 0.1

documentation-url: http://wiki.slicer.org/slicerWiki/index.php/Documentation/4.1/Modules/ResampleDTI

contributor: Francois Budin (UNC)

acknowledgements: This work is part of the National Alliance for Medical Image Computing (NAMIC), funded by the National Institutes of Health through the NIH Roadmap for Medical Research, Grant U54 EB005149. Information on the National Centers for Biomedical Computing can be obtained from http://nihroadmap.nih.gov/bioinformatics

"""

    input_spec = ResampleDTIVolumeInputSpec
    output_spec = ResampleDTIVolumeOutputSpec
    _cmd = "ResampleDTIVolume "
    _outputs_filenames = {'outputVolume': 'outputVolume.nii'}


class DWIRicianLMMSEFilterInputSpec(CommandLineInputSpec):
    iter = traits.Int(desc="Number of iterations for the noise removal filter.", argstr="--iter %d")
    re = InputMultiPath(traits.Int, desc="Estimation radius.", sep=",", argstr="--re %s")
    rf = InputMultiPath(traits.Int, desc="Filtering radius.", sep=",", argstr="--rf %s")
    mnvf = traits.Int(desc="Minimum number of voxels in kernel used for filtering.", argstr="--mnvf %d")
    mnve = traits.Int(desc="Minimum number of voxels in kernel used for estimation.", argstr="--mnve %d")
    minnstd = traits.Int(desc="Minimum allowed noise standard deviation.", argstr="--minnstd %d")
    maxnstd = traits.Int(desc="Maximum allowed noise standard deviation.", argstr="--maxnstd %d")
    hrf = traits.Float(desc="How many histogram bins per unit interval.", argstr="--hrf %f")
    uav = traits.Bool(desc="Use absolute value in case of negative square.", argstr="--uav ")
    inputVolume = File(position=-2, desc="Input DWI volume.", exists=True, argstr="%s")
    outputVolume = traits.Either(traits.Bool, File(), position=-1, hash_files=False, desc="Output DWI volume.", argstr="%s")
    compressOutput = traits.Bool(desc="Compress the data of the compressed file using gzip", argstr="--compressOutput ")


class DWIRicianLMMSEFilterOutputSpec(TraitedSpec):
    outputVolume = File(position=-1, desc="Output DWI volume.", exists=True)


class DWIRicianLMMSEFilter(SEMLikeCommandLine):
    """title: DWI Rician LMMSE Filter

category: Diffusion.Diffusion Weighted Images

description: This module reduces noise (or unwanted detail) on a set of diffusion weighted images. For this, it filters the image in the mean squared error sense using a Rician noise model. Images corresponding to each gradient direction, including baseline, are processed individually. The noise parameter is automatically estimated (noise estimation improved but slower).
Note that this is a general purpose filter for MRi images. The module jointLMMSE has been specifically designed for DWI volumes and shows a better performance, so its use is recommended instead.
A complete description of the algorithm in this module can be found in:
S. Aja-Fernandez, M. Niethammer, M. Kubicki, M. Shenton, and C.-F. Westin. Restoration of DWI data using a Rician LMMSE estimator. IEEE Transactions on Medical Imaging, 27(10): pp. 1389-1403, Oct. 2008.

version: 0.1.1.$Revision: 1 $(alpha)

documentation-url: http://wiki.slicer.org/slicerWiki/index.php/Documentation/4.1/Modules/RicianLMMSEImageFilter

contributor: Antonio Tristan Vega (UVa), Santiago Aja Fernandez (UVa), Marc Niethammer (UNC)

acknowledgements: Partially founded by grant number TEC2007-67073/TCM from the Comision Interministerial de Ciencia y Tecnologia (Spain).

"""

    input_spec = DWIRicianLMMSEFilterInputSpec
    output_spec = DWIRicianLMMSEFilterOutputSpec
    _cmd = "DWIRicianLMMSEFilter "
    _outputs_filenames = {'outputVolume': 'outputVolume.nii'}


class TractographyLabelMapSeedingInputSpec(CommandLineInputSpec):
    InputVolume = File(position=-2, desc="Input DTI volume", exists=True, argstr="%s")
    inputroi = File(desc="Label map with seeding ROIs", exists=True, argstr="--inputroi %s")
    OutputFibers = traits.Either(traits.Bool, File(), position=-1, hash_files=False, desc="Tractography result", argstr="%s")
    useindexspace = traits.Bool(desc="Seed at IJK voxel grid", argstr="--useindexspace ")
    seedspacing = traits.Float(desc="Spacing (in mm) between seed points, only matters if use Use Index Space is off", argstr="--seedspacing %f")
    randomgrid = traits.Bool(desc="Enable random placing of seeds", argstr="--randomgrid ")
    clthreshold = traits.Float(desc="Minimum Linear Measure for the seeding to start.", argstr="--clthreshold %f")
    minimumlength = traits.Float(desc="Minimum length of the fibers (in mm)", argstr="--minimumlength %f")
    maximumlength = traits.Float(desc="Maximum length of fibers (in mm)", argstr="--maximumlength %f")
    stoppingmode = traits.Enum("LinearMeasure", "FractionalAnisotropy", desc="Tensor measurement used to stop the tractography", argstr="--stoppingmode %s")
    stoppingvalue = traits.Float(desc="Tractography will stop when the stopping measurement drops below this value", argstr="--stoppingvalue %f")
    stoppingcurvature = traits.Float(desc="Tractography will stop if radius of curvature becomes smaller than this number units are degrees per mm", argstr="--stoppingcurvature %f")
    integrationsteplength = traits.Float(desc="Distance between points on the same fiber in mm", argstr="--integrationsteplength %f")
    label = traits.Int(desc="Label value that defines seeding region.", argstr="--label %d")
    writetofile = traits.Bool(desc="Write fibers to disk or create in the scene?", argstr="--writetofile ")
    outputdirectory = traits.Either(traits.Bool, Directory(), hash_files=False, desc="Directory in which to save fiber(s)", argstr="--outputdirectory %s")
    name = traits.Str(desc="Name to use for fiber files", argstr="--name %s")


class TractographyLabelMapSeedingOutputSpec(TraitedSpec):
    OutputFibers = File(position=-1, desc="Tractography result", exists=True)
    outputdirectory = Directory(desc="Directory in which to save fiber(s)", exists=True)


class TractographyLabelMapSeeding(SEMLikeCommandLine):
    """title: Tractography Label Map Seeding

category: Diffusion.Diffusion Tensor Images

description: Seed tracts on a Diffusion Tensor Image (DT) from a label map

version: 0.1.0.$Revision: 1892 $(alpha)

documentation-url: http://wiki.slicer.org/slicerWiki/index.php/Documentation/4.1/Modules/Seeding

license: slicer3

contributor: Raul San Jose (SPL, BWH), Demian Wassermann (SPL, BWH)

acknowledgements: Laboratory of Mathematics in Imaging. This work is part of the National Alliance for Medical Image Computing (NAMIC), funded by the National Institutes of Health through the NIH Roadmap for Medical Research, Grant U54 EB005149.

"""

    input_spec = TractographyLabelMapSeedingInputSpec
    output_spec = TractographyLabelMapSeedingOutputSpec
    _cmd = "TractographyLabelMapSeeding "
    _outputs_filenames = {'OutputFibers': 'OutputFibers.vtk', 'outputdirectory': 'outputdirectory'}


class DWIJointRicianLMMSEFilterInputSpec(CommandLineInputSpec):
    re = InputMultiPath(traits.Int, desc="Estimation radius.", sep=",", argstr="--re %s")
    rf = InputMultiPath(traits.Int, desc="Filtering radius.", sep=",", argstr="--rf %s")
    ng = traits.Int(desc="The number of the closest gradients that are used to jointly filter a given gradient direction (0 to use all).", argstr="--ng %d")
    inputVolume = File(position=-2, desc="Input DWI volume.", exists=True, argstr="%s")
    outputVolume = traits.Either(traits.Bool, File(), position=-1, hash_files=False, desc="Output DWI volume.", argstr="%s")
    compressOutput = traits.Bool(desc="Compress the data of the compressed file using gzip", argstr="--compressOutput ")


class DWIJointRicianLMMSEFilterOutputSpec(TraitedSpec):
    outputVolume = File(position=-1, desc="Output DWI volume.", exists=True)


class DWIJointRicianLMMSEFilter(SEMLikeCommandLine):
    """title: DWI Joint Rician LMMSE Filter

category: Diffusion.Diffusion Weighted Images

description: This module reduces Rician noise (or unwanted detail) on a set of diffusion weighted images. For this, it filters the image in the mean squared error sense using a Rician noise model. The N closest gradient directions to the direction being processed are filtered together to improve the results: the noise-free signal is seen as an n-diemensional vector which has to be estimated with the LMMSE method from a set of corrupted measurements. To that end, the covariance matrix of the noise-free vector and the cross covariance between this signal and the noise have to be estimated, which is done taking into account the image formation process.
The noise parameter is automatically estimated from a rough segmentation of the background of the image. In this area the signal is simply 0, so that Rician statistics reduce to Rayleigh and the noise power can be easily estimated from the mode of the histogram.
A complete description of the algorithm may be found in:
Antonio Tristan-Vega and Santiago Aja-Fernandez, DWI filtering using joint information for DTI and HARDI, Medical Image Analysis, Volume 14, Issue 2, Pages 205-218. 2010.

version: 0.1.1.$Revision: 1 $(alpha)

documentation-url: http://wiki.slicer.org/slicerWiki/index.php/Documentation/4.1/Modules/JointRicianLMMSEImageFilter

contributor: Antonio Tristan Vega (UVa), Santiago Aja Fernandez (UVa)

acknowledgements: Partially founded by grant number TEC2007-67073/TCM from the Comision Interministerial de Ciencia y Tecnologia (Spain).

"""

    input_spec = DWIJointRicianLMMSEFilterInputSpec
    output_spec = DWIJointRicianLMMSEFilterOutputSpec
    _cmd = "DWIJointRicianLMMSEFilter "
    _outputs_filenames = {'outputVolume': 'outputVolume.nii'}


class DiffusionWeightedVolumeMaskingInputSpec(CommandLineInputSpec):
    inputVolume = File(position=-4, desc="Input DWI volume", exists=True, argstr="%s")
    outputBaseline = traits.Either(traits.Bool, File(), position=-2, hash_files=False, desc="Estimated baseline volume", argstr="%s")
    thresholdMask = traits.Either(traits.Bool, File(), position=-1, hash_files=False, desc="Otsu Threshold Mask", argstr="%s")
    otsuomegathreshold = traits.Float(desc="Control the sharpness of the threshold in the Otsu computation. 0: lower threshold, 1: higher threhold", argstr="--otsuomegathreshold %f")
    removeislands = traits.Bool(desc="Remove Islands in Threshold Mask?", argstr="--removeislands ")


class DiffusionWeightedVolumeMaskingOutputSpec(TraitedSpec):
    outputBaseline = File(position=-2, desc="Estimated baseline volume", exists=True)
    thresholdMask = File(position=-1, desc="Otsu Threshold Mask", exists=True)


class DiffusionWeightedVolumeMasking(SEMLikeCommandLine):
    """title: Diffusion Weighted Volume Masking

category: Diffusion.Diffusion Weighted Images

description: <p>Performs a mask calculation from a diffusion weighted (DW) image.</p><p>Starting from a dw image, this module computes the baseline image averaging all the images without diffusion weighting and then applies the otsu segmentation algorithm in order to produce a mask. this mask can then be used when estimating the diffusion tensor (dt) image, not to estimate tensors all over the volume.</p>

version: 0.1.0.$Revision: 1892 $(alpha)

documentation-url: http://wiki.slicer.org/slicerWiki/index.php/Documentation/4.1/Modules/DiffusionWeightedMasking

license: slicer3

contributor: Demian Wassermann (SPL, BWH)

"""

    input_spec = DiffusionWeightedVolumeMaskingInputSpec
    output_spec = DiffusionWeightedVolumeMaskingOutputSpec
    _cmd = "DiffusionWeightedVolumeMasking "
    _outputs_filenames = {'outputBaseline': 'outputBaseline.nii', 'thresholdMask': 'thresholdMask.nii'}


class DTIimportInputSpec(CommandLineInputSpec):
    inputFile = File(position=-2, desc="Input DTI file", exists=True, argstr="%s")
    outputTensor = traits.Either(traits.Bool, File(), position=-1, hash_files=False, desc="Output DTI volume", argstr="%s")
    testingmode = traits.Bool(desc="Enable testing mode. Sample helix file (helix-DTI.nhdr) will be loaded into Slicer and converted in Nifti.", argstr="--testingmode ")


class DTIimportOutputSpec(TraitedSpec):
    outputTensor = File(position=-1, desc="Output DTI volume", exists=True)


class DTIimport(SEMLikeCommandLine):
    """title: DTIimport

category: Diffusion.Diffusion Data Conversion

description: Import tensor datasets from various formats, including the NifTi file format

version: 1.0

documentation-url: http://wiki.slicer.org/slicerWiki/index.php/Documentation/4.1/Modules/DTIImport

contributor: Sonia Pujol (SPL, BWH)

acknowledgements: This work is part of the National Alliance for Medical Image Computing (NA-MIC), funded by the National Institutes of Health through the NIH Roadmap for Medical Research, Grant U54 EB005149.

"""

    input_spec = DTIimportInputSpec
    output_spec = DTIimportOutputSpec
    _cmd = "DTIimport "
    _outputs_filenames = {'outputTensor': 'outputTensor.nii'}


class DWIToDTIEstimationInputSpec(CommandLineInputSpec):
    inputVolume = File(position=-3, desc="Input DWI volume", exists=True, argstr="%s")
    mask = File(desc="Mask where the tensors will be computed", exists=True, argstr="--mask %s")
    outputTensor = traits.Either(traits.Bool, File(), position=-2, hash_files=False, desc="Estimated DTI volume", argstr="%s")
    outputBaseline = traits.Either(traits.Bool, File(), position=-1, hash_files=False, desc="Estimated baseline volume", argstr="%s")
    enumeration = traits.Enum("LS", "WLS", desc="LS: Least Squares, WLS: Weighted Least Squares", argstr="--enumeration %s")
    shiftNeg = traits.Bool(desc="Shift eigenvalues so all are positive (accounts for bad tensors related to noise or acquisition error)", argstr="--shiftNeg ")


class DWIToDTIEstimationOutputSpec(TraitedSpec):
    outputTensor = File(position=-2, desc="Estimated DTI volume", exists=True)
    outputBaseline = File(position=-1, desc="Estimated baseline volume", exists=True)


class DWIToDTIEstimation(SEMLikeCommandLine):
    """title: DWI to DTI Estimation

category: Diffusion.Diffusion Weighted Images

description: Performs a tensor model estimation from diffusion weighted images.

There are three estimation methods available: least squares, weigthed least squares and non-linear estimation. The first method is the traditional method for tensor estimation and the fastest one. Weighted least squares takes into account the noise characteristics of the MRI images to weight the DWI samples used in the estimation based on its intensity magnitude. The last method is the more complex.

version: 0.1.0.$Revision: 1892 $(alpha)

documentation-url: http://wiki.slicer.org/slicerWiki/index.php/Documentation/4.1/Modules/DiffusionTensorEstimation

license: slicer3

contributor: Raul San Jose (SPL, BWH)

acknowledgements: This command module is based on the estimation functionality provided by the Teem library. This work is part of the National Alliance for Medical Image Computing (NAMIC), funded by the National Institutes of Health through the NIH Roadmap for Medical Research, Grant U54 EB005149.

"""

    input_spec = DWIToDTIEstimationInputSpec
    output_spec = DWIToDTIEstimationOutputSpec
    _cmd = "DWIToDTIEstimation "
    _outputs_filenames = {'outputTensor': 'outputTensor.nii', 'outputBaseline': 'outputBaseline.nii'}


class DiffusionTensorScalarMeasurementsInputSpec(CommandLineInputSpec):
    inputVolume = File(position=-3, desc="Input DTI volume", exists=True, argstr="%s")
    outputScalar = traits.Either(traits.Bool, File(), position=-1, hash_files=False, desc="Scalar volume derived from tensor", argstr="%s")
    enumeration = traits.Enum("Trace", "Determinant", "RelativeAnisotropy", "FractionalAnisotropy", "Mode", "LinearMeasure", "PlanarMeasure", "SphericalMeasure", "MinEigenvalue", "MidEigenvalue", "MaxEigenvalue", "MaxEigenvalueProjectionX", "MaxEigenvalueProjectionY", "MaxEigenvalueProjectionZ", "RAIMaxEigenvecX", "RAIMaxEigenvecY", "RAIMaxEigenvecZ", "MaxEigenvecX", "MaxEigenvecY", "MaxEigenvecZ", "D11", "D22", "D33", "ParallelDiffusivity", "PerpendicularDffusivity", desc="An enumeration of strings", argstr="--enumeration %s")


class DiffusionTensorScalarMeasurementsOutputSpec(TraitedSpec):
    outputScalar = File(position=-1, desc="Scalar volume derived from tensor", exists=True)


class DiffusionTensorScalarMeasurements(SEMLikeCommandLine):
    """title: Diffusion Tensor Scalar Measurements

category: Diffusion.Diffusion Tensor Images

description: Compute a set of different scalar measurements from a tensor field, specially oriented for Diffusion Tensors where some rotationally invariant measurements, like Fractional Anisotropy, are highly used to describe the anistropic behaviour of the tensor.

version: 0.1.0.$Revision: 1892 $(alpha)

documentation-url: http://wiki.slicer.org/slicerWiki/index.php/Documentation/4.1/Modules/DiffusionTensorMathematics

contributor: Raul San Jose (SPL, BWH)

acknowledgements: LMI

"""

    input_spec = DiffusionTensorScalarMeasurementsInputSpec
    output_spec = DiffusionTensorScalarMeasurementsOutputSpec
    _cmd = "DiffusionTensorScalarMeasurements "
    _outputs_filenames = {'outputScalar': 'outputScalar.nii'}


class DTIexportInputSpec(CommandLineInputSpec):
    inputTensor = File(position=-2, desc="Input DTI volume", exists=True, argstr="%s")
    outputFile = traits.Either(traits.Bool, File(), position=-1, hash_files=False, desc="Output DTI file", argstr="%s")


class DTIexportOutputSpec(TraitedSpec):
    outputFile = File(position=-1, desc="Output DTI file", exists=True)


class DTIexport(SEMLikeCommandLine):
    """title: DTIexport

category: Diffusion.Diffusion Data Conversion

description: Export DTI data to various file formats

version: 1.0

documentation-url: http://wiki.slicer.org/slicerWiki/index.php/Documentation/4.1/Modules/DTIExport

contributor: Sonia Pujol (SPL, BWH)

acknowledgements: This work is part of the National Alliance for Medical Image Computing (NA-MIC), funded by the National Institutes of Health through the NIH Roadmap for Medical Research, Grant U54 EB005149.

"""

    input_spec = DTIexportInputSpec
    output_spec = DTIexportOutputSpec
    _cmd = "DTIexport "
    _outputs_filenames = {'outputFile': 'outputFile'}
