#!/usr/bin/perl

use strict;
use CGI qw(:standard);
use HTML::Template;
use MythTV;
use Config::Simple; 

require includes;

my $file = "/etc/mythtv/mythexport/mythexport_settings.cfg";
my $content = "";
my $template = HTML::Template->new(filename => 'template/template.tmpl');

# if we have a valid config
if(-e $file && -s $file > 207){
    my $cfg = new Config::Simple();
    $cfg->read($file) || die $cfg->error();
    my $connect = undef;

    my $myth = new MythTV();
    # connect to database
    $connect = $myth->{'dbh'};

    my $test = $cfg->as_string();
    $test =~ s/\n//g;
    $test =~ s/^(.*?)\[//;
    $test =~ s/\](.*?)\[/,/g;
    $test =~ s/\](.*?)$//;

    my @blocks = split(",", $test);

    # find the old recordings
    my $query = "SELECT data from settings where value like ?";
    my $query_handle = $connect->prepare($query);
    $query_handle->execute("UserJobDesc%")  || die "Unable to query mythexport_job_queue table";

    $content = "<form id=\"form\" action=\"save_userjob.cgi\" method=\"post\"><p>Select a User Jobs:<br />";
    my $i = 1;
    while ( my ($description) = $query_handle->fetchrow_array() ) {
	    $content .= "<input type=\"radio\" id=\"radio$i\" name=\"userjobs\" value=\"$i\" />$description<br />";
	    $i++;
    }

    $content .= "<br />Choose a configuration: <select id=\"block\" name=\"block\">";

    foreach(@blocks){
	    $content .= "<option value=\"$_\">$_</option>";
    }

    $content .= "</select><br />
    Description: <input type=\"text\" id=\"description\" name=\"description\" value=\"\" /><br />
    <br />*WARNING: Proceeding will overwrite any data for this User Job<br />
    <br /><input type=\"submit\" id=\"submitButton\" name=\"submitButton\" value=\"Submit\" /></p></form></table>";
}
else{
    $content = "<p>Missing or Invalid configuration file, please create one.</p>";
}

$template->param(CONTENT => $content);
$template->param(LOCATION => "file");

print generateContentType(), $template->output;
exit(0);
