# -*- coding: utf-8; Mode: Python; indent-tabs-mode: nil; tab-width: 4 -*-
#
# Copyright (C) 2006, 2007, 2009 Canonical Ltd.
# Written by Colin Watson <cjwatson@ubuntu.com>.
# Copyright (C) 2007-2010 Mario Limonciello
#
# This file is part of Ubiquity.
#
# Ubiquity is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# Ubiquity is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Ubiquity.  If not, see <http://www.gnu.org/licenses/>.

from ubiquity.misc import execute_root
from mythbuntu_common.installer import MythPageGtk
from ubiquity.plugin import *
import os

#TODO, fix this plugin
# Disable for now, mythbuntu-setup needs to be fixed to work with mythtv
# from outside the chroot now
#NAME = 'myth-backend-setup'
#AFTER = 'myth-passwords'
#WEIGHT = 10
#HIDDEN = 'migrationassistant'

class PageGtk(MythPageGtk):
    plugin_title = 'ubiquity/text/setup_heading_label'

    def __init__(self, controller, *args, **kwargs):
        self.ui_file='mythbuntu_stepBackendSetup'
        self.backend = False
        self.setup_launched = False
        MythPageGtk.__init__(self,controller, *args, **kwargs)

    def plugin_get_current_page(self):
        if not self.backend:
            self.controller.go_forward()
            self.plugin_widgets = gtk.VBox()
        return self.plugin_widgets

    def do_mythtv_setup(self, widget):
        """Spawn MythTV-Setup binary."""
        self.controller.toggle_top_level()
        execute_root("/usr/share/ubiquity/mythbuntu-setup")
        self.setup_launched = True
        self.controller.toggle_top_level()

    def set_backend(self, status):
        """Marks this install as a backend"""
        self.backend = status
        #if not self.backend:
        #    self.controller.go_forward()

    def get_setup_launched(self):
        """Determines if mythtv-setup was launched"""
        if self.plugin_widgets:
            self.plugin_widgets.set_sensitive(False)
        return self.setup_launched

class Page(Plugin):
    def prepare(self):
        answer = self.db.get('mythbuntu/install_type')
        self.ui.set_backend('Backend' in answer)
        return (['/usr/share/ubiquity/ask-mythbuntu','setup'], ['^mythbuntu/setup-launched'])

    def ok_handler(self):
        self.preseed_bool('mythbuntu/setup-launched',self.ui.get_setup_launched())
        Plugin.ok_handler(self)
