## -*- coding: utf-8 -*-
#
# «MythExport» - A MythExport Plugin for MCC
#
# Copyright (C) 2009, John Baab, for Mythbuntu
#
#
# Mythbuntu is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this application; if not, write to the Free Software Foundation, Inc., 51
# Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##################################################################################

from MythbuntuControlCentre.plugin import MCCPlugin
from gi.repository import Gtk
import os

class MythExportPlugin(MCCPlugin):
    """A plugin to enable or disable mythexport"""
    #
    #Load GUI & Calculate Changes
    #
    CONFIGFILE = "/etc/default/mythexport-install"

    def __init__(self):
        #Initialize parent class
        information = {}
        information["name"] = "MythExport"
        information["icon"] = "gtk-leave-fullscreen"
        information["ui"] = "tab_mythexport"
        MCCPlugin.__init__(self,information)
        import configparser
        self.config = configparser.ConfigParser()

    def captureState(self):
        """Determines the state of the items on managed by this plugin
           and stores it into the plugin's own internal structures"""
        import os
        self.changes = {}
        self.changes['mythexport'] = self.query_installed('mythexport')

        if os.path.exists(self.CONFIGFILE):
            self.config.read(self.CONFIGFILE)
            self.changes['dir'] = self.config.get("cfg", "dir")
        else:
            self.changes['dir'] = "/var/lib/mythtv/"

    def applyStateToGUI(self):
        """Takes the current state information and sets the GUI
           for this plugin"""
        self.mythexport_checkbox.set_active(self.changes['mythexport'])
        self.export_dir.set_current_folder(self.changes['dir'])
        if self.changes['mythexport']:
            self.configuration_linkbutton.show()
            self.export_dir.set_sensitive(True);
        else:
            self.configuration_linkbutton.hide()
            self.export_dir.set_sensitive(False);

    def compareState(self):
        """Determines what items have been modified on this plugin"""
        MCCPlugin.clearParentState(self)
        if self.mythexport_checkbox.get_active() != self.changes['mythexport']:
            if self.mythexport_checkbox.get_active():
                self._markInstall('mythexport') 
                self._markReconfigureRoot('dir',self.export_dir.get_filename())            
            else:
                self._markRemove('mythexport')
        elif self.mythexport_checkbox.get_active() == True and self.export_dir.get_filename() != self.changes['dir']:
            self._markReconfigureRoot('dir',self.export_dir.get_filename())

    #
    # Process selected activities
    #

    def root_scripted_changes(self,reconfigure):
        """System-wide changes that need root access to be applied.
           This function is ran by the dbus backend"""
        if os.path.exists(self.CONFIGFILE):
          self.config.read(self.CONFIGFILE)
        else:
          self.config.add_section("cfg")
        for item in reconfigure:
            self.config.set("cfg", item, reconfigure[item]) 

        with open(self.CONFIGFILE, 'w', encoding='utf8') as configfile:
          self.config.write(configfile)
        os.system("DEBIAN_FRONTEND=noninteractive dpkg-reconfigure mythexport")


