## -*- coding: utf-8 -*-
#
# «system_updates» - MCC Plugin for administration of updates
#
# Copyright (C) 2009, Mario Limonciello, for Mythbuntu
#
#
# Mythbuntu is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this application; if not, write to the Free Software Foundation, Inc., 51
# Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##################################################################################

from MythbuntuControlCentre.plugin import MCCPlugin
import os
from gi.repository import GConf
from gi.repository import GObject

UPDATE_NOTIFIER_KEY="/apps/update-notifier/auto_launch"

class SystemUpdatesPlugin(MCCPlugin):
    """A plugin for performing a series of updates"""

    def __init__(self):
        #Initialize parent class
        information = {}
        information["name"] = "System Updates"
        information["icon"] = "update-manager"
        information["ui"] = "tab_system_updates"
        self.user_count=0
        self.gconfclient = GConf.Client.get_default()
        MCCPlugin.__init__(self,information)

    def captureState(self):
        """Determines the state of the items on managed by this plugin
           and stores it into the plugin's own internal structures"""
        #Check packages installed for turning on a few buttons
        self.synaptic=self.query_installed('synaptic')
        self.updatemanager=self.query_installed('update-manager')
        try:
            self.update_manager_background = self.gconfclient.get_bool(UPDATE_NOTIFIER_KEY)
        except GObject.GError as e:
            logging.warning(_("Error pulling gconf status for update notifier"))
            self.update_manager_background = True

    def applyStateToGUI(self):
        """Takes the current state information and sets the GUI
           for this plugin"""
        self.synaptic_button.set_sensitive(self.synaptic)
        self.updatemanager_button.set_sensitive(self.updatemanager)
        if self.update_manager_background:
            self.background_radio.set_active(True)
        else:
            self.notification_icon_radio.set_active(True)

    def compareState(self):
        """Determines what items have been modified on this plugin"""
        #Prepare for state capturing
        MCCPlugin.clearParentState(self)

        if self.update_manager_background != self.background_radio.get_active():
            self._markReconfigureUser("update_manager_background",self.background_radio.get_active())

    def launch_app(self,widget):
        """Launches an application"""
        if widget is not None:
            if widget.get_name() == 'updatemanager_button':
                MCCPlugin.launch_app(self,widget,"update-manager")
            elif widget.get_name() == 'synaptic_button':
                MCCPlugin.launch_app(self,widget,"gksudo synaptic")
            elif widget.get_name() == 'terminal_button':
                MCCPlugin.launch_app(self,widget,"x-terminal-emulator")

    def user_scripted_changes(self,reconfigure):
        """Local changes that can be performed by the user account.
           This function will be ran by the frontend."""
        for item in reconfigure:
            if item == "update_manager_background":
                self.gconfclient.set_bool(UPDATE_NOTIFIER_KEY,reconfigure[item])
