#!/usr/bin/python
# mythbuntu-common install script
# Copyright (C) 2007-2009, Mario Limonciello <superm1@mythbuntu.org>
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

from distutils.core import setup
from DistUtilsExtra.command import *

import glob, os.path

setup(
    name="mythbuntu-common",
    author="Mario Limonciello",
    author_email="superm1@mythbuntu.org",
    maintainer="Ubuntu MythTV Team",
    maintainer_email="ubuntu-mythtv@lists.ubuntu.com",
    url="http://www.mythbuntu.org",
    license="gpl",
    description="commonly used mythbuntu functions",
    packages=['mythbuntu_common'],
    data_files=[("share/mythbuntu/examples", glob.glob("examples/*")),
                ("share/mythbuntu/plugins/python", glob.glob("plugins/python/*")),
                ("share/mythbuntu/qr", glob.glob("qr/*")),
                ("share/mythbuntu/", glob.glob("*.db")),
                ("share/mythbuntu/plugins/ui", glob.glob("plugins/ui/*"))],
    scripts=[],
    cmdclass = { "build" : build_extra.build_extra,
        "build_i18n" : build_i18n.build_i18n,
        "clean" : clean_i18n.clean_i18n
        }
)
