## -*- coding: utf-8 -*-
#
# «mythbuntu-bare» - A Plugin to assist in backing up and restoring the mythtv DB
#
# Copyright (C) 2010, Thomas Mashos, for Mythbuntu
#
#
# Mythbuntu is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this application; if not, write to the Free Software Foundation, Inc., 51
# Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##################################################################################

from MythbuntuControlCentre.plugin import MCCPlugin
import gtk
import time
import os
import tarfile
import shutil
import subprocess
from threading import Thread

class MythbuntuBaRePlugin(MCCPlugin):
    """A Plugin to assist in backing up and restoring the mythtv DB"""
    #
    #Load GUI & Calculate Changes
    #
    CONFIGFILE = "/etc/default/mythbuntu-bare"

    USER=os.getenv("HOME")

    BACKUPFILES = [
    "/etc/mythtv/config.xml",
    "/etc/mythtv/mysql.txt",
    "/etc/lirc/lircd.conf",
    "/etc/lirc/hardware.conf",
    ]

    BACKUPFILES.append(USER+"/.lirc")

    BACKUP_LOCATION = USER
    BACKUP_DB=False
    restore_file = '/tmp'

    IsTarFile = False

    def __init__(self):
        #Initialize parent class
        information = {}
        information["name"] = "Backup and Restore"
        information["icon"] = "revert"
        information["ui"] = "tab_mythbuntu-bare"
        MCCPlugin.__init__(self,information)
        import ConfigParser
        self.config = ConfigParser.ConfigParser()

    def captureState(self):
        """Determines the state of the items on managed by this plugin
           and stores it into the plugin's own internal structures"""
        import os
        self.changes = {}
        self.changes['backup_schedule'] = os.path.exists('/etc/cron.daily/mythbuntu-bare')
        if os.path.exists(self.CONFIGFILE):
            self.config.read(self.CONFIGFILE)
            self.changes['BackupLocation'] = self.config.get("Backup", "BackupLocation")
        else:
            self.changes['BackupLocation'] = "NOWHERE"

    def applyStateToGUI(self):
        """Takes the current state information and sets the GUI
           for this plugin"""
        self.button_box.hide()
        self.hide_tabs()
        self.vbox_start.show()
#        self.vbox_backup.hide()
        self.vbox_restore.hide()
        self.vbox_choices.hide()
        self.radio_backup.set_active(False)
        ## Set radio buttons to default (off)
        self.radio_backup_default_off.set_active(True)
        self.radio_backup_default_off.hide()
        self.radio_schedule_default_off.set_active(True)
        self.radio_schedule_default_off.hide()
        self.backup_schedule_off.set_active(True)
        self.backup_schedule_off.hide()
        self.radio_restore.set_active(False)
        self.backup_now.set_active(False)
        self.backup_dir_button.set_active(False)
        self.on_radio_backup_toggled(None)
        self.on_backup_dir_button_toggled(None)
#        self.on_backup_schedule_toggled(None)
        if self.changes['backup_schedule']:
            self.scheduled_label.set_text("Enabled")
        else:
            self.scheduled_label.set_text("Disabled")
        if self.query_installed('mythtv-backend-master') == True:
            self.db_backup_checkbutton.set_active(True)
        else:
            self.db_backup_checkbutton.set_active(False)
        self.restore_label_isfile.hide()
        ## Filter only tar.gz files for restore
        filter = gtk.FileFilter()
        filter.set_name("Backup Files")
        filter.add_pattern("*.tar.gz")
        self.restore_file.add_filter(filter)
        self.restore_file.unselect_all()
        self.backup_location.unselect_all()
        ## Disable non-implemented items
        self.backup_schedule.hide()
        self.backup_u1_button.hide()
        self.backup_dropbox_button.hide()
        self.backup_dir_button.hide() ## Only disabled since no other locations are available

    def compareState(self):
        """Determines what items have been modified on this plugin"""
        MCCPlugin.clearParentState(self)
        if self.radio_backup.get_active():
#            print "BACKUP"
            if self.backup_dir_button.get_active():
                self.BACKUP_LOCATION=self.backup_location.get_filename()
            elif self.backup_u1_button.get_active():
                #TODO
                print "U1 Location"
            elif self.backup_dropbox_button.get_active():
                #TODO
                print "Dropbox Location"
            if self.backup_now.get_active():
                self._markReconfigureUser('Backup Now',self.BACKUP_LOCATION)
            elif self.backup_schedule.get_active():
                #TODO
                self._markReconfigureRoot('Save Backup Location',self.BACKUP_LOCATION)
                if self.BACKUP_LOCATION != self.changes['BackupLocation']:
                    self._markReconfigureRoot('backup_location',True)
                    self._markReconfigureRoot('backup_schedule',True)
#                if self.backup_schedule_status.get_active() != self.changes['backup_schedule']:
#                    self._markReconfigureRoot('backup_schedule',self.backup_schedule_status.get_active())
#                    print "schedule only"
            if self.db_backup_checkbutton.get_active() == True:
                self.BACKUP_DB = True
            else:
                self.BACKUP_DB = False
        if self.radio_restore.get_active():
            self._markReconfigureRoot('restore',self.restore_file.get_filename())
            self._markReconfigureRoot('restore_db',self.restore_db.get_active())

    #
    # Callbacks
    #

#    def on_backup_schedule_toggled(self,widget,data=None):
        #TODO
#        print "Populate setup data"
#        if self.changes['BackupLocation'] != "NOWHERE":
#            self.backup_location.set_filename(self.changes['BackupLocation'])

    def on_restore_file_selection_changed(self,widget,data=None):
        if self.restore_file.get_filename():
            tarfilename=self.restore_file.get_filename()
            if tarfile.is_tarfile(tarfilename):
                TF=tarfile.open(tarfilename,mode='r:gz')
                for line in TF.getnames():
                    if line.endswith('sql.gz'):
                        self.RESTORE_DB_EXISTS=True
                        break
                    else:
                        self.RESTORE_DB_EXISTS=False
                        self.restore_db.set_active(False)
                TF.close()
                self.IsTarFile=True
                self.restore_label_isfile.hide()
            else:
                self.restore_label_isfile.show()

    def on_button_started_clicked(self,widget,data=None):
        self.CUR_TAB = "vbox_choices"
        self.vbox_start.hide()
        self.vbox_choices.show()
        self.button_box.show()
        self.next_button.set_sensitive(True)

    def on_next_button_clicked(self,widget,data=None):
        self.change_tab(self.CUR_TAB,"next")

    def on_back_button_clicked(self,widget,data=None):
        self.change_tab(self.CUR_TAB,"back")

    def change_tab(self,CURRENT,DIRECTION):
        """Monkee around to display the correct wizard page"""
        self.hide_tabs()
        if self.CUR_TAB == "vbox_choices":
            if self.radio_backup_default_off.get_active() == False:
                if DIRECTION == "back":
                    self.CUR_TAB = "vbox_start"
                    self.vbox_start.show()
                    self.button_box.hide()
                elif DIRECTION == "next":
                    if self.radio_backup.get_active():
                        self.CUR_TAB = "vbox_backup_choice"
                        self.vbox_backup_choice.show()
                    else:
                        self.CUR_TAB = "vbox_restore"
                        self.vbox_restore.show()
            else:
                self.vbox_choices.show()
        elif self.CUR_TAB == "vbox_backup_choice":
            if DIRECTION == "back":
                self.CUR_TAB = "vbox_choices"
                self.vbox_choices.show()
            elif DIRECTION == "next":
                if self.backup_now.get_active():
                    self.CUR_TAB = "vbox_backup_location"
                    self.vbox_backup_location.show()
                    self.backup_type = "now"
                elif self.backup_schedule.get_active():
                    self.CUR_TAB = "vbox_backup_schedule"
                    self.vbox_backup_schedule.show()
                    self.backup_type = "scheduled"
        elif self.CUR_TAB == "vbox_restore":
            if DIRECTION == "back":
                self.CUR_TAB = "vbox_choices"
                self.vbox_choices.show()
            elif DIRECTION == "next":
                if self.IsTarFile == True:
                    if self.RESTORE_DB_EXISTS:
                        self.CUR_TAB = "vbox_restore_db"
                        self.vbox_restore_db.show()
                    else:
                        self.CUR_TAB = "vbox_final"
                        self.vbox_final.show()
                        self.next_button.set_sensitive(False)
                else:
                    self.vbox_restore.show()
        elif self.CUR_TAB == "vbox_restore_db":
            if DIRECTION == "back":
                self.CUR_TAB = "vbox_restore"
                self.vbox_restore.show()
            elif DIRECTION == "next":
                self.CUR_TAB = "vbox_final"
                self.vbox_final.show()
                self.next_button.set_sensitive(False)
        elif self.CUR_TAB == "vbox_backup_location":
            if DIRECTION == "back":
                if self.backup_type == "now":
                    self.CUR_TAB = "vbox_backup_choice"
                    self.vbox_backup_choice.show()
                elif self.backup_type == "scheduled":
                    self.CUR_TAB = "vbox_backup_schedule"
                    self.vbox_backup_schedule.show()
            elif DIRECTION == "next":
                self.CUR_TAB = "vbox_final"
                self.vbox_final.show()
                self.next_button.set_sensitive(False)
        elif self.CUR_TAB == "vbox_backup_schedule":
            if DIRECTION == "back":
                self.CUR_TAB = "vbox_backup_choice"
                self.vbox_backup_choice.show()
            elif DIRECTION == "next":
                self.CUR_TAB = "vbox_backup_location"
                self.vbox_backup_location.show()
        elif self.CUR_TAB == "vbox_final":
            if DIRECTION == "back":
                self.next_button.set_sensitive(True)
                if self.radio_backup.get_active():
                    self.CUR_TAB = "vbox_backup_location"
                    self.vbox_backup_location.show()
                else:
                    if self.RESTORE_DB_EXISTS:
                        self.CUR_TAB = "vbox_restore_db"
                        self.vbox_restore_db.show()
                    else:
                        self.CUR_TAB = "vbox_restore"
                        self.vbox_restore.show()

    def on_radio_backup_toggled(self,widget,data=None):
        """Show backup or restore settings depeding on user input"""
        was_selected = self.radio_backup.get_active()
#        if was_selected:
#            self.vbox_backup.show()
#            self.vbox_restore.hide()
#        else:          
#            self.vbox_backup.hide()
#            self.vbox_restore.show()

    def on_backup_dir_button_toggled(self,widget,data=None):
        """Prompt user for save location if needed"""
        self.hide_all()
        if self.backup_dir_button.get_active():
            self.backup_location.show()
        elif self.backup_u1_button.get_active():
            self.preconfigured_label.show()
        elif self.backup_dropbox_button.get_active():
            self.preconfigured_label.show()
        else:        
            print "Error: Unknown option selected"

#    def on_backup_schedule_toggled(self,widget,data=None):
#        """Show backup schedule options if needed"""
#        if self.backup_schedule.get_active():
#            self.backup_schedule_status.show()
#            if self.changes['BackupLocation'] != "NOWHERE":
#                self.backup_location.set_filename(self.changes['BackupLocation'])
#        else:
#            self.backup_schedule_status.hide()

    def hide_tabs(self):
        self.vbox_start.hide()
        self.vbox_restore.hide()
        self.vbox_restore_db.hide()
        self.vbox_backup_schedule.hide()
        self.vbox_choices.hide()
        self.vbox_backup_choice.hide()
        self.vbox_backup_location.hide()
        self.vbox_final.hide()

    def hide_all(self):
        """Hide everything before showing what is needed"""
        self.preconfigured_label.hide()
        self.backup_location.hide()

    #
    # Process selected activities
    #

    def root_scripted_changes(self,reconfigure):
        """System-wide changes that need root access to be applied.
           This function is ran by the dbus backend"""
        self.config.add_section("Backup")
        time.sleep(2)
        RESTORE_SET=False
        RESTORE_DB_SET=False
        STATUSFILE = "/tmp/mythbuntu-bare-status"
        for item in reconfigure:
            if item == "Save Backup Location":
                self.BACKUP_LOCATION = reconfigure[item]
        for item in reconfigure:
            if item == "backup_location":
                self.emit_progress("Setting to 40 percent as a root", 40)
                time.sleep(2)
                self.config.set("Backup", "backuplocation", self.BACKUP_LOCATION)
                with open('/etc/default/mythbuntu-bare', 'wb') as configfile:
                    self.config.write(configfile)
            if item == "backup_schedule":
                #TODO
                if reconfigure[item]:
                    self.emit_progress("Setting to 60 percent as a root", 60)
                    time.sleep(2)
                    file = open('/etc/cron.daily/mythbuntu-bare', "w")
                    location = self.BACKUP_LOCATION
                    self.emit_progress("Setting to 80 percent as a root", 80)
                    time.sleep(2) 
                    #TODO
                    file.writelines("Testing"+location)
                    file.close()
                else:
                    import os
                    os.remove('/etc/cron.daily/mythbuntu-bare')
            if item == "restore":
                RESTORE_LOCATION=reconfigure[item]
                RESTORE_SET=True
            if item == "restore_db":
                RESTORE_DB=reconfigure[item]
                RESTORE_DB_SET=True
#        print "Restore DB Set: "
#        print RESTORE_DB_SET
#        print "Restore Set: "
#        print RESTORE_SET
        if RESTORE_SET == True and RESTORE_DB_SET == True:
            #TODO
            rj = Thread(target=self.restore_job, args=(RESTORE_LOCATION,RESTORE_DB))
            rj.start()
            self.emit_progress("Restoring files", 20)
            time.sleep(2)
            status=20
            while rj.isAlive():
                f = open(STATUSFILE, 'r')
                ANS1 = f.readline().rstrip('\n')
                ANS2 = f.readline().rstrip('\n')
                status = int(ANS1)
                self.emit_progress(ANS2, status)
                f.close()
                while ANS2 == 'Restoring database (this could take a few minutes)':
                    f = open(STATUSFILE, 'r')
                    ANS1 = f.readline().rstrip('\n')
                    ANS2 = f.readline().rstrip('\n')
                    f.close()
                    if status <= 90:
                        status=status+0.1
                        self.emit_progress(ANS2, status)
                        time.sleep(0.1)
                time.sleep(0.1)
            self.emit_progress("Restore Job Complete", 100)
        time.sleep(2)

    def backup_job(self, Location, BackupDB):
        """Backup all the files"""
        ## Check backup directory exists
        if not os.path.exists(Location):
            os.makedirs(Location)
        ## Array of files to Backup
        BACKUPFILES = [
        "/etc/mythtv/config.xml",
        "/etc/mythtv/mysql.txt",
        "/etc/lirc/lircd.conf",
        "/etc/lirc/hardware.conf",
        "/etc/hostname",
        "/etc/hosts",
        ]
        USER=os.getenv("HOME")
        BACKUPFILES.append(USER+"/.lirc")
        ## Set up backup location
        TMPDIR="/tmp/mythbuntu-bare"
        if not os.path.exists(TMPDIR):
            os.makedirs(TMPDIR)
        BACKUPFILES.append(TMPDIR)
        ## Set status file
        STATUSFILE="/tmp/mythbuntu-bare-status"
        if os.path.isfile(STATUSFILE):
            os.remove(STATUSFILE)
        timestamp=time.strftime("%Y%m%d-%H%M", time.localtime())
        ## Backup database only if told to do so
        if BackupDB == True:
            #Run DB Backup
            os.system("echo '20\nBacking up database (this could take a few minutes)'>"+STATUSFILE)
            backupscript="/usr/share/mythtv/mythconverg_backup.pl"
            pipe = subprocess.Popen([backupscript, '--directory', TMPDIR], stdout=subprocess.PIPE).communicate()
        ## Setup for final tar file
        tarfilename=Location+'/mythbuntu-system-backup-'+timestamp+'.tar.gz'
        TF=tarfile.open(tarfilename,mode='w:gz')
        os.system("echo '90\nZipping up files'>"+STATUSFILE)
	## Add files to tarball
        for item in BACKUPFILES:
            if os.path.exists(item):
              TF.add(item)
        TF.close()
        ## Remove tmp Backup directory and status file
        if os.path.exists(TMPDIR):
            shutil.rmtree(TMPDIR)
        if os.path.isfile(STATUSFILE):
            os.remove(STATUSFILE)

    def restore_job(self, Location, RestoreDB):
        USER=os.getenv("HOME")
        ## Set temp directory and status file
        TMPDIR="/tmp/mythbuntu-bare/"
        STATUSFILE="/tmp/mythbuntu-bare-status"
        ##Remove temp DB dir and statusfile first in case it already exists
        if os.path.exists(STATUSFILE):
            os.remove(STATUSFILE)
        if os.path.exists(TMPDIR):
            shutil.rmtree(TMPDIR)
        ## Open and Extract tarfile
        os.system("echo '30\nRestoring configuration files'>"+STATUSFILE)
        TF=tarfile.open(Location,mode='r')
        TF.extractall(path="/", members=None)
        TF.close()
        ## Update mythtv db password with backed up password
        os.system("DEBIAN_FRONTEND=noninteractive dpkg-reconfigure mythtv-database")
        if RestoreDB == True:
            print "Yes we are restoring the database!"
            os.system("echo '40\nRestoring database (this could take a few minutes)'>"+STATUSFILE)
            ##TODO
            restorescript="/usr/share/mythtv/mythconverg_restore.pl"
            pipe = subprocess.Popen([restorescript, '--drop_database', '--create_database', '--directory', TMPDIR], stdout=subprocess.PIPE).communicate()
        ## Remove Temp directory and status file
        os.system("echo '90\nCleaning up temp files'>"+STATUSFILE)
        time.sleep(1)
        if os.path.exists(TMPDIR):
            shutil.rmtree(TMPDIR)
        if os.path.exists(STATUSFILE):
            os.remove(STATUSFILE)

    def user_scripted_changes(self,reconfigure):
        """Local changes that can be performed by the user account.
           This function will be ran by the frontend"""
        time.sleep(0.5)
        for item in reconfigure:
            if item == "Backup Now":
                STATUSFILE = "/tmp/mythbuntu-bare-status"
                bj = Thread(target=self.backup_job, args=(self.BACKUP_LOCATION,self.BACKUP_DB))
                bj.start()
                self.emit_progress("Starting Backup", 10)
                time.sleep(2)
                status=10
                while bj.isAlive():
                    f = open(STATUSFILE, 'r')
                    ANS1 = f.readline().rstrip('\n')
                    ANS2 = f.readline().rstrip('\n')
                    status = int(ANS1)
                    self.emit_progress(ANS2, status)
                    f.close()
                    while ANS2 == 'Backing up database (this could take a few minutes)':
                        f = open(STATUSFILE, 'r')
                        ANS1 = f.readline().rstrip('\n')
                        ANS2 = f.readline().rstrip('\n')
                        f.close()
                        if status <= 85:
                            status=status+0.1
                            self.emit_progress(ANS2, status)
                            time.sleep(0.1)
                    time.sleep(0.1)
        self.emit_progress("Backup Finished", 100)
        time.sleep(2)
