#!/usr/bin/env python
## -*- coding: utf-8 -*-
#
#
# Copyright (C) 2011, Thomas Mashos, for Mythbuntu
#
#
# Mythbuntu-bare is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this application; if not, write to the Free Software Foundation, Inc., 51
# Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##################################################################################

import logging

logger = logging.getLogger('mythbuntu-bare')
hdlr = logging.FileHandler('/var/log/mythbuntu-bare-client.log')
formatter = logging.Formatter('%(asctime)s %(levelname)s %(message)s')
hdlr.setFormatter(formatter)
logger.addHandler(hdlr) 
logger.setLevel(logging.WARNING)

ACTOR="<updater> "

class CronUpdater():

    def generate_cron_schedule(self):
      logger.info(ACTOR+'Cron update job started')
      import ConfigParser
      config = ConfigParser.ConfigParser()
      logger.info(ACTOR+'Reading conf file')
      config.read("/var/lib/mythtv/bare-client/mythbuntu-bare-client.conf")
      managed = config.get("General", "managed")
      schedule = config.get("Backup", "schedule")
      day = config.get("Backup", "day")
      hour = config.get("Backup", "hour")
      minute = config.get("Backup", "minute")
      weekday = config.get("Backup", "weekday")
      logger.info(ACTOR+'Detected Managed:'+str(managed)+' Schedule:'+str(schedule)+' Day:'+str(day)+' Hour:'+str(hour)+' Minute:'+str(minute)+' Weekday'+str(weekday))
      f = open("/etc/cron.d/mythbuntu-bare","w")
      if not schedule == "disabled":
        logger.info(ACTOR+'Writing backup schedule cron job')
        f.write(minute+" "+hour+" "+day+" "+"*"+" "+weekday+" root /usr/share/mythbuntu-bare/bareclient/backup-task.py\n")
      if managed:
        logger.info(ACTOR+'Writing update task cron job')
        f.write("41 * * * * root /usr/share/mythbuntu-bare/bareclient/update-task.py\n")
      f.close()
      logger.info(ACTOR+'Cron update job finished')
