# xmlgen- parses a C header file for structs and generate code to parse and
#     write XML files.
#
# Copyright (c) 2004 MySQL AB
#
# Example:
#
# /// begin group fruits
#
# /// generate fruit
# typedef struct fruit
# {
#   elements;
#   struct basket *basket; // [ref] means its just a reference
# } Fruit;
#
# /// generate basket [root]
# typedef struct basket
# {
#   unsigned int fruits_num;
#   Fruit *fruits;
# } Basket;
# /// end group fruits
#
#
# Available options: root, orderby:attribute
#
#
# struct element options: 
#    ref:parent  -  element is a ptr reference to the parent object
#



from parser import *

import string

DEBUG=0


class Type:
    def check(self, s):
        pass


class Generator:
    array_count_suffix= "_num"
    
    def __init__(self, group, others):
        self._group= group
        self._others= others
        self._prototypes= [] # function prototypes
        self._head= [] # stuff that should go in the beginning of the file


    def find_struct_by_type(self, typ):
        typ= typ.rstrip("*").strip()
        if typ.split()[0]=="struct":
            struc= typ.split()[1]
            for s in self._group["structs"]:
                if s["struct"]== struc:
                    return s 
        else:
            for s in self._group["structs"]:
                if s["typedef"]== typ:
                    return s
        return None

    def is_struct(self, s):
        if self.find_struct_by_type(s):
            return 1
        return 0


    def is_enum(self, s):
        for e in self._others["enums"]:
            if (e["enum"] or e["typedef"]) == s:
                return 1
        return 0

    def is_custom(self, s):
        return 0
    
    def find_struct(self, name):
        assert NotImplementedError
        return None
    
    def stringalize_type(self, t):
        return t.replace(" ","_")
    
    def split_arrays(self, struct):
        # split between array and non-array stuff
        # arrays have an array size variable and the data variable
        # returns ([(array_elems, array_sizes)], [variables])
        tmp=[]
        for elem in struct["elements"]:
            if is_int(elem["type"]) and elem["name"].endswith(self.array_count_suffix):
                tmp.append(elem)

        variables= struct["elements"][:]
        arrays= []
        for elem in tmp:
            for e in variables:
                if e["name"] == elem["name"][:-len(self.array_count_suffix)]:
                    arrays.append((elem, e))
                    variables.remove(elem)
                    variables.remove(e)

        return arrays, variables


    def process_int_variable(self, variable, depth, for_array):
        return None
    
    def process_str_variable(self, variable, depth, for_array):
        return None

    def process_fp_variable(self, variable, depth, for_array):
        return None

    def process_enum_variable(self, variable, depth, for_array):
        return None

    def process_custom_variable(self, variable, depth, for_array):
        return None

    def process_variable(self, variable, depth, for_array=0):
        if is_str(variable["type"]):
            return self.process_str_variable(variable, depth+1, for_array)
        elif is_int(variable["type"]):
            return self.process_int_variable(variable, depth+1, for_array)
        elif is_fp(variable["type"]):
            return self.process_fp_variable(variable, depth+1, for_array)
        elif self.is_enum(variable["type"]):
            return self.process_enum_variable(variable, depth+1, for_array)
        elif self.is_struct(variable["type"]):
            return self.process_struct_variable(variable, depth+1, for_array)
        elif self.is_custom(variable["type"]):
            return self.process_custom_variable(variable, depth+1, for_array)
        else:
            print "Unknwon variable type in", variable
            print "Known structs are:",[s["typedef"] for s in self._group["structs"]]
            raise StandardError
        # array types are handled in proces_struct

    def array_variable_to_plain(self, array):
        plain= array.copy()
        plain["type"]= plain["type"][:-1].strip() # strip the *
        return plain

    def process_array(self, count, array, depth):
        return self.process_variable(self.array_variable_to_plain(array), depth, 1)

    def process_struct(self, struct, depth=0):
        # 1st find out what are the array sizes and possible arrays
        array_data_names= []
        array_sizes= {}
        for elem in struct["elements"]:
            if is_int(elem["type"],1) and elem["name"].endswith(self.array_count_suffix):
                # this is an array size
                name= elem["name"][:-len(self.array_count_suffix)]
                array_sizes[name]= elem
            elif is_ptr(elem["type"]):
                array_data_names.append(elem["name"])

        # 2nd remove what wasn't really an array
        for a in array_sizes.keys():
            if a not in array_data_names:
                del array_sizes[a]

        body= []
        for elem in struct["elements"]:
            # ignore array count variables
            if elem["name"][:-len(self.array_count_suffix)] in array_sizes.keys():
                continue

            # this is an array
            if elem["name"] in array_sizes.keys():
                r= self.process_array(array_sizes[elem["name"]], elem, depth+1)
            else: # not an array
                r= self.process_variable(elem, depth+1)
            if r:
                body+= r

        return body


    def get_prototypes(self):
        return self._prototypes
    
    def get_head(self):
        return self._head

    def generate(self):
        text=""
        for s in self._group["structs"]:
            text+= self.process_struct(s)+"\n\n"
        return text


class OutputGenerator(Generator):
    pass

    
class InputGenerator(Generator):
    pass


class DestroyerGenerator(Generator):
    pass
