/* Copyright (C) 2005 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#ifndef _MGRTSHELL_H_
#define _MGRTSHELL_H_

#include <gtkmm/paned.h>
#include <gtkmm/textview.h>
#include <gtkmm/notebook.h>
#include <gtkmm/combobox.h>
#include <gtkmm/entry.h>
#include <gtkmm/treeview.h>
#include <gtkmm/treestore.h>
#include <gtkmm/label.h>
#include <gtkmm/box.h>
#include <gtkmm/menubar.h>
#include <gtkmm/window.h>

#include <MySQLGRT/MGRT.h>

class MGRTShell : public Gtk::Window {
    class TreeColumns : public Gtk::TreeModel::ColumnRecord {
      public:
        TreeColumns() {
          add(icon); add(text); add(detail); add(data);
        };
        Gtk::TreeModelColumn<Glib::RefPtr<Gdk::Pixbuf> > icon;
        Gtk::TreeModelColumn<Glib::ustring> text;
        Gtk::TreeModelColumn<int> detail;
        Gtk::TreeModelColumn<void*> data;
    } _columns;

    Gtk::MenuBar _menu;
    Gtk::VBox _top_box;
    
    Gtk::HPaned _paned;
    Gtk::TextView _text;
    Gtk::Notebook _sidenote;

    Glib::RefPtr<Gtk::TreeStore> _value_store;
    Gtk::VBox _value_box;
    Gtk::ComboBox _value_combo;
    Gtk::TreeView _value_tree;
    Gtk::Entry _value_entry;
    Gtk::TreeView _detail_tree;

    Glib::RefPtr<Gtk::TreeStore> _struct_store;
    Gtk::TreeView _struct_tree;
    
    Glib::RefPtr<Gtk::TreeStore> _module_store;
    Gtk::VBox _module_box;
    Gtk::TreeView _module_tree;
    Gtk::Label _module_label;

    MGRT *_grt;
    
    bool _container_only;
    
    Glib::ustring _root_path;
    std::string _icon_path;

    Glib::RefPtr<Gdk::Pixbuf> _simple_icon;
    Glib::RefPtr<Gdk::Pixbuf> _dict_icon;
    Glib::RefPtr<Gdk::Pixbuf> _struct_icon;
    Glib::RefPtr<Gdk::Pixbuf> _list_icon;

    void set_icon(Gtk::TreeRow row, MGRTValue value);
    void add_value_item(Gtk::TreeIter iter, MGRTValue value);
    
    void add_list_to_store(MGRTValue list, Gtk::TreeRow &parent, Glib::RefPtr<Gtk::TreeStore> store);
    void add_dict_to_store(MGRTValue dict, Gtk::TreeRow &parent, Glib::RefPtr<Gtk::TreeStore> store);
  public:
    MGRTShell(MGRT *grt, const std::string &icon_path);
    
    void refresh();
};

#endif /* _MGRTSHELL_H_ */
