
/* Automatically generated by autoxml, do not edit. */

#include "myx_public_interface.h"

#include <libxml/xmlmemory.h>
#include <libxml/parser.h>
#include "myx_xml_aux_functions.h"
#include <glib.h>

/* foward declarations */
static int myx_charset_store(const char *filename, MYX_DBM_CHARSETS *obj);
static MYX_DBM_CHARSETS *myx_charset_load(const char *filename,
                                          MYX_LIB_ERROR *error_code);
static int myx_free_charset(MYX_DBM_CHARSETS *obj);

/* wrappers */

int myx_charsets_store(const char *filename, MYX_DBM_CHARSETS *obj)
{
  return myx_charset_store(filename, obj);
}

MYX_DBM_CHARSETS *myx_charsets_load(const char *filename,
                                    MYX_LIB_ERROR *error_code)
{
  return myx_charset_load(filename, error_code);
}

int myx_free_charsets(MYX_DBM_CHARSETS *obj)
{
  return myx_free_charset(obj);
}

/* only static functions now */

///////////////////////////////////////////////////////////////////////////////
/** @brief Create a new xml-node, contained information from MYX_DBM_COLLATION
    @param obj MYX_DBM_COLLATION to store in xml-node
    @param parent parent for created node
*//////////////////////////////////////////////////////////////////////////////
static void store_charset_MYX_DBM_COLLATION(MYX_DBM_COLLATION *obj,
                                            xmlNodePtr parent)
{
  xmlNodePtr node;

  node= xmlNewTextChild(parent, NULL, (xmlChar*)"collation", NULL);

  xmlNewTextChild(node, NULL, (xmlChar*)"name", (xmlChar*)obj->name);

  NewTextChild_int_content(node, NULL, (xmlChar*)"id", obj->id);
  NewTextChild_int_content(node, NULL, (xmlChar*)"is_default", obj->is_default);
  NewTextChild_int_content(node, NULL, (xmlChar*)"is_compiled", obj->is_compiled);
  NewTextChild_int_content(node, NULL, (xmlChar*)"sort_len", obj->sort_len);
}

///////////////////////////////////////////////////////////////////////////////
/** @brief Create a new xml-node, contained information from MYX_DBM_CHARSET
    @param obj MYX_DBM_CHARSET to store in xml-node
    @param parent parent for created node
*//////////////////////////////////////////////////////////////////////////////
static void store_charset_MYX_DBM_CHARSET(MYX_DBM_CHARSET *obj,
                                          xmlNodePtr parent)
{
  xmlNodePtr node;
  unsigned int i;

  node= xmlNewTextChild(parent, NULL, (xmlChar*)"charset", NULL);

  for (i= 0; i < obj->collations_num; i++)
    store_charset_MYX_DBM_COLLATION(obj->collations+i, node);
  xmlNewTextChild(node, NULL, (xmlChar*)"name", (xmlChar*)obj->name);
  xmlNewTextChild(node, NULL, (xmlChar*)"desc", (xmlChar*)obj->desc);
  xmlNewTextChild(node, NULL, (xmlChar*)"default_collation", (xmlChar*)obj->default_collation);
  NewTextChild_int_content(node, NULL, (xmlChar*)"max_len", obj->max_len);
}

///////////////////////////////////////////////////////////////////////////////
/** @brief prepare an xml-document with MYX_DBM_CHARSETS struct stored in it
    @param obj MYX_DBM_CHARSETS struct to store
    @return created document
*//////////////////////////////////////////////////////////////////////////////
static xmlDocPtr make_xml_for_charset(MYX_DBM_CHARSETS *obj)
{
  xmlDocPtr doc;
  xmlNodePtr parent;
  unsigned int i;

  g_return_val_if_fail(obj, NULL);

  doc = xmlNewDoc((xmlChar*)"1.0");

  parent = doc->children = xmlNewDocRawNode(doc, NULL, (xmlChar*)"charsets", NULL);

  for (i= 0; i < obj->charsets_num; i++)
    store_charset_MYX_DBM_CHARSET(obj->charsets+i, parent);

  return doc;
}

///////////////////////////////////////////////////////////////////////////////
/** @brief store MYX_DBM_CHARSETS in an XML file
    @param filename path to file to store in
    @param obj MYX_DBM_CHARSETS struct to store
    @return -1 if file was not written, else 0
*//////////////////////////////////////////////////////////////////////////////
static int myx_charset_store(const char *filename, MYX_DBM_CHARSETS *obj)
{
  xmlDocPtr doc;
  int res;

  g_return_val_if_fail(obj, -1);
  g_return_val_if_fail(filename, -1);

  doc= make_xml_for_charset(obj);

  res= myx_xmlSaveFile(filename, doc);
  xmlFreeDoc(doc);
  return (res == -1) ? -1 : 0;
}

///////////////////////////////////////////////////////////////////////////////
/** @brief read MYX_DBM_COLLATION struct from xml node
    @param parent node to read from
    @param obj MYX_DBM_COLLATION struct to fill
*//////////////////////////////////////////////////////////////////////////////
static void read_charset_MYX_DBM_COLLATION(xmlNodePtr parent,
                                           MYX_DBM_COLLATION *obj)
{
  xmlNodePtr node;
  xmlDocPtr doc= parent->doc;

  for (node= parent->children; node != NULL; node= node->next)
  {
    try_to_get_string_field(doc, node, "name",        &obj->name);
    try_to_get_int_field   (doc, node, "id",          (int*)&obj->id);
    try_to_get_char_field  (doc, node, "is_default",  (char*)&obj->is_default);
    try_to_get_char_field  (doc, node, "is_compiled", (char*)&obj->is_compiled);
    try_to_get_int_field   (doc, node, "sort_len",    (int*)&obj->sort_len);
  }
}

///////////////////////////////////////////////////////////////////////////////
/** @brief read MYX_DBM_CHARSET struct from xml node
    @param parent node to read from
    @param obj MYX_DBM_CHARSET struct to fill
*//////////////////////////////////////////////////////////////////////////////
static void read_charset_MYX_DBM_CHARSET(xmlNodePtr parent,
                                         MYX_DBM_CHARSET *obj)
{
  xmlNodePtr node;
  xmlDocPtr doc= parent->doc;
  MYX_DBM_COLLATION * collation= NULL;

  obj->collations_num= get_child_count(parent, (xmlChar*)"collation");
  if (obj->collations_num > 0)
  {
    collation= obj->collations=
                      (MYX_DBM_COLLATION*)g_malloc0(obj->collations_num *
                                                    sizeof(MYX_DBM_COLLATION));
  }

  for (node = parent->children; node != NULL; node= node->next)
  {
    if (!xmlStrcmp(node->name, (xmlChar*)"collation"))
    {
      read_charset_MYX_DBM_COLLATION(node, collation);
      collation->charset= obj;
      collation++;
    }
    try_to_get_string_field(doc, node, "name",              &obj->name);
    try_to_get_string_field(doc, node, "desc",              &obj->desc);
    try_to_get_string_field(doc, node, "default_collation",
                            &obj->default_collation);
    try_to_get_int_field   (doc, node, "max_len",           (int*)&obj->max_len);
  }
}

///////////////////////////////////////////////////////////////////////////////
/** @brief read MYX_DBM_DATATYPES struct from xml document
    @param doc document to read from
    @param error_code returned error code, <BR>
           possible values are:
             - \link MYX_LIB_ERROR::MYX_XML_EMPTY_DOCUMENT 
                                               MYX_XML_EMPTY_DOCUMENT \endlink
             - unchanged..
    @return loaded MYX_DBM_DATATYPES
*//////////////////////////////////////////////////////////////////////////////
static MYX_DBM_CHARSETS *process_xml_for_charset(xmlDocPtr doc,
                                                 MYX_LIB_ERROR *error_code)
{
  xmlNodePtr parent;
  MYX_DBM_CHARSETS *obj;

  parent= xmlDocGetRootElement(doc);
  if (parent == NULL)
  {
    *error_code= MYX_XML_EMPTY_DOCUMENT;
    return NULL;
  }

  obj= (MYX_DBM_CHARSETS*)g_malloc0(sizeof(MYX_DBM_CHARSETS));
  obj->charsets_num= get_child_count(parent, (xmlChar*)"charset");

  if (obj->charsets_num > 0)
  {
    xmlNodePtr node;
    MYX_DBM_CHARSET * charset= obj->charsets= 
                   (MYX_DBM_CHARSET*)g_malloc0(obj->charsets_num *
                                               sizeof(MYX_DBM_CHARSET));
    for (node= parent->children; node != NULL; node= node->next)
    {
      if (!xmlStrcmp(node->name, (xmlChar*)"charset"))
      {
        read_charset_MYX_DBM_CHARSET(node, charset);
        charset++;
      }
    }
    
  }
  return obj;
}

///////////////////////////////////////////////////////////////////////////////
/** @ brief loads MYX_DBM_CHARSETS struct from an XML file
    @param filename path to a xml-file with stored MYX_DBM_CHARSETS struct
    @param error_code returned error code, <BR>
           possible values are:
             - \link MYX_LIB_ERROR::MYX_NO_ERROR MYX_NO_ERROR \endlink
             - \link MYX_LIB_ERROR::MYX_ERROR_CANT_OPEN_FILE 
                                             MYX_ERROR_CANT_OPEN_FILE \endlink
             - \link MYX_LIB_ERROR::MYX_XML_PARSE_ERROR 
                                                  MYX_XML_PARSE_ERROR \endlink
             - \link MYX_LIB_ERROR::MYX_XML_EMPTY_DOCUMENT 
                                               MYX_XML_EMPTY_DOCUMENT \endlink
             - \link MYX_LIB_ERROR::MYX_ALLOC_CHANGE_ERROR
                                               MYX_ALLOC_CHANGE_ERROR \endlink

    @return loaded MYX_DBM_CHARSETS
*//////////////////////////////////////////////////////////////////////////////
static MYX_DBM_CHARSETS *myx_charset_load(const char *filename,
                                          MYX_LIB_ERROR *error_code)
{
  xmlDocPtr doc;
  MYX_DBM_CHARSETS *obj;
  xmlFreeFunc org_free;
  xmlMallocFunc org_malloc;
  xmlReallocFunc org_realloc;
  xmlStrdupFunc org_strdup;
  
  *error_code = MYX_NO_ERROR;

  if (!file_exists(filename))
  {
    *error_code = MYX_ERROR_CANT_OPEN_FILE;
    return NULL;
  }
  
  if (xmlMemGet(&org_free, &org_malloc, &org_realloc, &org_strdup) ||
      xmlMemSetup(g_free, (xmlMallocFunc)g_malloc,
                  (xmlReallocFunc)g_realloc, g_strdup))
  {
    *error_code= MYX_ALLOC_CHANGE_ERROR;
    return NULL;
  }
  
  if (!(doc= myx_xmlParseFile(filename)))
  {
    *error_code = MYX_XML_PARSE_ERROR;
    return NULL;
  }
  obj= process_xml_for_charset(doc, error_code);

  xmlFreeDoc(doc);

  if (xmlMemSetup(org_free, org_malloc, org_realloc, org_strdup))
  {
    *error_code= MYX_ALLOC_CHANGE_ERROR;
    //should we free anything here?
    return NULL;
  }
  
  return obj;
}

///////////////////////////////////////////////////////////////////////////////
/** @brief free memory for the MYX_DBM_COLLATION struct
    @param obj MYX_DBM_COLLATION struct to free
    @return 0 always
*//////////////////////////////////////////////////////////////////////////////
static int free_charset_MYX_DBM_COLLATION(MYX_DBM_COLLATION *obj)
{
  xmlFree(obj->name);
  return 0;
}

///////////////////////////////////////////////////////////////////////////////
/** @brief free memory for the MYX_DBM_CHARSET struct
    @param obj MYX_DBM_CHARSET struct to free
    @return 0 always
*//////////////////////////////////////////////////////////////////////////////
static int free_charset_MYX_DBM_CHARSET(MYX_DBM_CHARSET *obj)
{
  unsigned int i;
  for (i= 0; i < obj->collations_num; i++)
    free_charset_MYX_DBM_COLLATION(obj->collations+i);
  g_free(obj->collations);
  xmlFree(obj->name);
  xmlFree(obj->desc);
  xmlFree(obj->default_collation);
  return 0;
}

///////////////////////////////////////////////////////////////////////////////
/** @brief free memory for the MYX_DBM_CHARSETS struct
    @param obj MYX_DBM_CHARSETS struct to free
    @return 0 always
*//////////////////////////////////////////////////////////////////////////////
static int myx_free_charset(MYX_DBM_CHARSETS *obj)
{
  unsigned int i;
  for (i= 0; i < obj->charsets_num; i++)
    free_charset_MYX_DBM_CHARSET(obj->charsets+i);
  g_free(obj->charsets);
  return 0;
}
