/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageTranslator {
    private static final String MESSAGES = "com.sap.dbtech.jdbc.messages";
    private static HashMap messagebundles = new HashMap();
    private static Object lock = new Object();

    public static String translate(String string) {
        return MessageTranslator.translate(string, null);
    }

    public static String translate(String string, Object object) {
        Object[] objectArray = new Object[]{object};
        return MessageTranslator.translate(string, objectArray);
    }

    public static String translate(String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return MessageTranslator.translate(string, objectArray);
    }

    public static String translate(String string, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        return MessageTranslator.translate(string, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceBundle getMessages() {
        Object object = messagebundles.get(Locale.getDefault().toString());
        if (object == null) {
            Object object2 = lock;
            synchronized (object2) {
                object = messagebundles.get(Locale.getDefault().toString());
                if (object == null) {
                    try {
                        object = ResourceBundle.getBundle(MESSAGES);
                        messagebundles.put(Locale.getDefault().toString(), object);
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                }
            }
        }
        return (ResourceBundle)object;
    }

    public static String translate(String string, Object[] objectArray) {
        try {
            String string2 = MessageTranslator.getMessages().getString(string);
            return MessageFormat.format(string2, objectArray);
        }
        catch (MissingResourceException missingResourceException) {
            StringBuffer stringBuffer = new StringBuffer("No message available for locale ");
            stringBuffer.append(MessageTranslator.getMessages().getLocale().toString());
            stringBuffer.append(", key ");
            stringBuffer.append(string);
            if (objectArray == null || objectArray.length == 0) {
                stringBuffer.append(".");
            } else {
                stringBuffer.append(", arguments [");
                for (int i = 0; i < objectArray.length - 1; ++i) {
                    stringBuffer.append(objectArray[i].toString());
                    stringBuffer.append(", ");
                }
                stringBuffer.append(objectArray[objectArray.length - 1].toString());
                stringBuffer.append("].");
            }
            return stringBuffer.toString();
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer("No message available for default locale ");
            stringBuffer.append("for key ");
            stringBuffer.append(string);
            if (objectArray == null || objectArray.length == 0) {
                stringBuffer.append(".");
            } else {
                stringBuffer.append(", arguments [");
                for (int i = 0; i < objectArray.length - 1; ++i) {
                    stringBuffer.append(objectArray[i].toString());
                    stringBuffer.append(", ");
                }
                stringBuffer.append(objectArray[objectArray.length - 1].toString());
                stringBuffer.append("].");
            }
            return stringBuffer.toString();
        }
    }
}

