/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.UnknownHostException;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbNamedPipe;
import net.sourceforge.jtds.jdbc.SharedSocket;

public class SharedNamedPipe
extends SharedSocket {
    private SmbNamedPipe pipe;

    private SharedNamedPipe(int tdsVersion, int serverType) {
        super(tdsVersion, serverType);
    }

    static SharedNamedPipe instance(String host, int tdsVersion, int serverType, int packetSize, String instance, String domain, String user, String password) throws IOException, UnknownHostException {
        SharedNamedPipe newInstance = new SharedNamedPipe(tdsVersion, serverType);
        NtlmPasswordAuthentication auth = new NtlmPasswordAuthentication(domain, user, password);
        StringBuffer url = new StringBuffer(32);
        url.append("smb://");
        url.append(host);
        url.append("/IPC$");
        if (instance != null && instance.length() != 0) {
            url.append("/MSSQL$");
            url.append(instance);
        }
        url.append("/sql/query");
        newInstance.setPipe(new SmbNamedPipe(url.toString(), 196608, auth));
        newInstance.setOut(new DataOutputStream(newInstance.getPipe().getNamedPipeOutputStream()));
        newInstance.setIn(new DataInputStream(new BufferedInputStream(newInstance.getPipe().getNamedPipeInputStream(), SharedNamedPipe.calculateBufferSize(tdsVersion, packetSize))));
        return newInstance;
    }

    boolean isConnected() {
        return this.getPipe() != null;
    }

    void close() throws IOException {
        super.close();
        this.getOut().close();
        this.getIn().close();
    }

    void forceClose() {
        try {
            try {
                this.getOut().close();
            }
            catch (IOException e) {
                Object var3_2 = null;
                this.setOut(null);
            }
            Object var3_1 = null;
            this.setOut(null);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.setOut(null);
            throw throwable;
        }
        try {
            try {
                this.getIn().close();
            }
            catch (IOException e) {
                Object var5_8 = null;
                this.setIn(null);
            }
            Object var5_7 = null;
            this.setIn(null);
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.setIn(null);
            throw throwable;
        }
        this.setPipe(null);
    }

    private SmbNamedPipe getPipe() {
        return this.pipe;
    }

    private void setPipe(SmbNamedPipe pipe) {
        this.pipe = pipe;
    }

    protected void setTimeout(int timeout) {
    }

    private static int calculateBufferSize(int tdsVersion, int packetSize) {
        if (packetSize == 0) {
            if (tdsVersion >= 3) {
                return 4096;
            }
            return 512;
        }
        return packetSize;
    }
}

