/* Copyright (C) 2005 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#ifndef _MWREVERSEENGINEERING_H_
#define _MWREVERSEENGINEERING_H_

#include <MySQLGRT/MGRTWizardBase.h>

#include <gtkmm/liststore.h>
#include <gtkmm/sizegroup.h>

class MGGladeXML;
class MGRTRevEngFilterPane;

class MWReverseEngineering : public MGRTWizardBase {
  protected:
    class Columns : public Gtk::TreeModel::ColumnRecord {
      public:
        Columns() {
          add(icon); add(text); add(value);
        };
        Gtk::TreeModelColumn<Glib::RefPtr<Gdk::Pixbuf> > icon;
        Gtk::TreeModelColumn<Glib::ustring> text;
        Gtk::TreeModelColumn<MGRTValue> value;
    } _columns;


    MGRTConnectDialog *_conn_panel;
    
    MGRTValue *_schema_list;
    MGRTValue *_catalog; 
    
    std::vector<MGRTRevEngFilterPane*> _filter_panes;

    Glib::RefPtr<Gtk::ListStore> _schema_store;
    
    Glib::RefPtr<Gtk::SizeGroup> _param_sizegroup;
    
    void placement_changed();
    

    virtual void setup();

    void changed_schema_selection();
    void schemata_fetches_done(const MGRTValue &result, bool error, void *data);
    void perform_schemata_fetches(bool back);
    void refresh_schemata_list();
    
    void perform_schemata_selection(bool back);
    bool build_object_selection();
    
    void reverse_engineering_done(const MGRTValue &result, bool error, void *data);
    void perform_reverse_engineering(bool back);
    void perform_object_selection();
    void perform_placement_selection();
    
    void merge_catalogs_done(const MGRTValue &result, bool error, void *data);
    void finalize_reverse_engineering();
    
    virtual void update_advanced();
    virtual void update_section(bool back);
  public:
    MWReverseEngineering(GtkWindow *win);
    ~MWReverseEngineering();

    virtual void set_grt(MGRT *grt);
    
    static MWReverseEngineering *create(MGRT *grt);
};

#endif /* _MWREVERSEENGINEERING_H_ */
